# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.6.1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from authentik_client.models.group_member import GroupMember
from authentik_client.models.web_authn_device_type import WebAuthnDeviceType
from typing import Optional, Set
from typing_extensions import Self

class WebAuthnDevice(BaseModel):
    """
    Serializer for WebAuthn authenticator devices
    """ # noqa: E501
    pk: StrictInt
    name: Annotated[str, Field(strict=True, max_length=200)]
    created_on: datetime
    device_type: Optional[WebAuthnDeviceType]
    aaguid: StrictStr
    user: GroupMember
    __properties: ClassVar[List[str]] = ["pk", "name", "created_on", "device_type", "aaguid", "user"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebAuthnDevice from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "pk",
            "created_on",
            "device_type",
            "aaguid",
            "user",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of device_type
        if self.device_type:
            _dict['device_type'] = self.device_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # set to None if device_type (nullable) is None
        # and model_fields_set contains the field
        if self.device_type is None and "device_type" in self.model_fields_set:
            _dict['device_type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebAuthnDevice from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pk": obj.get("pk"),
            "name": obj.get("name"),
            "created_on": obj.get("created_on"),
            "device_type": WebAuthnDeviceType.from_dict(obj["device_type"]) if obj.get("device_type") is not None else None,
            "aaguid": obj.get("aaguid"),
            "user": GroupMember.from_dict(obj["user"]) if obj.get("user") is not None else None
        })
        return _obj


