# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AddTeamMemberRequest(AbstractModel):
    """AddTeamMember request structure.

    """

    def __init__(self):
        r"""
        :param _TeamId: Team ID
        :type TeamId: str
        :param _MemberList: Members to be added
        :type MemberList: list of CreateTeamMemberInfoReq
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._TeamId = None
        self._MemberList = None
        self._PlatformId = None

    @property
    def TeamId(self):
        """Team ID
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def MemberList(self):
        """Members to be added
        :rtype: list of CreateTeamMemberInfoReq
        """
        return self._MemberList

    @MemberList.setter
    def MemberList(self, MemberList):
        self._MemberList = MemberList

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._TeamId = params.get("TeamId")
        if params.get("MemberList") is not None:
            self._MemberList = []
            for item in params.get("MemberList"):
                obj = CreateTeamMemberInfoReq()
                obj._deserialize(item)
                self._MemberList.append(obj)
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddTeamMemberResponse(AbstractModel):
    """AddTeamMember response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ApprovalItem(AbstractModel):
    """Result of the mini program approval requests

    """

    def __init__(self):
        r"""
        :param _AppId: Application ID
        :type AppId: str
        :param _ApprovalResult: Approval result. 2: Rejected;
3: Approved
        :type ApprovalResult: int
        :param _ApprovalNote: Approval notes. It’s required when the request is rejected.
        :type ApprovalNote: str
        """
        self._AppId = None
        self._ApprovalResult = None
        self._ApprovalNote = None

    @property
    def AppId(self):
        """Application ID
        :rtype: str
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def ApprovalResult(self):
        """Approval result. 2: Rejected;
3: Approved
        :rtype: int
        """
        return self._ApprovalResult

    @ApprovalResult.setter
    def ApprovalResult(self, ApprovalResult):
        self._ApprovalResult = ApprovalResult

    @property
    def ApprovalNote(self):
        """Approval notes. It’s required when the request is rejected.
        :rtype: str
        """
        return self._ApprovalNote

    @ApprovalNote.setter
    def ApprovalNote(self, ApprovalNote):
        self._ApprovalNote = ApprovalNote


    def _deserialize(self, params):
        self._AppId = params.get("AppId")
        self._ApprovalResult = params.get("ApprovalResult")
        self._ApprovalNote = params.get("ApprovalNote")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BooleanInfo(AbstractModel):
    """Used for Data object when no data is returned after the a successful action.

    """

    def __init__(self):
        r"""
        :param _Result: Bool type response object
Note: This field may return null, indicating that no valid values can be obtained.
        :type Result: bool
        """
        self._Result = None

    @property
    def Result(self):
        """Bool type response object
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result


    def _deserialize(self, params):
        self._Result = params.get("Result")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfigureMNPPreviewRequest(AbstractModel):
    """ConfigureMNPPreview request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _ActionType: 1: Set; 2: Cancel
        :type ActionType: int
        :param _MNPVersionId: Mini program version ID
        :type MNPVersionId: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _PreivewEntrancePath: Path to the preview page
        :type PreivewEntrancePath: str
        """
        self._MNPId = None
        self._ActionType = None
        self._MNPVersionId = None
        self._PlatformId = None
        self._PreivewEntrancePath = None

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def ActionType(self):
        """1: Set; 2: Cancel
        :rtype: int
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def MNPVersionId(self):
        """Mini program version ID
        :rtype: int
        """
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def PreivewEntrancePath(self):
        """Path to the preview page
        :rtype: str
        """
        return self._PreivewEntrancePath

    @PreivewEntrancePath.setter
    def PreivewEntrancePath(self, PreivewEntrancePath):
        self._PreivewEntrancePath = PreivewEntrancePath


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._ActionType = params.get("ActionType")
        self._MNPVersionId = params.get("MNPVersionId")
        self._PlatformId = params.get("PlatformId")
        self._PreivewEntrancePath = params.get("PreivewEntrancePath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfigureMNPPreviewResponse(AbstractModel):
    """ConfigureMNPPreview response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateApplicationRequest(AbstractModel):
    """CreateApplication request structure.

    """

    def __init__(self):
        r"""
        :param _ApplicationName: Application name
        :type ApplicationName: str
        :param _Logo: Logo address
        :type Logo: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _TeamId: Team ID
        :type TeamId: str
        :param _ApplicationType: Application type. 1: Test; 2: Formal
        :type ApplicationType: int
        :param _Intro: Introduction
        :type Intro: str
        :param _AndroidAppKey: Android app package name
        :type AndroidAppKey: str
        :param _IosAppKey: iOS App bundleId
        :type IosAppKey: str
        :param _Remark: Remarks
        :type Remark: str
        """
        self._ApplicationName = None
        self._Logo = None
        self._PlatformId = None
        self._TeamId = None
        self._ApplicationType = None
        self._Intro = None
        self._AndroidAppKey = None
        self._IosAppKey = None
        self._Remark = None

    @property
    def ApplicationName(self):
        """Application name
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def Logo(self):
        """Logo address
        :rtype: str
        """
        return self._Logo

    @Logo.setter
    def Logo(self, Logo):
        self._Logo = Logo

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def TeamId(self):
        """Team ID
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def ApplicationType(self):
        """Application type. 1: Test; 2: Formal
        :rtype: int
        """
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType

    @property
    def Intro(self):
        """Introduction
        :rtype: str
        """
        return self._Intro

    @Intro.setter
    def Intro(self, Intro):
        self._Intro = Intro

    @property
    def AndroidAppKey(self):
        """Android app package name
        :rtype: str
        """
        return self._AndroidAppKey

    @AndroidAppKey.setter
    def AndroidAppKey(self, AndroidAppKey):
        self._AndroidAppKey = AndroidAppKey

    @property
    def IosAppKey(self):
        """iOS App bundleId
        :rtype: str
        """
        return self._IosAppKey

    @IosAppKey.setter
    def IosAppKey(self, IosAppKey):
        self._IosAppKey = IosAppKey

    @property
    def Remark(self):
        """Remarks
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._ApplicationName = params.get("ApplicationName")
        self._Logo = params.get("Logo")
        self._PlatformId = params.get("PlatformId")
        self._TeamId = params.get("TeamId")
        self._ApplicationType = params.get("ApplicationType")
        self._Intro = params.get("Intro")
        self._AndroidAppKey = params.get("AndroidAppKey")
        self._IosAppKey = params.get("IosAppKey")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateApplicationResponse(AbstractModel):
    """CreateApplication response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.ResourceIdStringInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.ResourceIdStringInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = ResourceIdStringInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateApplicationSensitiveAPIReq(AbstractModel):
    """The request to add a sensitive API

    """

    def __init__(self):
        r"""
        :param _APIName: API name
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIName: str
        :param _APIDesc: API description
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIDesc: str
        :param _APIType: API type. 1: System; 2: Custom
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIType: int
        """
        self._APIName = None
        self._APIDesc = None
        self._APIType = None

    @property
    def APIName(self):
        """API name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._APIName

    @APIName.setter
    def APIName(self, APIName):
        self._APIName = APIName

    @property
    def APIDesc(self):
        """API description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._APIDesc

    @APIDesc.setter
    def APIDesc(self, APIDesc):
        self._APIDesc = APIDesc

    @property
    def APIType(self):
        """API type. 1: System; 2: Custom
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._APIType

    @APIType.setter
    def APIType(self, APIType):
        self._APIType = APIType


    def _deserialize(self, params):
        self._APIName = params.get("APIName")
        self._APIDesc = params.get("APIDesc")
        self._APIType = params.get("APIType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateApplicationSensitiveAPIRequest(AbstractModel):
    """CreateApplicationSensitiveAPI request structure.

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _APIList: List of newly-added APIs
        :type APIList: list of CreateApplicationSensitiveAPIReq
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._ApplicationId = None
        self._APIList = None
        self._PlatformId = None

    @property
    def ApplicationId(self):
        """Application ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def APIList(self):
        """List of newly-added APIs
        :rtype: list of CreateApplicationSensitiveAPIReq
        """
        return self._APIList

    @APIList.setter
    def APIList(self, APIList):
        self._APIList = APIList

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        if params.get("APIList") is not None:
            self._APIList = []
            for item in params.get("APIList"):
                obj = CreateApplicationSensitiveAPIReq()
                obj._deserialize(item)
                self._APIList.append(obj)
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateApplicationSensitiveAPIResponse(AbstractModel):
    """CreateApplicationSensitiveAPI response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateDomainParam(AbstractModel):
    """Parameters to create a domain name

    """

    def __init__(self):
        r"""
        :param _DomainUrlList: Array of domain name URLs
        :type DomainUrlList: list of str
        :param _DomainType: Domain type. 1: requests domain; 2: WebView load domain, 3: sockets domain; 4: File upload; 5: File download
        :type DomainType: int
        """
        self._DomainUrlList = None
        self._DomainType = None

    @property
    def DomainUrlList(self):
        """Array of domain name URLs
        :rtype: list of str
        """
        return self._DomainUrlList

    @DomainUrlList.setter
    def DomainUrlList(self, DomainUrlList):
        self._DomainUrlList = DomainUrlList

    @property
    def DomainType(self):
        """Domain type. 1: requests domain; 2: WebView load domain, 3: sockets domain; 4: File upload; 5: File download
        :rtype: int
        """
        return self._DomainType

    @DomainType.setter
    def DomainType(self, DomainType):
        self._DomainType = DomainType


    def _deserialize(self, params):
        self._DomainUrlList = params.get("DomainUrlList")
        self._DomainType = params.get("DomainType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateGlobalDomainACLRequest(AbstractModel):
    """CreateGlobalDomainACL request structure.

    """

    def __init__(self):
        r"""
        :param _DomainUrlList: Domain name list
        :type DomainUrlList: list of str
        :param _DomainType: Domain type. 1: Allowed; 2: Blocked
        :type DomainType: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._DomainUrlList = None
        self._DomainType = None
        self._PlatformId = None

    @property
    def DomainUrlList(self):
        """Domain name list
        :rtype: list of str
        """
        return self._DomainUrlList

    @DomainUrlList.setter
    def DomainUrlList(self, DomainUrlList):
        self._DomainUrlList = DomainUrlList

    @property
    def DomainType(self):
        """Domain type. 1: Allowed; 2: Blocked
        :rtype: int
        """
        return self._DomainType

    @DomainType.setter
    def DomainType(self, DomainType):
        self._DomainType = DomainType

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._DomainUrlList = params.get("DomainUrlList")
        self._DomainType = params.get("DomainType")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateGlobalDomainACLResponse(AbstractModel):
    """CreateGlobalDomainACL response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.CreateGlobalDomainResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.CreateGlobalDomainResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CreateGlobalDomainResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateGlobalDomainResp(AbstractModel):
    """Response of creating a global domain name

    """

    def __init__(self):
        r"""
        :param _Result: Result
Note: This field may return null, indicating that no valid values can be obtained.
        :type Result: bool
        :param _RepeatUrls: List of duplicate domain names
Note: This field may return null, indicating that no valid values can be obtained.
        :type RepeatUrls: list of str
        :param _ExistsWhiteUrls: List of allowed domain names
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExistsWhiteUrls: list of str
        :param _ExistsBlackUrls: List of blocked domain names
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExistsBlackUrls: list of str
        """
        self._Result = None
        self._RepeatUrls = None
        self._ExistsWhiteUrls = None
        self._ExistsBlackUrls = None

    @property
    def Result(self):
        """Result
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RepeatUrls(self):
        """List of duplicate domain names
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._RepeatUrls

    @RepeatUrls.setter
    def RepeatUrls(self, RepeatUrls):
        self._RepeatUrls = RepeatUrls

    @property
    def ExistsWhiteUrls(self):
        """List of allowed domain names
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._ExistsWhiteUrls

    @ExistsWhiteUrls.setter
    def ExistsWhiteUrls(self, ExistsWhiteUrls):
        self._ExistsWhiteUrls = ExistsWhiteUrls

    @property
    def ExistsBlackUrls(self):
        """List of blocked domain names
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._ExistsBlackUrls

    @ExistsBlackUrls.setter
    def ExistsBlackUrls(self, ExistsBlackUrls):
        self._ExistsBlackUrls = ExistsBlackUrls


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RepeatUrls = params.get("RepeatUrls")
        self._ExistsWhiteUrls = params.get("ExistsWhiteUrls")
        self._ExistsBlackUrls = params.get("ExistsBlackUrls")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMNPApprovalRequest(AbstractModel):
    """CreateMNPApproval request structure.

    """

    def __init__(self):
        r"""
        :param _MNPVersionId: Mini program version ID
        :type MNPVersionId: int
        :param _ApplyAction: submit: Submit an approval request; cancel: Cancel the approval request
        :type ApplyAction: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPVersionId = None
        self._ApplyAction = None
        self._PlatformId = None

    @property
    def MNPVersionId(self):
        """Mini program version ID
        :rtype: int
        """
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def ApplyAction(self):
        """submit: Submit an approval request; cancel: Cancel the approval request
        :rtype: str
        """
        return self._ApplyAction

    @ApplyAction.setter
    def ApplyAction(self, ApplyAction):
        self._ApplyAction = ApplyAction

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPVersionId = params.get("MNPVersionId")
        self._ApplyAction = params.get("ApplyAction")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMNPApprovalResponse(AbstractModel):
    """CreateMNPApproval response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateMNPDomainACLRequest(AbstractModel):
    """CreateMNPDomainACL request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _Domain: Domain name list
        :type Domain: list of CreateDomainParam
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._Domain = None
        self._PlatformId = None

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def Domain(self):
        """Domain name list
        :rtype: list of CreateDomainParam
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        if params.get("Domain") is not None:
            self._Domain = []
            for item in params.get("Domain"):
                obj = CreateDomainParam()
                obj._deserialize(item)
                self._Domain.append(obj)
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMNPDomainACLResponse(AbstractModel):
    """CreateMNPDomainACL response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateMNPRequest(AbstractModel):
    """CreateMNP request structure.

    """

    def __init__(self):
        r"""
        :param _MNPType: Mini program type
        :type MNPType: str
        :param _MNPName: Mini program name
        :type MNPName: str
        :param _MNPIcon: Mini app icon
        :type MNPIcon: str
        :param _MNPIntro: Mini program introduction
        :type MNPIntro: str
        :param _MNPDesc: Mini program description
        :type MNPDesc: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _TeamId: Team ID
        :type TeamId: str
        """
        self._MNPType = None
        self._MNPName = None
        self._MNPIcon = None
        self._MNPIntro = None
        self._MNPDesc = None
        self._PlatformId = None
        self._TeamId = None

    @property
    def MNPType(self):
        """Mini program type
        :rtype: str
        """
        return self._MNPType

    @MNPType.setter
    def MNPType(self, MNPType):
        self._MNPType = MNPType

    @property
    def MNPName(self):
        """Mini program name
        :rtype: str
        """
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def MNPIcon(self):
        """Mini app icon
        :rtype: str
        """
        return self._MNPIcon

    @MNPIcon.setter
    def MNPIcon(self, MNPIcon):
        self._MNPIcon = MNPIcon

    @property
    def MNPIntro(self):
        """Mini program introduction
        :rtype: str
        """
        return self._MNPIntro

    @MNPIntro.setter
    def MNPIntro(self, MNPIntro):
        self._MNPIntro = MNPIntro

    @property
    def MNPDesc(self):
        """Mini program description
        :rtype: str
        """
        return self._MNPDesc

    @MNPDesc.setter
    def MNPDesc(self, MNPDesc):
        self._MNPDesc = MNPDesc

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def TeamId(self):
        """Team ID
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId


    def _deserialize(self, params):
        self._MNPType = params.get("MNPType")
        self._MNPName = params.get("MNPName")
        self._MNPIcon = params.get("MNPIcon")
        self._MNPIntro = params.get("MNPIntro")
        self._MNPDesc = params.get("MNPDesc")
        self._PlatformId = params.get("PlatformId")
        self._TeamId = params.get("TeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMNPResponse(AbstractModel):
    """CreateMNP response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response mini program ID
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.ResourceIdStringInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response mini program ID
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.ResourceIdStringInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = ResourceIdStringInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateMNPSensitiveAPIPermissionApprovalRequest(AbstractModel):
    """CreateMNPSensitiveAPIPermissionApproval request structure.

    """

    def __init__(self):
        r"""
        :param _APIId: API Id
        :type APIId: str
        :param _ApplyReason: Reason for application
        :type ApplyReason: str
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._APIId = None
        self._ApplyReason = None
        self._MNPId = None
        self._PlatformId = None

    @property
    def APIId(self):
        """API Id
        :rtype: str
        """
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId

    @property
    def ApplyReason(self):
        """Reason for application
        :rtype: str
        """
        return self._ApplyReason

    @ApplyReason.setter
    def ApplyReason(self, ApplyReason):
        self._ApplyReason = ApplyReason

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._APIId = params.get("APIId")
        self._ApplyReason = params.get("ApplyReason")
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMNPSensitiveAPIPermissionApprovalResponse(AbstractModel):
    """CreateMNPSensitiveAPIPermissionApproval response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.ResourceIdStringInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.ResourceIdStringInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = ResourceIdStringInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateMNPVersionRequest(AbstractModel):
    """CreateMNPVersion request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _MNPVersion: Version number
        :type MNPVersion: str
        :param _FileUrl: Address of the mini program package. You can export the package from IDE and upload it to a file server.
        :type FileUrl: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _MNPVersionIntro: Version introduction
        :type MNPVersionIntro: str
        """
        self._MNPId = None
        self._MNPVersion = None
        self._FileUrl = None
        self._PlatformId = None
        self._MNPVersionIntro = None

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPVersion(self):
        """Version number
        :rtype: str
        """
        return self._MNPVersion

    @MNPVersion.setter
    def MNPVersion(self, MNPVersion):
        self._MNPVersion = MNPVersion

    @property
    def FileUrl(self):
        """Address of the mini program package. You can export the package from IDE and upload it to a file server.
        :rtype: str
        """
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def MNPVersionIntro(self):
        """Version introduction
        :rtype: str
        """
        return self._MNPVersionIntro

    @MNPVersionIntro.setter
    def MNPVersionIntro(self, MNPVersionIntro):
        self._MNPVersionIntro = MNPVersionIntro


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPVersion = params.get("MNPVersion")
        self._FileUrl = params.get("FileUrl")
        self._PlatformId = params.get("PlatformId")
        self._MNPVersionIntro = params.get("MNPVersionIntro")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMNPVersionResp(AbstractModel):
    """Response of creating a mini program version

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the task to create a mini program version
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """ID of the task to create a mini program version
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMNPVersionResponse(AbstractModel):
    """CreateMNPVersion response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.CreateMNPVersionResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.CreateMNPVersionResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CreateMNPVersionResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreatePresetKeyRequest(AbstractModel):
    """CreatePresetKey request structure.

    """


class CreatePresetKeyResponse(AbstractModel):
    """CreatePresetKey response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.PresetResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.PresetResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = PresetResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateTeamMemberInfoReq(AbstractModel):
    """New team member - Member information

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
        :type UserId: str
        :param _UserRoleId: User role ID
        :type UserRoleId: int
        """
        self._UserId = None
        self._UserRoleId = None

    @property
    def UserId(self):
        """User ID
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserRoleId(self):
        """User role ID
        :rtype: int
        """
        return self._UserRoleId

    @UserRoleId.setter
    def UserRoleId(self, UserRoleId):
        self._UserRoleId = UserRoleId


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserRoleId = params.get("UserRoleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTeamRequest(AbstractModel):
    """CreateTeam request structure.

    """

    def __init__(self):
        r"""
        :param _TeamName: Team name
        :type TeamName: str
        :param _AdminUserId: Admin name
        :type AdminUserId: str
        :param _TeamRoleTypeList: Permission assigned to the team. 1: Mini program; 2: Application (only one of these types is supported)
        :type TeamRoleTypeList: list of int
        :param _Remark: Remarks
        :type Remark: str
        :param _PlatformId: Platform ID, required for API call
        :type PlatformId: str
        :param _RelatedTeamId: Associated team ID
        :type RelatedTeamId: str
        """
        self._TeamName = None
        self._AdminUserId = None
        self._TeamRoleTypeList = None
        self._Remark = None
        self._PlatformId = None
        self._RelatedTeamId = None

    @property
    def TeamName(self):
        """Team name
        :rtype: str
        """
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def AdminUserId(self):
        """Admin name
        :rtype: str
        """
        return self._AdminUserId

    @AdminUserId.setter
    def AdminUserId(self, AdminUserId):
        self._AdminUserId = AdminUserId

    @property
    def TeamRoleTypeList(self):
        """Permission assigned to the team. 1: Mini program; 2: Application (only one of these types is supported)
        :rtype: list of int
        """
        return self._TeamRoleTypeList

    @TeamRoleTypeList.setter
    def TeamRoleTypeList(self, TeamRoleTypeList):
        self._TeamRoleTypeList = TeamRoleTypeList

    @property
    def Remark(self):
        """Remarks
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def PlatformId(self):
        """Platform ID, required for API call
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def RelatedTeamId(self):
        """Associated team ID
        :rtype: str
        """
        return self._RelatedTeamId

    @RelatedTeamId.setter
    def RelatedTeamId(self, RelatedTeamId):
        self._RelatedTeamId = RelatedTeamId


    def _deserialize(self, params):
        self._TeamName = params.get("TeamName")
        self._AdminUserId = params.get("AdminUserId")
        self._TeamRoleTypeList = params.get("TeamRoleTypeList")
        self._Remark = params.get("Remark")
        self._PlatformId = params.get("PlatformId")
        self._RelatedTeamId = params.get("RelatedTeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTeamResponse(AbstractModel):
    """CreateTeam response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateUserRequest(AbstractModel):
    """CreateUser request structure.

    """

    def __init__(self):
        r"""
        :param _UserAccount: User account
        :type UserAccount: str
        :param _UserName: User name
        :type UserName: str
        :param _AccountType: User account type. 2: Platform admin; 3: Member.
        :type AccountType: int
        :param _Password: Account password. Use CreatePresetKey to get the public key to encrypt the password.
        :type Password: str
        :param _KeyId: Call CreatePresetKey to get the keyID from RequestId
        :type KeyId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._UserAccount = None
        self._UserName = None
        self._AccountType = None
        self._Password = None
        self._KeyId = None
        self._PlatformId = None

    @property
    def UserAccount(self):
        """User account
        :rtype: str
        """
        return self._UserAccount

    @UserAccount.setter
    def UserAccount(self, UserAccount):
        self._UserAccount = UserAccount

    @property
    def UserName(self):
        """User name
        :rtype: str
        """
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def AccountType(self):
        """User account type. 2: Platform admin; 3: Member.
        :rtype: int
        """
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType

    @property
    def Password(self):
        """Account password. Use CreatePresetKey to get the public key to encrypt the password.
        :rtype: str
        """
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def KeyId(self):
        """Call CreatePresetKey to get the keyID from RequestId
        :rtype: str
        """
        return self._KeyId

    @KeyId.setter
    def KeyId(self, KeyId):
        self._KeyId = KeyId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._UserAccount = params.get("UserAccount")
        self._UserName = params.get("UserName")
        self._AccountType = params.get("AccountType")
        self._Password = params.get("Password")
        self._KeyId = params.get("KeyId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateUserResponse(AbstractModel):
    """CreateUser response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data, user ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.ResourceIdStringInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data, user ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.ResourceIdStringInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = ResourceIdStringInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DeleteApplicationRequest(AbstractModel):
    """DeleteApplication request structure.

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._ApplicationId = None
        self._PlatformId = None

    @property
    def ApplicationId(self):
        """Application ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteApplicationResponse(AbstractModel):
    """DeleteApplication response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DeleteApplicationSensitiveAPIRequest(AbstractModel):
    """DeleteApplicationSensitiveAPI request structure.

    """

    def __init__(self):
        r"""
        :param _APIId: API ID
        :type APIId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._APIId = None
        self._PlatformId = None

    @property
    def APIId(self):
        """API ID
        :rtype: str
        """
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._APIId = params.get("APIId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteApplicationSensitiveAPIResponse(AbstractModel):
    """DeleteApplicationSensitiveAPI response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DeleteGlobalDomainRequest(AbstractModel):
    """DeleteGlobalDomain request structure.

    """

    def __init__(self):
        r"""
        :param _DomainId: Domain ID
        :type DomainId: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._DomainId = None
        self._PlatformId = None

    @property
    def DomainId(self):
        """Domain ID
        :rtype: int
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._DomainId = params.get("DomainId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteGlobalDomainResponse(AbstractModel):
    """DeleteGlobalDomain response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.GlobalDomainDeleteResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.GlobalDomainDeleteResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = GlobalDomainDeleteResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DeleteMNPRequest(AbstractModel):
    """DeleteMNP request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMNPResponse(AbstractModel):
    """DeleteMNP response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DeleteTeamMemberRequest(AbstractModel):
    """DeleteTeamMember request structure.

    """

    def __init__(self):
        r"""
        :param _TeamId: Team ID
        :type TeamId: str
        :param _UserId: User ID
        :type UserId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._TeamId = None
        self._UserId = None
        self._PlatformId = None

    @property
    def TeamId(self):
        """Team ID
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def UserId(self):
        """User ID
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._TeamId = params.get("TeamId")
        self._UserId = params.get("UserId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTeamMemberResponse(AbstractModel):
    """DeleteTeamMember response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DeleteTeamRequest(AbstractModel):
    """DeleteTeam request structure.

    """

    def __init__(self):
        r"""
        :param _TeamId: Team ID
        :type TeamId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._TeamId = None
        self._PlatformId = None

    @property
    def TeamId(self):
        """Team ID
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._TeamId = params.get("TeamId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTeamResponse(AbstractModel):
    """DeleteTeam response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DeleteUserRequest(AbstractModel):
    """DeleteUser request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
        :type UserId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._UserId = None
        self._PlatformId = None

    @property
    def UserId(self):
        """User ID
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteUserResponse(AbstractModel):
    """DeleteUser response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeApplicationConfigFileRequest(AbstractModel):
    """DescribeApplicationConfigFile request structure.

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _AppType: Application platform. 2: Android; 3: iOS
        :type AppType: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._ApplicationId = None
        self._AppType = None
        self._PlatformId = None

    @property
    def ApplicationId(self):
        """Application ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def AppType(self):
        """Application platform. 2: Android; 3: iOS
        :rtype: int
        """
        return self._AppType

    @AppType.setter
    def AppType(self, AppType):
        self._AppType = AppType

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._AppType = params.get("AppType")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationConfigFileResponse(AbstractModel):
    """DescribeApplicationConfigFile response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DownloadApplicationConfigResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DownloadApplicationConfigResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DownloadApplicationConfigResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeApplicationListData(AbstractModel):
    """Application information

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationId: str
        :param _AppIdentityId: App ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type AppIdentityId: int
        :param _ApplicationName: Name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _Logo: Icon
        :type Logo: str
        :param _Remark: Remarks
        :type Remark: str
        :param _AndroidAppKey: Android app package name
Note: This field may return null, indicating that no valid values can be obtained.
        :type AndroidAppKey: str
        :param _IosAppKey: iOS App bundleId
Note: This field may return null, indicating that no valid values can be obtained.
        :type IosAppKey: str
        :param _CreateUser: Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateUser: Updater
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateUser: str
        :param _UpdateTime: Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _Intro: Introduction
        :type Intro: str
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _SensitiveApiCount: Number of sensitive APIs
Note: This field may return null, indicating that no valid values can be obtained.
        :type SensitiveApiCount: int
        :param _ApplicationType: Application type. 1: Test; 2: Formal
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationType: int
        """
        self._ApplicationId = None
        self._AppIdentityId = None
        self._ApplicationName = None
        self._Logo = None
        self._Remark = None
        self._AndroidAppKey = None
        self._IosAppKey = None
        self._CreateUser = None
        self._CreateTime = None
        self._UpdateUser = None
        self._UpdateTime = None
        self._Intro = None
        self._TeamId = None
        self._TeamName = None
        self._SensitiveApiCount = None
        self._ApplicationType = None

    @property
    def ApplicationId(self):
        """Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def AppIdentityId(self):
        """App ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._AppIdentityId

    @AppIdentityId.setter
    def AppIdentityId(self, AppIdentityId):
        self._AppIdentityId = AppIdentityId

    @property
    def ApplicationName(self):
        """Name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def Logo(self):
        """Icon
        :rtype: str
        """
        return self._Logo

    @Logo.setter
    def Logo(self, Logo):
        self._Logo = Logo

    @property
    def Remark(self):
        """Remarks
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def AndroidAppKey(self):
        """Android app package name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AndroidAppKey

    @AndroidAppKey.setter
    def AndroidAppKey(self, AndroidAppKey):
        self._AndroidAppKey = AndroidAppKey

    @property
    def IosAppKey(self):
        """iOS App bundleId
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IosAppKey

    @IosAppKey.setter
    def IosAppKey(self, IosAppKey):
        self._IosAppKey = IosAppKey

    @property
    def CreateUser(self):
        """Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        """Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateUser(self):
        """Updater
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UpdateUser

    @UpdateUser.setter
    def UpdateUser(self, UpdateUser):
        self._UpdateUser = UpdateUser

    @property
    def UpdateTime(self):
        """Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Intro(self):
        """Introduction
        :rtype: str
        """
        return self._Intro

    @Intro.setter
    def Intro(self, Intro):
        self._Intro = Intro

    @property
    def TeamId(self):
        """Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        """Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def SensitiveApiCount(self):
        """Number of sensitive APIs
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._SensitiveApiCount

    @SensitiveApiCount.setter
    def SensitiveApiCount(self, SensitiveApiCount):
        self._SensitiveApiCount = SensitiveApiCount

    @property
    def ApplicationType(self):
        """Application type. 1: Test; 2: Formal
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._AppIdentityId = params.get("AppIdentityId")
        self._ApplicationName = params.get("ApplicationName")
        self._Logo = params.get("Logo")
        self._Remark = params.get("Remark")
        self._AndroidAppKey = params.get("AndroidAppKey")
        self._IosAppKey = params.get("IosAppKey")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._UpdateUser = params.get("UpdateUser")
        self._UpdateTime = params.get("UpdateTime")
        self._Intro = params.get("Intro")
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._SensitiveApiCount = params.get("SensitiveApiCount")
        self._ApplicationType = params.get("ApplicationType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationListRequest(AbstractModel):
    """DescribeApplicationList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _Keyword: Keywords for search (app name)
        :type Keyword: str
        :param _TeamId: Team ID
        :type TeamId: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._Keyword = None
        self._TeamId = None

    @property
    def Offset(self):
        """Page offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of results per page
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def Keyword(self):
        """Keywords for search (app name)
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def TeamId(self):
        """Team ID
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._Keyword = params.get("Keyword")
        self._TeamId = params.get("TeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationListResp(AbstractModel):
    """List of applications

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeApplicationListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        """Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        """List information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DescribeApplicationListData
        """
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeApplicationListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationListResponse(AbstractModel):
    """DescribeApplicationList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeApplicationListResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeApplicationListResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeApplicationListResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeApplicationRequest(AbstractModel):
    """DescribeApplication request structure.

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._ApplicationId = None
        self._PlatformId = None

    @property
    def ApplicationId(self):
        """Application ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationResp(AbstractModel):
    """Application details

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationId: str
        :param _AppIdentityId: Product ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type AppIdentityId: int
        :param _ApplicationName: Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _Logo: Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type Logo: str
        :param _Remark: Remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _AndroidAppKey: Android package name
Note: This field may return null, indicating that no valid values can be obtained.
        :type AndroidAppKey: str
        :param _IosAppKey: iOS bundleId
Note: This field may return null, indicating that no valid values can be obtained.
        :type IosAppKey: str
        :param _CreateUser: Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateUser: Updater
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateUser: str
        :param _UpdateTime: Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _Intro: Application description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Intro: str
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _SensitiveApiCount: Number of sensitive APIs
Note: This field may return null, indicating that no valid values can be obtained.
        :type SensitiveApiCount: int
        :param _ApplicationType: Application type. 1: Test; 2: Formal
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationType: int
        """
        self._ApplicationId = None
        self._AppIdentityId = None
        self._ApplicationName = None
        self._Logo = None
        self._Remark = None
        self._AndroidAppKey = None
        self._IosAppKey = None
        self._CreateUser = None
        self._CreateTime = None
        self._UpdateUser = None
        self._UpdateTime = None
        self._Intro = None
        self._TeamId = None
        self._TeamName = None
        self._SensitiveApiCount = None
        self._ApplicationType = None

    @property
    def ApplicationId(self):
        """Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def AppIdentityId(self):
        """Product ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._AppIdentityId

    @AppIdentityId.setter
    def AppIdentityId(self, AppIdentityId):
        self._AppIdentityId = AppIdentityId

    @property
    def ApplicationName(self):
        """Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def Logo(self):
        """Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Logo

    @Logo.setter
    def Logo(self, Logo):
        self._Logo = Logo

    @property
    def Remark(self):
        """Remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def AndroidAppKey(self):
        """Android package name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AndroidAppKey

    @AndroidAppKey.setter
    def AndroidAppKey(self, AndroidAppKey):
        self._AndroidAppKey = AndroidAppKey

    @property
    def IosAppKey(self):
        """iOS bundleId
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IosAppKey

    @IosAppKey.setter
    def IosAppKey(self, IosAppKey):
        self._IosAppKey = IosAppKey

    @property
    def CreateUser(self):
        """Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        """Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateUser(self):
        """Updater
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UpdateUser

    @UpdateUser.setter
    def UpdateUser(self, UpdateUser):
        self._UpdateUser = UpdateUser

    @property
    def UpdateTime(self):
        """Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Intro(self):
        """Application description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Intro

    @Intro.setter
    def Intro(self, Intro):
        self._Intro = Intro

    @property
    def TeamId(self):
        """Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        """Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def SensitiveApiCount(self):
        """Number of sensitive APIs
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._SensitiveApiCount

    @SensitiveApiCount.setter
    def SensitiveApiCount(self, SensitiveApiCount):
        self._SensitiveApiCount = SensitiveApiCount

    @property
    def ApplicationType(self):
        """Application type. 1: Test; 2: Formal
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._AppIdentityId = params.get("AppIdentityId")
        self._ApplicationName = params.get("ApplicationName")
        self._Logo = params.get("Logo")
        self._Remark = params.get("Remark")
        self._AndroidAppKey = params.get("AndroidAppKey")
        self._IosAppKey = params.get("IosAppKey")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._UpdateUser = params.get("UpdateUser")
        self._UpdateTime = params.get("UpdateTime")
        self._Intro = params.get("Intro")
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._SensitiveApiCount = params.get("SensitiveApiCount")
        self._ApplicationType = params.get("ApplicationType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationResponse(AbstractModel):
    """DescribeApplication response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeApplicationResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeApplicationResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeApplicationResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeApplicationSensitiveAPIListData(AbstractModel):
    """List of sensitive APIs of an application

    """

    def __init__(self):
        r"""
        :param _APIId: APIID
        :type APIId: str
        :param _APIName: API name
        :type APIName: str
        :param _APIMethod: API request method
        :type APIMethod: str
        :param _APIDesc: API description
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIDesc: str
        :param _CreateUser: Creator
        :type CreateUser: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _UpdateUser: Updater
        :type UpdateUser: str
        :param _UpdateTime: Update time
        :type UpdateTime: str
        :param _ApplicationId: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationId: str
        :param _ApplicationName: Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _ApplicationLogo: Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationLogo: str
        :param _APIType: API type. 1: System; 2: Custom
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIType: int
        :param _Status: API status. 0: Public; 1: Restricted
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        """
        self._APIId = None
        self._APIName = None
        self._APIMethod = None
        self._APIDesc = None
        self._CreateUser = None
        self._CreateTime = None
        self._UpdateUser = None
        self._UpdateTime = None
        self._ApplicationId = None
        self._ApplicationName = None
        self._TeamId = None
        self._TeamName = None
        self._ApplicationLogo = None
        self._APIType = None
        self._Status = None

    @property
    def APIId(self):
        """APIID
        :rtype: str
        """
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId

    @property
    def APIName(self):
        """API name
        :rtype: str
        """
        return self._APIName

    @APIName.setter
    def APIName(self, APIName):
        self._APIName = APIName

    @property
    def APIMethod(self):
        """API request method
        :rtype: str
        """
        return self._APIMethod

    @APIMethod.setter
    def APIMethod(self, APIMethod):
        self._APIMethod = APIMethod

    @property
    def APIDesc(self):
        """API description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._APIDesc

    @APIDesc.setter
    def APIDesc(self, APIDesc):
        self._APIDesc = APIDesc

    @property
    def CreateUser(self):
        """Creator
        :rtype: str
        """
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        """Creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateUser(self):
        """Updater
        :rtype: str
        """
        return self._UpdateUser

    @UpdateUser.setter
    def UpdateUser(self, UpdateUser):
        self._UpdateUser = UpdateUser

    @property
    def UpdateTime(self):
        """Update time
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def ApplicationId(self):
        """Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        """Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def TeamId(self):
        """Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        """Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def ApplicationLogo(self):
        """Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplicationLogo

    @ApplicationLogo.setter
    def ApplicationLogo(self, ApplicationLogo):
        self._ApplicationLogo = ApplicationLogo

    @property
    def APIType(self):
        """API type. 1: System; 2: Custom
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._APIType

    @APIType.setter
    def APIType(self, APIType):
        self._APIType = APIType

    @property
    def Status(self):
        """API status. 0: Public; 1: Restricted
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._APIId = params.get("APIId")
        self._APIName = params.get("APIName")
        self._APIMethod = params.get("APIMethod")
        self._APIDesc = params.get("APIDesc")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._UpdateUser = params.get("UpdateUser")
        self._UpdateTime = params.get("UpdateTime")
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._ApplicationLogo = params.get("ApplicationLogo")
        self._APIType = params.get("APIType")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationSensitiveAPIListRequest(AbstractModel):
    """DescribeApplicationSensitiveAPIList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _Keyword: Keywords for search (API name or method)
        :type Keyword: str
        :param _TeamId: Team ID
        :type TeamId: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._ApplicationId = None
        self._Keyword = None
        self._TeamId = None

    @property
    def Offset(self):
        """Page offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of results per page
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def ApplicationId(self):
        """Application ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def Keyword(self):
        """Keywords for search (API name or method)
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def TeamId(self):
        """Team ID
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._ApplicationId = params.get("ApplicationId")
        self._Keyword = params.get("Keyword")
        self._TeamId = params.get("TeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationSensitiveAPIListResp(AbstractModel):
    """List of sensitive APIs of the application

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeApplicationSensitiveAPIListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        """Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        """List information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DescribeApplicationSensitiveAPIListData
        """
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeApplicationSensitiveAPIListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationSensitiveAPIListResponse(AbstractModel):
    """DescribeApplicationSensitiveAPIList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeApplicationSensitiveAPIListResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeApplicationSensitiveAPIListResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeApplicationSensitiveAPIListResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDomainInfoParam(AbstractModel):
    """Domain information

    """

    def __init__(self):
        r"""
        :param _DomainUrl: Multiple domain separators ';'
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainUrl: str
        :param _DomainType: Domain type 1-requests domain 2-WebView load domain
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainType: int
        """
        self._DomainUrl = None
        self._DomainType = None

    @property
    def DomainUrl(self):
        """Multiple domain separators ';'
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DomainUrl

    @DomainUrl.setter
    def DomainUrl(self, DomainUrl):
        self._DomainUrl = DomainUrl

    @property
    def DomainType(self):
        """Domain type 1-requests domain 2-WebView load domain
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._DomainType

    @DomainType.setter
    def DomainType(self, DomainType):
        self._DomainType = DomainType


    def _deserialize(self, params):
        self._DomainUrl = params.get("DomainUrl")
        self._DomainType = params.get("DomainType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGlobalDomainACLRequest(AbstractModel):
    """DescribeGlobalDomainACL request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _DomainTypes: Domain type. 1: Allowed; 2: Blocked
        :type DomainTypes: list of int
        :param _Keyword: Domain names to be queried
        :type Keyword: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._DomainTypes = None
        self._Keyword = None

    @property
    def Offset(self):
        """Page offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of results per page
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def DomainTypes(self):
        """Domain type. 1: Allowed; 2: Blocked
        :rtype: list of int
        """
        return self._DomainTypes

    @DomainTypes.setter
    def DomainTypes(self, DomainTypes):
        self._DomainTypes = DomainTypes

    @property
    def Keyword(self):
        """Domain names to be queried
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._DomainTypes = params.get("DomainTypes")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGlobalDomainACLResponse(AbstractModel):
    """DescribeGlobalDomainACL response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeGlobalDomainsResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeGlobalDomainsResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeGlobalDomainsResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeGlobalDomainsListData(AbstractModel):
    """List of global domain names

    """

    def __init__(self):
        r"""
        :param _DomainId: Domain ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainId: int
        :param _DomainUrl: Domain name
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainUrl: str
        :param _DomainType: Type. 1: Allowed; 2: Blocked
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainType: int
        :param _CreateUser: Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateUser: Updater
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateUser: str
        :param _UpdateTime: Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        """
        self._DomainId = None
        self._DomainUrl = None
        self._DomainType = None
        self._CreateUser = None
        self._CreateTime = None
        self._UpdateUser = None
        self._UpdateTime = None

    @property
    def DomainId(self):
        """Domain ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def DomainUrl(self):
        """Domain name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DomainUrl

    @DomainUrl.setter
    def DomainUrl(self, DomainUrl):
        self._DomainUrl = DomainUrl

    @property
    def DomainType(self):
        """Type. 1: Allowed; 2: Blocked
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._DomainType

    @DomainType.setter
    def DomainType(self, DomainType):
        self._DomainType = DomainType

    @property
    def CreateUser(self):
        """Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        """Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateUser(self):
        """Updater
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UpdateUser

    @UpdateUser.setter
    def UpdateUser(self, UpdateUser):
        self._UpdateUser = UpdateUser

    @property
    def UpdateTime(self):
        """Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._DomainId = params.get("DomainId")
        self._DomainUrl = params.get("DomainUrl")
        self._DomainType = params.get("DomainType")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._UpdateUser = params.get("UpdateUser")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGlobalDomainsResp(AbstractModel):
    """Global domain name page list

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of results
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: Domain name information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeGlobalDomainsListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        """Total number of results
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        """Domain name information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DescribeGlobalDomainsListData
        """
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeGlobalDomainsListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPAllStageVersionsRequest(AbstractModel):
    """DescribeMNPAllStageVersions request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPAllStageVersionsResponse(AbstractModel):
    """DescribeMNPAllStageVersions response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of DescribeMPAllStageVersionsResp
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DescribeMPAllStageVersionsResp
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DescribeMPAllStageVersionsResp()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMNPApprovalListData(AbstractModel):
    """List of mini program approval requests of the application

    """

    def __init__(self):
        r"""
        :param _ApprovalNo: Approval request ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalNo: str
        :param _ApplicationId: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationId: str
        :param _ApprovalStatus: Approval status : 1: Processing; 2: Rejected; 3: Approved; 4: Cancelled
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalStatus: int
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _MNPVersion: Mini program version
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersion: str
        :param _MNPVersionId: Mini program version ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersionId: int
        :param _ApplyUser: Applicant
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplyUser: str
        :param _ApplyTime: Application time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplyTime: str
        :param _MNPName: Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPName: str
        :param _MNPIcon: Mini program icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIcon: str
        :param _ApplicationName: Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _ApplicationLogo: Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationLogo: str
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _MNPQrCodeUrl: Mini Program QR code
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPQrCodeUrl: str
        :param _MNPType: Mini program type
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPType: str
        :param _ApprovalUser: Approver
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalUser: str
        :param _ApprovalTime: Approval time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalTime: str
        :param _ApprovalNote: Approval notes
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalNote: str
        """
        self._ApprovalNo = None
        self._ApplicationId = None
        self._ApprovalStatus = None
        self._MNPId = None
        self._MNPVersion = None
        self._MNPVersionId = None
        self._ApplyUser = None
        self._ApplyTime = None
        self._MNPName = None
        self._MNPIcon = None
        self._ApplicationName = None
        self._ApplicationLogo = None
        self._TeamId = None
        self._TeamName = None
        self._MNPQrCodeUrl = None
        self._MNPType = None
        self._ApprovalUser = None
        self._ApprovalTime = None
        self._ApprovalNote = None

    @property
    def ApprovalNo(self):
        """Approval request ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApprovalNo

    @ApprovalNo.setter
    def ApprovalNo(self, ApprovalNo):
        self._ApprovalNo = ApprovalNo

    @property
    def ApplicationId(self):
        """Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApprovalStatus(self):
        """Approval status : 1: Processing; 2: Rejected; 3: Approved; 4: Cancelled
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ApprovalStatus

    @ApprovalStatus.setter
    def ApprovalStatus(self, ApprovalStatus):
        self._ApprovalStatus = ApprovalStatus

    @property
    def MNPId(self):
        """Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPVersion(self):
        """Mini program version
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPVersion

    @MNPVersion.setter
    def MNPVersion(self, MNPVersion):
        self._MNPVersion = MNPVersion

    @property
    def MNPVersionId(self):
        """Mini program version ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def ApplyUser(self):
        """Applicant
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplyUser

    @ApplyUser.setter
    def ApplyUser(self, ApplyUser):
        self._ApplyUser = ApplyUser

    @property
    def ApplyTime(self):
        """Application time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplyTime

    @ApplyTime.setter
    def ApplyTime(self, ApplyTime):
        self._ApplyTime = ApplyTime

    @property
    def MNPName(self):
        """Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def MNPIcon(self):
        """Mini program icon
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPIcon

    @MNPIcon.setter
    def MNPIcon(self, MNPIcon):
        self._MNPIcon = MNPIcon

    @property
    def ApplicationName(self):
        """Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def ApplicationLogo(self):
        """Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplicationLogo

    @ApplicationLogo.setter
    def ApplicationLogo(self, ApplicationLogo):
        self._ApplicationLogo = ApplicationLogo

    @property
    def TeamId(self):
        """Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        """Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def MNPQrCodeUrl(self):
        """Mini Program QR code
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPQrCodeUrl

    @MNPQrCodeUrl.setter
    def MNPQrCodeUrl(self, MNPQrCodeUrl):
        self._MNPQrCodeUrl = MNPQrCodeUrl

    @property
    def MNPType(self):
        """Mini program type
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPType

    @MNPType.setter
    def MNPType(self, MNPType):
        self._MNPType = MNPType

    @property
    def ApprovalUser(self):
        """Approver
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApprovalUser

    @ApprovalUser.setter
    def ApprovalUser(self, ApprovalUser):
        self._ApprovalUser = ApprovalUser

    @property
    def ApprovalTime(self):
        """Approval time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApprovalTime

    @ApprovalTime.setter
    def ApprovalTime(self, ApprovalTime):
        self._ApprovalTime = ApprovalTime

    @property
    def ApprovalNote(self):
        """Approval notes
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApprovalNote

    @ApprovalNote.setter
    def ApprovalNote(self, ApprovalNote):
        self._ApprovalNote = ApprovalNote


    def _deserialize(self, params):
        self._ApprovalNo = params.get("ApprovalNo")
        self._ApplicationId = params.get("ApplicationId")
        self._ApprovalStatus = params.get("ApprovalStatus")
        self._MNPId = params.get("MNPId")
        self._MNPVersion = params.get("MNPVersion")
        self._MNPVersionId = params.get("MNPVersionId")
        self._ApplyUser = params.get("ApplyUser")
        self._ApplyTime = params.get("ApplyTime")
        self._MNPName = params.get("MNPName")
        self._MNPIcon = params.get("MNPIcon")
        self._ApplicationName = params.get("ApplicationName")
        self._ApplicationLogo = params.get("ApplicationLogo")
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._MNPQrCodeUrl = params.get("MNPQrCodeUrl")
        self._MNPType = params.get("MNPType")
        self._ApprovalUser = params.get("ApprovalUser")
        self._ApprovalTime = params.get("ApprovalTime")
        self._ApprovalNote = params.get("ApprovalNote")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPApprovalListRequest(AbstractModel):
    """DescribeMNPApprovalList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _ApprovalStatusList: Approval status. 1: Processing; 2: Rejected; 3: Approved; 4 Cancelled
        :type ApprovalStatusList: list of int
        :param _Keyword: Keywords of the mini program name to search
        :type Keyword: str
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _TeamId: Team ID
        :type TeamId: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._ApprovalStatusList = None
        self._Keyword = None
        self._ApplicationId = None
        self._TeamId = None

    @property
    def Offset(self):
        """Page offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of results per page
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def ApprovalStatusList(self):
        """Approval status. 1: Processing; 2: Rejected; 3: Approved; 4 Cancelled
        :rtype: list of int
        """
        return self._ApprovalStatusList

    @ApprovalStatusList.setter
    def ApprovalStatusList(self, ApprovalStatusList):
        self._ApprovalStatusList = ApprovalStatusList

    @property
    def Keyword(self):
        """Keywords of the mini program name to search
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def ApplicationId(self):
        """Application ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def TeamId(self):
        """Team ID
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._ApprovalStatusList = params.get("ApprovalStatusList")
        self._Keyword = params.get("Keyword")
        self._ApplicationId = params.get("ApplicationId")
        self._TeamId = params.get("TeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPApprovalListResp(AbstractModel):
    """List of mini program approval requests of an application

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeMNPApprovalListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        """Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        """List information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DescribeMNPApprovalListData
        """
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeMNPApprovalListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPApprovalListResponse(AbstractModel):
    """DescribeMNPApprovalList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeMNPApprovalListResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeMNPApprovalListResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPApprovalListResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPCategoryRequest(AbstractModel):
    """DescribeMNPCategory request structure.

    """

    def __init__(self):
        r"""
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._PlatformId = None

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPCategoryResponse(AbstractModel):
    """DescribeMNPCategory response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of MNPTypeDefine
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of MNPTypeDefine
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = MNPTypeDefine()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMNPDomainACLRequest(AbstractModel):
    """DescribeMNPDomainACL request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPDomainACLResponse(AbstractModel):
    """DescribeMNPDomainACL response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of DescribeDomainInfoParam
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DescribeDomainInfoParam
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DescribeDomainInfoParam()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMNPListData(AbstractModel):
    """Mini program list

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _MNPIcon: Mini program icon
        :type MNPIcon: str
        :param _MNPName: Mini program name
        :type MNPName: str
        :param _TeamName: Name of the associated team
        :type TeamName: str
        :param _MNPType: Mini program type
        :type MNPType: str
        :param _Status: Whether the mini program is released. 1: Released; 2: Removed
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _MNPIntro: Mini program introduction
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIntro: str
        :param _CreateUser: Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateUser: Updater
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateUser: str
        :param _UpdateTime: Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _ApplicationName: Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _EffectStatus: Effective status of the bound application. 1: Not effective; 2: Effective
Note: This field may return null, indicating that no valid values can be obtained.
        :type EffectStatus: int
        :param _EffectMNPVersionId: ID of the application bound with the mini program
Note: This field may return null, indicating that no valid values can be obtained.
        :type EffectMNPVersionId: int
        :param _EffectMNPVersion: Effective version number of the application that bound with the mini program
Note: This field may return null, indicating that no valid values can be obtained.
        :type EffectMNPVersion: str
        """
        self._MNPId = None
        self._MNPIcon = None
        self._MNPName = None
        self._TeamName = None
        self._MNPType = None
        self._Status = None
        self._MNPIntro = None
        self._CreateUser = None
        self._CreateTime = None
        self._UpdateUser = None
        self._UpdateTime = None
        self._ApplicationName = None
        self._EffectStatus = None
        self._EffectMNPVersionId = None
        self._EffectMNPVersion = None

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPIcon(self):
        """Mini program icon
        :rtype: str
        """
        return self._MNPIcon

    @MNPIcon.setter
    def MNPIcon(self, MNPIcon):
        self._MNPIcon = MNPIcon

    @property
    def MNPName(self):
        """Mini program name
        :rtype: str
        """
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def TeamName(self):
        """Name of the associated team
        :rtype: str
        """
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def MNPType(self):
        """Mini program type
        :rtype: str
        """
        return self._MNPType

    @MNPType.setter
    def MNPType(self, MNPType):
        self._MNPType = MNPType

    @property
    def Status(self):
        """Whether the mini program is released. 1: Released; 2: Removed
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def MNPIntro(self):
        """Mini program introduction
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPIntro

    @MNPIntro.setter
    def MNPIntro(self, MNPIntro):
        self._MNPIntro = MNPIntro

    @property
    def CreateUser(self):
        """Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        """Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateUser(self):
        """Updater
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UpdateUser

    @UpdateUser.setter
    def UpdateUser(self, UpdateUser):
        self._UpdateUser = UpdateUser

    @property
    def UpdateTime(self):
        """Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def ApplicationName(self):
        """Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def EffectStatus(self):
        """Effective status of the bound application. 1: Not effective; 2: Effective
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._EffectStatus

    @EffectStatus.setter
    def EffectStatus(self, EffectStatus):
        self._EffectStatus = EffectStatus

    @property
    def EffectMNPVersionId(self):
        """ID of the application bound with the mini program
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._EffectMNPVersionId

    @EffectMNPVersionId.setter
    def EffectMNPVersionId(self, EffectMNPVersionId):
        self._EffectMNPVersionId = EffectMNPVersionId

    @property
    def EffectMNPVersion(self):
        """Effective version number of the application that bound with the mini program
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._EffectMNPVersion

    @EffectMNPVersion.setter
    def EffectMNPVersion(self, EffectMNPVersion):
        self._EffectMNPVersion = EffectMNPVersion


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPIcon = params.get("MNPIcon")
        self._MNPName = params.get("MNPName")
        self._TeamName = params.get("TeamName")
        self._MNPType = params.get("MNPType")
        self._Status = params.get("Status")
        self._MNPIntro = params.get("MNPIntro")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._UpdateUser = params.get("UpdateUser")
        self._UpdateTime = params.get("UpdateTime")
        self._ApplicationName = params.get("ApplicationName")
        self._EffectStatus = params.get("EffectStatus")
        self._EffectMNPVersionId = params.get("EffectMNPVersionId")
        self._EffectMNPVersion = params.get("EffectMNPVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPListRequest(AbstractModel):
    """DescribeMNPList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _Keyword: Keywords for search (mini program name)
        :type Keyword: str
        :param _TeamId: Team ID
        :type TeamId: str
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._Keyword = None
        self._TeamId = None
        self._ApplicationId = None

    @property
    def Offset(self):
        """Page offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of results per page
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def Keyword(self):
        """Keywords for search (mini program name)
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def TeamId(self):
        """Team ID
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def ApplicationId(self):
        """Application ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._Keyword = params.get("Keyword")
        self._TeamId = params.get("TeamId")
        self._ApplicationId = params.get("ApplicationId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPListResp(AbstractModel):
    """Mini program list

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeMNPListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        """Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        """List information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DescribeMNPListData
        """
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeMNPListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPListResponse(AbstractModel):
    """DescribeMNPList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeMNPListResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeMNPListResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPListResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPManagerDetailData(AbstractModel):
    """Mini program details

    """

    def __init__(self):
        r"""
        :param _MNPType: Mini program type 
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPType: str
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _MNPName: Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPName: str
        :param _MNPIcon: Mini program icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIcon: str
        :param _MNPIntro: Mini program introduction
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIntro: str
        :param _MNPDesc: Mini program description
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPDesc: str
        :param _CreateTime: Creation time, timestamp
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _CreateUser: Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _AccessStatus: Connection status. 1: Not connected; 2: Connected
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccessStatus: int
        :param _TeamName: The name of the associated team
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _Status: Mini program release status. 1: Released; 2: Removed
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        """
        self._MNPType = None
        self._MNPId = None
        self._MNPName = None
        self._MNPIcon = None
        self._MNPIntro = None
        self._MNPDesc = None
        self._CreateTime = None
        self._CreateUser = None
        self._AccessStatus = None
        self._TeamName = None
        self._TeamId = None
        self._Status = None

    @property
    def MNPType(self):
        """Mini program type 
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPType

    @MNPType.setter
    def MNPType(self, MNPType):
        self._MNPType = MNPType

    @property
    def MNPId(self):
        """Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPName(self):
        """Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def MNPIcon(self):
        """Mini program icon
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPIcon

    @MNPIcon.setter
    def MNPIcon(self, MNPIcon):
        self._MNPIcon = MNPIcon

    @property
    def MNPIntro(self):
        """Mini program introduction
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPIntro

    @MNPIntro.setter
    def MNPIntro(self, MNPIntro):
        self._MNPIntro = MNPIntro

    @property
    def MNPDesc(self):
        """Mini program description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPDesc

    @MNPDesc.setter
    def MNPDesc(self, MNPDesc):
        self._MNPDesc = MNPDesc

    @property
    def CreateTime(self):
        """Creation time, timestamp
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def CreateUser(self):
        """Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def AccessStatus(self):
        """Connection status. 1: Not connected; 2: Connected
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._AccessStatus

    @AccessStatus.setter
    def AccessStatus(self, AccessStatus):
        self._AccessStatus = AccessStatus

    @property
    def TeamName(self):
        """The name of the associated team
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def TeamId(self):
        """Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def Status(self):
        """Mini program release status. 1: Released; 2: Removed
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._MNPType = params.get("MNPType")
        self._MNPId = params.get("MNPId")
        self._MNPName = params.get("MNPName")
        self._MNPIcon = params.get("MNPIcon")
        self._MNPIntro = params.get("MNPIntro")
        self._MNPDesc = params.get("MNPDesc")
        self._CreateTime = params.get("CreateTime")
        self._CreateUser = params.get("CreateUser")
        self._AccessStatus = params.get("AccessStatus")
        self._TeamName = params.get("TeamName")
        self._TeamId = params.get("TeamId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPOfflinePackageURLRequest(AbstractModel):
    """DescribeMNPOfflinePackageURL request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPOfflinePackageURLResponse(AbstractModel):
    """DescribeMNPOfflinePackageURL response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.StringData`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.StringData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = StringData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPPreviewRequest(AbstractModel):
    """DescribeMNPPreview request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _MNPVersionId: Mini program version ID
        :type MNPVersionId: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._MNPVersionId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPVersionId(self):
        """Mini program version ID
        :rtype: int
        """
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPVersionId = params.get("MNPVersionId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPPreviewResp(AbstractModel):
    """Response of querying the preview

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _MNPName: Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPName: str
        :param _MNPDesc: Mini program description
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPDesc: str
        :param _MNPVersion: Mini program version
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersion: str
        :param _MNPVersionIntro: Mini program introduction
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersionIntro: str
        :param _QRCodeUrl: Mini program QR code
Note: This field may return null, indicating that no valid values can be obtained.
        :type QRCodeUrl: str
        :param _PreviewEntrancePath: Path to the preview
Note: This field may return null, indicating that no valid values can be obtained.
        :type PreviewEntrancePath: str
        :param _QRCodeContent: QR code content
Note: This field may return null, indicating that no valid values can be obtained.
        :type QRCodeContent: str
        """
        self._MNPId = None
        self._MNPName = None
        self._MNPDesc = None
        self._MNPVersion = None
        self._MNPVersionIntro = None
        self._QRCodeUrl = None
        self._PreviewEntrancePath = None
        self._QRCodeContent = None

    @property
    def MNPId(self):
        """Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPName(self):
        """Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def MNPDesc(self):
        """Mini program description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPDesc

    @MNPDesc.setter
    def MNPDesc(self, MNPDesc):
        self._MNPDesc = MNPDesc

    @property
    def MNPVersion(self):
        """Mini program version
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPVersion

    @MNPVersion.setter
    def MNPVersion(self, MNPVersion):
        self._MNPVersion = MNPVersion

    @property
    def MNPVersionIntro(self):
        """Mini program introduction
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPVersionIntro

    @MNPVersionIntro.setter
    def MNPVersionIntro(self, MNPVersionIntro):
        self._MNPVersionIntro = MNPVersionIntro

    @property
    def QRCodeUrl(self):
        """Mini program QR code
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._QRCodeUrl

    @QRCodeUrl.setter
    def QRCodeUrl(self, QRCodeUrl):
        self._QRCodeUrl = QRCodeUrl

    @property
    def PreviewEntrancePath(self):
        """Path to the preview
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PreviewEntrancePath

    @PreviewEntrancePath.setter
    def PreviewEntrancePath(self, PreviewEntrancePath):
        self._PreviewEntrancePath = PreviewEntrancePath

    @property
    def QRCodeContent(self):
        """QR code content
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._QRCodeContent

    @QRCodeContent.setter
    def QRCodeContent(self, QRCodeContent):
        self._QRCodeContent = QRCodeContent


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPName = params.get("MNPName")
        self._MNPDesc = params.get("MNPDesc")
        self._MNPVersion = params.get("MNPVersion")
        self._MNPVersionIntro = params.get("MNPVersionIntro")
        self._QRCodeUrl = params.get("QRCodeUrl")
        self._PreviewEntrancePath = params.get("PreviewEntrancePath")
        self._QRCodeContent = params.get("QRCodeContent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPPreviewResponse(AbstractModel):
    """DescribeMNPPreview response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeMNPPreviewResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeMNPPreviewResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPPreviewResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPReleasedVersionHistoryRequest(AbstractModel):
    """DescribeMNPReleasedVersionHistory request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPReleasedVersionHistoryResponse(AbstractModel):
    """DescribeMNPReleasedVersionHistory response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeRevertOnlineVersionPageResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeRevertOnlineVersionPageResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeRevertOnlineVersionPageResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPRequest(AbstractModel):
    """DescribeMNP request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPResponse(AbstractModel):
    """DescribeMNP response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeMNPManagerDetailData`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeMNPManagerDetailData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPManagerDetailData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPSensitiveAPIPermissionApprovalData(AbstractModel):
    """Details of a permission request to allow a mini program to call sensitive APIs

    """

    def __init__(self):
        r"""
        :param _APIId: API ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIId: str
        :param _APIMethod: API request method
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIMethod: str
        :param _ApplyReason: Reason for the request
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplyReason: str
        :param _RejectReason: Reason for rejection
Note: This field may return null, indicating that no valid values can be obtained.
        :type RejectReason: str
        :param _ApprovalStatus: Approval status. 20: Rejected; 30: Approved
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalStatus: int
        :param _APIDesc: API feature description
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIDesc: str
        :param _APIType: API type. 1: System; 2: Custom
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIType: int
        """
        self._APIId = None
        self._APIMethod = None
        self._ApplyReason = None
        self._RejectReason = None
        self._ApprovalStatus = None
        self._APIDesc = None
        self._APIType = None

    @property
    def APIId(self):
        """API ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId

    @property
    def APIMethod(self):
        """API request method
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._APIMethod

    @APIMethod.setter
    def APIMethod(self, APIMethod):
        self._APIMethod = APIMethod

    @property
    def ApplyReason(self):
        """Reason for the request
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplyReason

    @ApplyReason.setter
    def ApplyReason(self, ApplyReason):
        self._ApplyReason = ApplyReason

    @property
    def RejectReason(self):
        """Reason for rejection
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._RejectReason

    @RejectReason.setter
    def RejectReason(self, RejectReason):
        self._RejectReason = RejectReason

    @property
    def ApprovalStatus(self):
        """Approval status. 20: Rejected; 30: Approved
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ApprovalStatus

    @ApprovalStatus.setter
    def ApprovalStatus(self, ApprovalStatus):
        self._ApprovalStatus = ApprovalStatus

    @property
    def APIDesc(self):
        """API feature description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._APIDesc

    @APIDesc.setter
    def APIDesc(self, APIDesc):
        self._APIDesc = APIDesc

    @property
    def APIType(self):
        """API type. 1: System; 2: Custom
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._APIType

    @APIType.setter
    def APIType(self, APIType):
        self._APIType = APIType


    def _deserialize(self, params):
        self._APIId = params.get("APIId")
        self._APIMethod = params.get("APIMethod")
        self._ApplyReason = params.get("ApplyReason")
        self._RejectReason = params.get("RejectReason")
        self._ApprovalStatus = params.get("ApprovalStatus")
        self._APIDesc = params.get("APIDesc")
        self._APIType = params.get("APIType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPSensitiveAPIPermissionApprovalListData(AbstractModel):
    """List of permission requests to allow a mini program to call sensitive APIs

    """

    def __init__(self):
        r"""
        :param _ApprovalNo: Approval ID
        :type ApprovalNo: str
        :param _APIId: Sensitive API ID
        :type APIId: str
        :param _APIName: API name
        :type APIName: str
        :param _APIMethod: API request method
        :type APIMethod: str
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _MNPName: Mini program name
        :type MNPName: str
        :param _ApplyUser: Applicant
        :type ApplyUser: str
        :param _ApplyTime: Application time
        :type ApplyTime: str
        :param _ApplyNote: Application notes
        :type ApplyNote: str
        :param _ApprovalStatus: Approval status. 1: Processing; 20: Rejected; 30: Approved
        :type ApprovalStatus: int
        :param _ApprovalUser: Approver
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalUser: str
        :param _ApprovalTime: Approval time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalTime: str
        :param _ApprovalNote: Approval notes
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalNote: str
        :param _ApplicationId: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationId: str
        :param _ApplicationName: Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _ApplicationLogo: Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationLogo: str
        :param _APIType: API type. 1: System; 2: Custom
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIType: int
        :param _APIDesc: API feature description
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIDesc: str
        """
        self._ApprovalNo = None
        self._APIId = None
        self._APIName = None
        self._APIMethod = None
        self._MNPId = None
        self._MNPName = None
        self._ApplyUser = None
        self._ApplyTime = None
        self._ApplyNote = None
        self._ApprovalStatus = None
        self._ApprovalUser = None
        self._ApprovalTime = None
        self._ApprovalNote = None
        self._ApplicationId = None
        self._ApplicationName = None
        self._ApplicationLogo = None
        self._APIType = None
        self._APIDesc = None

    @property
    def ApprovalNo(self):
        """Approval ID
        :rtype: str
        """
        return self._ApprovalNo

    @ApprovalNo.setter
    def ApprovalNo(self, ApprovalNo):
        self._ApprovalNo = ApprovalNo

    @property
    def APIId(self):
        """Sensitive API ID
        :rtype: str
        """
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId

    @property
    def APIName(self):
        """API name
        :rtype: str
        """
        return self._APIName

    @APIName.setter
    def APIName(self, APIName):
        self._APIName = APIName

    @property
    def APIMethod(self):
        """API request method
        :rtype: str
        """
        return self._APIMethod

    @APIMethod.setter
    def APIMethod(self, APIMethod):
        self._APIMethod = APIMethod

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPName(self):
        """Mini program name
        :rtype: str
        """
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def ApplyUser(self):
        """Applicant
        :rtype: str
        """
        return self._ApplyUser

    @ApplyUser.setter
    def ApplyUser(self, ApplyUser):
        self._ApplyUser = ApplyUser

    @property
    def ApplyTime(self):
        """Application time
        :rtype: str
        """
        return self._ApplyTime

    @ApplyTime.setter
    def ApplyTime(self, ApplyTime):
        self._ApplyTime = ApplyTime

    @property
    def ApplyNote(self):
        """Application notes
        :rtype: str
        """
        return self._ApplyNote

    @ApplyNote.setter
    def ApplyNote(self, ApplyNote):
        self._ApplyNote = ApplyNote

    @property
    def ApprovalStatus(self):
        """Approval status. 1: Processing; 20: Rejected; 30: Approved
        :rtype: int
        """
        return self._ApprovalStatus

    @ApprovalStatus.setter
    def ApprovalStatus(self, ApprovalStatus):
        self._ApprovalStatus = ApprovalStatus

    @property
    def ApprovalUser(self):
        """Approver
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApprovalUser

    @ApprovalUser.setter
    def ApprovalUser(self, ApprovalUser):
        self._ApprovalUser = ApprovalUser

    @property
    def ApprovalTime(self):
        """Approval time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApprovalTime

    @ApprovalTime.setter
    def ApprovalTime(self, ApprovalTime):
        self._ApprovalTime = ApprovalTime

    @property
    def ApprovalNote(self):
        """Approval notes
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApprovalNote

    @ApprovalNote.setter
    def ApprovalNote(self, ApprovalNote):
        self._ApprovalNote = ApprovalNote

    @property
    def ApplicationId(self):
        """Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        """Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def ApplicationLogo(self):
        """Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplicationLogo

    @ApplicationLogo.setter
    def ApplicationLogo(self, ApplicationLogo):
        self._ApplicationLogo = ApplicationLogo

    @property
    def APIType(self):
        """API type. 1: System; 2: Custom
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._APIType

    @APIType.setter
    def APIType(self, APIType):
        self._APIType = APIType

    @property
    def APIDesc(self):
        """API feature description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._APIDesc

    @APIDesc.setter
    def APIDesc(self, APIDesc):
        self._APIDesc = APIDesc


    def _deserialize(self, params):
        self._ApprovalNo = params.get("ApprovalNo")
        self._APIId = params.get("APIId")
        self._APIName = params.get("APIName")
        self._APIMethod = params.get("APIMethod")
        self._MNPId = params.get("MNPId")
        self._MNPName = params.get("MNPName")
        self._ApplyUser = params.get("ApplyUser")
        self._ApplyTime = params.get("ApplyTime")
        self._ApplyNote = params.get("ApplyNote")
        self._ApprovalStatus = params.get("ApprovalStatus")
        self._ApprovalUser = params.get("ApprovalUser")
        self._ApprovalTime = params.get("ApprovalTime")
        self._ApprovalNote = params.get("ApprovalNote")
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._ApplicationLogo = params.get("ApplicationLogo")
        self._APIType = params.get("APIType")
        self._APIDesc = params.get("APIDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPSensitiveAPIPermissionApprovalListRequest(AbstractModel):
    """DescribeMNPSensitiveAPIPermissionApprovalList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _ApprovalStatusList: Approval status. 1: Processing; 20: Rejected; 30: Approved
        :type ApprovalStatusList: list of int
        :param _Keyword: Keywords for search (API name, API method or application name)
        :type Keyword: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._ApprovalStatusList = None
        self._Keyword = None

    @property
    def Offset(self):
        """Page offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of results per page
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def ApprovalStatusList(self):
        """Approval status. 1: Processing; 20: Rejected; 30: Approved
        :rtype: list of int
        """
        return self._ApprovalStatusList

    @ApprovalStatusList.setter
    def ApprovalStatusList(self, ApprovalStatusList):
        self._ApprovalStatusList = ApprovalStatusList

    @property
    def Keyword(self):
        """Keywords for search (API name, API method or application name)
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._ApprovalStatusList = params.get("ApprovalStatusList")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPSensitiveAPIPermissionApprovalListResp(AbstractModel):
    """List of permission requests to allow a mini program to call sensitive APIs

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
        :type TotalCount: int
        :param _DataList: List information
        :type DataList: list of DescribeMNPSensitiveAPIPermissionApprovalListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        """Total number of entries
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        """List information
        :rtype: list of DescribeMNPSensitiveAPIPermissionApprovalListData
        """
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeMNPSensitiveAPIPermissionApprovalListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPSensitiveAPIPermissionApprovalListResponse(AbstractModel):
    """DescribeMNPSensitiveAPIPermissionApprovalList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeMNPSensitiveAPIPermissionApprovalListResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeMNPSensitiveAPIPermissionApprovalListResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPSensitiveAPIPermissionApprovalListResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPSensitiveAPIPermissionApprovalRequest(AbstractModel):
    """DescribeMNPSensitiveAPIPermissionApproval request structure.

    """

    def __init__(self):
        r"""
        :param _ApprovalNo: Approval request number
        :type ApprovalNo: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._ApprovalNo = None
        self._PlatformId = None

    @property
    def ApprovalNo(self):
        """Approval request number
        :rtype: str
        """
        return self._ApprovalNo

    @ApprovalNo.setter
    def ApprovalNo(self, ApprovalNo):
        self._ApprovalNo = ApprovalNo

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._ApprovalNo = params.get("ApprovalNo")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPSensitiveAPIPermissionApprovalResponse(AbstractModel):
    """DescribeMNPSensitiveAPIPermissionApproval response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeMNPSensitiveAPIPermissionApprovalData`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeMNPSensitiveAPIPermissionApprovalData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPSensitiveAPIPermissionApprovalData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPSensitiveAPIPermissionListData(AbstractModel):
    """List of sensitive APIs that can be called by a mini program

    """

    def __init__(self):
        r"""
        :param _APIId: API ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIId: str
        :param _APIName: API name
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIName: str
        :param _APIMethod: API request method
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIMethod: str
        :param _APIStatus: API status
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIStatus: int
        :param _APIApplyStatus: API application status
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIApplyStatus: int
        :param _RejectReason: Reason for rejection
Note: This field may return null, indicating that no valid values can be obtained.
        :type RejectReason: str
        :param _ApprovalNo: Approval ID
        :type ApprovalNo: str
        :param _ApplicationId: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationId: str
        :param _ApplicationIcon: Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationIcon: str
        :param _ApplicationName: Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _APIType: API type. 1: System; 2: Custom
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIType: int
        :param _APIDesc: API feature description
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIDesc: str
        """
        self._APIId = None
        self._APIName = None
        self._APIMethod = None
        self._APIStatus = None
        self._APIApplyStatus = None
        self._RejectReason = None
        self._ApprovalNo = None
        self._ApplicationId = None
        self._ApplicationIcon = None
        self._ApplicationName = None
        self._APIType = None
        self._APIDesc = None

    @property
    def APIId(self):
        """API ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId

    @property
    def APIName(self):
        """API name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._APIName

    @APIName.setter
    def APIName(self, APIName):
        self._APIName = APIName

    @property
    def APIMethod(self):
        """API request method
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._APIMethod

    @APIMethod.setter
    def APIMethod(self, APIMethod):
        self._APIMethod = APIMethod

    @property
    def APIStatus(self):
        """API status
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._APIStatus

    @APIStatus.setter
    def APIStatus(self, APIStatus):
        self._APIStatus = APIStatus

    @property
    def APIApplyStatus(self):
        """API application status
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._APIApplyStatus

    @APIApplyStatus.setter
    def APIApplyStatus(self, APIApplyStatus):
        self._APIApplyStatus = APIApplyStatus

    @property
    def RejectReason(self):
        """Reason for rejection
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._RejectReason

    @RejectReason.setter
    def RejectReason(self, RejectReason):
        self._RejectReason = RejectReason

    @property
    def ApprovalNo(self):
        """Approval ID
        :rtype: str
        """
        return self._ApprovalNo

    @ApprovalNo.setter
    def ApprovalNo(self, ApprovalNo):
        self._ApprovalNo = ApprovalNo

    @property
    def ApplicationId(self):
        """Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationIcon(self):
        """Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplicationIcon

    @ApplicationIcon.setter
    def ApplicationIcon(self, ApplicationIcon):
        self._ApplicationIcon = ApplicationIcon

    @property
    def ApplicationName(self):
        """Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def APIType(self):
        """API type. 1: System; 2: Custom
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._APIType

    @APIType.setter
    def APIType(self, APIType):
        self._APIType = APIType

    @property
    def APIDesc(self):
        """API feature description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._APIDesc

    @APIDesc.setter
    def APIDesc(self, APIDesc):
        self._APIDesc = APIDesc


    def _deserialize(self, params):
        self._APIId = params.get("APIId")
        self._APIName = params.get("APIName")
        self._APIMethod = params.get("APIMethod")
        self._APIStatus = params.get("APIStatus")
        self._APIApplyStatus = params.get("APIApplyStatus")
        self._RejectReason = params.get("RejectReason")
        self._ApprovalNo = params.get("ApprovalNo")
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationIcon = params.get("ApplicationIcon")
        self._ApplicationName = params.get("ApplicationName")
        self._APIType = params.get("APIType")
        self._APIDesc = params.get("APIDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPSensitiveAPIPermissionListRequest(AbstractModel):
    """DescribeMNPSensitiveAPIPermissionList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _Keyword: Keywords for search (API name)
        :type Keyword: str
        """
        self._Offset = None
        self._Limit = None
        self._MNPId = None
        self._PlatformId = None
        self._ApplicationId = None
        self._Keyword = None

    @property
    def Offset(self):
        """Page offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of results per page
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def ApplicationId(self):
        """Application ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def Keyword(self):
        """Keywords for search (API name)
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        self._ApplicationId = params.get("ApplicationId")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPSensitiveAPIPermissionListResp(AbstractModel):
    """List of sensitive APIs that can be called by a mini program

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List data
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeMNPSensitiveAPIPermissionListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        """Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        """List data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DescribeMNPSensitiveAPIPermissionListData
        """
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeMNPSensitiveAPIPermissionListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPSensitiveAPIPermissionListResponse(AbstractModel):
    """DescribeMNPSensitiveAPIPermissionList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response parameters
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeMNPSensitiveAPIPermissionListResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response parameters
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeMNPSensitiveAPIPermissionListResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPSensitiveAPIPermissionListResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPVersionRequest(AbstractModel):
    """DescribeMNPVersion request structure.

    """

    def __init__(self):
        r"""
        :param _BusinessId: ID of the task to create a mini program version
        :type BusinessId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._BusinessId = None
        self._PlatformId = None

    @property
    def BusinessId(self):
        """ID of the task to create a mini program version
        :rtype: str
        """
        return self._BusinessId

    @BusinessId.setter
    def BusinessId(self, BusinessId):
        self._BusinessId = BusinessId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._BusinessId = params.get("BusinessId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPVersionResp(AbstractModel):
    """Result of the task to create a mini program version

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _TaskId: Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: str
        :param _TaskStatus: 1: Pending; 20: Running; 30: Failed; 60: Succeeded 
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskStatus: int
        :param _TaskMsg: Task status message
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskMsg: str
        """
        self._MNPId = None
        self._TaskId = None
        self._TaskStatus = None
        self._TaskMsg = None

    @property
    def MNPId(self):
        """Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def TaskId(self):
        """Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskStatus(self):
        """1: Pending; 20: Running; 30: Failed; 60: Succeeded 
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def TaskMsg(self):
        """Task status message
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TaskMsg

    @TaskMsg.setter
    def TaskMsg(self, TaskMsg):
        self._TaskMsg = TaskMsg


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._TaskId = params.get("TaskId")
        self._TaskStatus = params.get("TaskStatus")
        self._TaskMsg = params.get("TaskMsg")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPVersionResponse(AbstractModel):
    """DescribeMNPVersion response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeMNPVersionResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeMNPVersionResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPVersionResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMPAllStageVersionsResp(AbstractModel):
    """List of all developer versions of a mini program

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _MNPVersionId: Mini program version ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersionId: int
        :param _MNPName: Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPName: str
        :param _MNPIcon: Mini program icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIcon: str
        :param _MNPType: Mini program type
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPType: str
        :param _MNPIntro: Mini program introduction
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIntro: str
        :param _MNPDesc: Mini program description
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPDesc: str
        :param _CreateUser: Developer
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _CreateTime: The time when the developer created it
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _MNPVersion: Mini program version
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersion: str
        :param _MNPVersionIntro: Version features
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersionIntro: str
        :param _Phase: Phase. Values: [Develop,Platform,Online]
Note: This field may return null, indicating that no valid values can be obtained.
        :type Phase: str
        :param _ApprovalStatus: 0: Pending; 1: Processing; 2: Rejected; 3: Approved; 4: Cancelled
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalStatus: int
        :param _ApprovalNo: Approval request number
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalNo: str
        :param _ShowCase: Whether it is a preview
0: Not a preview; 1: Preview
Note: This field may return null, indicating that no valid values can be obtained.
        :type ShowCase: int
        :param _RollbackVersion: Version number to roll back to
Note: This field may return null, indicating that no valid values can be obtained.
        :type RollbackVersion: int
        :param _Status: Release status
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _VersionCurrentStatus: Version approval status. 0: Pending; 1: Processing; 2: Rejected; 3: Approved; 4: Cancelled
Note: This field may return null, indicating that no valid values can be obtained.
        :type VersionCurrentStatus: int
        """
        self._MNPId = None
        self._MNPVersionId = None
        self._MNPName = None
        self._MNPIcon = None
        self._MNPType = None
        self._MNPIntro = None
        self._MNPDesc = None
        self._CreateUser = None
        self._CreateTime = None
        self._MNPVersion = None
        self._MNPVersionIntro = None
        self._Phase = None
        self._ApprovalStatus = None
        self._ApprovalNo = None
        self._ShowCase = None
        self._RollbackVersion = None
        self._Status = None
        self._VersionCurrentStatus = None

    @property
    def MNPId(self):
        """Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPVersionId(self):
        """Mini program version ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def MNPName(self):
        """Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def MNPIcon(self):
        """Mini program icon
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPIcon

    @MNPIcon.setter
    def MNPIcon(self, MNPIcon):
        self._MNPIcon = MNPIcon

    @property
    def MNPType(self):
        """Mini program type
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPType

    @MNPType.setter
    def MNPType(self, MNPType):
        self._MNPType = MNPType

    @property
    def MNPIntro(self):
        """Mini program introduction
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPIntro

    @MNPIntro.setter
    def MNPIntro(self, MNPIntro):
        self._MNPIntro = MNPIntro

    @property
    def MNPDesc(self):
        """Mini program description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPDesc

    @MNPDesc.setter
    def MNPDesc(self, MNPDesc):
        self._MNPDesc = MNPDesc

    @property
    def CreateUser(self):
        """Developer
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        """The time when the developer created it
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def MNPVersion(self):
        """Mini program version
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPVersion

    @MNPVersion.setter
    def MNPVersion(self, MNPVersion):
        self._MNPVersion = MNPVersion

    @property
    def MNPVersionIntro(self):
        """Version features
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPVersionIntro

    @MNPVersionIntro.setter
    def MNPVersionIntro(self, MNPVersionIntro):
        self._MNPVersionIntro = MNPVersionIntro

    @property
    def Phase(self):
        """Phase. Values: [Develop,Platform,Online]
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Phase

    @Phase.setter
    def Phase(self, Phase):
        self._Phase = Phase

    @property
    def ApprovalStatus(self):
        """0: Pending; 1: Processing; 2: Rejected; 3: Approved; 4: Cancelled
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ApprovalStatus

    @ApprovalStatus.setter
    def ApprovalStatus(self, ApprovalStatus):
        self._ApprovalStatus = ApprovalStatus

    @property
    def ApprovalNo(self):
        """Approval request number
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ApprovalNo

    @ApprovalNo.setter
    def ApprovalNo(self, ApprovalNo):
        self._ApprovalNo = ApprovalNo

    @property
    def ShowCase(self):
        """Whether it is a preview
0: Not a preview; 1: Preview
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ShowCase

    @ShowCase.setter
    def ShowCase(self, ShowCase):
        self._ShowCase = ShowCase

    @property
    def RollbackVersion(self):
        """Version number to roll back to
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._RollbackVersion

    @RollbackVersion.setter
    def RollbackVersion(self, RollbackVersion):
        self._RollbackVersion = RollbackVersion

    @property
    def Status(self):
        """Release status
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def VersionCurrentStatus(self):
        """Version approval status. 0: Pending; 1: Processing; 2: Rejected; 3: Approved; 4: Cancelled
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._VersionCurrentStatus

    @VersionCurrentStatus.setter
    def VersionCurrentStatus(self, VersionCurrentStatus):
        self._VersionCurrentStatus = VersionCurrentStatus


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPVersionId = params.get("MNPVersionId")
        self._MNPName = params.get("MNPName")
        self._MNPIcon = params.get("MNPIcon")
        self._MNPType = params.get("MNPType")
        self._MNPIntro = params.get("MNPIntro")
        self._MNPDesc = params.get("MNPDesc")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._MNPVersion = params.get("MNPVersion")
        self._MNPVersionIntro = params.get("MNPVersionIntro")
        self._Phase = params.get("Phase")
        self._ApprovalStatus = params.get("ApprovalStatus")
        self._ApprovalNo = params.get("ApprovalNo")
        self._ShowCase = params.get("ShowCase")
        self._RollbackVersion = params.get("RollbackVersion")
        self._Status = params.get("Status")
        self._VersionCurrentStatus = params.get("VersionCurrentStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRevertOnlineVersionPageResp(AbstractModel):
    """Response of querying the rollback version list

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of QueryOnlineVersionResp
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        """Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        """List information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of QueryOnlineVersionResp
        """
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = QueryOnlineVersionResp()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRoleListData(AbstractModel):
    """Role management list

    """

    def __init__(self):
        r"""
        :param _RoleId: Role ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RoleId: int
        :param _RoleName: Role name
Note: This field may return null, indicating that no valid values can be obtained.
        :type RoleName: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _RoleType: Role type 1-Preset role 2-Custom role
Note: This field may return null, indicating that no valid values can be obtained.
        :type RoleType: int
        """
        self._RoleId = None
        self._RoleName = None
        self._TeamName = None
        self._CreateTime = None
        self._RoleType = None

    @property
    def RoleId(self):
        """Role ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._RoleId

    @RoleId.setter
    def RoleId(self, RoleId):
        self._RoleId = RoleId

    @property
    def RoleName(self):
        """Role name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def TeamName(self):
        """Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def CreateTime(self):
        """Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def RoleType(self):
        """Role type 1-Preset role 2-Custom role
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._RoleType

    @RoleType.setter
    def RoleType(self, RoleType):
        self._RoleType = RoleType


    def _deserialize(self, params):
        self._RoleId = params.get("RoleId")
        self._RoleName = params.get("RoleName")
        self._TeamName = params.get("TeamName")
        self._CreateTime = params.get("CreateTime")
        self._RoleType = params.get("RoleType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRoleListRequest(AbstractModel):
    """DescribeRoleList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _Keyword: Keywords for search (role name)
        :type Keyword: str
        :param _TeamId: Team ID
        :type TeamId: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._Keyword = None
        self._TeamId = None

    @property
    def Offset(self):
        """Page offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of results per page
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def Keyword(self):
        """Keywords for search (role name)
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def TeamId(self):
        """Team ID
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._Keyword = params.get("Keyword")
        self._TeamId = params.get("TeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRoleListResp(AbstractModel):
    """Role management list

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List data
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeRoleListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        """Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        """List data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DescribeRoleListData
        """
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeRoleListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRoleListResponse(AbstractModel):
    """DescribeRoleList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeRoleListResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeRoleListResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeRoleListResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTeamDetailResp(AbstractModel):
    """Team details

    """

    def __init__(self):
        r"""
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _TeamRoleType: Team role type 1-Mini program team 2-Application team
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamRoleType: int
        :param _AdminUserAccount: Admin account
Note: This field may return null, indicating that no valid values can be obtained.
        :type AdminUserAccount: str
        :param _CreateUser: Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _MemberCount: Number of team members
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberCount: int
        :param _BindMiniTeamCount: Number of bound mini program teams
Note: This field may return null, indicating that no valid values can be obtained.
        :type BindMiniTeamCount: int
        :param _BindTeamName: Name of the bound team
        :type BindTeamName: str
        :param _RegisterLink: Team registration link
        :type RegisterLink: str
        :param _ApplicationName: Application name. It’s required when querying details of a mini program team.
        :type ApplicationName: str
        """
        self._TeamName = None
        self._TeamRoleType = None
        self._AdminUserAccount = None
        self._CreateUser = None
        self._CreateTime = None
        self._MemberCount = None
        self._BindMiniTeamCount = None
        self._BindTeamName = None
        self._RegisterLink = None
        self._ApplicationName = None

    @property
    def TeamName(self):
        """Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def TeamRoleType(self):
        """Team role type 1-Mini program team 2-Application team
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TeamRoleType

    @TeamRoleType.setter
    def TeamRoleType(self, TeamRoleType):
        self._TeamRoleType = TeamRoleType

    @property
    def AdminUserAccount(self):
        """Admin account
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AdminUserAccount

    @AdminUserAccount.setter
    def AdminUserAccount(self, AdminUserAccount):
        self._AdminUserAccount = AdminUserAccount

    @property
    def CreateUser(self):
        """Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        """Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def MemberCount(self):
        """Number of team members
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MemberCount

    @MemberCount.setter
    def MemberCount(self, MemberCount):
        self._MemberCount = MemberCount

    @property
    def BindMiniTeamCount(self):
        """Number of bound mini program teams
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._BindMiniTeamCount

    @BindMiniTeamCount.setter
    def BindMiniTeamCount(self, BindMiniTeamCount):
        self._BindMiniTeamCount = BindMiniTeamCount

    @property
    def BindTeamName(self):
        """Name of the bound team
        :rtype: str
        """
        return self._BindTeamName

    @BindTeamName.setter
    def BindTeamName(self, BindTeamName):
        self._BindTeamName = BindTeamName

    @property
    def RegisterLink(self):
        """Team registration link
        :rtype: str
        """
        return self._RegisterLink

    @RegisterLink.setter
    def RegisterLink(self, RegisterLink):
        self._RegisterLink = RegisterLink

    @property
    def ApplicationName(self):
        """Application name. It’s required when querying details of a mini program team.
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName


    def _deserialize(self, params):
        self._TeamName = params.get("TeamName")
        self._TeamRoleType = params.get("TeamRoleType")
        self._AdminUserAccount = params.get("AdminUserAccount")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._MemberCount = params.get("MemberCount")
        self._BindMiniTeamCount = params.get("BindMiniTeamCount")
        self._BindTeamName = params.get("BindTeamName")
        self._RegisterLink = params.get("RegisterLink")
        self._ApplicationName = params.get("ApplicationName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamListInfoResp(AbstractModel):
    """Team list information

    """

    def __init__(self):
        r"""
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _AdminUserId: Admin ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type AdminUserId: str
        :param _AdminUserAccount: Admin account
Note: This field may return null, indicating that no valid values can be obtained.
        :type AdminUserAccount: str
        :param _AdminUserName: Admin username
Note: This field may return null, indicating that no valid values can be obtained.
        :type AdminUserName: str
        :param _MemberCount: Number of team members
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberCount: int
        :param _RegisterLink: Team registration link
        :type RegisterLink: str
        :param _TeamRoleTypeList: Team permission type
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamRoleTypeList: list of int
        :param _RelatedTeamId: Associated team ID
        :type RelatedTeamId: int
        """
        self._TeamId = None
        self._TeamName = None
        self._AdminUserId = None
        self._AdminUserAccount = None
        self._AdminUserName = None
        self._MemberCount = None
        self._RegisterLink = None
        self._TeamRoleTypeList = None
        self._RelatedTeamId = None

    @property
    def TeamId(self):
        """Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        """Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def AdminUserId(self):
        """Admin ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AdminUserId

    @AdminUserId.setter
    def AdminUserId(self, AdminUserId):
        self._AdminUserId = AdminUserId

    @property
    def AdminUserAccount(self):
        """Admin account
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AdminUserAccount

    @AdminUserAccount.setter
    def AdminUserAccount(self, AdminUserAccount):
        self._AdminUserAccount = AdminUserAccount

    @property
    def AdminUserName(self):
        """Admin username
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AdminUserName

    @AdminUserName.setter
    def AdminUserName(self, AdminUserName):
        self._AdminUserName = AdminUserName

    @property
    def MemberCount(self):
        """Number of team members
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MemberCount

    @MemberCount.setter
    def MemberCount(self, MemberCount):
        self._MemberCount = MemberCount

    @property
    def RegisterLink(self):
        """Team registration link
        :rtype: str
        """
        return self._RegisterLink

    @RegisterLink.setter
    def RegisterLink(self, RegisterLink):
        self._RegisterLink = RegisterLink

    @property
    def TeamRoleTypeList(self):
        """Team permission type
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._TeamRoleTypeList

    @TeamRoleTypeList.setter
    def TeamRoleTypeList(self, TeamRoleTypeList):
        self._TeamRoleTypeList = TeamRoleTypeList

    @property
    def RelatedTeamId(self):
        """Associated team ID
        :rtype: int
        """
        return self._RelatedTeamId

    @RelatedTeamId.setter
    def RelatedTeamId(self, RelatedTeamId):
        self._RelatedTeamId = RelatedTeamId


    def _deserialize(self, params):
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._AdminUserId = params.get("AdminUserId")
        self._AdminUserAccount = params.get("AdminUserAccount")
        self._AdminUserName = params.get("AdminUserName")
        self._MemberCount = params.get("MemberCount")
        self._RegisterLink = params.get("RegisterLink")
        self._TeamRoleTypeList = params.get("TeamRoleTypeList")
        self._RelatedTeamId = params.get("RelatedTeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamListRequest(AbstractModel):
    """DescribeTeamList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Pagination offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _Keyword: Name of the team to be queried
        :type Keyword: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._Keyword = None

    @property
    def Offset(self):
        """Pagination offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of results per page
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def Keyword(self):
        """Name of the team to be queried
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamListResponse(AbstractModel):
    """DescribeTeamList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeTeamPageResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeTeamPageResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeTeamPageResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTeamMemberInfoResp(AbstractModel):
    """Team member information

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserId: str
        :param _UserAccount: User account
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserAccount: str
        :param _UserName: User name
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserName: str
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _TeamRoleName: Team role name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamRoleName: str
        :param _TeamRoleId: Team role ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamRoleId: int
        :param _CanEdit: Editable or not
Note: This field may return null, indicating that no valid values can be obtained.
        :type CanEdit: bool
        """
        self._UserId = None
        self._UserAccount = None
        self._UserName = None
        self._TeamId = None
        self._TeamName = None
        self._TeamRoleName = None
        self._TeamRoleId = None
        self._CanEdit = None

    @property
    def UserId(self):
        """User ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserAccount(self):
        """User account
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserAccount

    @UserAccount.setter
    def UserAccount(self, UserAccount):
        self._UserAccount = UserAccount

    @property
    def UserName(self):
        """User name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def TeamId(self):
        """Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        """Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def TeamRoleName(self):
        """Team role name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamRoleName

    @TeamRoleName.setter
    def TeamRoleName(self, TeamRoleName):
        self._TeamRoleName = TeamRoleName

    @property
    def TeamRoleId(self):
        """Team role ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TeamRoleId

    @TeamRoleId.setter
    def TeamRoleId(self, TeamRoleId):
        self._TeamRoleId = TeamRoleId

    @property
    def CanEdit(self):
        """Editable or not
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._CanEdit

    @CanEdit.setter
    def CanEdit(self, CanEdit):
        self._CanEdit = CanEdit


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserAccount = params.get("UserAccount")
        self._UserName = params.get("UserName")
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._TeamRoleName = params.get("TeamRoleName")
        self._TeamRoleId = params.get("TeamRoleId")
        self._CanEdit = params.get("CanEdit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamMemberListPageResp(AbstractModel):
    """List of members

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of results.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeTeamMemberInfoResp
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        """Total number of results.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        """List information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DescribeTeamMemberInfoResp
        """
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeTeamMemberInfoResp()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamMemberListRequest(AbstractModel):
    """DescribeTeamMemberList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _TeamId: Team ID
        :type TeamId: str
        :param _Keyword: Keywords for search (user name)
        :type Keyword: str
        :param _RoleIds: Role ID
        :type RoleIds: list of int
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._TeamId = None
        self._Keyword = None
        self._RoleIds = None

    @property
    def Offset(self):
        """Page offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of results per page
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def TeamId(self):
        """Team ID
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def Keyword(self):
        """Keywords for search (user name)
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def RoleIds(self):
        """Role ID
        :rtype: list of int
        """
        return self._RoleIds

    @RoleIds.setter
    def RoleIds(self, RoleIds):
        self._RoleIds = RoleIds


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._TeamId = params.get("TeamId")
        self._Keyword = params.get("Keyword")
        self._RoleIds = params.get("RoleIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamMemberListResponse(AbstractModel):
    """DescribeTeamMemberList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeTeamMemberListPageResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeTeamMemberListPageResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeTeamMemberListPageResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTeamPageResp(AbstractModel):
    """Team list

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeTeamListInfoResp
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        """Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        """List information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DescribeTeamListInfoResp
        """
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeTeamListInfoResp()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamRequest(AbstractModel):
    """DescribeTeam request structure.

    """

    def __init__(self):
        r"""
        :param _TeamId: Team ID
        :type TeamId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._TeamId = None
        self._PlatformId = None

    @property
    def TeamId(self):
        """Team ID
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._TeamId = params.get("TeamId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamResponse(AbstractModel):
    """DescribeTeam response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeTeamDetailResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeTeamDetailResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeTeamDetailResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTempSecret4UploadFile2CosRequest(AbstractModel):
    """DescribeTempSecret4UploadFile2Cos request structure.

    """

    def __init__(self):
        r"""
        :param _BusinessName: Service name
        :type BusinessName: str
        :param _Suffix: File suffix
        :type Suffix: str
        """
        self._BusinessName = None
        self._Suffix = None

    @property
    def BusinessName(self):
        """Service name
        :rtype: str
        """
        return self._BusinessName

    @BusinessName.setter
    def BusinessName(self, BusinessName):
        self._BusinessName = BusinessName

    @property
    def Suffix(self):
        """File suffix
        :rtype: str
        """
        return self._Suffix

    @Suffix.setter
    def Suffix(self, Suffix):
        self._Suffix = Suffix


    def _deserialize(self, params):
        self._BusinessName = params.get("BusinessName")
        self._Suffix = params.get("Suffix")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTempSecret4UploadFile2CosResponse(AbstractModel):
    """DescribeTempSecret4UploadFile2Cos response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.UploadFileTempSecret`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.UploadFileTempSecret`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = UploadFileTempSecret()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeUserDetailResp(AbstractModel):
    """User details

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserId: str
        :param _UserAccount: User account
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserAccount: str
        :param _AccountType: User account
1 - Super admin 2 - Platform admin 3 - Member
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccountType: int
        :param _UserName: User name
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserName: str
        """
        self._UserId = None
        self._UserAccount = None
        self._AccountType = None
        self._UserName = None

    @property
    def UserId(self):
        """User ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserAccount(self):
        """User account
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserAccount

    @UserAccount.setter
    def UserAccount(self, UserAccount):
        self._UserAccount = UserAccount

    @property
    def AccountType(self):
        """User account
1 - Super admin 2 - Platform admin 3 - Member
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType

    @property
    def UserName(self):
        """User name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserAccount = params.get("UserAccount")
        self._AccountType = params.get("AccountType")
        self._UserName = params.get("UserName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserListData(AbstractModel):
    """User list data

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserId: str
        :param _UserAccount: User account
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserAccount: str
        :param _AccountType: Account type. 1: Super admin; 2: Platform admin; 3: Member
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccountType: int
        :param _UserName: User name
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserName: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _Status: Status. 1: Normal; 2: Disabled
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        """
        self._UserId = None
        self._UserAccount = None
        self._AccountType = None
        self._UserName = None
        self._CreateTime = None
        self._Status = None
        self._TeamName = None

    @property
    def UserId(self):
        """User ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserAccount(self):
        """User account
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserAccount

    @UserAccount.setter
    def UserAccount(self, UserAccount):
        self._UserAccount = UserAccount

    @property
    def AccountType(self):
        """Account type. 1: Super admin; 2: Platform admin; 3: Member
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType

    @property
    def UserName(self):
        """User name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def CreateTime(self):
        """Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Status(self):
        """Status. 1: Normal; 2: Disabled
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TeamName(self):
        """Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserAccount = params.get("UserAccount")
        self._AccountType = params.get("AccountType")
        self._UserName = params.get("UserName")
        self._CreateTime = params.get("CreateTime")
        self._Status = params.get("Status")
        self._TeamName = params.get("TeamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserListRequest(AbstractModel):
    """DescribeUserList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _Keyword: Keywords for search (username or account)
        :type Keyword: str
        :param _AccountType: User account 1 - Super admin 2 - Platform admin 3 - Member
        :type AccountType: int
        :param _TeamId: Team ID
        :type TeamId: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._Keyword = None
        self._AccountType = None
        self._TeamId = None

    @property
    def Offset(self):
        """Page offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of results per page
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def Keyword(self):
        """Keywords for search (username or account)
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def AccountType(self):
        """User account 1 - Super admin 2 - Platform admin 3 - Member
        :rtype: int
        """
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType

    @property
    def TeamId(self):
        """Team ID
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._Keyword = params.get("Keyword")
        self._AccountType = params.get("AccountType")
        self._TeamId = params.get("TeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserListResp(AbstractModel):
    """User management list

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List data
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeUserListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        """Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        """List data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DescribeUserListData
        """
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeUserListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserListResponse(AbstractModel):
    """DescribeUserList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeUserListResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeUserListResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeUserListResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeUserRequest(AbstractModel):
    """DescribeUser request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
        :type UserId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._UserId = None
        self._PlatformId = None

    @property
    def UserId(self):
        """User ID
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserResponse(AbstractModel):
    """DescribeUser response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.DescribeUserDetailResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.DescribeUserDetailResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeUserDetailResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DisableApplicationSensitiveAPIRequest(AbstractModel):
    """DisableApplicationSensitiveAPI request structure.

    """

    def __init__(self):
        r"""
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _APIId: API ID
        :type APIId: str
        """
        self._PlatformId = None
        self._APIId = None

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def APIId(self):
        """API ID
        :rtype: str
        """
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId


    def _deserialize(self, params):
        self._PlatformId = params.get("PlatformId")
        self._APIId = params.get("APIId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableApplicationSensitiveAPIResponse(AbstractModel):
    """DisableApplicationSensitiveAPI response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DownloadApplicationConfigResp(AbstractModel):
    """Application configuration info

    """

    def __init__(self):
        r"""
        :param _File: Configuration information in Base64 format
Note: This field may return null, indicating that no valid values can be obtained.
        :type File: str
        """
        self._File = None

    @property
    def File(self):
        """Configuration information in Base64 format
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._File

    @File.setter
    def File(self, File):
        self._File = File


    def _deserialize(self, params):
        self._File = params.get("File")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableApplicationSensitiveAPIRequest(AbstractModel):
    """EnableApplicationSensitiveAPI request structure.

    """

    def __init__(self):
        r"""
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _APIId: API ID
        :type APIId: str
        """
        self._PlatformId = None
        self._APIId = None

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def APIId(self):
        """API ID
        :rtype: str
        """
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId


    def _deserialize(self, params):
        self._PlatformId = params.get("PlatformId")
        self._APIId = params.get("APIId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableApplicationSensitiveAPIResponse(AbstractModel):
    """EnableApplicationSensitiveAPI response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class GlobalDomainDeleteResp(AbstractModel):
    """Response of deleting a global domain name

    """

    def __init__(self):
        r"""
        :param _Result: Response result
Note: This field may return null, indicating that no valid values can be obtained.
        :type Result: bool
        """
        self._Result = None

    @property
    def Result(self):
        """Response result
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result


    def _deserialize(self, params):
        self._Result = params.get("Result")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GlobalDomainModifyRespResp(AbstractModel):
    """Response of global domain name modification

    """

    def __init__(self):
        r"""
        :param _Result: 0: Success; 1: Allowed domains; 2: Blocked domains
Note: This field may return null, indicating that no valid values can be obtained.
        :type Result: int
        """
        self._Result = None

    @property
    def Result(self):
        """0: Success; 1: Allowed domains; 2: Blocked domains
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result


    def _deserialize(self, params):
        self._Result = params.get("Result")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MNPTypeDefine(AbstractModel):
    """Mini program category information

    """

    def __init__(self):
        r"""
        :param _TypeName: Mini program category name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TypeName: str
        :param _TypeValue: Mini program category value
Note: This field may return null, indicating that no valid values can be obtained.
        :type TypeValue: list of str
        :param _TypeId: Category ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TypeId: int
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: int
        :param _CreateUser: Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _IsSystem: Whether it is a system category
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsSystem: bool
        """
        self._TypeName = None
        self._TypeValue = None
        self._TypeId = None
        self._CreateTime = None
        self._CreateUser = None
        self._IsSystem = None

    @property
    def TypeName(self):
        """Mini program category name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TypeName

    @TypeName.setter
    def TypeName(self, TypeName):
        self._TypeName = TypeName

    @property
    def TypeValue(self):
        """Mini program category value
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._TypeValue

    @TypeValue.setter
    def TypeValue(self, TypeValue):
        self._TypeValue = TypeValue

    @property
    def TypeId(self):
        """Category ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TypeId

    @TypeId.setter
    def TypeId(self, TypeId):
        self._TypeId = TypeId

    @property
    def CreateTime(self):
        """Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def CreateUser(self):
        """Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def IsSystem(self):
        """Whether it is a system category
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._IsSystem

    @IsSystem.setter
    def IsSystem(self, IsSystem):
        self._IsSystem = IsSystem


    def _deserialize(self, params):
        self._TypeName = params.get("TypeName")
        self._TypeValue = params.get("TypeValue")
        self._TypeId = params.get("TypeId")
        self._CreateTime = params.get("CreateTime")
        self._CreateUser = params.get("CreateUser")
        self._IsSystem = params.get("IsSystem")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyApplicationRequest(AbstractModel):
    """ModifyApplication request structure.

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _ApplicationName: Application name
        :type ApplicationName: str
        :param _Intro: Application introduction
        :type Intro: str
        :param _Logo: Icon
        :type Logo: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _AndroidAppKey: Android app package name
        :type AndroidAppKey: str
        :param _IosAppKey: iOS App bundleId
        :type IosAppKey: str
        :param _Remark: Remarks
        :type Remark: str
        """
        self._ApplicationId = None
        self._ApplicationName = None
        self._Intro = None
        self._Logo = None
        self._PlatformId = None
        self._AndroidAppKey = None
        self._IosAppKey = None
        self._Remark = None

    @property
    def ApplicationId(self):
        """Application ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        """Application name
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def Intro(self):
        """Application introduction
        :rtype: str
        """
        return self._Intro

    @Intro.setter
    def Intro(self, Intro):
        self._Intro = Intro

    @property
    def Logo(self):
        """Icon
        :rtype: str
        """
        return self._Logo

    @Logo.setter
    def Logo(self, Logo):
        self._Logo = Logo

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def AndroidAppKey(self):
        """Android app package name
        :rtype: str
        """
        return self._AndroidAppKey

    @AndroidAppKey.setter
    def AndroidAppKey(self, AndroidAppKey):
        self._AndroidAppKey = AndroidAppKey

    @property
    def IosAppKey(self):
        """iOS App bundleId
        :rtype: str
        """
        return self._IosAppKey

    @IosAppKey.setter
    def IosAppKey(self, IosAppKey):
        self._IosAppKey = IosAppKey

    @property
    def Remark(self):
        """Remarks
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._Intro = params.get("Intro")
        self._Logo = params.get("Logo")
        self._PlatformId = params.get("PlatformId")
        self._AndroidAppKey = params.get("AndroidAppKey")
        self._IosAppKey = params.get("IosAppKey")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyApplicationResponse(AbstractModel):
    """ModifyApplication response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyGlobalDomainRequest(AbstractModel):
    """ModifyGlobalDomain request structure.

    """

    def __init__(self):
        r"""
        :param _DomainId: Domain ID
        :type DomainId: int
        :param _DomainUrl: Domain name
        :type DomainUrl: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._DomainId = None
        self._DomainUrl = None
        self._PlatformId = None

    @property
    def DomainId(self):
        """Domain ID
        :rtype: int
        """
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def DomainUrl(self):
        """Domain name
        :rtype: str
        """
        return self._DomainUrl

    @DomainUrl.setter
    def DomainUrl(self, DomainUrl):
        self._DomainUrl = DomainUrl

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._DomainId = params.get("DomainId")
        self._DomainUrl = params.get("DomainUrl")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyGlobalDomainResponse(AbstractModel):
    """ModifyGlobalDomain response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.GlobalDomainModifyRespResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.GlobalDomainModifyRespResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = GlobalDomainModifyRespResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyMNPDomainRequest(AbstractModel):
    """ModifyMNPDomain request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _Domain: Domain list
        :type Domain: list of CreateDomainParam
        """
        self._MNPId = None
        self._PlatformId = None
        self._Domain = None

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def Domain(self):
        """Domain list
        :rtype: list of CreateDomainParam
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        if params.get("Domain") is not None:
            self._Domain = []
            for item in params.get("Domain"):
                obj = CreateDomainParam()
                obj._deserialize(item)
                self._Domain.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyMNPDomainResponse(AbstractModel):
    """ModifyMNPDomain response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyMNPRequest(AbstractModel):
    """ModifyMNP request structure.

    """

    def __init__(self):
        r"""
        :param _MNPType: Mini program type
        :type MNPType: str
        :param _MNPName: Mini program name
        :type MNPName: str
        :param _MNPIntro: Mini program introduction
        :type MNPIntro: str
        :param _MNPDesc: Mini program description
        :type MNPDesc: str
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _MNPIcon: Mini program icon
        :type MNPIcon: str
        """
        self._MNPType = None
        self._MNPName = None
        self._MNPIntro = None
        self._MNPDesc = None
        self._MNPId = None
        self._PlatformId = None
        self._MNPIcon = None

    @property
    def MNPType(self):
        """Mini program type
        :rtype: str
        """
        return self._MNPType

    @MNPType.setter
    def MNPType(self, MNPType):
        self._MNPType = MNPType

    @property
    def MNPName(self):
        """Mini program name
        :rtype: str
        """
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def MNPIntro(self):
        """Mini program introduction
        :rtype: str
        """
        return self._MNPIntro

    @MNPIntro.setter
    def MNPIntro(self, MNPIntro):
        self._MNPIntro = MNPIntro

    @property
    def MNPDesc(self):
        """Mini program description
        :rtype: str
        """
        return self._MNPDesc

    @MNPDesc.setter
    def MNPDesc(self, MNPDesc):
        self._MNPDesc = MNPDesc

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def MNPIcon(self):
        """Mini program icon
        :rtype: str
        """
        return self._MNPIcon

    @MNPIcon.setter
    def MNPIcon(self, MNPIcon):
        self._MNPIcon = MNPIcon


    def _deserialize(self, params):
        self._MNPType = params.get("MNPType")
        self._MNPName = params.get("MNPName")
        self._MNPIntro = params.get("MNPIntro")
        self._MNPDesc = params.get("MNPDesc")
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        self._MNPIcon = params.get("MNPIcon")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyMNPResponse(AbstractModel):
    """ModifyMNP response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.ResourceIdInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.ResourceIdInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = ResourceIdInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyTeamMemberRequest(AbstractModel):
    """ModifyTeamMember request structure.

    """

    def __init__(self):
        r"""
        :param _TeamId: Team ID
        :type TeamId: str
        :param _UserId: User ID
        :type UserId: str
        :param _RoleId: Role ID
        :type RoleId: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._TeamId = None
        self._UserId = None
        self._RoleId = None
        self._PlatformId = None

    @property
    def TeamId(self):
        """Team ID
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def UserId(self):
        """User ID
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def RoleId(self):
        """Role ID
        :rtype: int
        """
        return self._RoleId

    @RoleId.setter
    def RoleId(self, RoleId):
        self._RoleId = RoleId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._TeamId = params.get("TeamId")
        self._UserId = params.get("UserId")
        self._RoleId = params.get("RoleId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTeamMemberResponse(AbstractModel):
    """ModifyTeamMember response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyTeamRequest(AbstractModel):
    """ModifyTeam request structure.

    """

    def __init__(self):
        r"""
        :param _TeamId: Team ID
        :type TeamId: str
        :param _TeamName: Team name
        :type TeamName: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _AdminUserId: Team administrator
        :type AdminUserId: str
        """
        self._TeamId = None
        self._TeamName = None
        self._PlatformId = None
        self._AdminUserId = None

    @property
    def TeamId(self):
        """Team ID
        :rtype: str
        """
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        """Team name
        :rtype: str
        """
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def AdminUserId(self):
        """Team administrator
        :rtype: str
        """
        return self._AdminUserId

    @AdminUserId.setter
    def AdminUserId(self, AdminUserId):
        self._AdminUserId = AdminUserId


    def _deserialize(self, params):
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._PlatformId = params.get("PlatformId")
        self._AdminUserId = params.get("AdminUserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTeamResponse(AbstractModel):
    """ModifyTeam response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyUserRequest(AbstractModel):
    """ModifyUser request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
        :type UserId: str
        :param _UserName: User name
        :type UserName: str
        :param _AccountType: Account type 2 - Platform admin 3 - Member
        :type AccountType: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._UserId = None
        self._UserName = None
        self._AccountType = None
        self._PlatformId = None

    @property
    def UserId(self):
        """User ID
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserName(self):
        """User name
        :rtype: str
        """
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def AccountType(self):
        """Account type 2 - Platform admin 3 - Member
        :rtype: int
        """
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserName = params.get("UserName")
        self._AccountType = params.get("AccountType")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyUserResponse(AbstractModel):
    """ModifyUser response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class PresetResp(AbstractModel):
    """Encryption key returned

    """

    def __init__(self):
        r"""
        :param _Key: RSA encryption public key
Note: This field may return null, indicating that no valid values can be obtained.
        :type Key: str
        """
        self._Key = None

    @property
    def Key(self):
        """RSA encryption public key
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key


    def _deserialize(self, params):
        self._Key = params.get("Key")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProcessMNPApprovalRequest(AbstractModel):
    """ProcessMNPApproval request structure.

    """

    def __init__(self):
        r"""
        :param _ApprovalNo: Approval ID
        :type ApprovalNo: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _ApprovalItems: Approval details
        :type ApprovalItems: list of ApprovalItem
        """
        self._ApprovalNo = None
        self._PlatformId = None
        self._ApprovalItems = None

    @property
    def ApprovalNo(self):
        """Approval ID
        :rtype: str
        """
        return self._ApprovalNo

    @ApprovalNo.setter
    def ApprovalNo(self, ApprovalNo):
        self._ApprovalNo = ApprovalNo

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def ApprovalItems(self):
        """Approval details
        :rtype: list of ApprovalItem
        """
        return self._ApprovalItems

    @ApprovalItems.setter
    def ApprovalItems(self, ApprovalItems):
        self._ApprovalItems = ApprovalItems


    def _deserialize(self, params):
        self._ApprovalNo = params.get("ApprovalNo")
        self._PlatformId = params.get("PlatformId")
        if params.get("ApprovalItems") is not None:
            self._ApprovalItems = []
            for item in params.get("ApprovalItems"):
                obj = ApprovalItem()
                obj._deserialize(item)
                self._ApprovalItems.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProcessMNPApprovalResponse(AbstractModel):
    """ProcessMNPApproval response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ProcessMNPSensitiveAPIPermissionApprovalRequest(AbstractModel):
    """ProcessMNPSensitiveAPIPermissionApproval request structure.

    """

    def __init__(self):
        r"""
        :param _ApprovalNo: Approval ID
        :type ApprovalNo: str
        :param _ApprovalStatus: Approval status. 20: Rejected; 30: Approved
        :type ApprovalStatus: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _ApprovalNote: Approval notes
        :type ApprovalNote: str
        """
        self._ApprovalNo = None
        self._ApprovalStatus = None
        self._PlatformId = None
        self._ApprovalNote = None

    @property
    def ApprovalNo(self):
        """Approval ID
        :rtype: str
        """
        return self._ApprovalNo

    @ApprovalNo.setter
    def ApprovalNo(self, ApprovalNo):
        self._ApprovalNo = ApprovalNo

    @property
    def ApprovalStatus(self):
        """Approval status. 20: Rejected; 30: Approved
        :rtype: int
        """
        return self._ApprovalStatus

    @ApprovalStatus.setter
    def ApprovalStatus(self, ApprovalStatus):
        self._ApprovalStatus = ApprovalStatus

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def ApprovalNote(self):
        """Approval notes
        :rtype: str
        """
        return self._ApprovalNote

    @ApprovalNote.setter
    def ApprovalNote(self, ApprovalNote):
        self._ApprovalNote = ApprovalNote


    def _deserialize(self, params):
        self._ApprovalNo = params.get("ApprovalNo")
        self._ApprovalStatus = params.get("ApprovalStatus")
        self._PlatformId = params.get("PlatformId")
        self._ApprovalNote = params.get("ApprovalNote")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProcessMNPSensitiveAPIPermissionApprovalResponse(AbstractModel):
    """ProcessMNPSensitiveAPIPermissionApproval response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class QueryOnlineVersionResp(AbstractModel):
    """Mini program online version ID

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _MNPVersion: Version
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersion: str
        :param _MNPVersionId: Version ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersionId: int
        :param _MNPVersionNote: Version note
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersionNote: str
        :param _UpdateTime: Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        """
        self._MNPId = None
        self._MNPVersion = None
        self._MNPVersionId = None
        self._MNPVersionNote = None
        self._UpdateTime = None

    @property
    def MNPId(self):
        """Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPVersion(self):
        """Version
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPVersion

    @MNPVersion.setter
    def MNPVersion(self, MNPVersion):
        self._MNPVersion = MNPVersion

    @property
    def MNPVersionId(self):
        """Version ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def MNPVersionNote(self):
        """Version note
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MNPVersionNote

    @MNPVersionNote.setter
    def MNPVersionNote(self, MNPVersionNote):
        self._MNPVersionNote = MNPVersionNote

    @property
    def UpdateTime(self):
        """Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPVersion = params.get("MNPVersion")
        self._MNPVersionId = params.get("MNPVersionId")
        self._MNPVersionNote = params.get("MNPVersionNote")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReleaseMNPVersionRequest(AbstractModel):
    """ReleaseMNPVersion request structure.

    """

    def __init__(self):
        r"""
        :param _MNPVersionId: Mini program version ID
        :type MNPVersionId: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPVersionId = None
        self._PlatformId = None

    @property
    def MNPVersionId(self):
        """Mini program version ID
        :rtype: int
        """
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPVersionId = params.get("MNPVersionId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReleaseMNPVersionResponse(AbstractModel):
    """ReleaseMNPVersion response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class RemoveMNPRequest(AbstractModel):
    """RemoveMNP request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RemoveMNPResponse(AbstractModel):
    """RemoveMNP response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ResourceIdInfo(AbstractModel):
    """Unified operation success ID - integer

    """

    def __init__(self):
        r"""
        :param _ResourceId: Resource ID
0: No preview
1. A preview is currently available and uploaded by the current user.
2. A preview is currently available and uploaded by another user.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceId: int
        """
        self._ResourceId = None

    @property
    def ResourceId(self):
        """Resource ID
0: No preview
1. A preview is currently available and uploaded by the current user.
2. A preview is currently available and uploaded by another user.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResourceIdStringInfo(AbstractModel):
    """The general parameter for resource ID returned for successful operations

    """

    def __init__(self):
        r"""
        :param _ResourceId: The ID of the resource returned
Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceId: str
        """
        self._ResourceId = None

    @property
    def ResourceId(self):
        """The ID of the resource returned
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RollbackMNPVersionRequest(AbstractModel):
    """RollbackMNPVersion request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _MNPVersionId: Mini program version ID
        :type MNPVersionId: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _MNPVersion: Mini program version number
        :type MNPVersion: str
        """
        self._MNPId = None
        self._MNPVersionId = None
        self._PlatformId = None
        self._MNPVersion = None

    @property
    def MNPId(self):
        """Mini program ID
        :rtype: str
        """
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPVersionId(self):
        """Mini program version ID
        :rtype: int
        """
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def PlatformId(self):
        """Platform ID
        :rtype: str
        """
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def MNPVersion(self):
        """Mini program version number
        :rtype: str
        """
        return self._MNPVersion

    @MNPVersion.setter
    def MNPVersion(self, MNPVersion):
        self._MNPVersion = MNPVersion


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPVersionId = params.get("MNPVersionId")
        self._PlatformId = params.get("PlatformId")
        self._MNPVersion = params.get("MNPVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RollbackMNPVersionResponse(AbstractModel):
    """RollbackMNPVersion response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Response data
        :rtype: :class:`tencentcloud.tcsas.v20250106.models.BooleanInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class StringData(AbstractModel):
    """String object

    """

    def __init__(self):
        r"""
        :param _Data: String type response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: str
        """
        self._Data = None

    @property
    def Data(self):
        """String type response data
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data


    def _deserialize(self, params):
        self._Data = params.get("Data")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UploadFileTempSecret(AbstractModel):
    """Temporary key for file upload

    """

    def __init__(self):
        r"""
        :param _Bucket: Bucket
Note: This field may return null, indicating that no valid values can be obtained.
        :type Bucket: str
        :param _Region: Region
Note: This field may return null, indicating that no valid values can be obtained.
        :type Region: str
        :param _Path: Destination of upload
Note: This field may return null, indicating that no valid values can be obtained.
        :type Path: str
        :param _TempSecretId: Temporary secret ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TempSecretId: str
        :param _TempSecretKey: Temporary secret key
Note: This field may return null, indicating that no valid values can be obtained.
        :type TempSecretKey: str
        :param _Token: Token 
Note: This field may return null, indicating that no valid values can be obtained.
        :type Token: str
        :param _AccelerateEnable: Whether to enable global acceleration. Valid values: 0 (no), 1 (yes)
        :type AccelerateEnable: int
        """
        self._Bucket = None
        self._Region = None
        self._Path = None
        self._TempSecretId = None
        self._TempSecretKey = None
        self._Token = None
        self._AccelerateEnable = None

    @property
    def Bucket(self):
        """Bucket
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        """Region
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Path(self):
        """Destination of upload
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def TempSecretId(self):
        """Temporary secret ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TempSecretId

    @TempSecretId.setter
    def TempSecretId(self, TempSecretId):
        self._TempSecretId = TempSecretId

    @property
    def TempSecretKey(self):
        """Temporary secret key
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TempSecretKey

    @TempSecretKey.setter
    def TempSecretKey(self, TempSecretKey):
        self._TempSecretKey = TempSecretKey

    @property
    def Token(self):
        """Token 
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def AccelerateEnable(self):
        """Whether to enable global acceleration. Valid values: 0 (no), 1 (yes)
        :rtype: int
        """
        return self._AccelerateEnable

    @AccelerateEnable.setter
    def AccelerateEnable(self, AccelerateEnable):
        self._AccelerateEnable = AccelerateEnable


    def _deserialize(self, params):
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        self._Path = params.get("Path")
        self._TempSecretId = params.get("TempSecretId")
        self._TempSecretKey = params.get("TempSecretKey")
        self._Token = params.get("Token")
        self._AccelerateEnable = params.get("AccelerateEnable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        