# This file was auto-generated by Fern from our API Definition.

import typing

import httpx
from .activity.client import ActivityClient, AsyncActivityClient
from .aggregate.client import AggregateClient, AsyncAggregateClient
from .body.client import AsyncBodyClient, BodyClient
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .devices.client import AsyncDevicesClient, DevicesClient
from .electrocardiogram.client import AsyncElectrocardiogramClient, ElectrocardiogramClient
from .environment import VitalEnvironment
from .insurance.client import AsyncInsuranceClient, InsuranceClient
from .introspect.client import AsyncIntrospectClient, IntrospectClient
from .lab_tests.client import AsyncLabTestsClient, LabTestsClient
from .link.client import AsyncLinkClient, LinkClient
from .meal.client import AsyncMealClient, MealClient
from .menstrual_cycle.client import AsyncMenstrualCycleClient, MenstrualCycleClient
from .order.client import AsyncOrderClient, OrderClient
from .payor.client import AsyncPayorClient, PayorClient
from .profile.client import AsyncProfileClient, ProfileClient
from .providers.client import AsyncProvidersClient, ProvidersClient
from .sleep.client import AsyncSleepClient, SleepClient
from .sleep_cycle.client import AsyncSleepCycleClient, SleepCycleClient
from .team.client import AsyncTeamClient, TeamClient
from .testkit.client import AsyncTestkitClient, TestkitClient
from .user.client import AsyncUserClient, UserClient
from .vitals.client import AsyncVitalsClient, VitalsClient
from .workouts.client import AsyncWorkoutsClient, WorkoutsClient


class Vital:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : VitalEnvironment
        The environment to use for requests from the client. from .environment import VitalEnvironment

        Defaults to VitalEnvironment.PRODUCTION



    api_key : str
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from vital import Vital
    client = Vital(api_key="YOUR_API_KEY", )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: VitalEnvironment = VitalEnvironment.PRODUCTION,
        api_key: str,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.user = UserClient(client_wrapper=self._client_wrapper)
        self.team = TeamClient(client_wrapper=self._client_wrapper)
        self.providers = ProvidersClient(client_wrapper=self._client_wrapper)
        self.sleep = SleepClient(client_wrapper=self._client_wrapper)
        self.workouts = WorkoutsClient(client_wrapper=self._client_wrapper)
        self.vitals = VitalsClient(client_wrapper=self._client_wrapper)
        self.link = LinkClient(client_wrapper=self._client_wrapper)
        self.lab_tests = LabTestsClient(client_wrapper=self._client_wrapper)
        self.electrocardiogram = ElectrocardiogramClient(client_wrapper=self._client_wrapper)
        self.sleep_cycle = SleepCycleClient(client_wrapper=self._client_wrapper)
        self.profile = ProfileClient(client_wrapper=self._client_wrapper)
        self.devices = DevicesClient(client_wrapper=self._client_wrapper)
        self.activity = ActivityClient(client_wrapper=self._client_wrapper)
        self.body = BodyClient(client_wrapper=self._client_wrapper)
        self.meal = MealClient(client_wrapper=self._client_wrapper)
        self.menstrual_cycle = MenstrualCycleClient(client_wrapper=self._client_wrapper)
        self.testkit = TestkitClient(client_wrapper=self._client_wrapper)
        self.order = OrderClient(client_wrapper=self._client_wrapper)
        self.introspect = IntrospectClient(client_wrapper=self._client_wrapper)
        self.insurance = InsuranceClient(client_wrapper=self._client_wrapper)
        self.payor = PayorClient(client_wrapper=self._client_wrapper)
        self.aggregate = AggregateClient(client_wrapper=self._client_wrapper)


class AsyncVital:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : VitalEnvironment
        The environment to use for requests from the client. from .environment import VitalEnvironment

        Defaults to VitalEnvironment.PRODUCTION



    api_key : str
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from vital import AsyncVital
    client = AsyncVital(api_key="YOUR_API_KEY", )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: VitalEnvironment = VitalEnvironment.PRODUCTION,
        api_key: str,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.user = AsyncUserClient(client_wrapper=self._client_wrapper)
        self.team = AsyncTeamClient(client_wrapper=self._client_wrapper)
        self.providers = AsyncProvidersClient(client_wrapper=self._client_wrapper)
        self.sleep = AsyncSleepClient(client_wrapper=self._client_wrapper)
        self.workouts = AsyncWorkoutsClient(client_wrapper=self._client_wrapper)
        self.vitals = AsyncVitalsClient(client_wrapper=self._client_wrapper)
        self.link = AsyncLinkClient(client_wrapper=self._client_wrapper)
        self.lab_tests = AsyncLabTestsClient(client_wrapper=self._client_wrapper)
        self.electrocardiogram = AsyncElectrocardiogramClient(client_wrapper=self._client_wrapper)
        self.sleep_cycle = AsyncSleepCycleClient(client_wrapper=self._client_wrapper)
        self.profile = AsyncProfileClient(client_wrapper=self._client_wrapper)
        self.devices = AsyncDevicesClient(client_wrapper=self._client_wrapper)
        self.activity = AsyncActivityClient(client_wrapper=self._client_wrapper)
        self.body = AsyncBodyClient(client_wrapper=self._client_wrapper)
        self.meal = AsyncMealClient(client_wrapper=self._client_wrapper)
        self.menstrual_cycle = AsyncMenstrualCycleClient(client_wrapper=self._client_wrapper)
        self.testkit = AsyncTestkitClient(client_wrapper=self._client_wrapper)
        self.order = AsyncOrderClient(client_wrapper=self._client_wrapper)
        self.introspect = AsyncIntrospectClient(client_wrapper=self._client_wrapper)
        self.insurance = AsyncInsuranceClient(client_wrapper=self._client_wrapper)
        self.payor = AsyncPayorClient(client_wrapper=self._client_wrapper)
        self.aggregate = AsyncAggregateClient(client_wrapper=self._client_wrapper)


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: VitalEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
