# Project Agents.md Guide for OpenAI Codex

This Agents.md file provides comprehensive guidance for OpenAI Codex and other AI agents working with this codebase.

## Project Structure for OpenAI Codex Navigation

- `/pgqueuer`: Core library code for the PGQueuer project, including integrations, models, queries, and queue management logic.
- `/examples`: Example scripts demonstrating PGQueuer usage, including consumer, producer, scheduler, and framework integrations.
- `/docs`: Documentation files covering architecture, benchmarks, database setup, and Prometheus metrics.
- `/test`: Test files for unit tests, integration tests, and other test cases.
- `/tools`: Utility scripts for benchmarking and monitoring.

## Coding Conventions for OpenAI Codex

### General Conventions for Agents.md Implementation

- Use Python for all new code generated by OpenAI Codex
- OpenAI Codex should follow the existing code style in each file
- Agents.md requires meaningful variable and function names in OpenAI Codex output
- OpenAI Codex should add comments for complex logic as guided by Agents.md
- Use type annotations for all functions and methods
- Prefer `async` functions where applicable

## Testing Requirements for OpenAI Codex

OpenAI Codex should run tests with the following commands, ensuring the required environment variables are set inline:

```bash
# Run all tests with OpenAI Codex
PGUSER=pgquser PGDATABASE=pgqdb PGPASSWORD=pgqpw PGHOST=localhost PGPORT=5432 uv run pytest

# Run a specific test file with OpenAI Codex
PGUSER=pgquser PGDATABASE=pgqdb PGPASSWORD=pgqpw PGHOST=localhost PGPORT=5432 uv run pytest path/to/test-file.py
```

## Pull Request Guidelines for OpenAI Codex

When OpenAI Codex helps create a PR, please ensure it:

1. Includes a clear description of the changes as guided by Agents.md
2. References any related issues that OpenAI Codex is addressing
3. Ensures all tests pass for code generated by OpenAI Codex
4. Includes screenshots for UI changes implemented with OpenAI Codex
5. Keeps PRs focused on a single concern as specified in Agents.md

## Programmatic Checks for OpenAI Codex

Before submitting changes generated by OpenAI Codex, run the following checks, ensuring the required environment variables are set inline:

```bash
# Lint check for OpenAI Codex code
PGUSER=pgquser PGDATABASE=pgqdb PGPASSWORD=pgqpw PGHOST=localhost PGPORT=5432 uv run ruff check .

# Type check for OpenAI Codex Python
PGUSER=pgquser PGDATABASE=pgqdb PGPASSWORD=pgqpw PGHOST=localhost PGPORT=5432 uv run mypy .

# Build check for OpenAI Codex implementations
PGUSER=pgquser PGDATABASE=pgqdb PGPASSWORD=pgqpw PGHOST=localhost PGPORT=5432 uv sync --all-extras --frozen
PGUSER=pgquser PGDATABASE=pgqdb PGPASSWORD=pgqpw PGHOST=localhost PGPORT=5432 uv run pytest -v
```

All checks must pass before OpenAI Codex generated code can be merged. Agents.md helps ensure OpenAI Codex follows these requirements.
