# pylint: skip-file
from riot_na.alignment.nt_gene_alignments import create_vdjc_aligner_nt
from riot_na.data.model import Locus, Organism


def test_produce_nt_alignments():

    # given
    aligner = create_vdjc_aligner_nt(use_segment_aligner=True)

    query_sequence = "AACAACACATGTCCAATGTCCTCTCCACAGACACTGAACACACTGACTCTAACCATGGGAAGGAGCTGGATCTTTCTCTTCCTCCTGTCAGGAACTGCAGGTGTCCACTCTGAGGTCCAGCTGCAACAGTCTGGACCTGTGCTGGTGAAGCCTGGGGCTTCAGTGAAGATGTCCTGTAAGGCTTCTGGATACACATTCACTGACTACTATATGAACTGGGTGAAGCAGAGCCATGGAAAGAGACTTGAGTGGATTGGAGTTATTAATCCTTACAACGGTGGTACTAACTATAACCAGAAGTTCAAGGGCAAGGCCACATTGACTGTTGACAAGTCCTCCAGCACAGCCTACATGGAGCTCAACAGCCTGACATCTGAGGACTCTGCAGTCTATTACTGTGCAGATGGGATTATTACGAATTGGTATTTCGATGTCTGGGGCACAGGGACCACGGTCACCGTCTCCTCAGCCAAAACGACACCCCCATCTGTCTATCCACTGGCCCCTGGATCTGCTGCCCAAACTAACTCCATGGTGACCCTGGGATGCCTGGTCAAGGGCTATTTCCCTGAGCCAGTGACAGTGACCTGGAACTCTGGATCCCTGTCCAGCGGTGTGCACACCTTCCCAGCTGTCCTGCAGTCTGACCTCTACACTCTGAGCAGCTCAGTGACTGTCCCCTCCAGCACCTGGCCCAGCCAGACCGTCACCTGCAACGTTGCCCACCCGGCCAGCAGCACCAAGGTGGACAAGAAAATTGTGCCCAGGGATTGTGGTTGTAAGCCTTGCATATGTACAGTCCCAGAAGT"

    # when
    alignments = aligner.produce_nt_alignments(query_sequence)[0]

    # then
    assert alignments.v is not None
    assert alignments.v.target_id == "IGHV-2ZSK"
    assert alignments.v.alignment_score == 445.8980348533401
    assert alignments.v.seq_identity == 0.9896907216494846
    assert alignments.v.e_value == 4.962993038125875e-78
    assert alignments.segment_start == 111
    assert alignments.v.q_start == 0
    assert alignments.v.q_end == 402 - alignments.segment_start
    assert alignments.v.q_len == 291
    assert alignments.v.t_start == 0
    assert alignments.v.t_end == 291
    assert alignments.v.t_len == 291
    assert alignments.v.cigar == "291M"
    assert alignments.v.rev_comp is False
    assert alignments.v.species == Organism.MUS_MUSCULUS
    assert alignments.v.locus == Locus.IGH
    assert (
        alignments.v.q_seq
        == "AACAACACATGTCCAATGTCCTCTCCACAGACACTGAACACACTGACTCTAACCATGGGAAGGAGCTGGATCTTTCTCTTCCTCCTGTCAGGAACTGCAGGTGTCCACTCTGAGGTCCAGCTGCAACAGTCTGGACCTGTGCTGGTGAAGCCTGGGGCTTCAGTGAAGATGTCCTGTAAGGCTTCTGGATACACATTCACTGACTACTATATGAACTGGGTGAAGCAGAGCCATGGAAAGAGACTTGAGTGGATTGGAGTTATTAATCCTTACAACGGTGGTACTAACTATAACCAGAAGTTCAAGGGCAAGGCCACATTGACTGTTGACAAGTCCTCCAGCACAGCCTACATGGAGCTCAACAGCCTGACATCTGAGGACTCTGCAGTCTATTACTGTGCAGATGGGATTATTACGAATTGGTATTTCGATGTCTGGGGCACAGGGACCACGGTCACCGTCTCCTCAGCCAAAACGACACCCCCATCTGTCTATCCACTGGCCCCTGGATCTGCTGCCCAAACTAACTCCATGGTGACCCTGGGATGCCTGGTCAAGGGCTATTTCCCTGAGCCAGTGACAGTGACCTGGAACTCTGGATCCCTGTCCAGCGGTGTGCACACCTTCCCAGCTGTCCTGCAGTCTGACCTCTACACTCTGAGCAGCTCAGTGACTGTCCCCTCCAGCACCTGGCCCAGCCAGACCGTCACCTGCAACGTTGCCCACCCGGCCAGCAGCACCAAGGTGGACAAGAAAATTGTGCCCAGGGATTGTGGTTGTAAGCCTTGCATATGTACAGTCCCAGAAGT"[
            alignments.segment_start : alignments.segment_end
        ]
    )
    assert (
        alignments.v.t_seq
        == "GAGGTCCAGCTGCAACAGTCTGGACCTGTGCTGGTGAAGCCTGGGGCTTCAGTGAAGATGTCCTGTAAGGCTTCTGGATACACATTCACTGACTACTATATGAACTGGGTGAAGCAGAGCCATGGAAAGAGCCTTGAGTGGATTGGAGTTATTAATCCTTACAACGGTGGTACTAGCTACAACCAGAAGTTCAAGGGCAAGGCCACATTGACTGTTGACAAGTCCTCCAGCACAGCCTACATGGAGCTCAACAGCCTGACATCTGAGGACTCTGCAGTCTATTACTGTGCAAG"
    )
    assert alignments.v.reading_frame == 0

    assert alignments.d is not None
    assert alignments.d.target_id == "IGHD-4RNO"
    assert alignments.d.alignment_score == 14.301386420997765
    assert alignments.d.seq_identity == 0.9
    assert alignments.d.e_value == 24.1875
    assert alignments.d.q_start == 408 - alignments.segment_start
    assert alignments.d.q_end == 418 - alignments.segment_start
    assert alignments.d.q_len == 10
    assert alignments.d.t_start == 6
    assert alignments.d.t_end == 16
    assert alignments.d.t_len == 10
    assert alignments.d.cigar == "10M"
    assert alignments.d.rev_comp is False
    assert alignments.d.species == Organism.MUS_MUSCULUS
    assert alignments.d.locus == Locus.IGH
    assert alignments.d.q_seq == "GATGGGATTATTACGAAT"
    assert alignments.d.t_seq == "TCTACTATGATTACGAC"

    assert alignments.j is not None
    assert alignments.j.target_id == "IGHJ-32C2"
    assert alignments.j.alignment_score == 75.06770154324091
    assert alignments.j.seq_identity == 0.9795918367346939
    assert alignments.j.e_value == 8.791403161012568e-10
    assert alignments.j.q_start == 420 - alignments.segment_start
    assert alignments.j.q_end == 469 - alignments.segment_start
    assert alignments.j.q_len == 49
    assert alignments.j.t_start == 4
    assert alignments.j.t_end == 53
    assert alignments.j.t_len == 49
    assert alignments.j.cigar == "49M"
    assert alignments.j.rev_comp is False
    assert alignments.j.species == Organism.MUS_MUSCULUS
    assert alignments.j.locus == Locus.IGH
    assert (
        alignments.j.q_seq
        == "GATGGGATTATTACGAATTGGTATTTCGATGTCTGGGGCACAGGGACCACGGTCACCGTCTCCTCAGCCAAAACGACACCCCCATCTGTCTATCCACTGGCCCCTGGATCTGCTGCCCAAACTAACTCCATGGTGACCCTGGGATGCCTGGTCAAGGGCTATTTCCCTGAGCCAGTGACAGTGACCTGGAACTCTGGATCCCTGTCCAGCGGTGTGCACACCTTCCCAGCTGTCCTGCAGTCTGACCTCTACACTCTGAGCAGCTCAGTGACTGTCCCCTCCAGCACCTGGCCCAGCCAGACCGTCACCTGCAACGTTGCCCACCCGGCCAGCAGCACCAAGGTGGACAAGAAAATTGTGCCCAGGGATTGTGGTTGTAAGCCTTGCATATGTACAGTCCCAGAAGT"
    )
    assert alignments.j.t_seq == "CTACTGGTACTTCGATGTCTGGGGCACAGGGACCACGGTCACCGTCTCCTCAG"
    assert alignments.j.reading_frame == 1

    # AlignmentEntryNT(target_id='IGHG1', alignment_score=209.06521694100786, seq_identity=0.7833333333333333, e_value=3.1801713964550777e-34, q_start=538, q_end=775, q_len=237, t_start=70, t_end=310, t_len=240, cigar='104M3D133M', rev_comp=False, species=<Organism.HOMO_SAPIENS: 'human'>, locus=<Locus.IGH: 'igh'>, q_seq='CCAAAACGACACCCCCATCTGTCTATCCACTGGCCCCTGGATCTGCTGCCCAAACTAACTCCATGGTGACCCTGGGATGCCTGGTCAAGGGCTATTTCCCTGAGCCAGTGACAGTGACCTGGAACTCTGGATCCCTGTCCAGCGGTGTGCACACCTTCCCAGCTGTCCTGCAGTCTGACCTCTACACTCTGAGCAGCTCAGTGACTGTCCCCTCCAGCACCTGGCCCAGCCAGACCGTCACCTGCAACGTTGCCCACCCGGCCAGCAGCACCAAGGTGGACAAGAAAATTGTGCCCAGGGATTGTGGTTGTAAGCCTTGCATATGTACAGTCCCAGAAGT', t_seq='GCCTCCACCAAGGGCCCATCGGTCTTCCCCCTGGCACCCTCCTCCAAGAGCACCTCTGGGGGCACAGCAGCCCTGGGCTGCCTGGTCAAGGACTACTTCCCCGAACCGGTGACGGTGTCGTGGAACTCAGGCGCCCTGACCAGCGGCGTGCACACCTTCCCGGCTGTCCTACAGTCCTCAGGACTCTACTCCCTCAGCAGCGTGGTGACCGTGCCCTCCAGCAGCTTGGGCACCCAGACCTACATCTGCAACGTGAATCACAAGCCCAGCAACACCAAGGTGGACAAGAAAGTTGAGCCCAAATCTTGTGACAAAACTCACACATGCCCACCGTGCCCAGCACCTGAACTCCTGGGGGGACCGTCAGTCTTCCTCTTCCCCCCAAAACCCAAGGACACCCTCATGATCTCCCGGACCCCTGAGGTCACATGCGTGGTGGTGGACGTGAGCCACGAAGACCCTGAGGTCAAGTTCAACTGGTACGTGGACGGCGTGGAGGTGCATAATGCCAAGACAAAGCCGCGGGAGGAGCAGTACAACAGCACGTACCGTGTGGTCAGCGTCCTCACCGTCCTGCACCAGGACTGGCTGAATGGCAAGGAGTACAAGTGCAAGGTCTCCAACAAAGCCCTCCCAGCCCCCATCGAGAAAACCATCTCCAAAGCCAAAGGGCAGCCCCGAGAACCACAGGTGTACACCCTGCCCCCATCCCGGGATGAGCTGACCAAGAACCAGGTCAGCCTGACCTGCCTGGTCAAAGGCTTCTATCCCAGCGACATCGCCGTGGAGTGGGAGAGCAATGGGCAGCCGGAGAACAACTACAAGACCACGCCTCCCGTGCTGGACTCCGACGGCTCCTTCTTCCTCTACAGCAAGCTCACCGTGGACAAGAGCAGGTGGCAGCAGGGGAACGTCTTCTCATGCTCCGTGATGCATGAGGCTCTGCACAACCACTACACACAGAAGAGCCTCTCCCTGTCTCCGGGTAAATGA', reading_frame=None))
    assert alignments.c is not None
    assert alignments.c.target_id == "IGHG1"
    assert alignments.c.alignment_score == 209.06521694100786
    assert alignments.c.seq_identity == 0.7833333333333333
    assert alignments.c.e_value == 3.1801713964550777e-34
    assert alignments.c.q_start == 538 - alignments.segment_start
    assert alignments.c.q_end == 775 - alignments.segment_start
    assert alignments.c.q_len == 237
    assert alignments.c.t_start == 70
    assert alignments.c.t_end == 310
    assert alignments.c.t_len == 240
    assert alignments.c.cigar == "104M3D133M"
    assert alignments.c.rev_comp is False
    assert alignments.c.species == Organism.HOMO_SAPIENS
    assert alignments.c.locus == Locus.IGH
    assert (
        alignments.c.q_seq
        == "CCAAAACGACACCCCCATCTGTCTATCCACTGGCCCCTGGATCTGCTGCCCAAACTAACTCCATGGTGACCCTGGGATGCCTGGTCAAGGGCTATTTCCCTGAGCCAGTGACAGTGACCTGGAACTCTGGATCCCTGTCCAGCGGTGTGCACACCTTCCCAGCTGTCCTGCAGTCTGACCTCTACACTCTGAGCAGCTCAGTGACTGTCCCCTCCAGCACCTGGCCCAGCCAGACCGTCACCTGCAACGTTGCCCACCCGGCCAGCAGCACCAAGGTGGACAAGAAAATTGTGCCCAGGGATTGTGGTTGTAAGCCTTGCATATGTACAGTCCCAGAAGT"
    )
    assert (
        alignments.c.t_seq
        == "GCCTCCACCAAGGGCCCATCGGTCTTCCCCCTGGCACCCTCCTCCAAGAGCACCTCTGGGGGCACAGCAGCCCTGGGCTGCCTGGTCAAGGACTACTTCCCCGAACCGGTGACGGTGTCGTGGAACTCAGGCGCCCTGACCAGCGGCGTGCACACCTTCCCGGCTGTCCTACAGTCCTCAGGACTCTACTCCCTCAGCAGCGTGGTGACCGTGCCCTCCAGCAGCTTGGGCACCCAGACCTACATCTGCAACGTGAATCACAAGCCCAGCAACACCAAGGTGGACAAGAAAGTTGAGCCCAAATCTTGTGACAAAACTCACACATGCCCACCGTGCCCAGCACCTGAACTCCTGGGGGGACCGTCAGTCTTCCTCTTCCCCCCAAAACCCAAGGACACCCTCATGATCTCCCGGACCCCTGAGGTCACATGCGTGGTGGTGGACGTGAGCCACGAAGACCCTGAGGTCAAGTTCAACTGGTACGTGGACGGCGTGGAGGTGCATAATGCCAAGACAAAGCCGCGGGAGGAGCAGTACAACAGCACGTACCGTGTGGTCAGCGTCCTCACCGTCCTGCACCAGGACTGGCTGAATGGCAAGGAGTACAAGTGCAAGGTCTCCAACAAAGCCCTCCCAGCCCCCATCGAGAAAACCATCTCCAAAGCCAAAGGGCAGCCCCGAGAACCACAGGTGTACACCCTGCCCCCATCCCGGGATGAGCTGACCAAGAACCAGGTCAGCCTGACCTGCCTGGTCAAAGGCTTCTATCCCAGCGACATCGCCGTGGAGTGGGAGAGCAATGGGCAGCCGGAGAACAACTACAAGACCACGCCTCCCGTGCTGGACTCCGACGGCTCCTTCTTCCTCTACAGCAAGCTCACCGTGGACAAGAGCAGGTGGCAGCAGGGGAACGTCTTCTCATGCTCCGTGATGCATGAGGCTCTGCACAACCACTACACACAGAAGAGCCTCTCCCTGTCTCCGGGTAAATGA"
    )
    assert alignments.c.reading_frame is None


if __name__ == "__main__":
    test_produce_nt_alignments()
