"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from agentset.errors import AgentsetError
from agentset.models import badrequest_error as models_badrequest_error
from agentset.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Optional


class BadRequestErrorData(BaseModel):
    success: bool

    error: models_badrequest_error.BadRequestError


@dataclass(unsafe_hash=True)
class BadRequestError(AgentsetError):
    r"""The server cannot or will not process the request due to something that is perceived to be a client error (e.g., malformed request syntax, invalid request message framing, or deceptive request routing)."""

    data: BadRequestErrorData = field(hash=False)

    def __init__(
        self,
        data: BadRequestErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
