"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from agentset.errors import AgentsetError
from agentset.models import conflict_error as models_conflict_error
from agentset.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Optional


class ConflictErrorData(BaseModel):
    success: bool

    error: models_conflict_error.ConflictError


@dataclass(unsafe_hash=True)
class ConflictError(AgentsetError):
    r"""This response is sent when a request conflicts with the current state of the server."""

    data: ConflictErrorData = field(hash=False)

    def __init__(
        self,
        data: ConflictErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
