"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from agentset.errors import AgentsetError
from agentset.models import forbidden_error as models_forbidden_error
from agentset.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Optional


class ForbiddenErrorData(BaseModel):
    success: bool

    error: models_forbidden_error.ForbiddenError


@dataclass(unsafe_hash=True)
class ForbiddenError(AgentsetError):
    r"""The client does not have access rights to the content; that is, it is unauthorized, so the server is refusing to give the requested resource. Unlike 401 Unauthorized, the client's identity is known to the server."""

    data: ForbiddenErrorData = field(hash=False)

    def __init__(
        self,
        data: ForbiddenErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
