"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from agentset.errors import AgentsetError
from agentset.models import internalservererror as models_internalservererror
from agentset.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Optional


class InternalServerErrorData(BaseModel):
    success: bool

    error: models_internalservererror.InternalServerErrorError


@dataclass(unsafe_hash=True)
class InternalServerError(AgentsetError):
    r"""The server has encountered a situation it does not know how to handle."""

    data: InternalServerErrorData = field(hash=False)

    def __init__(
        self,
        data: InternalServerErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
