"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from agentset.errors import AgentsetError
from agentset.models import inviteexpired_error as models_inviteexpired_error
from agentset.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Optional


class InviteExpiredErrorData(BaseModel):
    success: bool

    error: models_inviteexpired_error.InviteExpiredError


@dataclass(unsafe_hash=True)
class InviteExpiredError(AgentsetError):
    r"""This response is sent when the requested content has been permanently deleted from server, with no forwarding address."""

    data: InviteExpiredErrorData = field(hash=False)

    def __init__(
        self,
        data: InviteExpiredErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
