"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from agentset.errors import AgentsetError
from agentset.models import notfound_error as models_notfound_error
from agentset.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Optional


class NotFoundErrorData(BaseModel):
    success: bool

    error: models_notfound_error.NotFoundError


@dataclass(unsafe_hash=True)
class NotFoundError(AgentsetError):
    r"""The server cannot find the requested resource."""

    data: NotFoundErrorData = field(hash=False)

    def __init__(
        self,
        data: NotFoundErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
