"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from agentset.errors import AgentsetError
from agentset.models import ratelimitexceeded_error as models_ratelimitexceeded_error
from agentset.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Optional


class RateLimitExceededErrorData(BaseModel):
    success: bool

    error: models_ratelimitexceeded_error.RateLimitExceededError


@dataclass(unsafe_hash=True)
class RateLimitExceededError(AgentsetError):
    r"""The user has sent too many requests in a given amount of time (\"rate limiting\")"""

    data: RateLimitExceededErrorData = field(hash=False)

    def __init__(
        self,
        data: RateLimitExceededErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
