"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from agentset.errors import AgentsetError
from agentset.models import unauthorized_error as models_unauthorized_error
from agentset.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Optional


class UnauthorizedErrorData(BaseModel):
    success: bool

    error: models_unauthorized_error.UnauthorizedError


@dataclass(unsafe_hash=True)
class UnauthorizedError(AgentsetError):
    r"""Although the HTTP standard specifies \"unauthorized\", semantically this response means \"unauthenticated\". That is, the client must authenticate itself to get the requested response."""

    data: UnauthorizedErrorData = field(hash=False)

    def __init__(
        self,
        data: UnauthorizedErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
