"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from agentset.errors import AgentsetError
from agentset.models import (
    unprocessableentity_error as models_unprocessableentity_error,
)
from agentset.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Optional


class UnprocessableEntityErrorData(BaseModel):
    success: bool

    error: models_unprocessableentity_error.UnprocessableEntityError


@dataclass(unsafe_hash=True)
class UnprocessableEntityError(AgentsetError):
    r"""The request was well-formed but was unable to be followed due to semantic errors."""

    data: UnprocessableEntityErrorData = field(hash=False)

    def __init__(
        self,
        data: UnprocessableEntityErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
