"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .openai_embedding_model_enum import OpenaiEmbeddingModelEnum
from agentset.types import BaseModel
from agentset.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AzureEmbeddingConfigOutputTypedDict(TypedDict):
    model: OpenaiEmbeddingModelEnum
    r"""The OpenAI embedding model enum."""
    resource_name: str
    r"""The resource name of the Azure OpenAI API. https://{resourceName}.openai.azure.com/v1"""
    deployment: str
    r"""The deployment name of the Azure OpenAI API."""
    api_key: str
    r"""The API key for the Azure OpenAI API."""
    provider: Literal["AZURE_OPENAI"]
    api_version: NotRequired[str]
    r"""The API version for the Azure OpenAI API. Defaults to `preview`."""


class AzureEmbeddingConfigOutput(BaseModel):
    model: OpenaiEmbeddingModelEnum
    r"""The OpenAI embedding model enum."""

    resource_name: Annotated[str, pydantic.Field(alias="resourceName")]
    r"""The resource name of the Azure OpenAI API. https://{resourceName}.openai.azure.com/v1"""

    deployment: str
    r"""The deployment name of the Azure OpenAI API."""

    api_key: Annotated[str, pydantic.Field(alias="apiKey")]
    r"""The API key for the Azure OpenAI API."""

    PROVIDER: Annotated[
        Annotated[
            Literal["AZURE_OPENAI"], AfterValidator(validate_const("AZURE_OPENAI"))
        ],
        pydantic.Field(alias="provider"),
    ] = "AZURE_OPENAI"

    api_version: Annotated[Optional[str], pydantic.Field(alias="apiVersion")] = (
        "preview"
    )
    r"""The API version for the Azure OpenAI API. Defaults to `preview`."""
