"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .document_configoutput import DocumentConfigOutput, DocumentConfigOutputTypedDict
from agentset.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from agentset.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class BatchPayloadOutputItemManagedFileTypedDict(TypedDict):
    key: str
    r"""The key of the managed file to ingest."""
    type: Literal["MANAGED_FILE"]
    file_name: NotRequired[Nullable[str]]
    config: NotRequired[DocumentConfigOutputTypedDict]
    r"""The ingest job config."""


class BatchPayloadOutputItemManagedFile(BaseModel):
    key: str
    r"""The key of the managed file to ingest."""

    TYPE: Annotated[
        Annotated[
            Literal["MANAGED_FILE"], AfterValidator(validate_const("MANAGED_FILE"))
        ],
        pydantic.Field(alias="type"),
    ] = "MANAGED_FILE"

    file_name: Annotated[OptionalNullable[str], pydantic.Field(alias="fileName")] = (
        UNSET
    )

    config: Optional[DocumentConfigOutput] = None
    r"""The ingest job config."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["fileName", "config"]
        nullable_fields = ["fileName"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class BatchPayloadOutputItemFileTypedDict(TypedDict):
    file_url: str
    r"""The URL of the file to ingest."""
    type: Literal["FILE"]
    file_name: NotRequired[Nullable[str]]
    config: NotRequired[DocumentConfigOutputTypedDict]
    r"""The ingest job config."""


class BatchPayloadOutputItemFile(BaseModel):
    file_url: Annotated[str, pydantic.Field(alias="fileUrl")]
    r"""The URL of the file to ingest."""

    TYPE: Annotated[
        Annotated[Literal["FILE"], AfterValidator(validate_const("FILE"))],
        pydantic.Field(alias="type"),
    ] = "FILE"

    file_name: Annotated[OptionalNullable[str], pydantic.Field(alias="fileName")] = (
        UNSET
    )

    config: Optional[DocumentConfigOutput] = None
    r"""The ingest job config."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["fileName", "config"]
        nullable_fields = ["fileName"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class BatchPayloadOutputItemTextTypedDict(TypedDict):
    text: str
    r"""The text to ingest."""
    type: Literal["TEXT"]
    file_name: NotRequired[Nullable[str]]
    config: NotRequired[DocumentConfigOutputTypedDict]
    r"""The ingest job config."""


class BatchPayloadOutputItemText(BaseModel):
    text: str
    r"""The text to ingest."""

    TYPE: Annotated[
        Annotated[Literal["TEXT"], AfterValidator(validate_const("TEXT"))],
        pydantic.Field(alias="type"),
    ] = "TEXT"

    file_name: Annotated[OptionalNullable[str], pydantic.Field(alias="fileName")] = (
        UNSET
    )

    config: Optional[DocumentConfigOutput] = None
    r"""The ingest job config."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["fileName", "config"]
        nullable_fields = ["fileName"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


BatchPayloadOutputItemUnionTypedDict = TypeAliasType(
    "BatchPayloadOutputItemUnionTypedDict",
    Union[
        BatchPayloadOutputItemTextTypedDict,
        BatchPayloadOutputItemFileTypedDict,
        BatchPayloadOutputItemManagedFileTypedDict,
    ],
)


BatchPayloadOutputItemUnion = TypeAliasType(
    "BatchPayloadOutputItemUnion",
    Union[
        BatchPayloadOutputItemText,
        BatchPayloadOutputItemFile,
        BatchPayloadOutputItemManagedFile,
    ],
)


class BatchPayloadOutputTypedDict(TypedDict):
    items: List[BatchPayloadOutputItemUnionTypedDict]
    type: Literal["BATCH"]


class BatchPayloadOutput(BaseModel):
    items: List[BatchPayloadOutputItemUnion]

    TYPE: Annotated[
        Annotated[Literal["BATCH"], AfterValidator(validate_const("BATCH"))],
        pydantic.Field(alias="type"),
    ] = "BATCH"
