"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .pinecone_config import PineconeConfig, PineconeConfigTypedDict
from .turbopuffer_config import TurbopufferConfig, TurbopufferConfigTypedDict
from agentset.types import BaseModel
from agentset.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


class CreateVectorStoreConfigManagedTurbopufferTypedDict(TypedDict):
    provider: Literal["MANAGED_TURBOPUFFER"]


class CreateVectorStoreConfigManagedTurbopuffer(BaseModel):
    PROVIDER: Annotated[
        Annotated[
            Literal["MANAGED_TURBOPUFFER"],
            AfterValidator(validate_const("MANAGED_TURBOPUFFER")),
        ],
        pydantic.Field(alias="provider"),
    ] = "MANAGED_TURBOPUFFER"


class CreateVectorStoreConfigManagedPineconeTypedDict(TypedDict):
    provider: Literal["MANAGED_PINECONE"]


class CreateVectorStoreConfigManagedPinecone(BaseModel):
    PROVIDER: Annotated[
        Annotated[
            Literal["MANAGED_PINECONE"],
            AfterValidator(validate_const("MANAGED_PINECONE")),
        ],
        pydantic.Field(alias="provider"),
    ] = "MANAGED_PINECONE"


CreateVectorStoreConfigTypedDict = TypeAliasType(
    "CreateVectorStoreConfigTypedDict",
    Union[
        CreateVectorStoreConfigManagedPineconeTypedDict,
        CreateVectorStoreConfigManagedTurbopufferTypedDict,
        PineconeConfigTypedDict,
        TurbopufferConfigTypedDict,
    ],
)
r"""The vector store config. If not provided, our MANAGED_PINECONE vector store will be used. Note: You can't change the vector store config after the namespace is created."""


CreateVectorStoreConfig = TypeAliasType(
    "CreateVectorStoreConfig",
    Union[
        CreateVectorStoreConfigManagedPinecone,
        CreateVectorStoreConfigManagedTurbopuffer,
        PineconeConfig,
        TurbopufferConfig,
    ],
)
r"""The vector store config. If not provided, our MANAGED_PINECONE vector store will be used. Note: You can't change the vector store config after the namespace is created."""
