"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .ingest_job import IngestJob, IngestJobTypedDict
from .ingest_job_config import IngestJobConfig, IngestJobConfigTypedDict
from .ingest_job_payload import IngestJobPayload, IngestJobPayloadTypedDict
from agentset.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from agentset.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    RequestMetadata,
    validate_const,
)
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreateIngestJobGlobalsTypedDict(TypedDict):
    namespace_id: NotRequired[str]
    r"""The id of the namespace (prefixed with ns_)"""
    x_tenant_id: NotRequired[str]
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class CreateIngestJobGlobals(BaseModel):
    namespace_id: Annotated[
        Optional[str],
        pydantic.Field(alias="namespaceId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ] = None
    r"""The id of the namespace (prefixed with ns_)"""

    x_tenant_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-tenant-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class CreateIngestJobRequestBodyTypedDict(TypedDict):
    payload: IngestJobPayloadTypedDict
    r"""The ingest job payload."""
    name: NotRequired[Nullable[str]]
    r"""The name of the ingest job."""
    config: NotRequired[IngestJobConfigTypedDict]
    r"""The ingest job config."""
    external_id: NotRequired[Nullable[str]]
    r"""A unique external ID of the ingest job. You can use this to identify the ingest job in your system."""


class CreateIngestJobRequestBody(BaseModel):
    payload: IngestJobPayload
    r"""The ingest job payload."""

    name: OptionalNullable[str] = UNSET
    r"""The name of the ingest job."""

    config: Optional[IngestJobConfig] = None
    r"""The ingest job config."""

    external_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="externalId")
    ] = UNSET
    r"""A unique external ID of the ingest job. You can use this to identify the ingest job in your system."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["name", "config", "externalId"]
        nullable_fields = ["name", "externalId"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateIngestJobRequestTypedDict(TypedDict):
    request_body: CreateIngestJobRequestBodyTypedDict
    x_tenant_id: NotRequired[str]
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class CreateIngestJobRequest(BaseModel):
    request_body: Annotated[
        CreateIngestJobRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    x_tenant_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-tenant-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class CreateIngestJobResponseTypedDict(TypedDict):
    r"""The created ingest job"""

    data: IngestJobTypedDict
    success: Literal[True]


class CreateIngestJobResponse(BaseModel):
    r"""The created ingest job"""

    data: IngestJob

    SUCCESS: Annotated[
        Annotated[Literal[True], AfterValidator(validate_const(True))],
        pydantic.Field(alias="success"),
    ] = True
