"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .create_vector_store_config import (
    CreateVectorStoreConfig,
    CreateVectorStoreConfigTypedDict,
)
from .embedding_model_config import EmbeddingModelConfig, EmbeddingModelConfigTypedDict
from .namespace import Namespace, NamespaceTypedDict
from agentset.types import BaseModel
from agentset.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreateNamespaceRequestTypedDict(TypedDict):
    name: str
    slug: str
    embedding_config: NotRequired[EmbeddingModelConfigTypedDict]
    r"""The embedding model config. If not provided, our managed embedding model will be used. Note: You can't change the embedding model config after the namespace is created."""
    vector_store_config: NotRequired[CreateVectorStoreConfigTypedDict]
    r"""The vector store config. If not provided, our MANAGED_PINECONE vector store will be used. Note: You can't change the vector store config after the namespace is created."""


class CreateNamespaceRequest(BaseModel):
    name: str

    slug: str

    embedding_config: Annotated[
        Optional[EmbeddingModelConfig], pydantic.Field(alias="embeddingConfig")
    ] = None
    r"""The embedding model config. If not provided, our managed embedding model will be used. Note: You can't change the embedding model config after the namespace is created."""

    vector_store_config: Annotated[
        Optional[CreateVectorStoreConfig], pydantic.Field(alias="vectorStoreConfig")
    ] = None
    r"""The vector store config. If not provided, our MANAGED_PINECONE vector store will be used. Note: You can't change the vector store config after the namespace is created."""


class CreateNamespaceResponseTypedDict(TypedDict):
    r"""The created namespace"""

    data: NamespaceTypedDict
    success: Literal[True]


class CreateNamespaceResponse(BaseModel):
    r"""The created namespace"""

    data: Namespace

    SUCCESS: Annotated[
        Annotated[Literal[True], AfterValidator(validate_const(True))],
        pydantic.Field(alias="success"),
    ] = True
