"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .ingest_job import IngestJob, IngestJobTypedDict
from agentset.types import BaseModel
from agentset.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    validate_const,
)
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class DeleteIngestJobGlobalsTypedDict(TypedDict):
    namespace_id: NotRequired[str]
    r"""The id of the namespace (prefixed with ns_)"""
    x_tenant_id: NotRequired[str]
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class DeleteIngestJobGlobals(BaseModel):
    namespace_id: Annotated[
        Optional[str],
        pydantic.Field(alias="namespaceId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ] = None
    r"""The id of the namespace (prefixed with ns_)"""

    x_tenant_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-tenant-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class DeleteIngestJobRequestTypedDict(TypedDict):
    job_id: str
    r"""The id of the job (prefixed with job_)"""
    x_tenant_id: NotRequired[str]
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class DeleteIngestJobRequest(BaseModel):
    job_id: Annotated[
        str,
        pydantic.Field(alias="jobId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The id of the job (prefixed with job_)"""

    x_tenant_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-tenant-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class DeleteIngestJobResponseTypedDict(TypedDict):
    r"""The deleted ingest job"""

    data: IngestJobTypedDict
    success: Literal[True]


class DeleteIngestJobResponse(BaseModel):
    r"""The deleted ingest job"""

    data: IngestJob

    SUCCESS: Annotated[
        Annotated[Literal[True], AfterValidator(validate_const(True))],
        pydantic.Field(alias="success"),
    ] = True
