"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .document_configoutput import DocumentConfigOutput, DocumentConfigOutputTypedDict
from .document_status import DocumentStatus
from agentset.types import BaseModel, Nullable, UNSET_SENTINEL
from agentset.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


class SourceManagedFileTypedDict(TypedDict):
    key: str
    r"""The key of the managed file to ingest."""
    type: Literal["MANAGED_FILE"]


class SourceManagedFile(BaseModel):
    key: str
    r"""The key of the managed file to ingest."""

    TYPE: Annotated[
        Annotated[
            Literal["MANAGED_FILE"], AfterValidator(validate_const("MANAGED_FILE"))
        ],
        pydantic.Field(alias="type"),
    ] = "MANAGED_FILE"


class SourceFileTypedDict(TypedDict):
    file_url: str
    r"""The URL of the file to ingest."""
    type: Literal["FILE"]


class SourceFile(BaseModel):
    file_url: Annotated[str, pydantic.Field(alias="fileUrl")]
    r"""The URL of the file to ingest."""

    TYPE: Annotated[
        Annotated[Literal["FILE"], AfterValidator(validate_const("FILE"))],
        pydantic.Field(alias="type"),
    ] = "FILE"


class SourceTextTypedDict(TypedDict):
    text: str
    r"""The text to ingest."""
    type: Literal["TEXT"]


class SourceText(BaseModel):
    text: str
    r"""The text to ingest."""

    TYPE: Annotated[
        Annotated[Literal["TEXT"], AfterValidator(validate_const("TEXT"))],
        pydantic.Field(alias="type"),
    ] = "TEXT"


SourceTypedDict = TypeAliasType(
    "SourceTypedDict",
    Union[SourceTextTypedDict, SourceFileTypedDict, SourceManagedFileTypedDict],
)
r"""The source of the document."""


Source = TypeAliasType("Source", Union[SourceText, SourceFile, SourceManagedFile])
r"""The source of the document."""


class PropertiesTypedDict(TypedDict):
    r"""The properties of the document."""

    file_size: float
    r"""The size of the file in bytes."""
    mime_type: Nullable[str]


class Properties(BaseModel):
    r"""The properties of the document."""

    file_size: Annotated[float, pydantic.Field(alias="fileSize")]
    r"""The size of the file in bytes."""

    mime_type: Annotated[Nullable[str], pydantic.Field(alias="mimeType")]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["mimeType"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class DocumentTypedDict(TypedDict):
    id: str
    r"""The unique ID of the document."""
    ingest_job_id: str
    r"""The ingest job ID of the document."""
    name: Nullable[str]
    r"""The name of the document."""
    tenant_id: Nullable[str]
    r"""The tenant ID of the ingest job."""
    status: DocumentStatus
    r"""The status of the document."""
    error: Nullable[str]
    r"""The error message of the document. Only exists when the status is failed."""
    source: SourceTypedDict
    r"""The source of the document."""
    properties: Nullable[PropertiesTypedDict]
    config: Nullable[DocumentConfigOutputTypedDict]
    total_chunks: float
    r"""The total number of chunks."""
    total_tokens: float
    r"""The total number of tokens."""
    total_characters: float
    r"""The total number of characters."""
    total_pages: float
    r"""The total number of pages. Will be 0 if the document is not paged (e.g. PDF)."""
    created_at: str
    r"""The date and time the document was created."""
    queued_at: Nullable[str]
    r"""The date and time the document was queued."""
    pre_processing_at: Nullable[str]
    r"""The date and time the document was pre-processed."""
    processing_at: Nullable[str]
    r"""The date and time the document was processed."""
    completed_at: Nullable[str]
    r"""The date and time the document was completed."""
    failed_at: Nullable[str]
    r"""The date and time the document failed."""


class Document(BaseModel):
    id: str
    r"""The unique ID of the document."""

    ingest_job_id: Annotated[str, pydantic.Field(alias="ingestJobId")]
    r"""The ingest job ID of the document."""

    name: Nullable[str]
    r"""The name of the document."""

    tenant_id: Annotated[Nullable[str], pydantic.Field(alias="tenantId")]
    r"""The tenant ID of the ingest job."""

    status: DocumentStatus
    r"""The status of the document."""

    error: Nullable[str]
    r"""The error message of the document. Only exists when the status is failed."""

    source: Source
    r"""The source of the document."""

    properties: Nullable[Properties]

    config: Nullable[DocumentConfigOutput]

    total_chunks: Annotated[float, pydantic.Field(alias="totalChunks")]
    r"""The total number of chunks."""

    total_tokens: Annotated[float, pydantic.Field(alias="totalTokens")]
    r"""The total number of tokens."""

    total_characters: Annotated[float, pydantic.Field(alias="totalCharacters")]
    r"""The total number of characters."""

    total_pages: Annotated[float, pydantic.Field(alias="totalPages")]
    r"""The total number of pages. Will be 0 if the document is not paged (e.g. PDF)."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The date and time the document was created."""

    queued_at: Annotated[Nullable[str], pydantic.Field(alias="queuedAt")]
    r"""The date and time the document was queued."""

    pre_processing_at: Annotated[Nullable[str], pydantic.Field(alias="preProcessingAt")]
    r"""The date and time the document was pre-processed."""

    processing_at: Annotated[Nullable[str], pydantic.Field(alias="processingAt")]
    r"""The date and time the document was processed."""

    completed_at: Annotated[Nullable[str], pydantic.Field(alias="completedAt")]
    r"""The date and time the document was completed."""

    failed_at: Annotated[Nullable[str], pydantic.Field(alias="failedAt")]
    r"""The date and time the document failed."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = [
            "name",
            "tenantId",
            "error",
            "properties",
            "config",
            "queuedAt",
            "preProcessingAt",
            "processingAt",
            "completedAt",
            "failedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
