"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .chunking_strategy import ChunkingStrategy
from .strategy import Strategy
from agentset.types import BaseModel
import pydantic
from typing import Dict, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


DocumentConfigOutputMetadataTypedDict = TypeAliasType(
    "DocumentConfigOutputMetadataTypedDict", Union[str, float, bool]
)


DocumentConfigOutputMetadata = TypeAliasType(
    "DocumentConfigOutputMetadata", Union[str, float, bool]
)


class DocumentConfigOutputTypedDict(TypedDict):
    r"""The ingest job config."""

    chunk_size: NotRequired[float]
    r"""Soft chunk size."""
    max_chunk_size: NotRequired[float]
    r"""Hard chunk size."""
    chunk_overlap: NotRequired[float]
    r"""Custom chunk overlap."""
    metadata: NotRequired[Dict[str, DocumentConfigOutputMetadataTypedDict]]
    r"""Custom metadata to be added to the ingested documents. It cannot contain nested objects; only primitive types (string, number, boolean) are allowed."""
    chunking_strategy: NotRequired[ChunkingStrategy]
    r"""The chunking strategy to use. Defaults to `basic`."""
    strategy: NotRequired[Strategy]
    r"""The strategy to use. Defaults to `auto`."""


class DocumentConfigOutput(BaseModel):
    r"""The ingest job config."""

    chunk_size: Annotated[Optional[float], pydantic.Field(alias="chunkSize")] = None
    r"""Soft chunk size."""

    max_chunk_size: Annotated[Optional[float], pydantic.Field(alias="maxChunkSize")] = (
        None
    )
    r"""Hard chunk size."""

    chunk_overlap: Annotated[Optional[float], pydantic.Field(alias="chunkOverlap")] = (
        None
    )
    r"""Custom chunk overlap."""

    metadata: Optional[Dict[str, DocumentConfigOutputMetadata]] = None
    r"""Custom metadata to be added to the ingested documents. It cannot contain nested objects; only primitive types (string, number, boolean) are allowed."""

    chunking_strategy: Annotated[
        Optional[ChunkingStrategy], pydantic.Field(alias="chunkingStrategy")
    ] = None
    r"""The chunking strategy to use. Defaults to `basic`."""

    strategy: Optional[Strategy] = None
    r"""The strategy to use. Defaults to `auto`."""
