"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .azure_embedding_config import AzureEmbeddingConfig, AzureEmbeddingConfigTypedDict
from .google_embedding_config import (
    GoogleEmbeddingConfig,
    GoogleEmbeddingConfigTypedDict,
)
from .openai_embedding_config import (
    OpenaiEmbeddingConfig,
    OpenaiEmbeddingConfigTypedDict,
)
from .voyage_embedding_config import (
    VoyageEmbeddingConfig,
    VoyageEmbeddingConfigTypedDict,
)
from agentset.types import BaseModel
from agentset.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


EmbeddingModelConfigModel = Literal["text-embedding-3-large",]


class EmbeddingModelConfigTextEmbedding3LargeTypedDict(TypedDict):
    model: EmbeddingModelConfigModel
    provider: Literal["MANAGED_OPENAI"]


class EmbeddingModelConfigTextEmbedding3Large(BaseModel):
    model: EmbeddingModelConfigModel

    PROVIDER: Annotated[
        Annotated[
            Literal["MANAGED_OPENAI"], AfterValidator(validate_const("MANAGED_OPENAI"))
        ],
        pydantic.Field(alias="provider"),
    ] = "MANAGED_OPENAI"


EmbeddingModelConfigTypedDict = TypeAliasType(
    "EmbeddingModelConfigTypedDict",
    Union[
        EmbeddingModelConfigTextEmbedding3LargeTypedDict,
        OpenaiEmbeddingConfigTypedDict,
        VoyageEmbeddingConfigTypedDict,
        GoogleEmbeddingConfigTypedDict,
        AzureEmbeddingConfigTypedDict,
    ],
)
r"""The embedding model config. If not provided, our managed embedding model will be used. Note: You can't change the embedding model config after the namespace is created."""


EmbeddingModelConfig = TypeAliasType(
    "EmbeddingModelConfig",
    Union[
        EmbeddingModelConfigTextEmbedding3Large,
        OpenaiEmbeddingConfig,
        VoyageEmbeddingConfig,
        GoogleEmbeddingConfig,
        AzureEmbeddingConfig,
    ],
)
r"""The embedding model config. If not provided, our managed embedding model will be used. Note: You can't change the embedding model config after the namespace is created."""
