"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .azure_embedding_configoutput import (
    AzureEmbeddingConfigOutput,
    AzureEmbeddingConfigOutputTypedDict,
)
from .google_embedding_configoutput import (
    GoogleEmbeddingConfigOutput,
    GoogleEmbeddingConfigOutputTypedDict,
)
from .openai_embedding_configoutput import (
    OpenaiEmbeddingConfigOutput,
    OpenaiEmbeddingConfigOutputTypedDict,
)
from .voyage_embedding_configoutput import (
    VoyageEmbeddingConfigOutput,
    VoyageEmbeddingConfigOutputTypedDict,
)
from agentset.types import BaseModel
from agentset.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


EmbeddingModelConfigOutputModel = Literal["text-embedding-3-large",]


class EmbeddingModelConfigOutputTextEmbedding3LargeTypedDict(TypedDict):
    model: EmbeddingModelConfigOutputModel
    provider: Literal["MANAGED_OPENAI"]


class EmbeddingModelConfigOutputTextEmbedding3Large(BaseModel):
    model: EmbeddingModelConfigOutputModel

    PROVIDER: Annotated[
        Annotated[
            Literal["MANAGED_OPENAI"], AfterValidator(validate_const("MANAGED_OPENAI"))
        ],
        pydantic.Field(alias="provider"),
    ] = "MANAGED_OPENAI"


EmbeddingModelConfigOutputTypedDict = TypeAliasType(
    "EmbeddingModelConfigOutputTypedDict",
    Union[
        EmbeddingModelConfigOutputTextEmbedding3LargeTypedDict,
        OpenaiEmbeddingConfigOutputTypedDict,
        VoyageEmbeddingConfigOutputTypedDict,
        GoogleEmbeddingConfigOutputTypedDict,
        AzureEmbeddingConfigOutputTypedDict,
    ],
)
r"""The embedding model config. If not provided, our managed embedding model will be used. Note: You can't change the embedding model config after the namespace is created."""


EmbeddingModelConfigOutput = TypeAliasType(
    "EmbeddingModelConfigOutput",
    Union[
        EmbeddingModelConfigOutputTextEmbedding3Large,
        OpenaiEmbeddingConfigOutput,
        VoyageEmbeddingConfigOutput,
        GoogleEmbeddingConfigOutput,
        AzureEmbeddingConfigOutput,
    ],
)
r"""The embedding model config. If not provided, our managed embedding model will be used. Note: You can't change the embedding model config after the namespace is created."""
