"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .document import Document, DocumentTypedDict
from agentset.types import BaseModel
from agentset.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    validate_const,
)
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetDocumentGlobalsTypedDict(TypedDict):
    namespace_id: NotRequired[str]
    r"""The id of the namespace (prefixed with ns_)"""
    x_tenant_id: NotRequired[str]
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class GetDocumentGlobals(BaseModel):
    namespace_id: Annotated[
        Optional[str],
        pydantic.Field(alias="namespaceId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ] = None
    r"""The id of the namespace (prefixed with ns_)"""

    x_tenant_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-tenant-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class GetDocumentRequestTypedDict(TypedDict):
    document_id: str
    r"""The id of the document (prefixed with doc_)"""
    x_tenant_id: NotRequired[str]
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class GetDocumentRequest(BaseModel):
    document_id: Annotated[
        str,
        pydantic.Field(alias="documentId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The id of the document (prefixed with doc_)"""

    x_tenant_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-tenant-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class GetDocumentResponseTypedDict(TypedDict):
    r"""The retrieved ingest job"""

    data: DocumentTypedDict
    success: Literal[True]


class GetDocumentResponse(BaseModel):
    r"""The retrieved ingest job"""

    data: Document

    SUCCESS: Annotated[
        Annotated[Literal[True], AfterValidator(validate_const(True))],
        pydantic.Field(alias="success"),
    ] = True
