"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from agentset.types import BaseModel, Nullable, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


RerankConfigModel = Literal[
    "cohere:rerank-v3.5",
    "cohere:rerank-english-v3.0",
    "cohere:rerank-multilingual-v3.0",
    "zeroentropy:zerank-1",
    "zeroentropy:zerank-1-small",
]


class RerankConfigTypedDict(TypedDict):
    model: RerankConfigModel


class RerankConfig(BaseModel):
    model: RerankConfigModel


LlmConfigModel = Literal[
    "openai:gpt-4.1",
    "openai:gpt-5",
    "openai:gpt-5-mini",
    "openai:gpt-5-nano",
]


class LlmConfigTypedDict(TypedDict):
    model: LlmConfigModel


class LlmConfig(BaseModel):
    model: LlmConfigModel


class HostingTypedDict(TypedDict):
    namespace_id: str
    r"""The ID of the namespace this hosting belongs to."""
    title: Nullable[str]
    r"""The title displayed on the hosted interface."""
    slug: Nullable[str]
    r"""The unique slug for accessing the hosted interface."""
    logo: Nullable[str]
    r"""The URL or base64 encoded image of the logo."""
    system_prompt: Nullable[str]
    r"""The system prompt used for the chat interface."""
    example_questions: List[str]
    r"""Example questions to display to users in the chat interface."""
    example_search_queries: List[str]
    r"""Example search queries to display to users in the search interface."""
    welcome_message: Nullable[str]
    r"""Welcome message displayed to users."""
    citation_metadata_path: Nullable[str]
    r"""Path to metadata field used for citations."""
    rerank_config: Nullable[RerankConfigTypedDict]
    r"""Configuration for the reranking model."""
    llm_config: Nullable[LlmConfigTypedDict]
    r"""Configuration for the LLM model."""
    allowed_emails: List[str]
    r"""List of allowed email addresses (when protected is true)."""
    allowed_email_domains: List[str]
    r"""List of allowed email domains (when protected is true)."""
    created_at: str
    r"""The date and time the hosting was created."""
    updated_at: str
    r"""The date and time the hosting was last updated."""
    search_enabled: NotRequired[bool]
    r"""Whether search functionality is enabled."""
    protected: NotRequired[bool]
    r"""Whether the hosted interface is protected by authentication."""


class Hosting(BaseModel):
    namespace_id: Annotated[str, pydantic.Field(alias="namespaceId")]
    r"""The ID of the namespace this hosting belongs to."""

    title: Nullable[str]
    r"""The title displayed on the hosted interface."""

    slug: Nullable[str]
    r"""The unique slug for accessing the hosted interface."""

    logo: Nullable[str]
    r"""The URL or base64 encoded image of the logo."""

    system_prompt: Annotated[Nullable[str], pydantic.Field(alias="systemPrompt")]
    r"""The system prompt used for the chat interface."""

    example_questions: Annotated[List[str], pydantic.Field(alias="exampleQuestions")]
    r"""Example questions to display to users in the chat interface."""

    example_search_queries: Annotated[
        List[str], pydantic.Field(alias="exampleSearchQueries")
    ]
    r"""Example search queries to display to users in the search interface."""

    welcome_message: Annotated[Nullable[str], pydantic.Field(alias="welcomeMessage")]
    r"""Welcome message displayed to users."""

    citation_metadata_path: Annotated[
        Nullable[str], pydantic.Field(alias="citationMetadataPath")
    ]
    r"""Path to metadata field used for citations."""

    rerank_config: Annotated[
        Nullable[RerankConfig], pydantic.Field(alias="rerankConfig")
    ]
    r"""Configuration for the reranking model."""

    llm_config: Annotated[Nullable[LlmConfig], pydantic.Field(alias="llmConfig")]
    r"""Configuration for the LLM model."""

    allowed_emails: Annotated[List[str], pydantic.Field(alias="allowedEmails")]
    r"""List of allowed email addresses (when protected is true)."""

    allowed_email_domains: Annotated[
        List[str], pydantic.Field(alias="allowedEmailDomains")
    ]
    r"""List of allowed email domains (when protected is true)."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The date and time the hosting was created."""

    updated_at: Annotated[str, pydantic.Field(alias="updatedAt")]
    r"""The date and time the hosting was last updated."""

    search_enabled: Annotated[Optional[bool], pydantic.Field(alias="searchEnabled")] = (
        True
    )
    r"""Whether search functionality is enabled."""

    protected: Optional[bool] = True
    r"""Whether the hosted interface is protected by authentication."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["searchEnabled", "protected"]
        nullable_fields = [
            "title",
            "slug",
            "logo",
            "systemPrompt",
            "welcomeMessage",
            "citationMetadataPath",
            "rerankConfig",
            "llmConfig",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
