"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .document_configoutput import DocumentConfigOutput, DocumentConfigOutputTypedDict
from .ingest_job_payloadoutput import (
    IngestJobPayloadOutput,
    IngestJobPayloadOutputTypedDict,
)
from .ingest_job_status import IngestJobStatus
from agentset.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict


class IngestJobTypedDict(TypedDict):
    id: str
    r"""The unique ID of the ingest job."""
    namespace_id: str
    r"""The namespace ID of the ingest job."""
    tenant_id: Nullable[str]
    r"""The tenant ID of the ingest job."""
    external_id: Nullable[str]
    r"""A unique external ID of the ingest job. You can use this to identify the ingest job in your system."""
    status: IngestJobStatus
    r"""The status of the ingest job."""
    error: Nullable[str]
    r"""The error message of the ingest job. Only exists when the status is failed."""
    payload: IngestJobPayloadOutputTypedDict
    r"""The ingest job payload."""
    config: Nullable[DocumentConfigOutputTypedDict]
    created_at: str
    r"""The date and time the namespace was created."""
    queued_at: Nullable[str]
    r"""The date and time the ingest job was queued."""
    pre_processing_at: Nullable[str]
    r"""The date and time the ingest job was pre-processed."""
    processing_at: Nullable[str]
    r"""The date and time the ingest job was processed."""
    completed_at: Nullable[str]
    r"""The date and time the ingest job was completed."""
    failed_at: Nullable[str]
    r"""The date and time the ingest job failed."""
    name: NotRequired[Nullable[str]]
    r"""The name of the ingest job."""


class IngestJob(BaseModel):
    id: str
    r"""The unique ID of the ingest job."""

    namespace_id: Annotated[str, pydantic.Field(alias="namespaceId")]
    r"""The namespace ID of the ingest job."""

    tenant_id: Annotated[Nullable[str], pydantic.Field(alias="tenantId")]
    r"""The tenant ID of the ingest job."""

    external_id: Annotated[Nullable[str], pydantic.Field(alias="externalId")]
    r"""A unique external ID of the ingest job. You can use this to identify the ingest job in your system."""

    status: IngestJobStatus
    r"""The status of the ingest job."""

    error: Nullable[str]
    r"""The error message of the ingest job. Only exists when the status is failed."""

    payload: IngestJobPayloadOutput
    r"""The ingest job payload."""

    config: Nullable[DocumentConfigOutput]

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The date and time the namespace was created."""

    queued_at: Annotated[Nullable[str], pydantic.Field(alias="queuedAt")]
    r"""The date and time the ingest job was queued."""

    pre_processing_at: Annotated[Nullable[str], pydantic.Field(alias="preProcessingAt")]
    r"""The date and time the ingest job was pre-processed."""

    processing_at: Annotated[Nullable[str], pydantic.Field(alias="processingAt")]
    r"""The date and time the ingest job was processed."""

    completed_at: Annotated[Nullable[str], pydantic.Field(alias="completedAt")]
    r"""The date and time the ingest job was completed."""

    failed_at: Annotated[Nullable[str], pydantic.Field(alias="failedAt")]
    r"""The date and time the ingest job failed."""

    name: OptionalNullable[str] = UNSET
    r"""The name of the ingest job."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["name"]
        nullable_fields = [
            "name",
            "tenantId",
            "externalId",
            "error",
            "config",
            "queuedAt",
            "preProcessingAt",
            "processingAt",
            "completedAt",
            "failedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
