"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .chunking_strategy import ChunkingStrategy
from .strategy import Strategy
from agentset.types import BaseModel
import pydantic
from typing import Dict, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


IngestJobConfigMetadataTypedDict = TypeAliasType(
    "IngestJobConfigMetadataTypedDict", Union[str, float, bool]
)


IngestJobConfigMetadata = TypeAliasType(
    "IngestJobConfigMetadata", Union[str, float, bool]
)


class IngestJobConfigTypedDict(TypedDict):
    r"""The ingest job config."""

    chunk_size: NotRequired[float]
    r"""Soft chunk size."""
    max_chunk_size: NotRequired[float]
    r"""Hard chunk size."""
    chunk_overlap: NotRequired[float]
    r"""Custom chunk overlap."""
    metadata: NotRequired[Dict[str, IngestJobConfigMetadataTypedDict]]
    r"""Custom metadata to be added to the ingested documents. It cannot contain nested objects; only primitive types (string, number, boolean) are allowed."""
    chunking_strategy: NotRequired[ChunkingStrategy]
    r"""The chunking strategy to use. Defaults to `basic`."""
    strategy: NotRequired[Strategy]
    r"""The strategy to use. Defaults to `auto`."""


class IngestJobConfig(BaseModel):
    r"""The ingest job config."""

    chunk_size: Annotated[Optional[float], pydantic.Field(alias="chunkSize")] = None
    r"""Soft chunk size."""

    max_chunk_size: Annotated[Optional[float], pydantic.Field(alias="maxChunkSize")] = (
        None
    )
    r"""Hard chunk size."""

    chunk_overlap: Annotated[Optional[float], pydantic.Field(alias="chunkOverlap")] = (
        None
    )
    r"""Custom chunk overlap."""

    metadata: Optional[Dict[str, IngestJobConfigMetadata]] = None
    r"""Custom metadata to be added to the ingested documents. It cannot contain nested objects; only primitive types (string, number, boolean) are allowed."""

    chunking_strategy: Annotated[
        Optional[ChunkingStrategy], pydantic.Field(alias="chunkingStrategy")
    ] = None
    r"""The chunking strategy to use. Defaults to `basic`."""

    strategy: Optional[Strategy] = None
    r"""The strategy to use. Defaults to `auto`."""
