"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .document import Document, DocumentTypedDict
from .document_status import DocumentStatus
from .pagination_cursor_direction import PaginationCursorDirection
from agentset.types import BaseModel, Nullable, UNSET_SENTINEL
from agentset.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    validate_const,
)
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Awaitable, Callable, List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class ListDocumentsGlobalsTypedDict(TypedDict):
    namespace_id: NotRequired[str]
    r"""The id of the namespace (prefixed with ns_)"""
    x_tenant_id: NotRequired[str]
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class ListDocumentsGlobals(BaseModel):
    namespace_id: Annotated[
        Optional[str],
        pydantic.Field(alias="namespaceId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ] = None
    r"""The id of the namespace (prefixed with ns_)"""

    x_tenant_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-tenant-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


ListDocumentsOrderBy = Literal["createdAt",]
r"""The field to order by. Default is `createdAt`."""


ListDocumentsOrder = Literal[
    "asc",
    "desc",
]
r"""The order to sort by. Default is `desc`."""


class ListDocumentsRequestTypedDict(TypedDict):
    statuses: NotRequired[List[DocumentStatus]]
    order_by: NotRequired[ListDocumentsOrderBy]
    r"""The field to order by. Default is `createdAt`."""
    order: NotRequired[ListDocumentsOrder]
    r"""The order to sort by. Default is `desc`."""
    ingest_job_id: NotRequired[str]
    cursor: NotRequired[str]
    cursor_direction: NotRequired[PaginationCursorDirection]
    r"""The direction to paginate by."""
    per_page: NotRequired[float]
    x_tenant_id: NotRequired[str]
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class ListDocumentsRequest(BaseModel):
    statuses: Annotated[
        Optional[List[DocumentStatus]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    order_by: Annotated[
        Optional[ListDocumentsOrderBy],
        pydantic.Field(alias="orderBy"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "createdAt"
    r"""The field to order by. Default is `createdAt`."""

    order: Annotated[
        Optional[ListDocumentsOrder],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "desc"
    r"""The order to sort by. Default is `desc`."""

    ingest_job_id: Annotated[
        Optional[str],
        pydantic.Field(alias="ingestJobId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    cursor: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    cursor_direction: Annotated[
        Optional[PaginationCursorDirection],
        pydantic.Field(alias="cursorDirection"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The direction to paginate by."""

    per_page: Annotated[
        Optional[float],
        pydantic.Field(alias="perPage"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 30

    x_tenant_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-tenant-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class ListDocumentsPaginationTypedDict(TypedDict):
    next_cursor: Nullable[str]
    prev_cursor: Nullable[str]
    has_more: bool


class ListDocumentsPagination(BaseModel):
    next_cursor: Annotated[Nullable[str], pydantic.Field(alias="nextCursor")]

    prev_cursor: Annotated[Nullable[str], pydantic.Field(alias="prevCursor")]

    has_more: Annotated[bool, pydantic.Field(alias="hasMore")]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["nextCursor", "prevCursor"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListDocumentsResponseBodyTypedDict(TypedDict):
    r"""The retrieved ingest jobs"""

    data: List[DocumentTypedDict]
    pagination: ListDocumentsPaginationTypedDict
    success: Literal[True]


class ListDocumentsResponseBody(BaseModel):
    r"""The retrieved ingest jobs"""

    data: List[Document]

    pagination: ListDocumentsPagination

    SUCCESS: Annotated[
        Annotated[Literal[True], AfterValidator(validate_const(True))],
        pydantic.Field(alias="success"),
    ] = True


class ListDocumentsResponseTypedDict(TypedDict):
    result: ListDocumentsResponseBodyTypedDict


class ListDocumentsResponse(BaseModel):
    next: Union[
        Callable[[], Optional[ListDocumentsResponse]],
        Callable[[], Awaitable[Optional[ListDocumentsResponse]]],
    ]

    result: ListDocumentsResponseBody
