"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from agentset.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from agentset.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, NotRequired, TypedDict


class ManagedFilePayloadTypedDict(TypedDict):
    key: str
    r"""The key of the managed file to ingest."""
    type: Literal["MANAGED_FILE"]
    file_name: NotRequired[Nullable[str]]


class ManagedFilePayload(BaseModel):
    key: str
    r"""The key of the managed file to ingest."""

    TYPE: Annotated[
        Annotated[
            Literal["MANAGED_FILE"], AfterValidator(validate_const("MANAGED_FILE"))
        ],
        pydantic.Field(alias="type"),
    ] = "MANAGED_FILE"

    file_name: Annotated[OptionalNullable[str], pydantic.Field(alias="fileName")] = (
        UNSET
    )

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["fileName"]
        nullable_fields = ["fileName"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
