"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .embedding_model_configoutput import (
    EmbeddingModelConfigOutput,
    EmbeddingModelConfigOutputTypedDict,
)
from .vector_store_config import VectorStoreConfig, VectorStoreConfigTypedDict
from agentset.types import BaseModel, Nullable, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, TypedDict


class NamespaceTypedDict(TypedDict):
    id: str
    r"""The unique ID of the namespace."""
    name: str
    r"""The name of the namespace."""
    slug: str
    r"""The slug of the namespace."""
    organization_id: str
    r"""The ID of the organization that owns the namespace."""
    created_at: str
    r"""The date and time the namespace was created."""
    embedding_config: Nullable[EmbeddingModelConfigOutputTypedDict]
    vector_store_config: Nullable[VectorStoreConfigTypedDict]


class Namespace(BaseModel):
    id: str
    r"""The unique ID of the namespace."""

    name: str
    r"""The name of the namespace."""

    slug: str
    r"""The slug of the namespace."""

    organization_id: Annotated[str, pydantic.Field(alias="organizationId")]
    r"""The ID of the organization that owns the namespace."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The date and time the namespace was created."""

    embedding_config: Annotated[
        Nullable[EmbeddingModelConfigOutput], pydantic.Field(alias="embeddingConfig")
    ]

    vector_store_config: Annotated[
        Nullable[VectorStoreConfig], pydantic.Field(alias="vectorStoreConfig")
    ]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["embeddingConfig", "vectorStoreConfig"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
