"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .openai_embedding_model_enum import OpenaiEmbeddingModelEnum
from agentset.types import BaseModel
from agentset.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, TypedDict


class OpenaiEmbeddingConfigTypedDict(TypedDict):
    model: OpenaiEmbeddingModelEnum
    r"""The OpenAI embedding model enum."""
    api_key: str
    provider: Literal["OPENAI"]


class OpenaiEmbeddingConfig(BaseModel):
    model: OpenaiEmbeddingModelEnum
    r"""The OpenAI embedding model enum."""

    api_key: Annotated[str, pydantic.Field(alias="apiKey")]

    PROVIDER: Annotated[
        Annotated[Literal["OPENAI"], AfterValidator(validate_const("OPENAI"))],
        pydantic.Field(alias="provider"),
    ] = "OPENAI"
