"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from agentset.types import BaseModel
from agentset.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, TypedDict


class PineconeConfigTypedDict(TypedDict):
    api_key: str
    r"""The API key for the Pinecone index."""
    index_host: str
    r"""The host of the Pinecone index."""
    provider: Literal["PINECONE"]


class PineconeConfig(BaseModel):
    api_key: Annotated[str, pydantic.Field(alias="apiKey")]
    r"""The API key for the Pinecone index."""

    index_host: Annotated[str, pydantic.Field(alias="indexHost")]
    r"""The host of the Pinecone index."""

    PROVIDER: Annotated[
        Annotated[Literal["PINECONE"], AfterValidator(validate_const("PINECONE"))],
        pydantic.Field(alias="provider"),
    ] = "PINECONE"
