"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from agentset.types import BaseModel
from agentset.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    RequestMetadata,
    validate_const,
)
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Any, Dict, List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SearchGlobalsTypedDict(TypedDict):
    namespace_id: NotRequired[str]
    r"""The id of the namespace (prefixed with ns_)"""
    x_tenant_id: NotRequired[str]
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class SearchGlobals(BaseModel):
    namespace_id: Annotated[
        Optional[str],
        pydantic.Field(alias="namespaceId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ] = None
    r"""The id of the namespace (prefixed with ns_)"""

    x_tenant_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-tenant-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


SearchRerankModel = Literal[
    "cohere:rerank-v3.5",
    "cohere:rerank-english-v3.0",
    "cohere:rerank-multilingual-v3.0",
    "zeroentropy:zerank-1",
    "zeroentropy:zerank-1-small",
]
r"""The reranking model to use."""


Mode = Literal[
    "semantic",
    "keyword",
]


class SearchRequestBodyTypedDict(TypedDict):
    query: str
    r"""The query to search for."""
    top_k: NotRequired[float]
    r"""The number of results to fetch from the vector store. Defaults to `10`."""
    rerank: NotRequired[bool]
    r"""Whether to rerank the results. Defaults to `true`."""
    rerank_limit: NotRequired[float]
    r"""The number of results to return after reranking. Defaults to `topK`."""
    rerank_model: NotRequired[SearchRerankModel]
    r"""The reranking model to use."""
    filter_: NotRequired[Dict[str, Any]]
    r"""A filter to apply to the results."""
    min_score: NotRequired[float]
    r"""The minimum score to return."""
    include_relationships: NotRequired[bool]
    r"""Whether to include relationships in the results. Defaults to `false`."""
    include_metadata: NotRequired[bool]
    r"""Whether to include metadata in the results. Defaults to `true`."""
    keyword_filter: NotRequired[str]
    mode: NotRequired[Mode]


class SearchRequestBody(BaseModel):
    query: str
    r"""The query to search for."""

    top_k: Annotated[Optional[float], pydantic.Field(alias="topK")] = 10
    r"""The number of results to fetch from the vector store. Defaults to `10`."""

    rerank: Optional[bool] = True
    r"""Whether to rerank the results. Defaults to `true`."""

    rerank_limit: Annotated[Optional[float], pydantic.Field(alias="rerankLimit")] = None
    r"""The number of results to return after reranking. Defaults to `topK`."""

    rerank_model: Annotated[
        Optional[SearchRerankModel], pydantic.Field(alias="rerankModel")
    ] = "cohere:rerank-v3.5"
    r"""The reranking model to use."""

    filter_: Annotated[Optional[Dict[str, Any]], pydantic.Field(alias="filter")] = None
    r"""A filter to apply to the results."""

    min_score: Annotated[Optional[float], pydantic.Field(alias="minScore")] = None
    r"""The minimum score to return."""

    include_relationships: Annotated[
        Optional[bool], pydantic.Field(alias="includeRelationships")
    ] = False
    r"""Whether to include relationships in the results. Defaults to `false`."""

    include_metadata: Annotated[
        Optional[bool], pydantic.Field(alias="includeMetadata")
    ] = True
    r"""Whether to include metadata in the results. Defaults to `true`."""

    keyword_filter: Annotated[Optional[str], pydantic.Field(alias="keywordFilter")] = (
        None
    )

    mode: Optional[Mode] = "semantic"


class SearchRequestTypedDict(TypedDict):
    request_body: SearchRequestBodyTypedDict
    x_tenant_id: NotRequired[str]
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class SearchRequest(BaseModel):
    request_body: Annotated[
        SearchRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    x_tenant_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-tenant-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class SearchMetadataTypedDict(TypedDict):
    file_directory: str
    filename: str
    filetype: str
    link_texts: NotRequired[List[Any]]
    link_urls: NotRequired[List[Any]]
    languages: NotRequired[List[Any]]
    sequence_number: NotRequired[float]


class SearchMetadata(BaseModel):
    file_directory: str

    filename: str

    filetype: str

    link_texts: Optional[List[Any]] = None

    link_urls: Optional[List[Any]] = None

    languages: Optional[List[Any]] = None

    sequence_number: Optional[float] = None


class SearchDataTypedDict(TypedDict):
    id: str
    score: float
    text: NotRequired[str]
    relationships: NotRequired[Dict[str, Any]]
    metadata: NotRequired[SearchMetadataTypedDict]


class SearchData(BaseModel):
    id: str

    score: float

    text: Optional[str] = None

    relationships: Optional[Dict[str, Any]] = None

    metadata: Optional[SearchMetadata] = None


class SearchResponseTypedDict(TypedDict):
    r"""The retrieved namespace"""

    data: List[SearchDataTypedDict]
    success: Literal[True]


class SearchResponse(BaseModel):
    r"""The retrieved namespace"""

    data: List[SearchData]

    SUCCESS: Annotated[
        Annotated[Literal[True], AfterValidator(validate_const(True))],
        pydantic.Field(alias="success"),
    ] = True
