"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .turbopuffer_region_enum import TurbopufferRegionEnum
from agentset.types import BaseModel
from agentset.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, TypedDict


class TurbopufferConfigOutputTypedDict(TypedDict):
    api_key: str
    r"""The API key for the Turbopuffer index."""
    region: TurbopufferRegionEnum
    r"""The region for the Turbopuffer index. Check https://turbopuffer.com/docs/regions"""
    provider: Literal["TURBOPUFFER"]


class TurbopufferConfigOutput(BaseModel):
    api_key: Annotated[str, pydantic.Field(alias="apiKey")]
    r"""The API key for the Turbopuffer index."""

    region: TurbopufferRegionEnum
    r"""The region for the Turbopuffer index. Check https://turbopuffer.com/docs/regions"""

    PROVIDER: Annotated[
        Annotated[
            Literal["TURBOPUFFER"], AfterValidator(validate_const("TURBOPUFFER"))
        ],
        pydantic.Field(alias="provider"),
    ] = "TURBOPUFFER"
