"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .hosting import Hosting, HostingTypedDict
from agentset.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from agentset.utils import FieldMetadata, PathParamMetadata, validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateHostingGlobalsTypedDict(TypedDict):
    namespace_id: NotRequired[str]
    r"""The id of the namespace (prefixed with ns_)"""


class UpdateHostingGlobals(BaseModel):
    namespace_id: Annotated[
        Optional[str],
        pydantic.Field(alias="namespaceId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ] = None
    r"""The id of the namespace (prefixed with ns_)"""


UpdateHostingRerankModel = Literal[
    "cohere:rerank-v3.5",
    "cohere:rerank-english-v3.0",
    "cohere:rerank-multilingual-v3.0",
    "zeroentropy:zerank-1",
    "zeroentropy:zerank-1-small",
]


LlmModel = Literal[
    "openai:gpt-4.1",
    "openai:gpt-5",
    "openai:gpt-5-mini",
    "openai:gpt-5-nano",
]


class UpdateHostingRequestTypedDict(TypedDict):
    title: NotRequired[str]
    slug: NotRequired[str]
    logo: NotRequired[Nullable[str]]
    protected: NotRequired[bool]
    allowed_emails: NotRequired[List[str]]
    allowed_email_domains: NotRequired[List[str]]
    system_prompt: NotRequired[str]
    example_questions: NotRequired[List[str]]
    example_search_queries: NotRequired[List[str]]
    welcome_message: NotRequired[str]
    citation_metadata_path: NotRequired[str]
    search_enabled: NotRequired[bool]
    rerank_model: NotRequired[UpdateHostingRerankModel]
    llm_model: NotRequired[LlmModel]


class UpdateHostingRequest(BaseModel):
    title: Optional[str] = None

    slug: Optional[str] = None

    logo: OptionalNullable[str] = UNSET

    protected: Optional[bool] = None

    allowed_emails: Annotated[
        Optional[List[str]], pydantic.Field(alias="allowedEmails")
    ] = None

    allowed_email_domains: Annotated[
        Optional[List[str]], pydantic.Field(alias="allowedEmailDomains")
    ] = None

    system_prompt: Annotated[Optional[str], pydantic.Field(alias="systemPrompt")] = None

    example_questions: Annotated[
        Optional[List[str]], pydantic.Field(alias="exampleQuestions")
    ] = None

    example_search_queries: Annotated[
        Optional[List[str]], pydantic.Field(alias="exampleSearchQueries")
    ] = None

    welcome_message: Annotated[
        Optional[str], pydantic.Field(alias="welcomeMessage")
    ] = None

    citation_metadata_path: Annotated[
        Optional[str], pydantic.Field(alias="citationMetadataPath")
    ] = None

    search_enabled: Annotated[Optional[bool], pydantic.Field(alias="searchEnabled")] = (
        None
    )

    rerank_model: Annotated[
        Optional[UpdateHostingRerankModel], pydantic.Field(alias="rerankModel")
    ] = None

    llm_model: Annotated[Optional[LlmModel], pydantic.Field(alias="llmModel")] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "title",
            "slug",
            "logo",
            "protected",
            "allowedEmails",
            "allowedEmailDomains",
            "systemPrompt",
            "exampleQuestions",
            "exampleSearchQueries",
            "welcomeMessage",
            "citationMetadataPath",
            "searchEnabled",
            "rerankModel",
            "llmModel",
        ]
        nullable_fields = ["logo"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateHostingResponseTypedDict(TypedDict):
    r"""The updated hosting configuration"""

    data: HostingTypedDict
    success: Literal[True]


class UpdateHostingResponse(BaseModel):
    r"""The updated hosting configuration"""

    data: Hosting

    SUCCESS: Annotated[
        Annotated[Literal[True], AfterValidator(validate_const(True))],
        pydantic.Field(alias="success"),
    ] = True
