"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .namespace import Namespace, NamespaceTypedDict
from agentset.types import BaseModel
from agentset.utils import FieldMetadata, PathParamMetadata, validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateNamespaceGlobalsTypedDict(TypedDict):
    namespace_id: NotRequired[str]
    r"""The id of the namespace (prefixed with ns_)"""


class UpdateNamespaceGlobals(BaseModel):
    namespace_id: Annotated[
        Optional[str],
        pydantic.Field(alias="namespaceId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ] = None
    r"""The id of the namespace (prefixed with ns_)"""


class UpdateNamespaceRequestTypedDict(TypedDict):
    name: NotRequired[str]
    slug: NotRequired[str]


class UpdateNamespaceRequest(BaseModel):
    name: Optional[str] = None

    slug: Optional[str] = None


class UpdateNamespaceResponseTypedDict(TypedDict):
    r"""The updated namespace"""

    data: NamespaceTypedDict
    success: Literal[True]


class UpdateNamespaceResponse(BaseModel):
    r"""The updated namespace"""

    data: Namespace

    SUCCESS: Annotated[
        Annotated[Literal[True], AfterValidator(validate_const(True))],
        pydantic.Field(alias="success"),
    ] = True
