"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from agentset.types import BaseModel
from agentset.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    validate_const,
)
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class WarmUpGlobalsTypedDict(TypedDict):
    namespace_id: NotRequired[str]
    r"""The id of the namespace (prefixed with ns_)"""
    x_tenant_id: NotRequired[str]
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class WarmUpGlobals(BaseModel):
    namespace_id: Annotated[
        Optional[str],
        pydantic.Field(alias="namespaceId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ] = None
    r"""The id of the namespace (prefixed with ns_)"""

    x_tenant_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-tenant-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class WarmUpRequestTypedDict(TypedDict):
    x_tenant_id: NotRequired[str]
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class WarmUpRequest(BaseModel):
    x_tenant_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-tenant-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters."""


class WarmUpDataTypedDict(TypedDict):
    status: bool


class WarmUpData(BaseModel):
    status: bool


class WarmUpResponseTypedDict(TypedDict):
    r"""Cache warming started"""

    data: WarmUpDataTypedDict
    success: Literal[True]


class WarmUpResponse(BaseModel):
    r"""Cache warming started"""

    data: WarmUpData

    SUCCESS: Annotated[
        Annotated[Literal[True], AfterValidator(validate_const(True))],
        pydantic.Field(alias="success"),
    ] = True
