"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from agentset import errors, models, utils
from agentset._hooks import HookContext
from agentset.types import OptionalNullable, UNSET
from agentset.utils import get_security_from_env
from agentset.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Dict, List, Mapping, Optional


class Search(BaseSDK):
    def execute(
        self,
        *,
        query: str,
        x_tenant_id: Optional[str] = None,
        top_k: Optional[float] = 10,
        rerank: Optional[bool] = True,
        rerank_limit: Optional[float] = None,
        rerank_model: Optional[models.SearchRerankModel] = "cohere:rerank-v3.5",
        filter_: Optional[Dict[str, Any]] = None,
        min_score: Optional[float] = None,
        include_relationships: Optional[bool] = False,
        include_metadata: Optional[bool] = True,
        keyword_filter: Optional[str] = None,
        mode: Optional[models.Mode] = "semantic",
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.SearchData]:
        r"""Search a namespace

        Search a namespace for a query.

        :param query: The query to search for.
        :param x_tenant_id: Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters.
        :param top_k: The number of results to fetch from the vector store. Defaults to `10`.
        :param rerank: Whether to rerank the results. Defaults to `true`.
        :param rerank_limit: The number of results to return after reranking. Defaults to `topK`.
        :param rerank_model: The reranking model to use.
        :param filter_: A filter to apply to the results.
        :param min_score: The minimum score to return.
        :param include_relationships: Whether to include relationships in the results. Defaults to `false`.
        :param include_metadata: Whether to include metadata in the results. Defaults to `true`.
        :param keyword_filter:
        :param mode:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SearchRequest(
            x_tenant_id=x_tenant_id,
            request_body=models.SearchRequestBody(
                query=query,
                top_k=top_k,
                rerank=rerank,
                rerank_limit=rerank_limit,
                rerank_model=rerank_model,
                filter_=filter_,
                min_score=min_score,
                include_relationships=include_relationships,
                include_metadata=include_metadata,
                keyword_filter=keyword_filter,
                mode=mode,
            ),
        )

        req = self._build_request(
            method="POST",
            path="/v1/namespace/{namespaceId}/search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.SearchGlobals(
                namespace_id=self.sdk_configuration.globals.namespace_id,
                x_tenant_id=self.sdk_configuration.globals.x_tenant_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body, False, False, "json", models.SearchRequestBody
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="search",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "410",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SearchResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "410", "application/json"):
            response_data = unmarshal_json_response(
                errors.InviteExpiredErrorData, http_res
            )
            raise errors.InviteExpiredError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.RateLimitExceededErrorData, http_res
            )
            raise errors.RateLimitExceededError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AgentsetDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AgentsetDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AgentsetDefaultError("Unexpected response received", http_res)

    async def execute_async(
        self,
        *,
        query: str,
        x_tenant_id: Optional[str] = None,
        top_k: Optional[float] = 10,
        rerank: Optional[bool] = True,
        rerank_limit: Optional[float] = None,
        rerank_model: Optional[models.SearchRerankModel] = "cohere:rerank-v3.5",
        filter_: Optional[Dict[str, Any]] = None,
        min_score: Optional[float] = None,
        include_relationships: Optional[bool] = False,
        include_metadata: Optional[bool] = True,
        keyword_filter: Optional[str] = None,
        mode: Optional[models.Mode] = "semantic",
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.SearchData]:
        r"""Search a namespace

        Search a namespace for a query.

        :param query: The query to search for.
        :param x_tenant_id: Optional tenant id to use for the request. If not provided, the namespace will be used directly. Must be alphanumeric and up to 64 characters.
        :param top_k: The number of results to fetch from the vector store. Defaults to `10`.
        :param rerank: Whether to rerank the results. Defaults to `true`.
        :param rerank_limit: The number of results to return after reranking. Defaults to `topK`.
        :param rerank_model: The reranking model to use.
        :param filter_: A filter to apply to the results.
        :param min_score: The minimum score to return.
        :param include_relationships: Whether to include relationships in the results. Defaults to `false`.
        :param include_metadata: Whether to include metadata in the results. Defaults to `true`.
        :param keyword_filter:
        :param mode:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SearchRequest(
            x_tenant_id=x_tenant_id,
            request_body=models.SearchRequestBody(
                query=query,
                top_k=top_k,
                rerank=rerank,
                rerank_limit=rerank_limit,
                rerank_model=rerank_model,
                filter_=filter_,
                min_score=min_score,
                include_relationships=include_relationships,
                include_metadata=include_metadata,
                keyword_filter=keyword_filter,
                mode=mode,
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/namespace/{namespaceId}/search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.SearchGlobals(
                namespace_id=self.sdk_configuration.globals.namespace_id,
                x_tenant_id=self.sdk_configuration.globals.x_tenant_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body, False, False, "json", models.SearchRequestBody
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="search",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "410",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SearchResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "410", "application/json"):
            response_data = unmarshal_json_response(
                errors.InviteExpiredErrorData, http_res
            )
            raise errors.InviteExpiredError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.RateLimitExceededErrorData, http_res
            )
            raise errors.RateLimitExceededError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AgentsetDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AgentsetDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AgentsetDefaultError("Unexpected response received", http_res)
