# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-07-29T23:31:56+00:00

from __future__ import annotations

from datetime import date as Date
from datetime import datetime as DateTime
from enum import Enum
from typing import Any, Dict, List, Optional, Union
from uuid import UUID

from pydantic import BaseModel, Field, confloat, conint, constr


class AccountBalance(BaseModel):
    account_number: str = Field(
        ...,
        description="Ledger account number in the chart of accounts",
        title="Account Number",
    )
    account_name: Optional[str] = Field(
        None, description="Display name of the ledger account", title="Account Name"
    )
    debit: float = Field(
        ...,
        description="Debit at end date. When debit and credit are equal to 0 and balance is different from 0 then the debit and credit cannot be determined, only the balance can be calculated in those cases.",
        title="Debit",
    )
    credit: float = Field(
        ...,
        description="Credit at end date. When debit and credit are equal to 0 and balance is different from 0 then the debit and credit cannot be determined, only the balance can be calculated in those cases.",
        title="Credit",
    )
    balance: float = Field(..., title="Balance")
    period_debit: float = Field(
        ...,
        description="Debit at end date beginning from the given start date. When debit and credit are equal to 0 and balance is different from 0 then the debit and credit cannot be determined, only the balance can be calculated in those cases.",
        title="Period Debit",
    )
    period_credit: float = Field(
        ...,
        description="Credit at end date beginning from the given start date. When debit and credit are equal to 0 and balance is different from 0 then the debit and credit cannot be determined, only the balance can be calculated in those cases.",
        title="Period Credit",
    )
    period_balance: float = Field(
        ...,
        description="Balance at end date beginning from the given start date.",
        title="Period Balance",
    )


class AccountBalanceFilter(BaseModel):
    accounts: List[str] = Field(
        ...,
        description='Array/list containing the account numbers/classes to include in the response. E.g. ["601", "7"] to retrieve all account in the class 7 and accounts with an account number beginning with 601',
        title="Accounts",
    )
    start: Optional[str] = Field(
        None,
        description="Start month (inclusive). Format: YYYYMM (e.g., 202502 for February 2025).",
        title="Start",
    )
    end: constr(min_length=6, max_length=6) = Field(
        ...,
        description="End month (inclusive). Format: YYYYMM (e.g., 202512 for December 2025).",
        title="End",
    )


class AccountItemType(Enum):
    bank = "bank"
    cash = "cash"
    other_financial = "other_financial"
    receivable = "receivable"
    payable = "payable"
    income = "income"
    expense = "expense"
    vat = "vat"
    other = "other"


class AccountToCreate(BaseModel):
    account_number: constr(min_length=1) = Field(..., title="Account Number")
    account_name: constr(min_length=1) = Field(..., title="Account Name")


class AccountTypeFilter(Enum):
    bank = "bank"
    cash = "cash"
    income = "income"
    expense = "expense"
    vat = "vat"


class AccountingCategoryItem(BaseModel):
    id: str = Field(
        ...,
        description="Unique identifier of the accounting category",
        examples=["371ca583-d218-4900-b236-397532cf0e2"],
        title="Id",
    )
    name: str = Field(
        ...,
        description="Name given to the accounting category",
        examples=["Beverages"],
        title="Name",
    )
    code: Optional[str] = Field(
        None,
        description="Code assigned to the category",
        examples=["123456"],
        title="Code",
    )
    ledger_account_code: Optional[str] = Field(
        None,
        description="Ledger account code assigned to the category",
        examples=["123456"],
        title="Ledger Account Code",
    )
    posting_account_code: Optional[str] = Field(
        None,
        description="Posting account code assigned to the category",
        examples=["123456"],
        title="Posting Account Code",
    )


class AddressItem(BaseModel):
    address_type: Optional[str] = Field(
        None, description="Type of the address", examples=["home"], title="Address Type"
    )
    name: Optional[str] = Field(
        None,
        description="Name given to the address (e.g. 'home')",
        examples=["Home"],
        title="Name",
    )
    street: Optional[str] = Field(
        None, description="Street name", examples=["Main Street"], title="Street"
    )
    number: Optional[str] = Field(
        None, description="Number of the address", examples=["123"], title="Number"
    )
    box: Optional[str] = Field(
        None, description="Box of the address", examples=["A"], title="Box"
    )
    city: Optional[str] = Field(
        None, description="City name", examples=["Paris"], title="City"
    )
    postal_code: Optional[str] = Field(
        None,
        description="Postal code of the address",
        examples=["75000"],
        title="Postal Code",
    )
    country: Optional[str] = Field(
        None,
        description="Country, format: ISO 3166-1 codes.",
        examples=["FR"],
        title="Country",
    )


class AddressType(Enum):
    main = "main"
    delivery = "delivery"
    invoice = "invoice"


class AddressTypeInvoicing(Enum):
    main = "main"
    delivery = "delivery"
    invoice = "invoice"
    other = "other"


class AnalyticAccountItemIn(BaseModel):
    active: Optional[bool] = Field(
        True,
        description="Flag indicating whether the analytic account is active.",
        title="Active",
    )
    code: constr(min_length=1) = Field(
        ...,
        description="Short code for the analytic account. Often used for internal referencing. May be required to be unique",
        title="Code",
    )
    name: constr(min_length=1) = Field(
        ...,
        description="Name or label of the analytic account as it appears in the accounting system.",
        title="Name",
    )
    currency: str = Field(
        ...,
        description="Indicates the currency of the analytic account (e.g., EUR, USD).",
        title="Currency",
    )


class AnalyticAccountItemOut(BaseModel):
    id: str = Field(
        ...,
        description="Unique id of the analytic account in the accounting system.",
        title="Id",
    )
    active: bool = Field(
        ...,
        description="Flag indicating whether the analytic account is active.",
        title="Active",
    )
    code: Optional[str] = Field(
        None,
        description="Short code for the analytic account. Often used for internal referencing. For some integrations, it may be required to be unique.",
        title="Code",
    )
    name: str = Field(
        ...,
        description="Name or label of the analytic account as it appears in the accounting system.",
        title="Name",
    )
    currency: Optional[str] = Field(
        None,
        description="Indicates the currency of the analytic account (e.g., EUR, USD).",
        title="Currency",
    )
    balance: Optional[float] = Field(0, title="Balance")
    credit: Optional[float] = Field(0, title="Credit")
    debit: Optional[float] = Field(0, title="Debit")


class AnalyticAccountItemOutMultiAnalyticPlans(BaseModel):
    id: str = Field(
        ...,
        description="Unique id of the analytic account in the accounting system.",
        title="Id",
    )
    active: bool = Field(
        ...,
        description="Flag indicating whether the analytic account is active.",
        title="Active",
    )
    code: Optional[str] = Field(
        None,
        description="Short code for the analytic account. Often used for internal referencing. For some integrations, it may be required to be unique.",
        title="Code",
    )
    name: str = Field(
        ...,
        description="Name or label of the analytic account as it appears in the accounting system.",
        title="Name",
    )
    currency: Optional[str] = Field(
        None,
        description="Indicates the currency of the analytic account (e.g., EUR, USD).",
        title="Currency",
    )
    balance: Optional[float] = Field(0, title="Balance")
    credit: Optional[float] = Field(0, title="Credit")
    debit: Optional[float] = Field(0, title="Debit")
    analytic_plan: str = Field(..., title="Analytic Plan")


class AnalyticAccountItemUpdate(BaseModel):
    active: Optional[bool] = Field(
        True,
        description="Flag indicating whether the analytic account is active.",
        title="Active",
    )
    code: Optional[str] = Field(
        None,
        description="Short code for the analytic account. Often used for internal referencing. May be required to be unique",
        title="Code",
    )
    name: Optional[str] = Field(
        None,
        description="Name or label of the analytic account as it appears in the accounting system.",
        title="Name",
    )
    currency: Optional[str] = Field(
        None,
        description="Indicates the currency of the analytic account (e.g., EUR, USD).",
        title="Currency",
    )


class AnalyticDistributionDetail(BaseModel):
    analytic_account: str = Field(..., title="Analytic Account")
    percentage: float = Field(
        ...,
        description="Percentage of the untaxed amount attributed to this analytic account. Only whole numbers (no decimals) are allowed. The total across the analytic distribution (all accounts in a given analytic plan) must equal 100%.",
        title="Percentage",
    )


class AnalyticPlanItem(BaseModel):
    id: str = Field(
        ...,
        description="Unique id of the analytic plan instance in the accounting system.",
        title="Id",
    )
    name: str = Field(
        ...,
        description="Name of the analytic plan as it appears in the accounting system.",
        title="Name",
    )
    active: Optional[bool] = Field(
        True, description="Indicates if the analytic plan is active.", title="Active"
    )
    parent_id: Optional[str] = Field(
        None,
        description="Id of the parent analytic plan, if any. This is used to create a hierarchy of analytic plans when that is supported.",
        title="Parent Id",
    )


class Api(Enum):
    Point_of_Sale = "Point of Sale"
    eCommerce = "eCommerce"
    Accounting = "Accounting"
    Invoicing = "Invoicing"
    Communication = "Communication"
    Banking = "Banking"
    Custom = "Custom"
    Payment = "Payment"
    Property_Management_System = "Property Management System"


class AttachmentItem(BaseModel):
    base64_string: str = Field(..., title="Base64 String")


class AttachmentItemOut(BaseModel):
    id: str = Field(..., title="Id")
    base64_string: str = Field(..., title="Base64 String")


class AuthItem(BaseModel):
    clientId: str = Field(..., title="Clientid")
    clientSecret: str = Field(..., title="Clientsecret")
    accountId: UUID = Field(..., title="Accountid")
    marketplaceId: Optional[UUID] = Field(None, title="Marketplaceid")


class BankAccountItemIn(BaseModel):
    code: constr(min_length=1) = Field(
        ...,
        description="A userfriendly code to represent the bank account. This will be used as the code of the journal if we need to create a journal for the bank account.",
        title="Code",
    )
    currency: constr(min_length=1) = Field(
        ...,
        description="Currency of the bank account (e.g., EUR, USD).",
        title="Currency",
    )
    account_name: Optional[str] = Field(
        None,
        description="Name of the bank account. Represents this specific bank account in the accounting system.",
        title="Account Name",
    )
    account_number: Optional[str] = Field(
        None,
        description="Unique number representing the bank account. At least one of the fields 'account_number' or 'IBAN' must be filled in.",
        title="Account Number",
    )
    iban: Optional[str] = Field(
        None,
        description="IBAN of the bank account. At least one of the fields 'account_number' or 'IBAN' must be filled in.",
        title="Iban",
    )
    bank_name: str = Field(
        ...,
        description="Name of the bank linked to the bank account.",
        title="Bank Name",
    )


class BankAccountItemOut(BaseModel):
    id: str = Field(..., title="Id")
    code: Optional[str] = Field(
        None,
        description="A userfriendly code to represent the bank account. This will be used as the code of the journal if we need to create a journal for the bank account.",
        title="Code",
    )
    currency: Optional[str] = Field(
        None,
        description="Currency of the bank account (e.g., EUR, USD).",
        title="Currency",
    )
    account_name: Optional[str] = Field(
        None,
        description="Name of the bank account. Represents this specific bank account in the accounting system.",
        title="Account Name",
    )
    account_number: Optional[str] = Field(
        None,
        description="Unique number representing the bank account.",
        title="Account Number",
    )
    iban: Optional[str] = Field(
        None, description="IBAN of the bank account.", title="Iban"
    )
    bank_name: Optional[str] = Field(
        None,
        description="Name of the bank linked to the bank account.",
        title="Bank Name",
    )
    journal_id: Optional[str] = Field(
        None,
        description="Indicates the journal used in the accounting system to represent the bank account. The journal contains all the transactions related to this specific bank account.",
        title="Journal Id",
    )
    ledger_account: Optional[str] = Field(
        None,
        description="Indicates the ledger account used in the accounting system to represent the bank account. The ledger account is used in all the transactions related to this specific bank account. This ledger account is used to track the balance of the bank account.",
        title="Ledger Account",
    )


class BankingAccountItem(BaseModel):
    id: str = Field(
        ...,
        description="Unique identifier of the account",
        examples=["account-123"],
        title="Id",
    )
    currency: str = Field(
        ..., description="Currency of the account", examples=["EUR"], title="Currency"
    )
    current_balance: float = Field(
        ...,
        description="Current balance of the account",
        examples=[1000],
        title="Current Balance",
    )
    current_balance_last_update_date: Optional[DateTime] = Field(
        None,
        description="Last update date of the current balance",
        examples=["2025-01-01T00:00:00Z"],
        title="Current Balance Last Update Date",
    )
    available_balance: float = Field(
        ...,
        description="Available balance of the account",
        examples=[1000],
        title="Available Balance",
    )
    available_balance_last_update_date: Optional[DateTime] = Field(
        None,
        description="Last update date of the available balance",
        examples=["2025-01-01T00:00:00Z"],
        title="Available Balance Last Update Date",
    )
    description: str = Field(
        ...,
        description="Description of the account",
        examples=["Chift account"],
        title="Description",
    )
    reference: str = Field(
        ...,
        description="Reference of the account",
        examples=["FR76300040123456789012345678"],
        title="Reference",
    )
    reference_type: str = Field(
        ...,
        description="Type of the reference",
        examples=["IBAN"],
        title="Reference Type",
    )
    holder_name: Optional[str] = Field(
        None,
        description="Name of the account holder",
        examples=["John Doe"],
        title="Holder Name",
    )


class BankingCounterPartItem(BaseModel):
    name: Optional[str] = Field(
        None, description="Name of the counterpart", examples=["John Doe"], title="Name"
    )
    reference: Optional[str] = Field(
        None,
        description="Reference of the counterpart",
        examples=["FR76300040123456789012345678"],
        title="Reference",
    )
    details: Optional[str] = Field(
        None,
        description="Details of the counterpart",
        examples=["Chift counterpart"],
        title="Details",
    )


class BankingFinancialInstitutionItem(BaseModel):
    id: str = Field(
        ...,
        description="Unique identifier of the financial institution",
        examples=["financial-institution-123"],
        title="Id",
    )
    bic: Optional[str] = Field(
        None,
        description="BIC of the financial institution",
        examples=["GEBABEBBXXX"],
        title="Bic",
    )
    country: Optional[str] = Field(
        None,
        description="Country of the financial institution, format: ISO 3166-1 codes.",
        examples=["FR"],
        title="Country",
    )
    name: str = Field(
        ...,
        description="Name of the financial institution",
        examples=["BNP"],
        title="Name",
    )


class BankingTransactionItem(BaseModel):
    id: str = Field(
        ...,
        description="Unique identifier of the transaction",
        examples=["transaction-123"],
        title="Id",
    )
    amount: float = Field(
        ..., description="Amount of the transaction", examples=[1000], title="Amount"
    )
    currency: str = Field(
        ...,
        description="Currency of the transaction",
        examples=["EUR"],
        title="Currency",
    )
    description: Optional[str] = Field(
        None,
        description="Description of the transaction",
        examples=["Chift transaction"],
        title="Description",
    )
    additional_information: Optional[str] = Field(
        None,
        description="Additional information of the transaction",
        examples=["Chift transaction"],
        title="Additional Information",
    )
    counterpart_name: Optional[str] = Field(
        None,
        description="Name of the counterpart",
        examples=["John Doe"],
        title="Counterpart Name",
    )
    counterpart_reference: Optional[str] = Field(
        None,
        description="Reference of the counterpart",
        examples=["FR76300040123456789012345678"],
        title="Counterpart Reference",
    )
    remittance_information: Optional[str] = Field(
        None,
        description="Remittance information of the transaction",
        examples=["Chift transaction"],
        title="Remittance Information",
    )
    creation_date: DateTime = Field(
        ...,
        description="Creation date of the transaction",
        examples=["2025-01-01T00:00:00Z"],
        title="Creation Date",
    )
    value_date: DateTime = Field(
        ...,
        description="Value date of the transaction",
        examples=["2025-01-01T00:00:00Z"],
        title="Value Date",
    )
    execution_date: DateTime = Field(
        ...,
        description="Execution date of the transaction",
        examples=["2025-01-01T00:00:00Z"],
        title="Execution Date",
    )


class BookYear(BaseModel):
    name: str = Field(
        ...,
        description="Name of the book year, typically in the format 'YYYY'.",
        title="Name",
    )
    start: Date = Field(
        ...,
        description="Start date of the book year (format: YYYY-MM-DD). This is the date when the book year begins.",
        title="Start",
    )
    end: Date = Field(
        ...,
        description="End date of the book year (format: YYYY-MM-DD). This is the date when the book year ends.",
        title="End",
    )
    closed: bool = Field(
        ...,
        description="Indicates whether the book year is closed. A closed book year normally cannot be modified or have new entries added to it.",
        title="Closed",
    )


class BoolParam(Enum):
    true = "true"
    false = "false"


class ChainExecutionItem(BaseModel):
    id: str = Field(..., title="Id")
    start: DateTime = Field(..., title="Start")
    end: Optional[DateTime] = Field(..., title="End")
    status: str = Field(..., title="Status")


class ChiftError(BaseModel):
    message: str = Field(..., title="Message")
    status: Optional[str] = Field("error", title="Status")
    detail: Optional[str] = Field("", title="Detail")


class ChiftPageAccountBalance(BaseModel):
    items: List[AccountBalance] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageAccountingCategoryItem(BaseModel):
    items: List[AccountingCategoryItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageAnalyticAccountItemOutMultiAnalyticPlans(BaseModel):
    items: List[AnalyticAccountItemOutMultiAnalyticPlans] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageAnalyticAccountItemOut(BaseModel):
    items: List[AnalyticAccountItemOut] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageAnalyticPlanItem(BaseModel):
    items: List[AnalyticPlanItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageAttachmentItemOut(BaseModel):
    items: List[AttachmentItemOut] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageBankingAccountItem(BaseModel):
    items: List[BankingAccountItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageBankingCounterPartItem(BaseModel):
    items: List[BankingCounterPartItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageBankingFinancialInstitutionItem(BaseModel):
    items: List[BankingFinancialInstitutionItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageBankingTransactionItem(BaseModel):
    items: List[BankingTransactionItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageBookYear(BaseModel):
    items: List[BookYear] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ClosurePaymentItem(BaseModel):
    payment_method_id: Optional[str] = Field(
        None,
        description="Unique identifier of the payment method used for the payment",
        examples=["payment_method-1"],
        title="Payment Method Id",
    )
    payment_method_name: Optional[str] = Field(
        None,
        description="Chift's name of the payment method used for the payment",
        examples=["Cash"],
        title="Payment Method Name",
    )
    total: float = Field(
        ..., description="Total amount including tax", examples=[11], title="Total"
    )


class ClosureStates(Enum):
    open = "open"
    closed = "closed"


class CommerceLocationItem(BaseModel):
    id: str = Field(
        ..., description="Technical id of the location in Chift", title="Id"
    )
    name: str = Field(..., title="Name")


class CommonAttributeItem(BaseModel):
    name: str = Field(..., title="Name")
    values: List[str] = Field(..., title="Values")


class ConnectionItemInput(BaseModel):
    one_api: Optional[int] = Field(None, title="One Api")
    connection_type: Optional[int] = Field(None, title="Connection Type")
    display_order: Optional[int] = Field(0, title="Display Order")
    display_hidden: Optional[bool] = Field(False, title="Display Hidden")


class ConsumerItem(BaseModel):
    consumerid: UUID = Field(
        ..., description="Unique id of the consumer in Chift", title="Consumerid"
    )
    name: constr(min_length=1) = Field(
        ...,
        description="Name of the consumer as it will appear in your Chift platform. This name may be used for automated communications, such as automatic mailings if you enable this feature",
        title="Name",
    )
    email: Optional[str] = Field(
        None,
        description="Optional - Email address of the consumer. It can be used for sending automated reminders (if the feature is enabled) and deployment by mail of local agent (when on-premise connector).",
        title="Email",
    )
    internal_reference: Optional[str] = Field(
        None,
        description="Your internal reference for the client (e.g., customer ID or unique identifier in your system).",
        title="Internal Reference",
    )
    redirect_url: Optional[str] = Field(
        None,
        description="URL to redirect the user after completing the activation via our link. Useful for directing customers to a dynamic or personalized url. You can also set up a default static URL in Chift's back office for all consumers.",
        title="Redirect Url",
    )


class ContactGender(Enum):
    H = "H"
    F = "F"
    N_A = "N/A"


class ContactType(Enum):
    prospect = "prospect"
    customer = "customer"
    supplier = "supplier"
    all = "all"


class CountryItem(BaseModel):
    code: str = Field(..., description="Country ISO Code", title="Code")
    name: str = Field(..., title="Name")


class CreateConsumerSyncItem(BaseModel):
    syncid: UUID = Field(..., title="Syncid")
    integrationids: Optional[List[str]] = Field(
        [],
        description="[OPTIONAL] Can be used to specify maximum one integrationid for each One API that you want to highlight. If specified, only this connector will be displayed to your clients.",
        title="Integrationids",
    )
    country: Optional[str] = Field(
        None,
        description="ISO 3166-1 alpha-2 country code to filter connectors by country. Ignored if integrationids are provided.",
        title="Country",
    )
    link_metadata: Optional[Dict[str, Any]] = Field(None, title="Link Metadata")


class CredentialItemInput(BaseModel):
    key: str = Field(..., title="Key")
    value: str = Field(..., title="Value")


class CredentialItemOutput(BaseModel):
    name: str = Field(..., title="Name")
    optional: Optional[bool] = Field(False, title="Optional")


class DataItem(BaseModel):
    data: Dict[str, Any] = Field(..., title="Data")


class DataItemOut(BaseModel):
    data: Dict[str, Any] = Field(..., title="Data")
    id: str = Field(..., title="Id")
    created_on: DateTime = Field(..., title="Created On")


class DatastoreColumn(BaseModel):
    name: str = Field(..., title="Name")
    title: str = Field(..., title="Title")
    type: str = Field(..., title="Type")
    optional: Optional[bool] = Field(False, title="Optional")


class DatastoreDef(BaseModel):
    columns: List[DatastoreColumn] = Field(..., title="Columns")
    search_column: Optional[str] = Field(
        None,
        description="Column name that will be indexed and used in search if any.",
        title="Search Column",
    )


class DiscountType(Enum):
    OFFERED = "OFFERED"
    UNKNOWN = "UNKNOWN"
    LOSS = "LOSS"


class DocumentType(Enum):
    invoice = "invoice"
    entry = "entry"


class EmployeeItem(BaseModel):
    id: str = Field(
        ...,
        description="Unique id of the employee in the accounting system.",
        title="Id",
    )
    name: str = Field(
        ...,
        description="Full name or legal name of the employee as it appears in the accounting system.",
        title="Name",
    )
    first_name: Optional[str] = Field(
        None, description="First name of the employee.", title="First Name"
    )
    last_name: Optional[str] = Field(
        None, description="Last name of the employee.", title="Last Name"
    )
    function: Optional[str] = Field(
        None, description="Job title or function of the employee.", title="Function"
    )
    phone: Optional[str] = Field(
        None, description="Phone number of the employee.", title="Phone"
    )
    mobile: Optional[str] = Field(
        None, description="Mobile phone number of the employee.", title="Mobile"
    )
    email: Optional[str] = Field(
        None, description="Email address of the employee.", title="Email"
    )
    active: Optional[bool] = Field(
        True, description="Indicates if the employee is active.", title="Active"
    )
    reference: Optional[str] = Field(
        None,
        description="External reference or identifier for the employee.",
        title="Reference",
    )
    account_number: Optional[str] = Field(
        None,
        description="Ledger account number assigned to the employee in the accounting system as it will appear in the official accounting export file (FEC, SIE, iXBRL, etc.)",
        title="Account Number",
    )


class EnableFlowConsumer(BaseModel):
    integrationids: Optional[List[str]] = Field(
        [],
        description="List of integrationids of the connections that will be used to enable the flow",
        title="Integrationids",
    )
    triggerid: Optional[str] = Field("trigger-1", title="Triggerid")
    cronschedule: Optional[str] = Field(None, title="Cronschedule")
    data: Optional[Dict[str, Any]] = Field(
        {},
        description="Object containing the configuration of the flow for the consumer",
        title="Data",
    )


class EntryLineType(Enum):
    customer_account = "customer_account"
    supplier_account = "supplier_account"
    employee_account = "employee_account"
    general_account = "general_account"


class ErrorInfo(BaseModel):
    error_code: str = Field(..., title="Error Code")
    status: str = Field(..., title="Status")
    title: str = Field(..., title="Title")
    description: Optional[str] = Field(None, title="Description")


class ExecutionType(Enum):
    code = "code"
    module = "module"


class FECItemOut(BaseModel):
    JournalCode: str = Field(..., title="Journalcode")
    JournalLib: str = Field(..., title="Journallib")
    EcritureNum: str = Field(..., title="Ecriturenum")
    EcritureDate: Date = Field(..., title="Ecrituredate")
    CompteNum: str = Field(..., title="Comptenum")
    CompteLib: str = Field(..., title="Comptelib")
    CompAuxNum: str = Field(..., title="Compauxnum")
    CompAuxLib: str = Field(..., title="Compauxlib")
    PieceRef: str = Field(..., title="Pieceref")
    PieceDate: Date = Field(..., title="Piecedate")
    Debit: float = Field(..., title="Debit")
    Credit: float = Field(..., title="Credit")
    EcritureLet: str = Field(..., title="Ecriturelet")
    DateLet: Optional[Date] = Field(..., title="Datelet")
    ValidDate: Optional[Date] = Field(..., title="Validdate")
    Montantdevise: float = Field(..., title="Montantdevise")
    Idevise: str = Field(..., title="Idevise")


class FeesType(Enum):
    shipping = "shipping"
    other = "other"


class FieldItemType(Enum):
    fixed = "fixed"
    api = "api"


class FieldItemValue(BaseModel):
    id: str = Field(..., title="Id")
    label: str = Field(..., title="Label")


class FieldRef(BaseModel):
    id: Optional[str] = Field(
        None, description="Technical id in the target software", title="Id"
    )
    model: Optional[str] = Field(
        None,
        description="Name of the model/entity in the target software",
        title="Model",
    )
    name: Optional[str] = Field(
        None, description="Value the field in the target software", title="Name"
    )


class FinancialEntryLineItem(BaseModel):
    account_type: EntryLineType = Field(
        ...,
        description="account_type can be either general ('general_account') or thirdparty ('customer', 'supplier' or 'employee')",
    )
    account: constr(min_length=1) = Field(
        ...,
        description="Depending on account_type, if the account_type is 'general_account', this is the general ledger account number used to book the journal item against. If the account_type is 'customer_account', 'supplier_account' or 'employee_account', this is the thirdparty_id (id of the customer, supplier or employee in the accounting system).",
        title="Account",
    )
    amount: float = Field(
        ...,
        description="A positive value represents funds received in the bank or cash account (i.e., the bank/cash account is debited and the specified account_number is credited). A negative value represents funds leaving the bank/cash account.",
        title="Amount",
    )
    description: Optional[str] = Field(
        None,
        description="Text description for this line item. This is typically used to provide additional context or information.",
        title="Description",
    )


class FinancialEntryLineItemOut(BaseModel):
    account_type: EntryLineType = Field(
        ...,
        description="account_type can be either general ('general_account') or thirdparty ('customer', 'supplier' or 'employee')",
    )
    account: constr(min_length=1) = Field(
        ...,
        description="Depending on account_type, if the account_type is 'general_account', this is the general ledger account number used to book the journal item against. If the account_type is 'customer_account', 'supplier_account' or 'employee_account', this is the thirdparty_id (id of the customer, supplier or employee in the accounting system).",
        title="Account",
    )
    amount: float = Field(
        ...,
        description="A positive value represents funds received in the bank or cash account (i.e., the bank/cash account is debited and the specified account_number is credited). A negative value represents funds leaving the bank/cash account.",
        title="Amount",
    )
    description: Optional[str] = Field(
        None,
        description="Text description for this line item. This is typically used to provide additional context or information.",
        title="Description",
    )
    counterpart_account: str = Field(..., title="Counterpart Account")


class FlowExecutionChain(BaseModel):
    name: str = Field(..., title="Name")


class FlowExecutionCode(BaseModel):
    code: str = Field(..., title="Code")


class FolderAddressItem(BaseModel):
    street: Optional[str] = Field(None, title="Street")
    number: Optional[str] = Field(None, title="Number")
    box: Optional[str] = Field(None, title="Box")
    postal_code: Optional[str] = Field(None, title="Postal Code")
    city: Optional[str] = Field(None, title="City")
    country: Optional[str] = Field(None, title="Country")


class FolderItem(BaseModel):
    id: str = Field(..., title="Id")
    name: str = Field(..., title="Name")
    selected: Optional[bool] = Field(True, title="Selected")
    vat: Optional[str] = Field(None, title="Vat")
    company_number: Optional[str] = Field(None, title="Company Number")
    main_currency: Optional[str] = Field(None, title="Main Currency")
    addresses: Optional[List[FolderAddressItem]] = Field(None, title="Addresses")


class ImageItem(BaseModel):
    id: str = Field(
        ..., description="Technical id of the image in the target software", title="Id"
    )
    main_image: bool = Field(..., title="Main Image")
    url: str = Field(..., title="Url")


class ImageType(Enum):
    icon = "icon"
    logo = "logo"


class InventoryDetailsItem(BaseModel):
    location: CommerceLocationItem
    available_quantity: float = Field(..., title="Available Quantity")


class InventoryDetailsUpdate(BaseModel):
    location_id: str = Field(
        ..., description="Technical id of the location in Chift", title="Location Id"
    )
    available_quantity: confloat(ge=0.0) = Field(..., title="Available Quantity")


class InvoiceCorrection(BaseModel):
    sale_invoice_correction_tax_code: Optional[str] = Field(
        None,
        description="Tax code to apply on the correction line when the invoice is a sale (customer invoice). Required only when invoice_correction is used for a sale invoice or refund.",
        title="Sale Invoice Correction Tax Code",
    )
    purchase_invoice_correction_tax_code: Optional[str] = Field(
        None,
        description="Tax code to apply on the correction line when the invoice is a purchase (supplier invoice). Required only when invoice_correction is used for a purchase invoice or refund.",
        title="Purchase Invoice Correction Tax Code",
    )
    invoice_correction_credit_account_number: Optional[str] = Field(
        None,
        description="Account number to use for the correction line on a sale (customer invoice).",
        title="Invoice Correction Credit Account Number",
    )
    invoice_correction_debit_account_number: Optional[str] = Field(
        None,
        description="Account number to use for the correction line on a purchase (supplier invoice).",
        title="Invoice Correction Debit Account Number",
    )


class InvoiceItemDueDatesOut(BaseModel):
    due_date: Date = Field(..., description="Due date of the item.", title="Due Date")
    payment_method: Optional[str] = Field(
        None,
        description="Payment method used to pay the invoice on that due date.",
        title="Payment Method",
    )
    amount: float = Field(
        ...,
        description="Amount due for the invoice on that due date. A positive amount represents debit on customer invoices and supplier refunds or credit on supplier invoices and customer refunds. A negative amount represents credit on customer invoices and supplier refunds or debit on supplier invoices and customer refunds.",
        title="Amount",
    )


class InvoiceLineItem(BaseModel):
    description: Optional[str] = Field(
        None, description="Line description", title="Description"
    )
    unit_price: float = Field(
        ..., description="Unit price excl. taxes", title="Unit Price"
    )
    quantity: float = Field(..., description="Quantity", title="Quantity")
    discount_amount: Optional[float] = Field(
        0.0,
        description="Line discount amount excl. taxes, (unit_price * quantity) - discount_amount = untaxed_amount",
        title="Discount Amount",
    )
    tax_amount: float = Field(
        ..., description="Line total taxes amount", title="Tax Amount"
    )
    untaxed_amount: float = Field(
        ..., description="Line total untaxed amount", title="Untaxed Amount"
    )
    total: float = Field(
        ...,
        description="Line total amount incl. taxes, total = tax_amount + untaxed_amount",
        title="Total",
    )
    tax_rate: Optional[float] = Field(
        None, description="Tax rate (e.g. 21.0)", title="Tax Rate"
    )
    account_number: Optional[str] = Field(
        None,
        description="Number of the accounting account used (e.g. 701000)",
        title="Account Number",
    )
    tax_id: Optional[str] = Field(
        None, description="Technical id of the tax in Chift", title="Tax Id"
    )
    tax_exemption_reason: Optional[str] = Field(
        None, description="Tax exemption reason", title="Tax Exemption Reason"
    )
    unit_of_measure: Optional[str] = Field(
        None,
        description="Unit of measure matching target sofware name",
        title="Unit Of Measure",
    )
    product_id: Optional[str] = Field(
        None, description="Technical id of the product in Chift", title="Product Id"
    )
    product_code: Optional[str] = Field(
        None, description="Product reference", title="Product Code"
    )
    product_name: Optional[str] = Field(
        None, description="Product name", title="Product Name"
    )


class InvoiceLineItemInMonoAnalyticPlan(BaseModel):
    line_number: Optional[int] = Field(
        1,
        description="Optional line sequence number used to preserve the order of invoice items.",
        title="Line Number",
    )
    unit_price: float = Field(
        ..., description="Unit price of the item, before tax.", title="Unit Price"
    )
    unit_of_measure: Optional[str] = Field(
        None,
        description="A list of default units can be used for which an advanced mapping has been done (units: 'hour', 'day', 'cm', 'm2', 'm3', 'm', 'km', 'mile', 'g', 'kg', 'ton', 'box', 'pallet', 'roll', 'liter', 'unit'). Custom units of measure must have an identical name in the target software.",
        title="Unit Of Measure",
    )
    quantity: float = Field(
        ...,
        description="Quantity of items. This is the amount of units sold or purchased.",
        title="Quantity",
    )
    untaxed_amount: float = Field(
        ...,
        description="Amount excluding tax for the line item (i.e., unit_price × quantity).",
        title="Untaxed Amount",
    )
    tax_rate: float = Field(
        ..., description="Tax rate used for the line (e.g., 21.0).", title="Tax Rate"
    )
    tax_amount: float = Field(
        ...,
        description="Tax amount calculated for the line (i.e. untaxed_amount * tax_rate).",
        title="Tax Amount",
    )
    total: float = Field(
        ...,
        description="Total amount for the item, including tax (untaxed_amount + tax_amount).",
        title="Total",
    )
    account_number: constr(min_length=1) = Field(
        ...,
        description="Ledger account number (of type general) used for the line (e.g., 701000).",
        title="Account Number",
    )
    tax_code: constr(min_length=1) = Field(
        ...,
        description="Indicates the tax code used for the line. This is the Id of the Tax Code in the accounting software.",
        title="Tax Code",
    )
    description: Optional[str] = Field(
        "", description="Text description for this line item.", title="Description"
    )
    analytic_account: Optional[str] = Field(
        None,
        description="Analytic account in the default analytic plan.",
        title="Analytic Account",
    )


class InvoiceLineItemOutMonoAnalyticPlan(BaseModel):
    line_number: Optional[int] = Field(
        1,
        description="Optional line sequence number used to preserve the order of invoice items.",
        title="Line Number",
    )
    unit_price: float = Field(
        ..., description="Unit price of the item, before tax.", title="Unit Price"
    )
    unit_of_measure: Optional[str] = Field(
        None,
        description="A list of default units can be used for which an advanced mapping has been done (units: 'hour', 'day', 'cm', 'm2', 'm3', 'm', 'km', 'mile', 'g', 'kg', 'ton', 'box', 'pallet', 'roll', 'liter', 'unit'). Custom units of measure must have an identical name in the target software.",
        title="Unit Of Measure",
    )
    quantity: float = Field(
        ...,
        description="Quantity of items. This is the amount of units sold or purchased.",
        title="Quantity",
    )
    untaxed_amount: float = Field(
        ...,
        description="Amount excluding tax for the line item (i.e., unit_price × quantity).",
        title="Untaxed Amount",
    )
    tax_rate: float = Field(
        ..., description="Tax rate used for the line (e.g., 21.0).", title="Tax Rate"
    )
    tax_amount: float = Field(
        ...,
        description="Tax amount calculated for the line (i.e. untaxed_amount * tax_rate).",
        title="Tax Amount",
    )
    total: float = Field(
        ...,
        description="Total amount for the item, including tax (untaxed_amount + tax_amount).",
        title="Total",
    )
    account_number: Optional[str] = Field(
        None,
        description="Ledger account number (of type general) used for the line (e.g., 701000).",
        title="Account Number",
    )
    tax_code: Optional[str] = Field(
        None,
        description="Indicates the tax code used for the line. This is the Id of the Tax Code in the accounting software.",
        title="Tax Code",
    )
    description: Optional[str] = Field(
        "", description="Text description for this line.", title="Description"
    )
    analytic_account: Optional[str] = Field(
        None,
        description="Analytic account in the default analytic plan.",
        title="Analytic Account",
    )


class InvoiceStatus(Enum):
    cancelled = "cancelled"
    draft = "draft"
    posted = "posted"
    paid = "paid"


class InvoiceStatusIn(Enum):
    draft = "draft"
    posted = "posted"


class InvoiceStatusOut(Enum):
    cancelled = "cancelled"
    draft = "draft"
    posted = "posted"
    paid = "paid"


class IssueEvent(BaseModel):
    id: str = Field(..., title="Id")
    execution_id: str = Field(..., title="Execution Id")
    created_on: DateTime = Field(..., title="Created On")
    context: Optional[Dict[str, Any]] = Field(None, title="Context")
    message: Optional[str] = Field(None, title="Message")


class IssueLevel(Enum):
    error = "error"
    warning = "warning"


class IssueStatus(Enum):
    open = "open"
    closed = "closed"
    all = "all"


class JournalInType(Enum):
    customer_invoice = "customer_invoice"
    customer_refund = "customer_refund"
    supplier_invoice = "supplier_invoice"
    supplier_refund = "supplier_refund"
    bank = "bank"
    cash = "cash"
    miscellaneous_operation = "miscellaneous_operation"


class JournalItemDueDatesOut(BaseModel):
    due_date: Date = Field(..., description="Due date of the item.", title="Due Date")
    payment_method: Optional[str] = Field(
        None,
        description="Payment method used to pay the entry on that due date.",
        title="Payment Method",
    )
    debit: Optional[float] = Field(
        0, description="Debit of the item on this due date.", title="Debit"
    )
    credit: Optional[float] = Field(
        0, description="Credit of the item on this due date.", title="Credit"
    )


class JournalItemMonoAnalyticPlan(BaseModel):
    account_number: constr(min_length=1) = Field(
        ...,
        description="Depending on account_type, if the account_type is 'general_account', this is the general ledger account number used to book the journal item against. If the account_type is 'customer_account', 'supplier_account' or 'employee_account', this is the thirdparty_id (id of the customer, supplier or employee in the accounting system).",
        title="Account Number",
    )
    partner_id: Optional[str] = Field(
        None,
        description="Id of the thirdparty (customer, supplier or employee) in the accounting system if the journal item relates to a thirdparty (e.g., an invoice).",
        title="Partner Id",
    )
    description: Optional[str] = Field(
        None,
        description="Text description for this journal item. This is typically used to provide additional context or information.",
        title="Description",
    )
    debit: float = Field(
        ...,
        description="Amount to debit on the account. Must be 0 if credit field is not 0",
        title="Debit",
    )
    credit: float = Field(
        ...,
        description="Amount to credit on the account. Must be 0 if debit field is not 0",
        title="Credit",
    )
    currency: constr(min_length=1) = Field(
        ...,
        description="Currency code (e.g., USD, EUR) used for the journal item amounts.",
        title="Currency",
    )
    currency_exchange_rate: Optional[float] = Field(
        1,
        description="Exchange rate applicable at the date of the journal item. Required when currency is different from the folder's default currency.",
        title="Currency Exchange Rate",
    )
    id: str = Field(
        ...,
        description="Unique id of the journal item instance in the accounting system.",
        title="Id",
    )
    partner_name: Optional[str] = Field(
        None,
        description="Name of the thirdparty (customer, supplier or employee) linked to the journal item if journal item relates to a thirdparty (e.g., an invoice).",
        title="Partner Name",
    )
    account_name: str = Field(
        ...,
        description="Name or label of the ledger account used to book the journal item against.",
        title="Account Name",
    )
    matching_numbers: Optional[List[str]] = Field(
        [],
        description="List of matching numbers used to link this journal item to other entries in the accounting system. This is used for reconciliation/lettering purposes.",
        title="Matching Numbers",
    )
    analytic_account: Optional[str] = Field(
        None,
        description="Analytic account in the default analytic plan.",
        title="Analytic Account",
    )
    analytic_account_name: Optional[str] = Field(
        None,
        description="Name of the analytic account in the default analytic plan.",
        title="Analytic Account Name",
    )


class JournalType(Enum):
    customer_invoice = "customer_invoice"
    customer_refund = "customer_refund"
    supplier_invoice = "supplier_invoice"
    supplier_refund = "supplier_refund"
    financial_operation = "financial_operation"
    miscellaneous_operation = "miscellaneous_operation"
    unknown = "unknown"


class LedgerAccountItemIn(BaseModel):
    name: constr(min_length=1) = Field(
        ...,
        description="Name or label of the ledger account as it appears in the accounting system.",
        title="Name",
    )
    number: constr(min_length=3) = Field(
        ...,
        description="The account number in the chart of accounts. Must be unique within the accounting folder. In some countries (e.g., France, Belgium, Spain), the number structure is constrained by local accounting rules and must follow official charts of accounts (e.g., Plan Comptable Général).",
        title="Number",
    )


class LinkItem(BaseModel):
    url: str = Field(..., title="Url")


class LinkSyncItem(BaseModel):
    url: str = Field(..., title="Url")


class LocalAgentStatus(Enum):
    up = "up"
    down = "down"


class LogoImage(BaseModel):
    integrationid: int = Field(..., title="Integrationid")
    data: str = Field(..., title="Data")


class MatchingIn(BaseModel):
    entries: List[str] = Field(
        ...,
        description="List of entries to match. Must contain at least 2 entries. Entries are typically journal entry id, invoice id or financial entry id.",
        min_length=2,
        title="Entries",
    )
    partner_id: str = Field(
        ...,
        description="Id of the thirdparty (customer, supplier or employee) in the accounting system . All entries are must be linked to one same partner.",
        title="Partner Id",
    )


class MatchingOut(BaseModel):
    matching_number: str = Field(
        ...,
        description="Unique 'number' of the matching operation in the accounting system.",
        title="Matching Number",
    )
    balance: float = Field(
        ...,
        description="Balance of the matching operation. This is the sum of all entries in the matching operation. It should be zero if the matching is complete.",
        title="Balance",
    )


class MiscellaneousOperationLineType(Enum):
    customer_account = "customer_account"
    supplier_account = "supplier_account"
    general_account = "general_account"


class MiscellaneousOperationStatusIn(Enum):
    draft = "draft"
    posted = "posted"


class MiscellaneousOperationStatusOut(Enum):
    cancelled = "cancelled"
    draft = "draft"
    posted = "posted"
    matched = "matched"


class MultipleMatchingIn(BaseModel):
    matchings: List[MatchingIn] = Field(..., title="Matchings")


class MultipleMatchingOut(BaseModel):
    matching_number: Optional[str] = Field(None, title="Matching Number")
    processed: bool = Field(..., title="Processed")
    error_msg: Optional[Dict[str, Any]] = Field(None, title="Error Msg")


class NextDocumentNumber(BaseModel):
    bookyear_name: Optional[str] = Field(None, title="Bookyear Name")
    next_document_number: Optional[str] = Field(None, title="Next Document Number")
    start_date: Optional[Date] = Field(None, title="Start Date")
    end_date: Optional[Date] = Field(None, title="End Date")


class ObjectivesItem(BaseModel):
    total: float = Field(
        ...,
        description="Total amount including tax of the sales",
        examples=[10],
        title="Total",
    )
    tax_amount: float = Field(
        ..., description="Total amount of the taxes", examples=[1], title="Tax Amount"
    )
    date: Date = Field(
        ..., description="Date of the objective", examples=["2025-01-01"], title="Date"
    )


class OpportunityStatus(Enum):
    open = "open"
    won = "won"
    lost = "lost"
    cancelled = "cancelled"
    closed = "closed"


class OrderCustomerItem(BaseModel):
    first_name: Optional[str] = Field(None, title="First Name")
    last_name: Optional[str] = Field(None, title="Last Name")
    phone: Optional[str] = Field(None, title="Phone")
    internal_notes: Optional[str] = Field(None, title="Internal Notes")
    email: str = Field(..., title="Email")


class OrderCustomerItemOut(BaseModel):
    first_name: Optional[str] = Field(None, title="First Name")
    last_name: Optional[str] = Field(None, title="Last Name")
    phone: Optional[str] = Field(None, title="Phone")
    internal_notes: Optional[str] = Field(None, title="Internal Notes")
    email: Optional[str] = Field(None, title="Email")
    id: str = Field(
        ..., description="Technical id of the customer in Chift", title="Id"
    )


class OrderLineItemIn(BaseModel):
    variant_id: str = Field(
        ...,
        description="Technical id of the product variant in Chift",
        title="Variant Id",
    )
    quantity: int = Field(..., title="Quantity")
    tax_rate: float = Field(
        ...,
        description="Indicates the tax rate used for the line (e.g. 21.0).",
        title="Tax Rate",
    )
    unit_price: float = Field(
        ..., description="Unit price of the product without taxes.", title="Unit Price"
    )


class OrderPaymentMethods(BaseModel):
    id: str = Field(
        ...,
        description="Technical id of the payment method in the eCommerce",
        title="Id",
    )
    name: Optional[str] = Field(
        None, description="Name of the payment method", title="Name"
    )


class OrderStatus(Enum):
    cancelled_unpaid = "cancelled_unpaid"
    cancelled = "cancelled"
    draft = "draft"
    confirmed = "confirmed"
    shipped = "shipped"
    refunded = "refunded"


class OriginalOutstandingItem(BaseModel):
    id: Optional[str] = Field(
        None,
        description="Unique id of the original outstanding item in the accounting system.",
        title="Id",
    )
    number: Optional[str] = Field(
        None, description="Number of the original outstanding item.", title="Number"
    )
    journal_id: Optional[str] = Field(
        None,
        description="Id of the journal associated with the original outstanding item.",
        title="Journal Id",
    )
    journal_type: Optional[JournalType] = Field(
        None,
        description="Type of the journal associated with the original outstanding item.",
    )
    date: Optional[Date] = Field(
        None, description="Date of the original outstanding item.", title="Date"
    )
    due_date: Optional[Date] = Field(
        None, description="Due date of the original outstanding item.", title="Due Date"
    )
    reference: Optional[str] = Field(
        None,
        description="Reference of the original outstanding item.",
        title="Reference",
    )


class OutstandingItem(BaseModel):
    id: str = Field(
        ...,
        description="Unique id of the outstanding item instance in the accounting system.",
        title="Id",
    )
    number: Optional[str] = Field(
        None,
        description="Invoice, Journal entry or Financial entry number of the outstanding item.",
        title="Number",
    )
    journal_id: str = Field(
        ...,
        description="Id of the journal instance associated with the outstanding item.",
        title="Journal Id",
    )
    journal_type: JournalType = Field(
        ...,
        description="Type of the journal associated with the outstanding item. This indicates the type of journal in which the outstanding item is recorded, such as 'sales', 'purchases', 'bank', etc. It helps in categorizing the outstanding item based on the nature of the transaction.",
    )
    date: Date = Field(
        ..., description="Accounting date of the outstanding item.", title="Date"
    )
    due_date: Optional[Date] = Field(
        None, description="Due date of the outstanding item.", title="Due Date"
    )
    currency: str = Field(
        ...,
        description="Currency of the outstanding item (e.g., EUR, USD).",
        title="Currency",
    )
    currency_exchange_rate: float = Field(
        ...,
        description="Exchange rate applicable at the date of the outstanding item if currency different from folder's default currency.",
        title="Currency Exchange Rate",
    )
    amount: float = Field(..., description="Total amount", title="Amount")
    open_amount: float = Field(..., description="Open amount.", title="Open Amount")
    partner_id: str = Field(
        ...,
        description="Id of the thirdparty (customer, supplier or employee) in the accounting system linked to the outstanding item. This is used to identify the entity associated with the outstanding item.",
        title="Partner Id",
    )
    account_number: str = Field(
        ...,
        description="Account number in the chart of accounts associated with the outstanding item. This is typically used to book the outstanding item against a specific ledger account.",
        title="Account Number",
    )
    reference: Optional[str] = Field(
        None,
        description="Reference of the outstanding item. This is an optional field that can be used to store additional information or context related to the outstanding item, such as an invoice number or a transaction reference.",
        title="Reference",
    )
    matching_numbers: Optional[List[str]] = Field(
        [],
        description="List of matching numbers associated with the outstanding item. This is used to track any matching operations that have been performed on the outstanding item, such as payments or adjustments.",
        title="Matching Numbers",
    )
    payment_communication: Optional[str] = Field(
        None,
        description="Payment communication associated with the outstanding item. This is an optional field that can be used to store additional information related to the payment",
        title="Payment Communication",
    )
    posted: bool = Field(
        ...,
        description="Indicates if the outstanding item has been posted (finalized) in the accounting system. If not provided, it defaults to True.",
        title="Posted",
    )
    original_document: Optional[OriginalOutstandingItem] = Field(
        None,
        description="Details of the original document associated with the outstanding item. This is used to link the outstanding item to its original source when oustanding item was initially posted in previous bookyear.",
    )


class OutstandingType(Enum):
    client = "client"
    supplier = "supplier"


class PMSLocationItem(BaseModel):
    id: str = Field(
        ...,
        description="Unique identifier of the location",
        examples=["371ca583-d218-4900-b236-397532cf0e52"],
        title="Id",
    )
    name: str = Field(
        ...,
        description="Name given to the location",
        examples=["Restaurant de la Paix"],
        title="Name",
    )
    timezone: Optional[str] = Field(
        None,
        description="Indicates the timezone of the location. TZ notation, e.g. Europe/Brussels .",
        examples=["Europe/Paris"],
        title="Timezone",
    )
    address: Optional[AddressItem] = Field(None, description="Address of the location")


class PMSStates(Enum):
    consumed = "consumed"
    closed = "closed"


class POSCustomerItem(BaseModel):
    id: str = Field(
        ...,
        description="Unique identifier of the customer",
        examples=["371ca583-d218-8000-b236-397532cf0e52"],
        title="Id",
    )
    first_name: Optional[str] = Field(
        None,
        description="First name of the customer",
        examples=["John"],
        title="First Name",
    )
    last_name: Optional[str] = Field(
        None,
        description="Last name of the customer",
        examples=["Doe"],
        title="Last Name",
    )
    name: str = Field(
        ...,
        description="Name (first name + last name) of the customer",
        examples=["John Doe"],
        title="Name",
    )
    phone: Optional[str] = Field(
        None,
        description="Phone number (mobile, home, work, ...) of the customer",
        examples=["+32475123456"],
        title="Phone",
    )
    email: Optional[str] = Field(
        None,
        description="Email address of the customer",
        examples=["john.doe@gmail.com"],
        title="Email",
    )
    created_on: Optional[DateTime] = Field(
        None,
        description="Date and time when the customer was created",
        examples=["2025-01-01T00:00:00Z"],
        title="Created On",
    )
    addresses: Optional[List[AddressItem]] = Field(
        [], description="List of addresses of the customer", title="Addresses"
    )
    loyalty: Optional[int] = Field(
        None,
        description="Loyalty points of the customer",
        examples=[100],
        title="Loyalty",
    )
    birthdate: Optional[Date] = Field(
        None,
        description="Birthdate of the customer",
        examples=["1990-01-01"],
        title="Birthdate",
    )


class POSLineItemType(Enum):
    menu = "menu"
    product = "product"
    service = "service"
    general_discount = "general_discount"


class POSLocationItem(BaseModel):
    id: str = Field(
        ...,
        description="Unique identifier of the location",
        examples=["371ca583-d218-4900-b236-397532cf0e52"],
        title="Id",
    )
    name: str = Field(
        ...,
        description="Name given to the location",
        examples=["Restaurant de la Paix"],
        title="Name",
    )
    timezone: Optional[str] = Field(
        None,
        description="Indicates the timezone of the location. TZ notation, e.g. Europe/Brussels .",
        examples=["Europe/Paris"],
        title="Timezone",
    )
    address: Optional[AddressItem] = Field(None, description="Address of the location")


class PartnerType(Enum):
    owner = "owner"
    account = "account"


class PatchConnectionItem(BaseModel):
    redirect: Optional[bool] = Field(
        False,
        description="Indicates whether you want to return to the consumer's redirectUrl after update (true) or whether you want to return on the connection page (false)",
        title="Redirect",
    )
    name: Optional[str] = Field(
        None,
        description="Can be used to update the name of an existing connection",
        title="Name",
    )
    credentials: Optional[List[CredentialItemInput]] = Field(
        None,
        description="Can be used to update the credentials of an existing connection. Please use the getIntegrations route to see the available credentials for each integration",
        title="Credentials",
    )


class Payment(BaseModel):
    id: str = Field(..., title="Id")
    name: str = Field(..., title="Name")
    currency: str = Field(..., title="Currency")
    amount: float = Field(
        ...,
        description="Total amount of the payment. A part of this amount could be reconciled with another invoice.",
        title="Amount",
    )
    dedicated_amount: Optional[float] = Field(
        0,
        description="Amount of the payment dedicated to the invoice. ",
        title="Dedicated Amount",
    )
    payment_date: Date = Field(..., title="Payment Date")
    journal_type: JournalType
    journal_id: str = Field(..., title="Journal Id")
    journal_name: str = Field(..., title="Journal Name")
    reconciled: Optional[bool] = Field(False, title="Reconciled")
    communication: Optional[str] = Field(None, title="Communication")
    matching_number: Optional[str] = Field(None, title="Matching Number")


class PaymentMethods(BaseModel):
    id: str = Field(
        ...,
        description="Unique identifier of the payment method",
        examples=["371ca583-d218-4900-b236-397532cf0e52"],
        title="Id",
    )
    name: str = Field(
        ...,
        description="Chift's name of the payment method (e.g. 'Cash', 'Card', 'Transfer', ...)",
        examples=["Cash"],
        title="Name",
    )
    extra: Optional[str] = Field(
        None,
        description="Original name of the payment method",
        examples=["Espèces"],
        title="Extra",
    )


class PaymentReportingConditions(Enum):
    TP01 = "TP01"
    TP02 = "TP02"
    TP03 = "TP03"


class PaymentReportingMethod(Enum):
    MP01 = "MP01"
    MP02 = "MP02"
    MP03 = "MP03"
    MP04 = "MP04"
    MP05 = "MP05"
    MP06 = "MP06"
    MP07 = "MP07"
    MP08 = "MP08"
    MP09 = "MP09"
    MP10 = "MP10"
    MP11 = "MP11"
    MP12 = "MP12"
    MP13 = "MP13"
    MP14 = "MP14"
    MP15 = "MP15"
    MP16 = "MP16"
    MP17 = "MP17"
    MP18 = "MP18"
    MP19 = "MP19"
    MP20 = "MP20"
    MP21 = "MP21"
    MP22 = "MP22"
    MP23 = "MP23"


class PaymentStatusInput(Enum):
    all = "all"
    unpaid = "unpaid"
    paid = "paid"


class PaymentTermAccountInfo(BaseModel):
    amount: float = Field(
        ..., description="Amount to be paid to the G or N account", title="Amount"
    )
    iban: str = Field(..., description="IBAN of the G or R account", title="Iban")


class PostAddressItem(BaseModel):
    name: constr(min_length=1) = Field(
        ...,
        description="Name given to the address (e.g. 'home')",
        examples=["home"],
        title="Name",
    )
    street: Optional[str] = Field(
        None,
        description="Street name",
        examples=["Avenue de la République"],
        title="Street",
    )
    number: Optional[str] = Field(
        None, description="Number of the address", examples=["123"], title="Number"
    )
    box: Optional[str] = Field(
        None, description="Box of the address", examples=["A"], title="Box"
    )
    city: constr(min_length=1) = Field(
        ..., description="City name", examples=["Paris"], title="City"
    )
    postal_code: constr(min_length=1) = Field(
        ...,
        description="Postal code of the address",
        examples=["75000"],
        title="Postal Code",
    )
    country: Optional[str] = Field(
        None,
        description="Country, format: ISO 3166-1 codes.",
        examples=["FR"],
        title="Country",
    )


class PostConnectionItemInput(BaseModel):
    integrationid: Optional[int] = Field(
        None,
        description="Can be used to specify the integration code of a specific connector. If specified, the url will will point directly to the connection page of the connector and will redirect on save to the redirect url of the consumer if specified.",
        title="Integrationid",
    )
    name: Optional[str] = Field(
        None,
        description="Can be used to specify the name of the connection. Must be used in combination with an integrationid.",
        title="Name",
    )
    credentials: Optional[List[CredentialItemInput]] = Field(
        None,
        description="Can be used to specify the credentials of your connection. Must be used in combination with an integrationid and a name. Please use the getIntegrations route to see the available credentials for each integration",
        title="Credentials",
    )
    country: Optional[str] = Field(
        None,
        description="ISO 3166-1 alpha-2 country code to filter connectors by country. Ignored if integrationid is provided.",
        title="Country",
    )


class PostConnectionItemOutput(BaseModel):
    id: str = Field(..., title="Id")
    title: str = Field(..., title="Title")
    optional: bool = Field(..., title="Optional")
    resource: str = Field(..., title="Resource")


class PostConsumerItem(BaseModel):
    name: constr(min_length=1, max_length=255) = Field(
        ...,
        description="Name of the consumer as it will appear in your Chift platform. This name may be used for automated communications, such as automatic mailings if you enable this feature.",
        title="Name",
    )
    email: Optional[constr(max_length=80)] = Field(
        None,
        description="Optional - Email address of the consumer. It can be used for sending automated reminders (if feature enabled) and deployment by mail of local agent (when on-premise connector).",
        title="Email",
    )
    internal_reference: Optional[constr(max_length=255)] = Field(
        None,
        description="Your internal reference for the client (e.g., customer ID or unique identifier in your system).",
        title="Internal Reference",
    )
    redirect_url: Optional[constr(max_length=255)] = Field(
        None,
        description="URL to redirect the user after completing the activation via our link. Useful for directing customers to a dynamic or personalized url. You can also set up a default static URL in Chift's back office for all consumers.",
        title="Redirect Url",
    )


class PostSyncFlowEvent(BaseModel):
    consumers: Optional[List[UUID]] = Field([], title="Consumers")
    data: Optional[Dict[str, Any]] = Field({}, title="Data")


class ProductCostItem(BaseModel):
    amount: float = Field(..., title="Amount")
    currency: str = Field(..., title="Currency")


class ProductItemInput(BaseModel):
    name: str = Field(..., description="Name", title="Name")
    unit_price: Optional[float] = Field(
        None, description="Unit price", title="Unit Price"
    )
    tax_id: Optional[str] = Field(
        None, description="Technical id of the tax in Chift", title="Tax Id"
    )
    code: Optional[str] = Field(None, description="Reference/code", title="Code")
    unit: Optional[str] = Field(
        None, description="Unit of measure matching target software name", title="Unit"
    )
    category: Optional[str] = Field(
        None, description="Category matching target software name", title="Category"
    )
    currency: Optional[str] = Field(
        None, description="Currency matching target software name", title="Currency"
    )
    description: Optional[str] = Field(
        None, description="Description", title="Description"
    )
    cost: Optional[float] = Field(0, description="Cost of the product", title="Cost")


class ProductStatus(Enum):
    unknown = "unknown"
    archived = "archived"
    unpublished = "unpublished"
    published = "published"


class ReadMappingItem(BaseModel):
    source_id: Optional[str] = Field(None, title="Source Id")
    target_id: Optional[str] = Field(None, title="Target Id")


class ReadSyncMappingItem(BaseModel):
    name: str = Field(..., title="Name")
    description: Optional[str] = Field(None, title="Description")
    display_order: Optional[int] = Field(0, title="Display Order")
    challenge_question: Optional[str] = Field(None, title="Challenge Question")
    values: List[ReadMappingItem] = Field(..., title="Values")
    sub_mapping_name: str = Field(..., title="Sub Mapping Name")
    sub_mapping_description: Optional[str] = Field(
        None, title="Sub Mapping Description"
    )


class Ref(BaseModel):
    id: Optional[str] = Field(
        None, description="Technical id in the target software", title="Id"
    )
    model: Optional[str] = Field(
        None,
        description="Name of the model/entity in the target software",
        title="Model",
    )


class RefundFeesItem(BaseModel):
    id: str = Field(..., description="Technical id of the fee in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    type: FeesType
    untaxed_amount: float = Field(..., title="Untaxed Amount")
    tax_amount: float = Field(..., title="Tax Amount")
    total: float = Field(..., title="Total")


class ReturnFeesItem(BaseModel):
    id: str = Field(..., description="Technical id of the fee in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    type: FeesType
    untaxed_amount: float = Field(..., title="Untaxed Amount")
    tax_amount: float = Field(..., title="Tax Amount")
    total: float = Field(..., title="Total")


class ShippingRefund(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    untaxed_amount: float = Field(
        ...,
        description="Untaxed amount refunded (after discount).",
        title="Untaxed Amount",
    )
    tax_amount: float = Field(
        ..., description="Total taxes refunded (after discount).", title="Tax Amount"
    )
    total: float = Field(
        ..., description="Total refunded (after discount).", title="Total"
    )


class States(Enum):
    open = "open"
    closed = "closed"
    all = "all"


class Status(Enum):
    active = "active"
    inactive = "inactive"


class SyncConsumerStatus(Enum):
    active = "active"
    inactive = "inactive"


class TaxRateItem(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    label: str = Field(..., title="Label")
    rate: float = Field(..., title="Rate")
    country: Optional[str] = Field(None, title="Country")


class Token(BaseModel):
    access_token: str = Field(..., title="Access Token")
    token_type: str = Field(..., title="Token Type")
    expires_in: int = Field(..., title="Expires In")
    expires_on: int = Field(..., title="Expires On")


class TotalTaxItem(BaseModel):
    tax_rate: float = Field(
        ..., description="Tax rate", examples=["10"], title="Tax Rate"
    )
    tax_amount: float = Field(
        ..., description="Tax amount", examples=["1"], title="Tax Amount"
    )
    total: float = Field(
        ..., description="Total amount including tax", examples=["11"], title="Total"
    )


class TransactionAccountingCategory(Enum):
    all = "all"
    unknown = "unknown"
    payout = "payout"
    payout_cancel = "payout_cancel"
    payment = "payment"
    payment_cancel = "payment_cancel"
    fee = "fee"
    fee_cancel = "fee_cancel"
    invoice = "invoice"
    internal_move = "internal_move"


class TransactionFilterDateType(Enum):
    value_date = "value_date"
    execution_date = "execution_date"


class TransactionItemOut(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    amount: float = Field(..., description="Total amount incl. fee", title="Amount")
    fee: float = Field(..., description="Total fee", title="Fee")
    currency: str = Field(..., description="Currency", title="Currency")
    exchange_rate: float = Field(
        ..., description="Exchange rate", title="Exchange Rate"
    )
    create_date: DateTime = Field(..., description="Create Date", title="Create Date")
    application_type: str = Field(
        ...,
        description="Type of the transaction as recorded in the target software",
        title="Application Type",
    )
    accounting_category: TransactionAccountingCategory = Field(
        ..., description="Accounting category"
    )
    refund_id: Optional[str] = Field(None, title="Refund Id")
    payment_id: Optional[str] = Field(None, title="Payment Id")


class TransactionStatus(Enum):
    failed = "failed"
    pending = "pending"
    success = "success"


class TriggerResponse(BaseModel):
    status: str = Field(..., title="Status")
    message: str = Field(..., title="Message")
    data: Optional[Dict[str, Any]] = Field(None, title="Data")


class TriggerType(Enum):
    timer = "timer"
    event = "event"


class UpdateConsumerItem(BaseModel):
    name: Optional[constr(max_length=255)] = Field(
        None,
        description="Name of the consumer as it will appear in your Chift platform. This name may be used for automated communications, such as automatic mailings if you enable this feature.",
        title="Name",
    )
    email: Optional[constr(max_length=80)] = Field(
        None,
        description="Optional - Email address of the consumer. It can be used for sending automated reminders (if feature enabled) and deployment by mail of local agent (when on-premise connector).",
        title="Email",
    )
    internal_reference: Optional[constr(max_length=255)] = Field(
        None,
        description="Your internal reference for the client (e.g., customer ID or unique identifier in your system).",
        title="Internal Reference",
    )
    redirect_url: Optional[constr(max_length=255)] = Field(
        None,
        description="URL to redirect the user after completing the activation via our link. Useful for directing customers to a dynamic or personalized url. You can also set up a default static URL in Chift's back office for all consumers.",
        title="Redirect Url",
    )


class UpdateFlowConsumer(BaseModel):
    triggerid: Optional[str] = Field("trigger-1", title="Triggerid")
    data: Optional[Dict[str, Any]] = Field(
        {},
        description="Object containing the configuration of the flow for the consumer",
        title="Data",
    )


class UpdateOrderItem(BaseModel):
    customer_id: Optional[str] = Field(
        None,
        description="Unique identifier of the customer",
        examples=["371ca583-d218-4900-b236-397532cf0e52"],
        title="Customer Id",
    )


class ValidationError(BaseModel):
    loc: List[Union[str, int]] = Field(..., title="Location")
    msg: str = Field(..., title="Message")
    type: str = Field(..., title="Error Type")


class VariantAttributeItem(BaseModel):
    name: str = Field(..., title="Name")
    value: str = Field(..., title="Value")


class VariantAttributeOptionItem(BaseModel):
    name: str = Field(..., title="Name")
    values: List[str] = Field(..., title="Values")


class VatCodeScope(Enum):
    nat = "nat"
    eu = "eu"
    int = "int"
    unknown = "unknown"


class VatCodeType(Enum):
    sale = "sale"
    purchase = "purchase"
    both = "both"
    unknown = "unknown"


class WebhookInstanceGetItem(BaseModel):
    webhookid: UUID = Field(..., title="Webhookid")
    accountid: UUID = Field(..., title="Accountid")
    createdby: Optional[UUID] = Field(None, title="Createdby")
    createdon: DateTime = Field(..., title="Createdon")
    event: str = Field(..., title="Event")
    url: str = Field(..., title="Url")
    status: Status
    integrationid: Optional[int] = Field(None, title="Integrationid")


class WebhookInstancePatchItem(BaseModel):
    status: Optional[Status] = None
    url: Optional[constr(max_length=500)] = Field(None, title="Url")
    signingsecret: Optional[constr(max_length=100)] = Field(None, title="Signingsecret")


class WebhookInstancePostItem(BaseModel):
    event: constr(max_length=80) = Field(..., title="Event")
    url: constr(max_length=500) = Field(..., title="Url")
    signingsecret: Optional[constr(max_length=100)] = Field(None, title="Signingsecret")
    integrationid: Optional[int] = Field(
        None,
        description="Can be used to specify the integration code of a specific connector. This is mandatory in case you create a webhook related to a specific One API.",
        title="Integrationid",
    )


class WebhookItem(BaseModel):
    event: str = Field(..., title="Event")
    api: Optional[str] = Field(None, title="Api")


class WebhookLogItem(BaseModel):
    webhooklogid: UUID = Field(..., title="Webhooklogid")
    webhookid: UUID = Field(..., title="Webhookid")
    event: str = Field(..., title="Event")
    url: str = Field(..., title="Url")
    accountid: str = Field(..., title="Accountid")
    createdon: DateTime = Field(..., title="Createdon")
    httpstatus: int = Field(..., title="Httpstatus")
    integrationid: Optional[int] = Field(None, title="Integrationid")


class WelfareFundType(Enum):
    TC01 = "TC01"
    TC02 = "TC02"
    TC03 = "TC03"
    TC04 = "TC04"
    TC05 = "TC05"
    TC06 = "TC06"
    TC07 = "TC07"
    TC08 = "TC08"
    TC09 = "TC09"
    TC10 = "TC10"
    TC11 = "TC11"
    TC12 = "TC12"
    TC13 = "TC13"
    TC14 = "TC14"
    TC15 = "TC15"
    TC16 = "TC16"
    TC17 = "TC17"
    TC18 = "TC18"
    TC19 = "TC19"
    TC20 = "TC20"
    TC21 = "TC21"
    TC22 = "TC22"


class WithholdingTaxPaymentReason(Enum):
    A = "A"
    U = "U"
    R = "R"
    Q = "Q"
    H = "H"
    V = "V"
    V2 = "V2"
    I = "I"
    J = "J"
    K = "K"
    P = "P"
    S = "S"
    T = "T"
    W = "W"
    X = "X"
    Y = "Y"
    B = "B"
    C = "C"
    D = "D"
    E = "E"
    F = "F"
    G = "G"
    L = "L"
    L1 = "L1"
    M = "M"
    M1 = "M1"
    M2 = "M2"
    IN = "IN"
    O = "O"
    O1 = "O1"
    V1 = "V1"


class WithholdingTaxReason(Enum):
    RT01 = "RT01"
    RT02 = "RT02"
    RT03 = "RT03"
    RT04 = "RT04"
    RT05 = "RT05"
    RT06 = "RT06"


class BackboneApiAppRoutersSyncsConnectionItem(BaseModel):
    one_api: Optional[int] = Field(None, title="One Api")
    connection_type: Optional[int] = Field(None, title="Connection Type")
    display_order: Optional[int] = Field(0, title="Display Order")
    display_hidden: Optional[bool] = Field(False, title="Display Hidden")


class BackboneCommonModelsAccountingCommonInvoiceType(Enum):
    customer_invoice = "customer_invoice"
    customer_refund = "customer_refund"
    supplier_invoice = "supplier_invoice"
    supplier_refund = "supplier_refund"


class BackboneCommonModelsCommerceCommonAddressItemIn(BaseModel):
    first_name: str = Field(..., title="First Name")
    last_name: str = Field(..., title="Last Name")
    street: str = Field(..., title="Street")
    number: str = Field(..., title="Number")
    box: Optional[str] = Field(None, title="Box")
    city: str = Field(..., title="City")
    postal_code: Optional[str] = Field(None, title="Postal Code")
    country: str = Field(..., description="Format: ISO 3166-1 codes.", title="Country")
    phone: Optional[str] = Field(None, title="Phone")
    email: Optional[str] = Field(None, title="Email")


class BackboneCommonModelsCommerceCommonAddressItemOut(BaseModel):
    address_type: AddressType
    company_name: Optional[str] = Field(None, title="Company Name")
    first_name: Optional[str] = Field(None, title="First Name")
    last_name: Optional[str] = Field(None, title="Last Name")
    street: Optional[str] = Field(None, title="Street")
    number: Optional[str] = Field(None, title="Number")
    box: Optional[str] = Field(None, title="Box")
    city: Optional[str] = Field(None, title="City")
    postal_code: Optional[str] = Field(None, title="Postal Code")
    country: Optional[str] = Field(
        None, description="Format: ISO 3166-1 codes.", title="Country"
    )
    phone: Optional[str] = Field(None, title="Phone")
    email: Optional[str] = Field(None, title="Email")


class BackboneCommonModelsCommerceCommonDiscountItem(BaseModel):
    name: str = Field(..., title="Name")
    description: str = Field(..., title="Description")
    amount: float = Field(..., title="Amount")


class BackboneCommonModelsCommerceCommonProductCategoryItem(BaseModel):
    id: str = Field(
        ..., description="Technical id of the category in Chift", title="Id"
    )
    name: str = Field(..., title="Name")


class BackboneCommonModelsCommerceCommonProductPriceItem(BaseModel):
    currency: str = Field(..., title="Currency")
    price: Optional[float] = Field(0, title="Price")


class BackboneCommonModelsCommonAddressItemIn(BaseModel):
    address_type: AddressType
    name: Optional[str] = Field(None, title="Name")
    number: Optional[str] = Field(None, title="Number")
    box: Optional[str] = Field(None, title="Box")
    phone: Optional[str] = Field(None, title="Phone")
    mobile: Optional[str] = Field(None, title="Mobile")
    email: Optional[str] = Field(None, title="Email")
    street: str = Field(..., title="Street")
    city: str = Field(..., title="City")
    postal_code: str = Field(..., title="Postal Code")
    country: str = Field(..., description="Format: ISO 3166-1 codes.", title="Country")


class BackboneCommonModelsCommonAddressItemOut(BaseModel):
    address_type: AddressType
    name: Optional[str] = Field(None, title="Name")
    number: Optional[str] = Field(None, title="Number")
    box: Optional[str] = Field(None, title="Box")
    phone: Optional[str] = Field(None, title="Phone")
    mobile: Optional[str] = Field(None, title="Mobile")
    email: Optional[str] = Field(None, title="Email")
    street: Optional[str] = Field(None, title="Street")
    city: Optional[str] = Field(None, title="City")
    postal_code: Optional[str] = Field(None, title="Postal Code")
    country: Optional[str] = Field(
        None, description="Format: ISO 3166-1 codes.", title="Country"
    )


class BackboneCommonModelsInvoicingCommonInvoiceType(Enum):
    customer_invoice = "customer_invoice"
    customer_refund = "customer_refund"
    supplier_invoice = "supplier_invoice"
    supplier_refund = "supplier_refund"
    all = "all"


class BackboneCommonModelsPaymentCommonPaymentStatus(Enum):
    pending = "pending"
    completed = "completed"
    partially_completed = "partially_completed"
    canceled = "canceled"
    failed = "failed"
    unknown = "unknown"
    authorized = "authorized"


class BackboneCommonModelsPosCommonProductCategoryItem(BaseModel):
    id: str = Field(
        ...,
        description="Unique identifier of the category",
        examples=["371ca583-d218-4900-b236-397532cf0e52"],
        title="Id",
    )
    name: str = Field(
        ..., description="Name given to the category", examples=["Pizza"], title="Name"
    )
    description: Optional[str] = Field(
        None,
        description="Description of the category",
        examples=["Delicious pizza"],
        title="Description",
    )
    id_parent: Optional[str] = Field(
        None,
        description="Indicates if the category belongs to a parent category",
        examples=["371ca583-d218-4900-b236-397532cf0e55"],
        title="Id Parent",
    )


class BackboneCommonModelsPosCommonProductPriceItem(BaseModel):
    unit_price: float = Field(
        ...,
        description="Unit price (without tax) of the product",
        examples=[10],
        title="Unit Price",
    )
    tax_rate: Optional[float] = Field(
        None,
        description="Tax rate applied to the product",
        examples=[10],
        title="Tax Rate",
    )


class BackboneCommonModelsPosPmsDiscountItem(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the discount",
        examples=["Percentage discount"],
        title="Name",
    )
    total: float = Field(
        ..., description="Total amount of the discount", examples=[10], title="Total"
    )
    type: Optional[DiscountType] = Field(
        "UNKNOWN", description="Type of the discount", examples=["offered"]
    )


class BackboneCommonModelsPosPmsPaymentStatus(Enum):
    Pending = "Pending"
    Completed = "Completed"
    Canceled = "Canceled"
    Failed = "Failed"
    Unknown = "Unknown"
    Authorised = "Authorised"


class AccountItem(BaseModel):
    number: str = Field(
        ...,
        description="The account number in the chart of accounts. Must be unique within the accounting folder. In some countries (e.g., France, Belgium, Spain), the number structure is constrained by local accounting rules and must follow official charts of accounts (e.g., Plan Comptable Général).",
        title="Number",
    )
    name: str = Field(
        ...,
        description="Name or label of the account as it appears in the accounting system. This is typically used for internal referencing and identification of the account.",
        title="Name",
    )
    active: Optional[bool] = Field(
        True,
        description="Flag indicating whether the account is active. If True, the account is active and can be used in transactions. If False, the account is inactive and cannot be used for transactions.",
        title="Active",
    )
    type: Optional[AccountItemType] = Field(
        None,
        description="Represents the functional type of the ledger account, used to support common accounting operations such as payments, invoicing, tax handling, and reporting. The type here is more operational and aligned with how accounts are actually used in day-to-day processes (e.g., tracking receivables, recording VAT, handling bank transactions) ",
    )


class AccountingVatCode(BaseModel):
    id: str = Field(
        ...,
        description="Unique id of the VAT Code instance in the accounting system.",
        title="Id",
    )
    code: Optional[str] = Field(
        None,
        description="Short code (sometimes also used as id) for the VAT code, as defined in the accounting system. This code is typically used for internal referencing, mapping, or selection of VAT codes",
        title="Code",
    )
    label: str = Field(
        ...,
        description="Label of the VAT code as it appears in the accounting system. This is the human-readable name used to identify the VAT code.",
        title="Label",
    )
    scope: Optional[VatCodeScope] = Field(
        "unknown",
        description="Scope of the VAT code, indicating its applicability. Use 'nat' for VAT codes that apply to local/domestic sales or purchases, 'eu' for cross-border transactions within the EU, and 'int' for transactions with countries outside the EU.",
    )
    rate: float = Field(
        ...,
        description="VAT rate associated with the VAT code. This is the percentage rate applied to the amount when this VAT code is used.",
        title="Rate",
    )
    type: VatCodeType = Field(
        ...,
        description="Type of the VAT code, indicating whether it is a sales tax or purchase tax. This helps in understanding how the VAT code is applied in transactions.",
    )
    deductible_account: Optional[str] = Field(
        None,
        description="Ledger account number used for the deductible part of the VAT code. This is typically used for purchase transactions where VAT can be deducted.",
        title="Deductible Account",
    )
    payable_account: Optional[str] = Field(
        None,
        description="Ledger account number used for the payable part of the VAT code. This is typically used for sales transactions where VAT is collected from customers.",
        title="Payable Account",
    )
    reversed: Optional[bool] = Field(
        False,
        description="Indicates whether the VAT code is reversed. A reversed VAT code is used in specific scenarios, such as reverse charge mechanisms, where the responsibility for reporting VAT shifts from the seller to the buyer.",
        title="Reversed",
    )


class AddressItemInInvoicing(BaseModel):
    address_type: AddressTypeInvoicing
    name: Optional[str] = Field(None, title="Name")
    number: Optional[str] = Field(None, title="Number")
    box: Optional[str] = Field(None, title="Box")
    phone: Optional[str] = Field(None, title="Phone")
    mobile: Optional[str] = Field(None, title="Mobile")
    email: Optional[str] = Field(None, title="Email")
    street: str = Field(..., title="Street")
    city: str = Field(..., title="City")
    postal_code: str = Field(..., title="Postal Code")
    country: str = Field(..., description="Format: ISO 3166-1 codes.", title="Country")


class AddressItemOutInput(BaseModel):
    address_type: AddressType
    name: Optional[str] = Field(None, title="Name")
    number: Optional[str] = Field(None, title="Number")
    box: Optional[str] = Field(None, title="Box")
    phone: Optional[str] = Field(None, title="Phone")
    mobile: Optional[str] = Field(None, title="Mobile")
    email: Optional[str] = Field(None, title="Email")
    street: Optional[str] = Field(None, title="Street")
    city: Optional[str] = Field(None, title="City")
    postal_code: Optional[str] = Field(None, title="Postal Code")
    country: Optional[str] = Field(
        None, description="Format: ISO 3166-1 codes.", title="Country"
    )


class AddressItemOutInvoicing(BaseModel):
    address_type: AddressTypeInvoicing
    name: Optional[str] = Field(None, title="Name")
    number: Optional[str] = Field(None, title="Number")
    box: Optional[str] = Field(None, title="Box")
    phone: Optional[str] = Field(None, title="Phone")
    mobile: Optional[str] = Field(None, title="Mobile")
    email: Optional[str] = Field(None, title="Email")
    street: Optional[str] = Field(None, title="Street")
    city: Optional[str] = Field(None, title="City")
    postal_code: Optional[str] = Field(None, title="Postal Code")
    country: Optional[str] = Field(
        None, description="Format: ISO 3166-1 codes.", title="Country"
    )


class AnalyticDistribution(BaseModel):
    analytic_plan: str = Field(
        ...,
        description="Id of the analytic plan to which the distribution applies.",
        title="Analytic Plan",
    )
    analytic_accounts: List[AnalyticDistributionDetail] = Field(
        ...,
        description="List of analytic accounts and their respective percentages for the distribution.",
        title="Analytic Accounts",
    )


class BalanceItemOut(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    available_amount: float = Field(
        ..., description="Total amount available", title="Available Amount"
    )
    currency: str = Field(..., description="Currency", title="Currency")
    create_date: DateTime = Field(..., description="Create Date", title="Create Date")


class CategoryItem(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    name: str = Field(..., title="Name")
    parent_id: Optional[str] = Field(
        None,
        description="Technical id of the parent category in the target software",
        title="Parent Id",
    )


class ChiftId(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")


class ChiftPageAccountItem(BaseModel):
    items: List[AccountItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageAccountingVatCode(BaseModel):
    items: List[AccountingVatCode] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageBalanceItemOut(BaseModel):
    items: List[BalanceItemOut] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageCategoryItem(BaseModel):
    items: List[CategoryItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageCountryItem(BaseModel):
    items: List[CountryItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageEmployeeItem(BaseModel):
    items: List[EmployeeItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageObjectivesItem(BaseModel):
    items: List[ObjectivesItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageOutstandingItem(BaseModel):
    items: List[OutstandingItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPagePMSLocationItem(BaseModel):
    items: List[PMSLocationItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPagePOSCustomerItem(BaseModel):
    items: List[POSCustomerItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPagePOSLocationItem(BaseModel):
    items: List[POSLocationItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPagePaymentMethods(BaseModel):
    items: List[PaymentMethods] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPagePayment(BaseModel):
    items: List[Payment] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageProductCategoryItem(BaseModel):
    items: List[BackboneCommonModelsPosCommonProductCategoryItem] = Field(
        ..., title="Items"
    )
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageTaxRateItem(BaseModel):
    items: List[TaxRateItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageTransactionItemOut(BaseModel):
    items: List[TransactionItemOut] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ClientItemIn(BaseModel):
    external_reference: Optional[str] = Field(
        None,
        description="External identifier used to link the client in the accounting system with the corresponding client reference in your own system.",
        title="External Reference",
    )
    first_name: Optional[str] = Field(
        None,
        description="Only used when the client is an individual (is_company=false). Indicates the first name of the client.",
        title="First Name",
    )
    last_name: Optional[str] = Field(
        None,
        description="Only used when the client is an individual (is_company=false). Indicates the last name of the client.",
        title="Last Name",
    )
    name: constr(min_length=1) = Field(
        ...,
        description="Full name or legal name of the client (individual or company). This is the name that will be displayed in the accounting software.",
        title="Name",
    )
    function: Optional[str] = Field(
        None,
        description="Only used when the client is an individual (is_company=false). Indicates the function of the client.",
        title="Function",
    )
    is_company: Optional[bool] = Field(
        True,
        description="Indicates if the client is an individual or a company.",
        title="Is Company",
    )
    company_id: Optional[str] = Field(
        None,
        description="Only used when the client is an individual (is_company=false). Indicates the id of the company linked to the client.",
        title="Company Id",
    )
    phone: Optional[str] = Field(
        None, description="Phone number of the client.", title="Phone"
    )
    mobile: Optional[str] = Field(
        None, description="Mobile phone number of the client.", title="Mobile"
    )
    email: Optional[str] = Field(
        None, description="Email address of the client.", title="Email"
    )
    language: Optional[str] = Field(
        None,
        description="Language of the client. Format: ISO 639-1 codes.",
        title="Language",
    )
    internal_notes: Optional[str] = Field(
        None, description="Internal notes about the client.", title="Internal Notes"
    )
    website: Optional[str] = Field(
        None, description="Website of the client.", title="Website"
    )
    vat: Optional[str] = Field(
        None,
        description="VAT number of the client, used for tax compliance and invoicing. This value is unique per company and can be used as a reliable identifier to match clients between systems.",
        title="Vat",
    )
    iban: Optional[str] = Field(
        None, description="IBAN account number of the client.", title="Iban"
    )
    bank_account: Optional[str] = Field(
        None, description="Bank account number of the client.", title="Bank Account"
    )
    currency: Optional[str] = Field(
        None,
        description="Indicates the currency of the client (e.g., EUR).",
        title="Currency",
    )
    active: Optional[bool] = Field(
        True, description="Indicates if the client is active.", title="Active"
    )
    addresses: List[BackboneCommonModelsCommonAddressItemIn] = Field(
        ...,
        description="List of addresses associated with the client.",
        title="Addresses",
    )
    account_number: Optional[str] = Field(
        None,
        description="Number of ledger account assigned to the client in the accounting system as it will appear in the official accounting export file (FEC, SIE, iXBRL, etc.). This is typically the ledger account used for posting receivables. In some systems, each customer has a dedicated account; in others, a shared control account is used and customer balances are tracked in a subledger.",
        title="Account Number",
    )


class ClientItemOut(BaseModel):
    external_reference: Optional[str] = Field(
        None,
        description="External identifier used to link the client in the accounting system with the corresponding client reference in your own system.",
        title="External Reference",
    )
    first_name: Optional[str] = Field(
        None,
        description="Only used when the client is an individual (is_company=false). Indicates the first name of the client.",
        title="First Name",
    )
    last_name: Optional[str] = Field(
        None,
        description="Only used when the client is an individual (is_company=false). Indicates the last name of the client.",
        title="Last Name",
    )
    name: Optional[str] = Field(
        None,
        description="Full name or legal name of the client (individual or company). This is the name displayed in the accounting software.",
        title="Name",
    )
    function: Optional[str] = Field(
        None,
        description="Only used when the client is an individual (is_company=false). Indicates the function of the client.",
        title="Function",
    )
    is_company: Optional[bool] = Field(
        True,
        description="Indicates if the client is an individual or a company.",
        title="Is Company",
    )
    company_id: Optional[str] = Field(
        None,
        description="Only used when the client is an individual (is_company=false). Indicates the id of the company linked to the client.",
        title="Company Id",
    )
    phone: Optional[str] = Field(
        None, description="Phone number of the client.", title="Phone"
    )
    mobile: Optional[str] = Field(
        None, description="Mobile phone number of the client.", title="Mobile"
    )
    email: Optional[str] = Field(
        None, description="Email address of the client.", title="Email"
    )
    language: Optional[str] = Field(
        None,
        description="Language of the client. Format: ISO 639-1 codes.",
        title="Language",
    )
    internal_notes: Optional[str] = Field(
        None, description="Internal notes about the client.", title="Internal Notes"
    )
    website: Optional[str] = Field(
        None, description="Website of the client.", title="Website"
    )
    vat: Optional[str] = Field(
        None, description="VAT number of the client.", title="Vat"
    )
    iban: Optional[str] = Field(
        None, description="IBAN account number of the client.", title="Iban"
    )
    bank_account: Optional[str] = Field(
        None, description="Bank account number of the client.", title="Bank Account"
    )
    currency: Optional[str] = Field(
        None,
        description="Indicates the currency of the client (e.g., EUR).",
        title="Currency",
    )
    active: Optional[bool] = Field(
        True, description="Indicates if the client is active.", title="Active"
    )
    account_number: Optional[str] = Field(
        None,
        description="Ledger account number assigned to the customer in the accounting system as it will appear in the official accounting export file (FEC, SIE, iXBRL, etc.).",
        title="Account Number",
    )
    company_number: Optional[str] = Field(
        None,
        description="Id of the associated company, used when the record is a contact person linked to a company.",
        title="Company Number",
    )
    id: Optional[str] = Field(
        None,
        description="Id of the client in the accounting software. This is the unique identifier used to reference the client in the system.",
        title="Id",
    )
    last_updated_on: Optional[DateTime] = Field(
        None,
        description="The last time the client has been updated.",
        title="Last Updated On",
    )
    addresses: Optional[List[BackboneCommonModelsCommonAddressItemOut]] = Field(
        [],
        description="List of addresses associated with the client.",
        title="Addresses",
    )


class ClientItemUpdate(BaseModel):
    external_reference: Optional[str] = Field(
        None,
        description="External identifier used to link the client in the accounting system with the corresponding client reference in your own system.",
        title="External Reference",
    )
    first_name: Optional[str] = Field(
        None,
        description="Only used when the client is an individual (is_company=false). Indicates the first name of the client.",
        title="First Name",
    )
    last_name: Optional[str] = Field(
        None,
        description="Only used when the client is an individual (is_company=false). Indicates the last name of the client.",
        title="Last Name",
    )
    name: Optional[str] = Field(
        None,
        description="Full name or legal name of the client (individual or company). This is the name that will be displayed in the accounting software.",
        title="Name",
    )
    function: Optional[str] = Field(
        None,
        description="Only used when the client is an individual (is_company=false). Indicates the function of the client.",
        title="Function",
    )
    is_company: Optional[bool] = Field(
        True,
        description="Indicates if the client is an individual or a company.",
        title="Is Company",
    )
    company_id: Optional[str] = Field(
        None,
        description="Only used when the client is an individual (is_company=false). Indicates the id of the company linked to the client.",
        title="Company Id",
    )
    phone: Optional[str] = Field(
        None, description="Phone number of the client.", title="Phone"
    )
    mobile: Optional[str] = Field(
        None, description="Mobile phone number of the client.", title="Mobile"
    )
    email: Optional[str] = Field(
        None, description="Email address of the client.", title="Email"
    )
    language: Optional[str] = Field(
        None,
        description="Language of the client. Format: ISO 639-1 codes.",
        title="Language",
    )
    internal_notes: Optional[str] = Field(
        None, description="Internal notes about the client.", title="Internal Notes"
    )
    website: Optional[str] = Field(
        None, description="Website of the client.", title="Website"
    )
    vat: Optional[str] = Field(
        None,
        description="VAT number of the client, used for tax compliance and invoicing. This value is unique per company and can be used as a reliable identifier to match clients between systems.",
        title="Vat",
    )
    iban: Optional[str] = Field(
        None, description="IBAN account number of the client.", title="Iban"
    )
    bank_account: Optional[str] = Field(
        None, description="Bank account number of the client.", title="Bank Account"
    )
    currency: Optional[str] = Field(
        None,
        description="Indicates the currency of the client (e.g., EUR).",
        title="Currency",
    )
    active: Optional[bool] = Field(
        True, description="Indicates if the client is active.", title="Active"
    )
    addresses: Optional[List[AddressItemOutInput]] = Field(
        [],
        description="List of addresses associated with the client.",
        title="Addresses",
    )


class CommerceCustomerItem(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    first_name: Optional[str] = Field(None, title="First Name")
    last_name: Optional[str] = Field(None, title="Last Name")
    phone: Optional[str] = Field(None, title="Phone")
    email: Optional[str] = Field(None, title="Email")
    language: Optional[str] = Field(
        None, description="Format: ISO 639-1 codes.", title="Language"
    )
    internal_notes: Optional[str] = Field(None, title="Internal Notes")
    currency: Optional[str] = Field(
        None,
        description="Indicates the currency of the client (e.g. EUR).",
        title="Currency",
    )
    addresses: Optional[List[BackboneCommonModelsCommerceCommonAddressItemOut]] = Field(
        [], title="Addresses"
    )
    created_on: Optional[DateTime] = Field(None, title="Created On")


class CommerceLocationItemOut(BaseModel):
    id: str = Field(
        ..., description="Technical id of the location in Chift", title="Id"
    )
    name: str = Field(..., title="Name")
    source_ref: Optional[Ref] = Field(
        None, description="Technical id of the location in the target software"
    )


class ContactItemIn(BaseModel):
    is_prospect: Optional[bool] = Field(
        None, description="Is a prospect?", title="Is Prospect"
    )
    is_customer: Optional[bool] = Field(
        None, description="Is a customer?", title="Is Customer"
    )
    is_supplier: Optional[bool] = Field(
        None, description="Is a supplier?", title="Is Supplier"
    )
    is_company: Optional[bool] = Field(
        None, description="Is a company?", title="Is Company"
    )
    company_name: Optional[str] = Field(
        None, description="Name of the company", title="Company Name"
    )
    first_name: Optional[str] = Field(None, description="Firstname", title="First Name")
    last_name: Optional[str] = Field(None, description="Lastname", title="Last Name")
    email: Optional[str] = Field(None, description="Email", title="Email")
    phone: Optional[str] = Field(None, description="Phone", title="Phone")
    mobile: Optional[str] = Field(None, description="Mobile", title="Mobile")
    company_id: Optional[str] = Field(
        None,
        description="Technical id of the contact' company in Chift",
        title="Company Id",
    )
    vat: Optional[str] = Field(None, description="VAT number", title="Vat")
    company_number: Optional[str] = Field(
        None,
        description="Company number (identification number different than the VAT (e.g. siret))",
        title="Company Number",
    )
    currency: Optional[str] = Field(
        None, description="Currency matching target sofware name", title="Currency"
    )
    language: Optional[str] = Field(
        None, description="Language matching target sofware name", title="Language"
    )
    comment: Optional[str] = Field(None, description="Comment", title="Comment")
    customer_account_number: Optional[str] = Field(
        None,
        description="Number of the accounting account used for sales (e.g. 701000)",
        title="Customer Account Number",
    )
    supplier_account_number: Optional[str] = Field(
        None,
        description="Number of the accounting account used for purchases (e.g. 601000)",
        title="Supplier Account Number",
    )
    birthdate: Optional[Date] = Field(None, description="Birthdate", title="Birthdate")
    gender: Optional[ContactGender] = Field(None, description="Gender")
    addresses: Optional[List[AddressItemInInvoicing]] = Field(
        [], description="Addresses", title="Addresses"
    )


class ContactItemOut(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    is_prospect: Optional[bool] = Field(
        None, description="Is a prospect?", title="Is Prospect"
    )
    is_customer: Optional[bool] = Field(
        None, description="Is a customer?", title="Is Customer"
    )
    is_supplier: Optional[bool] = Field(
        None, description="Is a supplier?", title="Is Supplier"
    )
    is_company: Optional[bool] = Field(
        None, description="Is a company?", title="Is Company"
    )
    company_name: Optional[str] = Field(
        None, description="Name of the company", title="Company Name"
    )
    first_name: Optional[str] = Field(None, description="Firstname", title="First Name")
    last_name: Optional[str] = Field(None, description="Lastname", title="Last Name")
    email: Optional[str] = Field(None, description="Email", title="Email")
    phone: Optional[str] = Field(None, description="Phone", title="Phone")
    mobile: Optional[str] = Field(None, description="Mobile", title="Mobile")
    company_id: Optional[str] = Field(
        None,
        description="Technical id of the contact' company in Chift",
        title="Company Id",
    )
    vat: Optional[str] = Field(None, description="VAT number", title="Vat")
    company_number: Optional[str] = Field(
        None,
        description="Company number (identification number different than the VAT (e.g. siret))",
        title="Company Number",
    )
    currency: Optional[str] = Field(
        None, description="Currency matching target sofware name", title="Currency"
    )
    language: Optional[str] = Field(
        None, description="Language matching target sofware name", title="Language"
    )
    comment: Optional[str] = Field(None, description="Comment", title="Comment")
    customer_account_number: Optional[str] = Field(
        None,
        description="Number of the accounting account used for sales (e.g. 701000)",
        title="Customer Account Number",
    )
    supplier_account_number: Optional[str] = Field(
        None,
        description="Number of the accounting account used for purchases (e.g. 601000)",
        title="Supplier Account Number",
    )
    birthdate: Optional[Date] = Field(None, description="Birthdate", title="Birthdate")
    gender: Optional[ContactGender] = Field(None, description="Gender")
    addresses: Optional[List[AddressItemOutInvoicing]] = Field(
        [], description="Addresses", title="Addresses"
    )
    external_reference: Optional[str] = Field(
        None,
        description="External reference of the contact in the invoicing system",
        title="External Reference",
    )


class DataStoreItem(BaseModel):
    id: str = Field(..., title="Id")
    name: str = Field(..., title="Name")
    status: Optional[Status] = "active"
    definition: DatastoreDef


class ExtendedIssueItem(BaseModel):
    id: str = Field(..., title="Id")
    consumer_id: str = Field(..., title="Consumer Id")
    connection_id: str = Field(..., title="Connection Id")
    integration_id: int = Field(..., title="Integration Id")
    integration_name: str = Field(..., title="Integration Name")
    created_on: DateTime = Field(..., title="Created On")
    updated_on: DateTime = Field(..., title="Updated On")
    last_seen: DateTime = Field(..., title="Last Seen")
    error: ErrorInfo
    occurrences: int = Field(..., title="Occurrences")
    level: IssueLevel
    events: Optional[List[IssueEvent]] = Field([], title="Events")


class FeesItem(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    created_on: Optional[DateTime] = Field(None, title="Created On")
    type: FeesType
    removed: Optional[bool] = Field(
        False,
        description="Indicates if the fee has been removed from the order",
        title="Removed",
    )
    tax_rate: float = Field(..., title="Tax Rate")
    tax_id: Optional[str] = Field(
        None, description="Technical id of the tax rate in Chift", title="Tax Id"
    )
    discounts: Optional[List[BackboneCommonModelsCommerceCommonDiscountItem]] = Field(
        [], title="Discounts"
    )
    untaxed_amount: float = Field(..., title="Untaxed Amount")
    tax_amount: float = Field(..., title="Tax Amount")
    total: float = Field(..., title="Total")


class FieldItem(BaseModel):
    name: str = Field(..., title="Name")
    type: FieldItemType
    display_condition: Optional[Dict[str, Any]] = Field(None, title="Display Condition")
    values: Optional[List[FieldItemValue]] = Field([], title="Values")
    api_route: Optional[str] = Field(None, title="Api Route")
    connection_type: Optional[int] = Field(None, title="Connection Type")


class FinancialEntryItemIn(BaseModel):
    date: Date = Field(
        ...,
        description="Accounting date of the financial entry (format: YYYY-MM-DD). This is the date when the financial entry is recorded in the accounting system.",
        title="Date",
    )
    journal_id: str = Field(
        ...,
        description="Id of the journal instance in the accounting system in which the financial entry is recorded.",
        title="Journal Id",
    )
    currency: str = Field(
        ...,
        description="Indicates the currency of the operation (e.g., EUR, USD).",
        title="Currency",
    )
    currency_exchange_rate: Optional[float] = Field(
        1,
        description="Indicates the exchange rate at the date of the operation. Must be filled in when creating the operation in another currency from the folder's default currency.",
        title="Currency Exchange Rate",
    )
    reference: Optional[str] = Field(
        None,
        description="Optional reference field that can be used for lettering by storing an external or contextual identifier related to the entry . For example, it can be used to store a reference number, such as the invoice number associated with the payment.",
        title="Reference",
    )
    number: Optional[str] = Field(
        None,
        description="Unique 'number' of the financial entry in the accounting software. This is an internal number or identifier assigned to the financial entry. It is recommended to use this number for idempotency to prevent duplicate entries. Refer to the idempotency documentation in the Developer Guides for more details.",
        title="Number",
    )
    items: List[FinancialEntryLineItem] = Field(..., min_length=1, title="Items")
    pdf: Optional[str] = Field(
        None,
        description="Base 64 string representing the PDF attached to the sale/purchase entry.",
        title="Pdf",
    )


class FinancialEntryItemOut(BaseModel):
    date: Date = Field(
        ...,
        description="Accounting date of the financial entry (format: YYYY-MM-DD). This is the date when the financial entry is recorded in the accounting system.",
        title="Date",
    )
    journal_id: str = Field(
        ...,
        description="Id of the journal instance in the accounting system in which the financial entry is recorded.",
        title="Journal Id",
    )
    currency: str = Field(
        ...,
        description="Indicates the currency of the operation (e.g., EUR, USD).",
        title="Currency",
    )
    currency_exchange_rate: Optional[float] = Field(
        1,
        description="Indicates the exchange rate at the date of the operation. Must be filled in when creating the operation in another currency from the folder's default currency.",
        title="Currency Exchange Rate",
    )
    reference: Optional[str] = Field(
        None,
        description="Optional reference field that can be used for lettering by storing an external or contextual identifier related to the entry . For example, it can be used to store a reference number, such as the invoice number associated with the payment.",
        title="Reference",
    )
    id: str = Field(
        ...,
        description="Unique id of the financial entry instance in the accounting system.",
        title="Id",
    )
    number: str = Field(
        ...,
        description="Unique 'number' of the financial entry in the accounting software. This is an internal number or identifier assigned to the financial entry. It is recommended to use this number for idempotency to prevent duplicate entries. Refer to the idempotency documentation in the Developer Guides for more details.",
        title="Number",
    )
    items: List[FinancialEntryLineItemOut] = Field(..., title="Items")


class FlowDataStoreItemInput(BaseModel):
    id: Optional[str] = Field(None, title="Id")
    name: str = Field(..., title="Name")
    status: Optional[Status] = "active"
    definition: DatastoreDef


class FlowDataStoreItemOutput(BaseModel):
    id: Optional[str] = Field(None, title="Id")
    name: str = Field(..., title="Name")
    status: Optional[Status] = "active"
    definition: DatastoreDef


class FlowExecution(BaseModel):
    type: ExecutionType
    data: Optional[Union[FlowExecutionChain, FlowExecutionCode]] = Field(
        ..., title="Data"
    )


class FlowTrigger(BaseModel):
    id: str = Field(..., title="Id")
    type: TriggerType
    cronschedules: Optional[List[str]] = Field(None, title="Cronschedules")
    visible: Optional[bool] = Field(True, title="Visible")
    definitionFields: Optional[List[Dict[str, Any]]] = Field(
        None, title="Definitionfields"
    )
    options: Optional[Dict[str, Any]] = Field(None, title="Options")


class GenericJournalItem(BaseModel):
    account_type: EntryLineType = Field(
        ...,
        description="account_type can be either general ('general_account') or thirdparty ('customer', 'supplier' or 'employee')",
    )
    account: constr(min_length=1) = Field(
        ...,
        description="Depending on account_type, if the account_type is 'general_account', this is the general ledger account number used to book the journal item against. If the account_type is 'customer_account', 'supplier_account' or 'employee_account', this is the thirdparty_id (id of the customer, supplier or employee in the accounting system).",
        title="Account",
    )
    force_general_account: Optional[str] = Field(
        None,
        description="Overrides the default general account for customer, supplier, or employee accounts. If provided, this value will be used as the general account instead of the one determined by the accounting system's configuration.",
        title="Force General Account",
    )
    prioritise_thirdparty_account: Optional[bool] = Field(
        False,
        description="If True, prioritize using the third-party account information when a general account is forced in accounting software that only allows one account. Recommended to set it to True",
        title="Prioritise Thirdparty Account",
    )
    description: Optional[str] = Field(
        None,
        description="Text description for this journal item. This is typically used to provide additional context or information.",
        title="Description",
    )
    debit: float = Field(
        ...,
        description="Amount to debit on the account. Must be 0 if credit line is not 0",
        title="Debit",
    )
    credit: float = Field(
        ...,
        description="Amount to credit on the account. Must be 0 if debit line is not 0",
        title="Credit",
    )
    analytic_distribution: Optional[List[AnalyticDistribution]] = Field(
        [],
        description="List of analytic distributions for the journal item. Each distribution specifies an analytic plan and the allocation of the journal entry item's amount across analytic accounts using percentages.",
        title="Analytic Distribution",
    )
    tax_code: Optional[str] = Field(
        None,
        description="Indicates the Tax Code used for the entry item. This is the Id of the Tax Code instance in the accounting software.",
        title="Tax Code",
    )
    account_info: Optional[AccountToCreate] = Field(
        None,
        description="(For certain specific connectors only) Details of the third-party account (client/supplier) to be created if it does not already exist in the accounting system. Some softwares do not support creating third-party accounts via API; in such cases, this information must be provided to allow the accounting software to automatically create the missing account (e.g., for Tiime).",
    )


class HTTPValidationError(BaseModel):
    message: str = Field(..., title="Message")
    status: Optional[str] = Field("error", title="Status")
    detail: Optional[List[ValidationError]] = Field(None, title="Detail")


class IntegrationItem(BaseModel):
    integrationid: int = Field(..., title="Integrationid")
    name: str = Field(..., title="Name")
    status: Status
    api: Api
    logo_url: str = Field(..., title="Logo Url")
    icon_url: str = Field(..., title="Icon Url")
    post_connections: Optional[List[PostConnectionItemOutput]] = Field(
        [],
        description="List of post-connections that can be activated for this integration.",
        title="Post Connections",
    )
    credentials: Optional[List[CredentialItemOutput]] = Field(
        [],
        description="List of credentials that must be specified to create a connection. Can be used if you want to pass credentials on connection creation. Not compatible with oAuth2 routes.",
        title="Credentials",
    )
    supported_countries: Optional[List[str]] = Field(
        None,
        description="Country codes (ISO 3166-1 alpha-2) where this integration is supported. If not defined, the integration is supported globally.",
        examples=["BE", "FR", "ES"],
        title="Supported Countries",
    )
    local_agent: Optional[bool] = Field(
        False,
        description="This field indicate if the integration is a local agent.",
        title="Local Agent",
    )


class InvoiceLineItemInMultiAnalyticPlans(BaseModel):
    line_number: Optional[int] = Field(
        1,
        description="Optional line sequence number used to preserve the order of invoice items.",
        title="Line Number",
    )
    unit_price: float = Field(
        ..., description="Unit price of the item, before tax.", title="Unit Price"
    )
    unit_of_measure: Optional[str] = Field(
        None,
        description="A list of default units can be used for which an advanced mapping has been done (units: 'hour', 'day', 'cm', 'm2', 'm3', 'm', 'km', 'mile', 'g', 'kg', 'ton', 'box', 'pallet', 'roll', 'liter', 'unit'). Custom units of measure must have an identical name in the target software.",
        title="Unit Of Measure",
    )
    quantity: float = Field(
        ...,
        description="Quantity of items. This is the amount of units sold or purchased.",
        title="Quantity",
    )
    untaxed_amount: float = Field(
        ...,
        description="Amount excluding tax for the line item (i.e., unit_price × quantity).",
        title="Untaxed Amount",
    )
    tax_rate: float = Field(
        ..., description="Tax rate used for the line (e.g., 21.0).", title="Tax Rate"
    )
    tax_amount: float = Field(
        ...,
        description="Tax amount calculated for the line (i.e. untaxed_amount * tax_rate).",
        title="Tax Amount",
    )
    total: float = Field(
        ...,
        description="Total amount for the item, including tax (untaxed_amount + tax_amount).",
        title="Total",
    )
    account_number: constr(min_length=1) = Field(
        ...,
        description="Ledger account number (of type general) used for the line (e.g., 701000).",
        title="Account Number",
    )
    tax_code: constr(min_length=1) = Field(
        ...,
        description="Indicates the tax code used for the line. This is the Id of the Tax Code in the accounting software.",
        title="Tax Code",
    )
    description: Optional[str] = Field(
        "", description="Text description for this line item.", title="Description"
    )
    analytic_distribution: Optional[List[AnalyticDistribution]] = Field(
        [], title="Analytic Distribution"
    )


class InvoiceLineItemOutMultiAnalyticPlans(BaseModel):
    line_number: Optional[int] = Field(
        1,
        description="Optional line sequence number used to preserve the order of invoice items.",
        title="Line Number",
    )
    unit_price: float = Field(
        ..., description="Unit price of the item, before tax.", title="Unit Price"
    )
    unit_of_measure: Optional[str] = Field(
        None,
        description="A list of default units can be used for which an advanced mapping has been done (units: 'hour', 'day', 'cm', 'm2', 'm3', 'm', 'km', 'mile', 'g', 'kg', 'ton', 'box', 'pallet', 'roll', 'liter', 'unit'). Custom units of measure must have an identical name in the target software.",
        title="Unit Of Measure",
    )
    quantity: float = Field(
        ...,
        description="Quantity of items. This is the amount of units sold or purchased.",
        title="Quantity",
    )
    untaxed_amount: float = Field(
        ...,
        description="Amount excluding tax for the line item (i.e., unit_price × quantity).",
        title="Untaxed Amount",
    )
    tax_rate: float = Field(
        ..., description="Tax rate used for the line (e.g., 21.0).", title="Tax Rate"
    )
    tax_amount: float = Field(
        ...,
        description="Tax amount calculated for the line (i.e. untaxed_amount * tax_rate).",
        title="Tax Amount",
    )
    total: float = Field(
        ...,
        description="Total amount for the item, including tax (untaxed_amount + tax_amount).",
        title="Total",
    )
    account_number: Optional[str] = Field(
        None,
        description="Ledger account number (of type general) used for the line (e.g., 701000).",
        title="Account Number",
    )
    tax_code: Optional[str] = Field(
        None,
        description="Indicates the tax code used for the line. This is the Id of the Tax Code in the accounting software.",
        title="Tax Code",
    )
    description: Optional[str] = Field(
        "", description="Text description for this line.", title="Description"
    )
    analytic_distribution: Optional[List[AnalyticDistribution]] = Field(
        [],
        description="List of analytic distributions for the line item. Each distribution specifies an analytic plan and the associated analytic accounts with their percentages.",
        title="Analytic Distribution",
    )


class InvoicePartnerItem(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    type: PartnerType = Field(
        ..., description="Type of the partner", examples=["account"]
    )
    address: Optional[AddressItem] = Field(None, description="Address of the partner")
    first_name: Optional[str] = Field(
        None,
        description="First name of the partner. In case the partner is an individual.",
        examples=["John"],
        title="First Name",
    )
    last_name: Optional[str] = Field(
        None,
        description="Last name of the partner. In case the partner is an individual.",
        examples=["Doe"],
        title="Last Name",
    )
    company_name: Optional[str] = Field(
        None,
        description="Company name of the partner. In case the partner is a company.",
        examples=["Acme Corp"],
        title="Company Name",
    )


class InvoicingPaymentItem(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    status: BackboneCommonModelsPaymentCommonPaymentStatus = Field(
        ..., description="Payment status"
    )
    description: str = Field(..., description="Description", title="Description")
    amount: float = Field(..., description="Amount", title="Amount")
    currency: str = Field(..., description="Currency", title="Currency")
    payment_date: DateTime = Field(
        ..., description="Date of creation", title="Payment Date"
    )
    partner_id: Optional[str] = Field(
        None, description="Partner ID", title="Partner Id"
    )
    payment_method_id: Optional[str] = Field(
        None,
        description="Technical id of the payment method in Chift",
        title="Payment Method Id",
    )
    payment_method_name: Optional[str] = Field(
        None, description="Payment method name", title="Payment Method Name"
    )
    invoice_id: Optional[str] = Field(
        None, description="Technical id of the invoice in Chift", title="Invoice Id"
    )
    invoice_number: Optional[str] = Field(
        None, description="Invoice number", title="Invoice Number"
    )


class InvoicingPaymentMethodItem(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    name: str = Field(..., description="Payment method name", title="Name")


class InvoicingVatCode(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    label: str = Field(..., description="Label", title="Label")
    rate: float = Field(..., description="Tax rate (e.g. 21.0)", title="Rate")
    type: VatCodeType = Field(..., description="Type")
    code: Optional[str] = Field(None, description="Code", title="Code")
    scope: Optional[VatCodeScope] = Field("unknown", description="Scope")
    active: Optional[bool] = Field(
        True, description="Is the tax active?", title="Active"
    )


class IssueItem(BaseModel):
    id: str = Field(..., title="Id")
    consumer_id: str = Field(..., title="Consumer Id")
    connection_id: str = Field(..., title="Connection Id")
    integration_id: int = Field(..., title="Integration Id")
    integration_name: str = Field(..., title="Integration Name")
    created_on: DateTime = Field(..., title="Created On")
    updated_on: DateTime = Field(..., title="Updated On")
    last_seen: DateTime = Field(..., title="Last Seen")
    error: ErrorInfo
    occurrences: int = Field(..., title="Occurrences")
    level: IssueLevel


class Journal(BaseModel):
    id: str = Field(..., title="Id")
    code: Optional[str] = Field(None, title="Code")
    name: str = Field(..., title="Name")
    journal_type: JournalType
    counterpart_account: Optional[str] = Field(
        None,
        description="When journal is of type bank or cash, this is account number of the counterpart account used for the journal.",
        title="Counterpart Account",
    )
    next_document_numbers: Optional[List[NextDocumentNumber]] = Field(
        [], title="Next Document Numbers"
    )
    iban: Optional[str] = Field(
        None,
        description="When the journal is of type bank, IBAN of the bank account linked to the journal ",
        title="Iban",
    )
    currency: Optional[str] = Field(
        None,
        description="Currency of the journal (e.g., EUR). If empty, the journal follows the currency of the accounting folder.",
        title="Currency",
    )
    other_currencies_allowed: Optional[bool] = Field(
        True,
        description="Indicates if the journal allows other currencies. If it doesn't allow other currencies an exchange rate must be provided for Chift to convert the amounts to the journal currency. This only applicable if the journal currency is the same as the accounting folder currency.",
        title="Other Currencies Allowed",
    )


class JournalEntryMonoAnalyticPlan(BaseModel):
    reference: Optional[str] = Field(
        None,
        description="Optional reference field used to store an external or contextual identifier related to the entry. For example, it can be used to store a reference number, the invoice number issued by the suppllier or any other relevant information.",
        title="Reference",
    )
    due_date: Optional[Date] = Field(
        None,
        description="If the journal entry relates to an invoice, this is the due date for payment or settlement (format: YYYY-MM-DD).",
        title="Due Date",
    )
    journal_id: str = Field(
        ...,
        description="Id of the journal instance in the accounting system in which the journal entry is recorded.",
        title="Journal Id",
    )
    name: Optional[str] = Field(None, title="Name")
    journal_name: Optional[str] = Field(
        None,
        description="Name of the journal in which the journal entry is recorded.",
        title="Journal Name",
    )
    date: Optional[Date] = Field(
        "1970-01-01",
        description="Accounting date of the journal entry. It is automatically set to '1970-01-01' if the value is not available/empty in the accounting system.",
        title="Date",
    )
    posted: Optional[bool] = Field(
        False,
        description="Indicates if the journal entry has been posted (finalized) in the accounting system.",
        title="Posted",
    )
    id: str = Field(
        ...,
        description="Unique id of the journal entry instance in the accounting system.",
        title="Id",
    )
    due_dates: Optional[List[JournalItemDueDatesOut]] = Field(
        [], description="List of all due dates of a journal entry.", title="Due Dates"
    )
    items: Optional[List[JournalItemMonoAnalyticPlan]] = Field(
        [],
        description="List of journal items that make up the journal entry. Each item represents a line in the journal entry, and the sum of debits must equal the sum of credits to ensure the entry is balanced.",
        title="Items",
    )


class JournalIn(BaseModel):
    code: constr(min_length=2) = Field(
        ...,
        description="Short code or identifier of the journal (e.g., 'BNK', 'INV').",
        title="Code",
    )
    name: constr(min_length=1) = Field(
        ...,
        description="Name or label of the journal as it appears in the accounting system.",
        title="Name",
    )
    journal_type: JournalInType = Field(..., description="Type of journal. ")
    counterpart_account: Optional[str] = Field(
        None,
        description="When journal is of type bank or cash, this is account number of the counterpart account used for the journal.",
        title="Counterpart Account",
    )


class JournalItemMultiAnalyticPlan(BaseModel):
    account_number: constr(min_length=1) = Field(
        ...,
        description="Depending on account_type, if the account_type is 'general_account', this is the general ledger account number used to book the journal item against. If the account_type is 'customer_account', 'supplier_account' or 'employee_account', this is the thirdparty_id (id of the customer, supplier or employee in the accounting system).",
        title="Account Number",
    )
    partner_id: Optional[str] = Field(
        None,
        description="Id of the thirdparty (customer, supplier or employee) in the accounting system if the journal item relates to a thirdparty (e.g., an invoice).",
        title="Partner Id",
    )
    description: Optional[str] = Field(
        None,
        description="Text description for this journal item. This is typically used to provide additional context or information.",
        title="Description",
    )
    debit: float = Field(
        ...,
        description="Amount to debit on the account. Must be 0 if credit field is not 0",
        title="Debit",
    )
    credit: float = Field(
        ...,
        description="Amount to credit on the account. Must be 0 if debit field is not 0",
        title="Credit",
    )
    currency: constr(min_length=1) = Field(
        ...,
        description="Currency code (e.g., USD, EUR) used for the journal item amounts.",
        title="Currency",
    )
    currency_exchange_rate: Optional[float] = Field(
        1,
        description="Exchange rate applicable at the date of the journal item. Required when currency is different from the folder's default currency.",
        title="Currency Exchange Rate",
    )
    id: str = Field(
        ...,
        description="Unique id of the journal item instance in the accounting system.",
        title="Id",
    )
    partner_name: Optional[str] = Field(
        None,
        description="Name of the thirdparty (customer, supplier or employee) linked to the journal item if journal item relates to a thirdparty (e.g., an invoice).",
        title="Partner Name",
    )
    account_name: str = Field(
        ...,
        description="Name or label of the ledger account used to book the journal item against.",
        title="Account Name",
    )
    matching_numbers: Optional[List[str]] = Field(
        [],
        description="List of matching numbers used to link this journal item to other entries in the accounting system. This is used for reconciliation/lettering purposes.",
        title="Matching Numbers",
    )
    analytic_distribution: Optional[List[AnalyticDistribution]] = Field(
        [],
        description="List of analytic distributions for the journal item. Each distribution specifies an analytic plan and the allocation of the journal entry item's amount across analytic accounts using percentages.",
        title="Analytic Distribution",
    )


class LocalAgentInfo(BaseModel):
    status: LocalAgentStatus


class MiscellaneousOperationLine(BaseModel):
    line_number: Optional[int] = Field(
        1,
        description="Line number of the operation line. This is used to order the lines in the operation. It is automatically set to 1 if not provided.",
        title="Line Number",
    )
    description: Optional[str] = Field(
        None,
        description="Text description used to provide additional context or information about the operation line.",
        title="Description",
    )
    amount: float = Field(
        ..., description="Positive for Credit and negative for Debit.", title="Amount"
    )
    type: MiscellaneousOperationLineType
    account_number: str = Field(
        ...,
        description="Indicates the account number used in the operation line. This is the ledger account number in the chart of accounts.",
        title="Account Number",
    )
    partner_id: Optional[str] = Field(
        None,
        description="Must be filled in if it is a 'customer_account' or 'supplier_account' line type.",
        title="Partner Id",
    )
    analytic_account: Optional[str] = Field(
        None,
        description="Analytic account used in the operation line. This is the id of a analytic account - no distribution possible. It is used to track the operation line in the analytic accounting system.",
        title="Analytic Account",
    )


class MiscellaneousOperationOut(BaseModel):
    operation_number: Optional[str] = Field(None, title="Operation Number")
    currency: str = Field(
        ...,
        description="Indicates the currency of the operation (e.g., EUR, USD).",
        title="Currency",
    )
    currency_exchange_rate: Optional[float] = Field(
        1,
        description="Indicates the exchange rate at the date of the operation. Must be filled in when creating the operation in another currency from the folder's default currency.",
        title="Currency Exchange Rate",
    )
    lines: List[MiscellaneousOperationLine] = Field(..., title="Lines")
    operation_date: Optional[Date] = Field(
        "1970-01-01",
        description="Accounting date of the miscellaneous operation. It is automatically set to '1970-01-01' if the value is not available/empty in the accounting system.",
        title="Operation Date",
    )
    journal_id: str = Field(
        ...,
        description="Indicates the journal used in for the operation.",
        title="Journal Id",
    )
    status: MiscellaneousOperationStatusOut
    id: str = Field(..., title="Id")


class NlPaymentTermsSplit(BaseModel):
    g_account: PaymentTermAccountInfo = Field(
        ...,
        description="This is the 'Geblokkeerde rekening' in Dutch. It is a blocked bank account used only for tax-related payments, such as VAT and payroll tax.",
    )
    n_account: PaymentTermAccountInfo = Field(
        ...,
        description="This is the 'Normale rekening' in Dutch. It is a regular bank account used for standard business operations and unrestricted funds. The non-tax portion of the invoice is paid here.",
    )


class OpportunityItem(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    name: str = Field(..., description="Name", title="Name")
    total: float = Field(..., description="Total", title="Total")
    probability: float = Field(
        ..., description="Probability of success", title="Probability"
    )
    status: OpportunityStatus = Field(..., description="Status")
    partner_id: Optional[str] = Field(
        None, description="Technical id of the customer in Chift", title="Partner Id"
    )
    comment: Optional[str] = Field(None, description="Comment", title="Comment")
    currency: Optional[str] = Field(
        None, description="Currency matching target sofware name", title="Currency"
    )
    description: Optional[str] = Field(
        None, description="Description", title="Description"
    )
    pipe_status: Optional[str] = Field(
        None, description="Current stage in pipeline", title="Pipe Status"
    )
    pipe_name: Optional[str] = Field(
        None, description="Pipeline name", title="Pipe Name"
    )
    created_date: Optional[Date] = Field(
        None, description="Date creation", title="Created Date"
    )
    due_date: Optional[Date] = Field(None, description="Due Date", title="Due Date")
    end_date: Optional[Date] = Field(None, description="End Date", title="End Date")
    is_won: Optional[bool] = Field(None, description="Is won?", title="Is Won")
    owner_ref: Optional[FieldRef] = Field(None, description="Employee/User")


class OrderItemIn(BaseModel):
    customer: OrderCustomerItem
    billing_address: BackboneCommonModelsCommerceCommonAddressItemIn
    shipping_address: BackboneCommonModelsCommerceCommonAddressItemIn
    currency: str = Field(
        ...,
        description="Indicates the currency of the order (e.g. EUR).",
        title="Currency",
    )
    note: Optional[str] = Field(None, title="Note")
    lines: List[OrderLineItemIn] = Field(..., min_length=1, title="Lines")
    payment_method: Optional[str] = Field(
        None,
        description="If filled in the order will be marked as paid and processed by this payment method.",
        title="Payment Method",
    )


class OrderLineProductVariantItem(BaseModel):
    id: str = Field(
        ..., description="Technical id of the product variant in Chift", title="Id"
    )
    sku: Optional[str] = Field(None, title="Sku")
    name: str = Field(..., title="Name")
    categories: Optional[
        List[BackboneCommonModelsCommerceCommonProductCategoryItem]
    ] = Field([], title="Categories")


class OrderTransactions(BaseModel):
    id: str = Field(
        ..., description="Technical id of the transaction in the eCommerce", title="Id"
    )
    created_on: Optional[DateTime] = Field(None, title="Created On")
    payment_method_id: Optional[str] = Field(
        None,
        description="Technical id of the payment method in the eCommerce",
        title="Payment Method Id",
    )
    payment_method_name: Optional[str] = Field(
        None, description="Name of the payment method", title="Payment Method Name"
    )
    amount: float = Field(..., title="Amount")
    status: TransactionStatus


class PMSAccountingCategoryItem(BaseModel):
    id: str = Field(
        ...,
        description="Unique identifier of the accounting category",
        examples=["371ca583-d218-4900-b236-397532cf0e2"],
        title="Id",
    )
    source_ref: Ref = Field(..., description="Technical id in the target software")
    name: str = Field(
        ...,
        description="Name given to the accounting category",
        examples=["Beverages"],
        title="Name",
    )
    code: Optional[str] = Field(
        None,
        description="Code assigned to the category",
        examples=["123456"],
        title="Code",
    )
    ledger_account_code: Optional[str] = Field(
        None,
        description="Ledger account code assigned to the category",
        examples=["123456"],
        title="Ledger Account Code",
    )
    posting_account_code: Optional[str] = Field(
        None,
        description="Posting account code assigned to the category",
        examples=["123456"],
        title="Posting Account Code",
    )


class PMSCustomerItem(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    first_name: Optional[str] = Field(
        None,
        description="First name of the customer. In case the customer is an individual.",
        examples=["John"],
        title="First Name",
    )
    last_name: Optional[str] = Field(
        None,
        description="Last name of the customer. In case the customer is an individual.",
        examples=["Doe"],
        title="Last Name",
    )
    company_name: Optional[str] = Field(
        None,
        description="Company name of the customer. In case the customer is a company.",
        examples=["Acme Corp"],
        title="Company Name",
    )
    phone: Optional[str] = Field(
        None,
        description="Phone number of the customer",
        examples=["+1234567890"],
        title="Phone",
    )
    email: Optional[str] = Field(
        None,
        description="Email address of the customer",
        examples=["john.doe@example.com"],
        title="Email",
    )
    account_number: Optional[str] = Field(
        None,
        description="Number of the accounting account used (e.g. 701000)",
        examples=["701000"],
        title="Account Number",
    )
    created_on: Optional[DateTime] = Field(
        None,
        description="Creation date of the customer",
        examples=["2023-09-25T12:00:00"],
        title="Created On",
    )
    addresses: Optional[List[AddressItem]] = Field(
        None, description="List of addresses related to the customer", title="Addresses"
    )


class PMSOrderLineItem(BaseModel):
    id: str = Field(
        ...,
        description="Unique identifier of the order line item",
        examples=["123"],
        title="Id",
    )
    source_ref: Ref = Field(..., description="Technical id in the target software")
    type: Optional[POSLineItemType] = Field(
        None, description="Type of the order line item", examples=["product"]
    )
    menu_id: Optional[str] = Field(
        None,
        description="Unique identifier of the menu",
        examples=["456"],
        title="Menu Id",
    )
    quantity: float = Field(
        ...,
        description="Quantity of the order line item",
        examples=[1],
        title="Quantity",
    )
    unit_price: float = Field(
        ...,
        description="Unit price (without tax) of the order line item",
        examples=[10],
        title="Unit Price",
    )
    total: float = Field(
        ...,
        description="Total amount including tax of the order line item",
        examples=[11],
        title="Total",
    )
    tax_amount: float = Field(
        ...,
        description="Total amount of the taxes of the order line item",
        examples=[1],
        title="Tax Amount",
    )
    tax_rate: Optional[float] = Field(
        None,
        description="Tax rate of the order line item",
        examples=[10],
        title="Tax Rate",
    )
    description: Optional[str] = Field(
        None,
        description="Description of the order line item",
        examples=["Pizza"],
        title="Description",
    )
    discounts: Optional[List[BackboneCommonModelsPosPmsDiscountItem]] = Field(
        [],
        description="List of discounts of the order line item. Discounts of items are always part of the total discount of the order",
        examples=[[]],
        title="Discounts",
    )
    product_id: Optional[str] = Field(
        None,
        description="Reference to the product related to this item",
        examples=["789"],
        title="Product Id",
    )
    accounting_category_id: Optional[str] = Field(
        None,
        description="Sometimes used by a POS to give a specific accounting category to an order item",
        examples=["123"],
        title="Accounting Category Id",
    )


class PMSPaymentItem(BaseModel):
    id: Optional[str] = Field(
        None,
        description="Unique identifier of the payment",
        examples=["payment-123"],
        title="Id",
    )
    source_ref: Ref = Field(..., description="Technical id in the target software")
    payment_method_id: Optional[str] = Field(
        None,
        description="Unique identifier of the payment method used for the payment",
        examples=["payment-method-123"],
        title="Payment Method Id",
    )
    payment_method_name: Optional[str] = Field(
        None,
        description="Chift's name of the payment method used for the payment",
        examples=["Cash"],
        title="Payment Method Name",
    )
    total: float = Field(
        ..., description="Total amount of the payment", examples=[11], title="Total"
    )
    tip: Optional[float] = Field(
        "0",
        description="Total amount of the tips of the payment. Tips are not part of the total of the payment",
        examples=[1],
        title="Tip",
    )
    status: Optional[BackboneCommonModelsPosPmsPaymentStatus] = Field(
        "Unknown", description="Status of the payment", examples=["Completed"]
    )
    currency: Optional[str] = Field(
        None, description="Currency of the payment", examples=["EUR"], title="Currency"
    )
    date: Optional[DateTime] = Field(
        None,
        description="Date of the payment",
        examples=["2025-01-01T00:00:00Z"],
        title="Date",
    )
    partner_id: Optional[ChiftId] = Field(
        None, description="Reference to the customer related to this payment"
    )


class PMSPaymentMethods(BaseModel):
    id: str = Field(
        ...,
        description="Unique identifier of the payment method",
        examples=["371ca583-d218-4900-b236-397532cf0e52"],
        title="Id",
    )
    source_ref: Ref = Field(..., description="Technical id in the target software")
    name: str = Field(
        ...,
        description="Chift's name of the payment method (e.g. 'Cash', 'Card', 'Transfer', ...)",
        examples=["Cash"],
        title="Name",
    )
    extra: Optional[str] = Field(
        None,
        description="Original name of the payment method",
        examples=["Espèces"],
        title="Extra",
    )
    ledger_account_code: Optional[str] = Field(
        None,
        description="Ledger account code assigned to the category",
        examples=["4000"],
        title="Ledger Account Code",
    )


class PMSTaxRateItem(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    label: Optional[str] = Field(
        None, description="Label of the tax rate", examples=["VAT 21%"], title="Label"
    )
    rate: Optional[float] = Field(
        None, description="Percentage of the tax rate", examples=[21.0], title="Rate"
    )


class POSClosureInformationItem(BaseModel):
    id: str = Field(..., title="Id")
    total: float = Field(
        ...,
        description="Total amount of the payments in current closure",
        title="Total",
    )
    tax_amount: float = Field(
        ..., description="Total tax amount the in current closure", title="Tax Amount"
    )
    payments: Optional[List[ClosurePaymentItem]] = Field(
        [], description="List of payments related to current closure", title="Payments"
    )
    taxes: Optional[List[TotalTaxItem]] = Field(
        [], description="List of taxes related to current closure", title="Taxes"
    )


class POSCreateCustomerItem(BaseModel):
    first_name: constr(min_length=1) = Field(
        ...,
        description="First name of the customer",
        examples=["John"],
        title="First Name",
    )
    last_name: constr(min_length=1) = Field(
        ...,
        description="Last name of the customer",
        examples=["Doe"],
        title="Last Name",
    )
    phone: Optional[str] = Field(
        None,
        description="Phone number (mobile, home, work, ...) of the customer",
        examples=["+32475123456"],
        title="Phone",
    )
    email: Optional[str] = Field(
        None,
        description="Email address of the customer",
        examples=["john.doe@gmail.com"],
        title="Email",
    )
    address: Optional[PostAddressItem] = Field(
        None, description="Address of the customer"
    )


class POSItem(BaseModel):
    id: str = Field(
        ...,
        description="Unique identifier of the order line item",
        examples=["123"],
        title="Id",
    )
    type: Optional[POSLineItemType] = Field(
        None, description="Type of the order line item", examples=["product"]
    )
    menu_id: Optional[str] = Field(
        None,
        description="Unique identifier of the menu",
        examples=["456"],
        title="Menu Id",
    )
    quantity: float = Field(
        ...,
        description="Quantity of the order line item",
        examples=[1],
        title="Quantity",
    )
    unit_price: float = Field(
        ...,
        description="Unit price (without tax) of the order line item",
        examples=[10],
        title="Unit Price",
    )
    total: float = Field(
        ...,
        description="Total amount including tax of the order line item",
        examples=[11],
        title="Total",
    )
    tax_amount: float = Field(
        ...,
        description="Total amount of the taxes of the order line item",
        examples=[1],
        title="Tax Amount",
    )
    tax_rate: Optional[float] = Field(
        None,
        description="Tax rate of the order line item",
        examples=[10],
        title="Tax Rate",
    )
    description: Optional[str] = Field(
        None,
        description="Description of the order line item",
        examples=["Pizza"],
        title="Description",
    )
    discounts: Optional[List[BackboneCommonModelsPosPmsDiscountItem]] = Field(
        [],
        description="List of discounts of the order line item. Discounts of items are always part of the total discount of the order",
        examples=[[]],
        title="Discounts",
    )
    product_id: Optional[str] = Field(
        None,
        description="Reference to the product related to this item",
        examples=["789"],
        title="Product Id",
    )
    accounting_category_id: Optional[str] = Field(
        None,
        description="Sometimes used by a POS to give a specific accounting category to an order item",
        examples=["123"],
        title="Accounting Category Id",
    )


class POSPaymentItem(BaseModel):
    id: Optional[str] = Field(
        None,
        description="Unique identifier of the payment",
        examples=["payment-123"],
        title="Id",
    )
    payment_method_id: Optional[str] = Field(
        None,
        description="Unique identifier of the payment method used for the payment",
        examples=["payment-method-123"],
        title="Payment Method Id",
    )
    payment_method_name: Optional[str] = Field(
        None,
        description="Chift's name of the payment method used for the payment",
        examples=["Cash"],
        title="Payment Method Name",
    )
    total: float = Field(
        ..., description="Total amount of the payment", examples=[11], title="Total"
    )
    tip: Optional[float] = Field(
        "0",
        description="Total amount of the tips of the payment. Tips are not part of the total of the payment",
        examples=[1],
        title="Tip",
    )
    status: Optional[BackboneCommonModelsPosPmsPaymentStatus] = Field(
        "Unknown", description="Status of the payment", examples=["Completed"]
    )
    currency: Optional[str] = Field(
        None, description="Currency of the payment", examples=["EUR"], title="Currency"
    )
    date: Optional[DateTime] = Field(
        None,
        description="Date of the payment",
        examples=["2025-01-01T00:00:00Z"],
        title="Date",
    )


class POSProductItem(BaseModel):
    id: str = Field(
        ...,
        description="Unique identifier of the product",
        examples=["371ca583-d218-4900-b236-397532cf0e39"],
        title="Id",
    )
    categories: Optional[List[str]] = Field(
        [],
        description="List of categories the product belongs to",
        examples=["371ca583-d218-4900-b236-397532cf0e52"],
        title="Categories",
    )
    name: str = Field(
        ...,
        description="Name ofthe product",
        examples=["Pizza margheritta"],
        title="Name",
    )
    description: Optional[str] = Field(
        None,
        description="Description of the product",
        examples=["Pizza margheritta"],
        title="Description",
    )
    prices: List[BackboneCommonModelsPosCommonProductPriceItem] = Field(
        ..., description="List of prices for the product", title="Prices"
    )
    accounting_category_ids: Optional[List[str]] = Field(
        None,
        description="Used by a POS to give one or more specific accounting categories to a product item. If not available it will use the category ids",
        examples=["371ca583-d218-4900-b236-397532cf0e2"],
        title="Accounting Category Ids",
    )


class Partner(BaseModel):
    external_reference: Optional[str] = Field(
        None,
        description="External identifier used to link the client in the accounting system with the corresponding client reference in your own system.",
        title="External Reference",
    )
    first_name: Optional[str] = Field(
        None,
        description="Only used when the client is an individual (is_company=false). Indicates the first name of the client.",
        title="First Name",
    )
    last_name: Optional[str] = Field(
        None,
        description="Only used when the client is an individual (is_company=false). Indicates the last name of the client.",
        title="Last Name",
    )
    name: Optional[str] = Field(
        None,
        description="Full name or legal name of the client (individual or company). This is the name displayed in the accounting software.",
        title="Name",
    )
    function: Optional[str] = Field(
        None,
        description="Only used when the client is an individual (is_company=false). Indicates the function of the client.",
        title="Function",
    )
    is_company: Optional[bool] = Field(
        True,
        description="Indicates if the client is an individual or a company.",
        title="Is Company",
    )
    company_id: Optional[str] = Field(
        None,
        description="Only used when the client is an individual (is_company=false). Indicates the id of the company linked to the client.",
        title="Company Id",
    )
    phone: Optional[str] = Field(
        None, description="Phone number of the client.", title="Phone"
    )
    mobile: Optional[str] = Field(
        None, description="Mobile phone number of the client.", title="Mobile"
    )
    email: Optional[str] = Field(
        None, description="Email address of the client.", title="Email"
    )
    language: Optional[str] = Field(
        None,
        description="Language of the client. Format: ISO 639-1 codes.",
        title="Language",
    )
    internal_notes: Optional[str] = Field(
        None, description="Internal notes about the client.", title="Internal Notes"
    )
    website: Optional[str] = Field(
        None, description="Website of the client.", title="Website"
    )
    vat: Optional[str] = Field(
        None, description="VAT number of the client.", title="Vat"
    )
    iban: Optional[str] = Field(
        None, description="IBAN account number of the client.", title="Iban"
    )
    bank_account: Optional[str] = Field(
        None, description="Bank account number of the client.", title="Bank Account"
    )
    currency: Optional[str] = Field(
        None,
        description="Indicates the currency of the client (e.g., EUR).",
        title="Currency",
    )
    active: Optional[bool] = Field(
        True, description="Indicates if the client is active.", title="Active"
    )
    account_number: Optional[str] = Field(
        None,
        description="Ledger account number assigned to the customer in the accounting system as it will appear in the official accounting export file (FEC, SIE, iXBRL, etc.).",
        title="Account Number",
    )
    company_number: Optional[str] = Field(
        None,
        description="Id of the associated company, used when the record is a contact person linked to a company.",
        title="Company Number",
    )
    id: Optional[str] = Field(
        None,
        description="Id of the client in the accounting software. This is the unique identifier used to reference the client in the system.",
        title="Id",
    )
    last_updated_on: Optional[DateTime] = Field(
        None,
        description="The last time the client has been updated.",
        title="Last Updated On",
    )
    addresses: Optional[List[BackboneCommonModelsCommonAddressItemOut]] = Field(
        [],
        description="List of addresses associated with the client.",
        title="Addresses",
    )


class PaymentItemOut(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    status: BackboneCommonModelsPaymentCommonPaymentStatus = Field(
        ..., description="Payment status"
    )
    description: str = Field(..., description="Description", title="Description")
    amount: float = Field(..., description="Amount", title="Amount")
    currency: str = Field(..., description="Currency", title="Currency")
    payment_date: DateTime = Field(
        ..., description="Date of creation", title="Payment Date"
    )
    partner_id: Optional[str] = Field(
        None, description="Partner ID", title="Partner Id"
    )


class PaymentMethodItem(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    name: str = Field(..., title="Name")
    active: bool = Field(..., title="Active")


class PaymentReporting(BaseModel):
    method: Optional[PaymentReportingMethod] = Field(None, description="Payment method")
    conditions: Optional[PaymentReportingConditions] = Field(
        None, description="Payment conditions"
    )


class ProductItemOut(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    name: str = Field(..., description="Name", title="Name")
    unit_price: Optional[float] = Field(
        None, description="Unit price", title="Unit Price"
    )
    tax_id: Optional[str] = Field(
        None, description="Technical id of the tax in Chift", title="Tax Id"
    )
    code: Optional[str] = Field(None, description="Reference/code", title="Code")
    unit: Optional[str] = Field(
        None, description="Unit of measure matching target software name", title="Unit"
    )
    category: Optional[str] = Field(
        None, description="Category matching target software name", title="Category"
    )
    currency: Optional[str] = Field(
        None, description="Currency matching target software name", title="Currency"
    )
    description: Optional[str] = Field(
        None, description="Description", title="Description"
    )
    cost: Optional[float] = Field(0, description="Cost of the product", title="Cost")
    available_quantity: Optional[float] = Field(
        0,
        description="Available quanity of the product in stock. Will only be used for products that have an inventory (services will always be 0)",
        title="Available Quantity",
    )


class ProductVariantItem(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    parent_id: str = Field(
        ...,
        description="Technical id of the parent product in Chift",
        title="Parent Id",
    )
    name: str = Field(..., title="Name")
    description: Optional[str] = Field(None, title="Description")
    description_html: Optional[str] = Field(None, title="Description Html")
    categories: Optional[
        List[BackboneCommonModelsCommerceCommonProductCategoryItem]
    ] = Field([], title="Categories")
    created_on: Optional[DateTime] = Field(None, title="Created On")
    sku: Optional[str] = Field(None, title="Sku")
    barcode: Optional[str] = Field(None, title="Barcode")
    available_quantity: Optional[float] = Field(0, title="Available Quantity")
    prices: Optional[List[BackboneCommonModelsCommerceCommonProductPriceItem]] = Field(
        [], title="Prices"
    )
    unit_cost: Optional[ProductCostItem] = None
    unit_of_measure: Optional[str] = Field(None, title="Unit Of Measure")
    weight: Optional[float] = Field(0, title="Weight")
    weight_unit: Optional[str] = Field(None, title="Weight Unit")
    status: Optional[ProductStatus] = None
    variant_attributes: Optional[List[VariantAttributeItem]] = Field(
        [],
        description="List of attributes that are specific to the variant of the product.",
        title="Variant Attributes",
    )
    variant_images: Optional[List[ImageItem]] = Field(
        [],
        description="List of images that are specific to the variant of the product.",
        title="Variant Images",
    )


class ReadFlowTrigger(BaseModel):
    id: str = Field(..., title="Id")
    type: TriggerType
    cronschedule: Optional[str] = Field(None, title="Cronschedule")


class RefundItemOut(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    status: BackboneCommonModelsPaymentCommonPaymentStatus = Field(
        ..., description="Payment status"
    )
    description: str = Field(..., description="Description", title="Description")
    amount: float = Field(..., description="Amount", title="Amount")
    currency: str = Field(..., description="Currency", title="Currency")
    refund_date: DateTime = Field(
        ..., description="Date of creation", title="Refund Date"
    )
    payment_id: Optional[str] = Field(
        None, description="ID of the payment being refunded", title="Payment Id"
    )


class RefundOrderLineItem(BaseModel):
    id: str = Field(
        ..., description="Technical id of the order line in Chift", title="Id"
    )
    variant: Optional[OrderLineProductVariantItem] = Field(
        None, description="Product variant"
    )
    quantity: int = Field(..., title="Quantity")
    untaxed_amount: float = Field(
        ...,
        description="Untaxed amount refunded (after discount).",
        title="Untaxed Amount",
    )
    tax_amount: float = Field(
        ..., description="Total taxes refunded (after discount).", title="Tax Amount"
    )
    total: float = Field(
        ..., description="Total refunded (after discount).", title="Total"
    )


class ReservationItem(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    start_date: Optional[DateTime] = Field(
        None,
        description="Start date of the reservation",
        examples=["2024-10-01T12:00:00"],
        title="Start Date",
    )
    end_date: Optional[DateTime] = Field(
        None,
        description="End date of the reservation",
        examples=["2024-10-10T12:00:00"],
        title="End Date",
    )
    creation_date: Optional[DateTime] = Field(
        None,
        description="Creation date of the reservation",
        examples=["2024-09-25T12:00:00"],
        title="Creation Date",
    )
    resource_id: Optional[ChiftId] = Field(
        None, description="Unique reference to the resource related to the reservation"
    )
    resource_name: Optional[str] = Field(
        None,
        description="Name of the resource related to the reservation",
        examples=["Room 101"],
        title="Resource Name",
    )
    resource_identifier: Optional[str] = Field(
        None,
        description="Identifier of the resource related to the reservation",
        examples=["R101"],
        title="Resource Identifier",
    )


class ReturnOrderLineItem(BaseModel):
    id: str = Field(
        ..., description="Technical id of the order line in Chift", title="Id"
    )
    variant: Optional[OrderLineProductVariantItem] = Field(
        None, description="Product variant"
    )
    quantity: int = Field(..., title="Quantity")
    untaxed_amount: float = Field(
        ...,
        description="Untaxed amount refunded (after discount).",
        title="Untaxed Amount",
    )
    tax_amount: float = Field(
        ..., description="Total taxes refunded (after discount).", title="Tax Amount"
    )
    total: float = Field(
        ..., description="Total refunded (after discount).", title="Total"
    )


class SalesItem(BaseModel):
    total: float = Field(
        ...,
        description="Total amount including tax of the sales",
        examples=[10],
        title="Total",
    )
    tax_amount: float = Field(
        ..., description="Total amount of the taxes", examples=[1], title="Tax Amount"
    )
    taxes: Optional[List[TotalTaxItem]] = Field(
        [],
        description="List of taxes grouped by tax rateapplied to the sales",
        title="Taxes",
    )


class SupplierItemIn(BaseModel):
    external_reference: Optional[str] = Field(
        None,
        description="External identifier used to link the supplier in the accounting system with the corresponding supplier reference in your own system.",
        title="External Reference",
    )
    first_name: Optional[str] = Field(
        None,
        description="Only used when the supplier is an individual (is_company=false). Indicates the first name of the supplier.",
        title="First Name",
    )
    last_name: Optional[str] = Field(
        None,
        description="Only used when the supplier is an individual (is_company=false). Indicates the last name of the supplier.",
        title="Last Name",
    )
    name: constr(min_length=1) = Field(
        ...,
        description="Full name or legal name of the supplier (individual or company). This is the name that will be displayed in the accounting software.",
        title="Name",
    )
    function: Optional[str] = Field(
        None,
        description="Only used when the supplier is an individual (is_company=false). Indicates the function of the supplier.",
        title="Function",
    )
    is_company: Optional[bool] = Field(
        True,
        description="Indicates if the supplier is an individual or a company.",
        title="Is Company",
    )
    company_id: Optional[str] = Field(
        None,
        description="Only used when the supplier is an individual (is_company=false). Indicates the id of the company linked to the supplier.",
        title="Company Id",
    )
    phone: Optional[str] = Field(
        None, description="Phone number of the supplier.", title="Phone"
    )
    mobile: Optional[str] = Field(
        None, description="Mobile phone number of the supplier.", title="Mobile"
    )
    email: Optional[str] = Field(
        None, description="Email address of the supplier.", title="Email"
    )
    language: Optional[str] = Field(
        None,
        description="Language of the supplier. Format: ISO 639-1 codes.",
        title="Language",
    )
    internal_notes: Optional[str] = Field(
        None, description="Internal notes about the supplier.", title="Internal Notes"
    )
    website: Optional[str] = Field(
        None, description="Website of the supplier.", title="Website"
    )
    vat: Optional[str] = Field(
        None, description="VAT number of the supplier.", title="Vat"
    )
    iban: Optional[str] = Field(
        None, description="IBAN account number of the supplier.", title="Iban"
    )
    bank_account: Optional[str] = Field(
        None, description="Bank account number of the supplier.", title="Bank Account"
    )
    currency: Optional[str] = Field(
        None,
        description="Indicates the currency of the supplier (e.g., EUR).",
        title="Currency",
    )
    active: Optional[bool] = Field(
        True, description="Indicates if the supplier is active.", title="Active"
    )
    addresses: List[BackboneCommonModelsCommonAddressItemIn] = Field(
        ...,
        description="List of addresses associated with the supplier.",
        title="Addresses",
    )
    account_number: Optional[str] = Field(
        None,
        description="Number of ledger account assigned to the supplier in the accounting system as it will appear in the official accounting export file (FEC, SIE, iXBRL, etc.). This is typically the ledger account used for posting payables. In some systems, each supplier has a dedicated account; in others, a shared control account is used and supplier balances are tracked in a subledger.",
        title="Account Number",
    )


class SupplierItemOut(BaseModel):
    external_reference: Optional[str] = Field(
        None,
        description="External identifier used to link the supplier in the accounting system with the corresponding supplier reference in your own system.",
        title="External Reference",
    )
    first_name: Optional[str] = Field(
        None,
        description="Only used when the supplier is an individual (is_company=false). Indicates the first name of the supplier.",
        title="First Name",
    )
    last_name: Optional[str] = Field(
        None,
        description="Only used when the supplier is an individual (is_company=false). Indicates the last name of the supplier.",
        title="Last Name",
    )
    name: Optional[str] = Field(
        None,
        description="Full name or legal name of the supplier (individual or company). This is the name displayed in the accounting software.",
        title="Name",
    )
    function: Optional[str] = Field(
        None,
        description="Only used when the supplier is an individual (is_company=false). Indicates the function of the supplier.",
        title="Function",
    )
    is_company: Optional[bool] = Field(
        True,
        description="Indicates if the supplier is an individual or a company.",
        title="Is Company",
    )
    company_id: Optional[str] = Field(
        None,
        description="Only used when the supplier is an individual (is_company=false). Indicates the id of the company linked to the supplier.",
        title="Company Id",
    )
    phone: Optional[str] = Field(
        None, description="Phone number of the supplier.", title="Phone"
    )
    mobile: Optional[str] = Field(
        None, description="Mobile phone number of the supplier.", title="Mobile"
    )
    email: Optional[str] = Field(
        None, description="Email address of the supplier.", title="Email"
    )
    language: Optional[str] = Field(
        None,
        description="Language of the supplier. Format: ISO 639-1 codes.",
        title="Language",
    )
    internal_notes: Optional[str] = Field(
        None, description="Internal notes about the supplier.", title="Internal Notes"
    )
    website: Optional[str] = Field(
        None, description="Website of the supplier.", title="Website"
    )
    vat: Optional[str] = Field(
        None, description="VAT number of the supplier.", title="Vat"
    )
    iban: Optional[str] = Field(
        None, description="IBAN account number of the supplier.", title="Iban"
    )
    bank_account: Optional[str] = Field(
        None, description="Bank account number of the supplier.", title="Bank Account"
    )
    currency: Optional[str] = Field(
        None,
        description="Indicates the currency of the supplier (e.g., EUR).",
        title="Currency",
    )
    active: Optional[bool] = Field(
        True, description="Indicates if the supplier is active.", title="Active"
    )
    account_number: Optional[str] = Field(
        None,
        description="Ledger account number assigned to the supplier in the accounting system as it will appear in the official accounting export file (FEC, SIE, iXBRL, etc.).",
        title="Account Number",
    )
    company_number: Optional[str] = Field(
        None,
        description="Id of the associated company, used when the record is a contact person linked to a company.",
        title="Company Number",
    )
    id: Optional[str] = Field(
        None,
        description="Id of the supplier in the accounting software. This is the unique identifier used to reference the supplier in the system.",
        title="Id",
    )
    last_updated_on: Optional[DateTime] = Field(
        None,
        description="The last time the supplier has been updated.",
        title="Last Updated On",
    )
    addresses: Optional[List[BackboneCommonModelsCommonAddressItemOut]] = Field(
        [],
        description="List of addresses associated with the supplier.",
        title="Addresses",
    )


class SupplierItemUpdate(BaseModel):
    external_reference: Optional[str] = Field(
        None,
        description="External identifier used to link the supplier in the accounting system with the corresponding supplier reference in your own system.",
        title="External Reference",
    )
    first_name: Optional[str] = Field(
        None,
        description="Only used when the supplier is an individual (is_company=false). Indicates the first name of the supplier.",
        title="First Name",
    )
    last_name: Optional[str] = Field(
        None,
        description="Only used when the supplier is an individual (is_company=false). Indicates the last name of the supplier.",
        title="Last Name",
    )
    name: Optional[str] = Field(
        None,
        description="Full name or legal name of the supplier (individual or company). This is the name that will be displayed in the accounting software.",
        title="Name",
    )
    function: Optional[str] = Field(
        None,
        description="Only used when the supplier is an individual (is_company=false). Indicates the function of the supplier.",
        title="Function",
    )
    is_company: Optional[bool] = Field(
        True,
        description="Indicates if the supplier is an individual or a company.",
        title="Is Company",
    )
    company_id: Optional[str] = Field(
        None,
        description="Only used when the supplier is an individual (is_company=false). Indicates the id of the company linked to the supplier.",
        title="Company Id",
    )
    phone: Optional[str] = Field(
        None, description="Phone number of the supplier.", title="Phone"
    )
    mobile: Optional[str] = Field(
        None, description="Mobile phone number of the supplier.", title="Mobile"
    )
    email: Optional[str] = Field(
        None, description="Email address of the supplier.", title="Email"
    )
    language: Optional[str] = Field(
        None,
        description="Language of the supplier. Format: ISO 639-1 codes.",
        title="Language",
    )
    internal_notes: Optional[str] = Field(
        None, description="Internal notes about the supplier.", title="Internal Notes"
    )
    website: Optional[str] = Field(
        None, description="Website of the supplier.", title="Website"
    )
    vat: Optional[str] = Field(
        None, description="VAT number of the supplier.", title="Vat"
    )
    iban: Optional[str] = Field(
        None, description="IBAN account number of the supplier.", title="Iban"
    )
    bank_account: Optional[str] = Field(
        None, description="Bank account number of the supplier.", title="Bank Account"
    )
    currency: Optional[str] = Field(
        None,
        description="Indicates the currency of the supplier (e.g., EUR).",
        title="Currency",
    )
    active: Optional[bool] = Field(
        True, description="Indicates if the supplier is active.", title="Active"
    )
    addresses: Optional[List[AddressItemOutInput]] = Field(
        [],
        description="List of addresses associated with the supplier.",
        title="Addresses",
    )


class VariantItem(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    parent_id: str = Field(
        ...,
        description="Technical id of the parent product in Chift",
        title="Parent Id",
    )
    name: str = Field(..., title="Name")
    description: Optional[str] = Field(None, title="Description")
    description_html: Optional[str] = Field(None, title="Description Html")
    categories: Optional[
        List[BackboneCommonModelsCommerceCommonProductCategoryItem]
    ] = Field([], title="Categories")
    created_on: Optional[DateTime] = Field(None, title="Created On")
    sku: Optional[str] = Field(None, title="Sku")
    barcode: Optional[str] = Field(None, title="Barcode")
    available_quantity: Optional[float] = Field(0, title="Available Quantity")
    prices: Optional[List[BackboneCommonModelsCommerceCommonProductPriceItem]] = Field(
        [], title="Prices"
    )
    unit_cost: Optional[ProductCostItem] = None
    unit_of_measure: Optional[str] = Field(None, title="Unit Of Measure")
    weight: Optional[float] = Field(0, title="Weight")
    weight_unit: Optional[str] = Field(None, title="Weight Unit")
    status: Optional[ProductStatus] = None
    inventory_details: Optional[List[InventoryDetailsItem]] = Field(
        [], title="Inventory Details"
    )
    common_attributes: Optional[List[CommonAttributeItem]] = Field(
        [],
        description="List of attributes that are shared by all variants of the product.",
        title="Common Attributes",
    )
    variant_attributes: Optional[List[VariantAttributeItem]] = Field(
        [],
        description="List of attributes that are specific to the variant of the product.",
        title="Variant Attributes",
    )
    common_images: Optional[List[ImageItem]] = Field(
        [],
        description="List of images that are shared by all variants of the product.",
        title="Common Images",
    )
    variant_images: Optional[List[ImageItem]] = Field(
        [],
        description="List of images that are specific to the variant of the product.",
        title="Variant Images",
    )


class WelfareFund(BaseModel):
    rate: float = Field(..., description="Rate", title="Rate")
    amount: float = Field(..., description="Amount", title="Amount")
    type: Optional[WelfareFundType] = Field(None, description="Type")


class WithholdingTax(BaseModel):
    rate: float = Field(..., description="Rate", title="Rate")
    amount: float = Field(..., description="Amount", title="Amount")
    reason: Optional[WithholdingTaxReason] = Field(None, description="Reason")
    payment_reason: Optional[WithholdingTaxPaymentReason] = Field(
        None, description="Payment reason"
    )


class BackboneApiAppRoutersConnectionsConnectionItem(BaseModel):
    connectionid: UUID = Field(..., title="Connectionid")
    name: str = Field(..., title="Name")
    integration: str = Field(..., title="Integration")
    integrationid: int = Field(..., title="Integrationid")
    api: str = Field(..., title="Api")
    data: Optional[Dict[str, Any]] = Field(None, title="Data")
    status: Status
    agent: Optional[LocalAgentInfo] = Field(
        None,
        description="For local agent only. Indicates whether the local agent is up and running",
    )


class ChiftPageClientItemOut(BaseModel):
    items: List[ClientItemOut] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageCommerceCustomerItem(BaseModel):
    items: List[CommerceCustomerItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageCommerceLocationItemOut(BaseModel):
    items: List[CommerceLocationItemOut] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageContactItemOut(BaseModel):
    items: List[ContactItemOut] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageInvoicingPaymentItem(BaseModel):
    items: List[InvoicingPaymentItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageInvoicingPaymentMethodItem(BaseModel):
    items: List[InvoicingPaymentMethodItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageInvoicingVatCode(BaseModel):
    items: List[InvoicingVatCode] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageJournalEntryMonoAnalyticPlan(BaseModel):
    items: List[JournalEntryMonoAnalyticPlan] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageJournal(BaseModel):
    items: List[Journal] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageMiscellaneousOperationOut(BaseModel):
    items: List[MiscellaneousOperationOut] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageOpportunityItem(BaseModel):
    items: List[OpportunityItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPagePMSAccountingCategoryItem(BaseModel):
    items: List[PMSAccountingCategoryItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPagePMSCustomerItem(BaseModel):
    items: List[PMSCustomerItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPagePMSPaymentItem(BaseModel):
    items: List[PMSPaymentItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPagePMSPaymentMethods(BaseModel):
    items: List[PMSPaymentMethods] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPagePMSTaxRateItem(BaseModel):
    items: List[PMSTaxRateItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPagePOSPaymentItem(BaseModel):
    items: List[POSPaymentItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPagePOSProductItem(BaseModel):
    items: List[POSProductItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPagePaymentItemOut(BaseModel):
    items: List[PaymentItemOut] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPagePaymentMethodItem(BaseModel):
    items: List[PaymentMethodItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageProductItemOut(BaseModel):
    items: List[ProductItemOut] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageRefundItemOut(BaseModel):
    items: List[RefundItemOut] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageSupplierItemOut(BaseModel):
    items: List[SupplierItemOut] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ClosureItem(BaseModel):
    date: Date = Field(
        ..., description="Date of the closure", examples=["2025-01-01"], title="Date"
    )
    status: ClosureStates = Field(
        ..., description="Status of the closure", examples=["closed"]
    )
    closures: Optional[List[POSClosureInformationItem]] = Field(
        [], description="Info about closures related to specific day", title="Closures"
    )


class CreateSyncMappingToFieldItemInput(BaseModel):
    name: str = Field(..., title="Name")
    description: Optional[str] = Field(None, title="Description")
    display_order: Optional[int] = Field(0, title="Display Order")
    challenge_question: Optional[str] = Field(None, title="Challenge Question")
    source_field: FieldItem
    target_field: FieldItem
    display_delete: Optional[bool] = Field(False, title="Display Delete")
    logic: Optional[Dict[str, Any]] = Field(None, title="Logic")


class CreateSyncMappingToFieldItemOutput(BaseModel):
    name: str = Field(..., title="Name")
    description: Optional[str] = Field(None, title="Description")
    display_order: Optional[int] = Field(0, title="Display Order")
    challenge_question: Optional[str] = Field(None, title="Challenge Question")
    source_field: FieldItem
    target_field: FieldItem
    display_delete: Optional[bool] = Field(False, title="Display Delete")
    logic: Optional[Dict[str, Any]] = Field(None, title="Logic")


class FlowConfigInput(BaseModel):
    definitionFields: Optional[List[Dict[str, Any]]] = Field(
        None, title="Definitionfields"
    )
    doorkeyFields: Optional[List[Dict[str, Any]]] = Field(None, title="Doorkeyfields")
    customFields: Optional[List[Dict[str, Any]]] = Field(None, title="Customfields")
    datastores: Optional[List[FlowDataStoreItemInput]] = Field([], title="Datastores")


class FlowConfigOutput(BaseModel):
    definitionFields: Optional[List[Dict[str, Any]]] = Field(
        None, title="Definitionfields"
    )
    doorkeyFields: Optional[List[Dict[str, Any]]] = Field(None, title="Doorkeyfields")
    customFields: Optional[List[Dict[str, Any]]] = Field(None, title="Customfields")
    datastores: Optional[List[FlowDataStoreItemOutput]] = Field([], title="Datastores")


class GenericJournalEntry(BaseModel):
    reference: Optional[str] = Field(
        None,
        description="Optional reference field used to store an external or contextual identifier related to the entry. For example, it can be used to store a reference number, the invoice number issued by the suppllier or any other relevant information.",
        title="Reference",
    )
    due_date: Optional[Date] = Field(
        None,
        description="If the journal entry relates to an invoice, this is the due date for payment or settlement (format: YYYY-MM-DD).",
        title="Due Date",
    )
    journal_id: str = Field(
        ...,
        description="Id of the journal instance in the accounting system in which the journal entry is recorded.",
        title="Journal Id",
    )
    number: constr(min_length=1) = Field(
        ...,
        description="Unique 'number' of the journal entry in the accounting software. This is an internal number or ID assigned to the journal entry, not necessarily the label or number visible on an invoice. It is recommended to use this number for idempotency to prevent duplicate entries. Refer to the idempotency documentation in the Developer Guides for more details.",
        title="Number",
    )
    currency: constr(min_length=1) = Field(
        ...,
        description="Indicates the currency of the journal entry (e.g., EUR, USD).",
        title="Currency",
    )
    currency_exchange_rate: Optional[float] = Field(
        1,
        description="Indicates the exchange rate at the date of the journal entry. Must be filled in when creating the entry in another currency from the folder's default currency.",
        title="Currency Exchange Rate",
    )
    date: Date = Field(
        ...,
        description="Accounting date of the journal entry (format: YYYY-MM-DD). This is the date when the journal entry is recorded in the accounting system.",
        title="Date",
    )
    items: List[GenericJournalItem] = Field(
        ...,
        description="List of journal items that make up the journal entry. Each item represents a line in the journal entry, and the sum of debits must equal the sum of credits to ensure the entry is balanced. There must always be at least 2 lines/items.",
        min_length=2,
        title="Items",
    )
    pdf: Optional[str] = Field(
        None,
        description="Base 64 string representing the PDF attached to the item.",
        title="Pdf",
    )
    posted: Optional[bool] = Field(
        True,
        description="Indicates if the journal entry has been posted (finalized) in the accounting system. If not provided, it defaults to True.",
        title="Posted",
    )
    start_date: Optional[Date] = Field(
        None,
        description="Start date of the period covered by the journal entry (format: YYYY-MM-DD). This field should be used when the entry relates to prepaid income or expenses (accruals and deferrals), indicating when the covered period begins.",
        title="Start Date",
    )
    end_date: Optional[Date] = Field(
        None,
        description="End date of the period covered by the journal entry (format: YYYY-MM-DD). This field should be used when the entry relates to prepaid income or expenses (accruals and deferrals), indicating when the covered period ends.",
        title="End Date",
    )


class InvoiceItemOutput(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    invoice_number: Optional[str] = Field(
        ...,
        description="Number/sequence",
        examples=["INV-12345"],
        title="Invoice Number",
    )
    creation_date: Optional[DateTime] = Field(
        None,
        description="Creation date of the invoice",
        examples=["2023-10-01T12:00:00"],
        title="Creation Date",
    )
    closing_date: Optional[DateTime] = Field(
        None,
        description="Closing date of the invoice",
        examples=["2023-10-10T12:00:00"],
        title="Closing Date",
    )
    partners: Optional[List[InvoicePartnerItem]] = Field(
        None, description="List of partners related to the invoice", title="Partners"
    )


class InvoiceItemInMonoAnalyticPlan(BaseModel):
    invoice_type: BackboneCommonModelsAccountingCommonInvoiceType = Field(
        ..., description="Specifies the type of invoice"
    )
    invoice_number: Optional[str] = Field(
        None,
        description="Unique 'number' of the invoice instance in the accounting software. This is an internal reference number. if not specified, will be automatically generated according to the system’s numbering rules. It does not necessarily match the number displayed on an invoice.It is recommended to use this number for idempotency to prevent duplicate entries. Refer to the idempotency documentation in the Developer Guides for more details",
        title="Invoice Number",
    )
    currency: str = Field(
        ...,
        description="Code (e.g., USD, EUR) of the currency used for invoice amounts.",
        title="Currency",
    )
    untaxed_amount: float = Field(
        ...,
        description="Total amount of the invoice excluding taxes.",
        title="Untaxed Amount",
    )
    tax_amount: float = Field(
        ...,
        description="Total amount of tax applied to the invoice",
        title="Tax Amount",
    )
    total: float = Field(
        ...,
        description="Total amount of the invoice, including taxes (untaxed_amount + tax_amount).",
        title="Total",
    )
    reference: Optional[str] = Field(
        None,
        description="Optional reference field used to store an external or contextual identifier related to the entry. For purchase invoices, it typically contains the invoice number issued by the supplier. For sales invoices, it may reference a quote number or any other relevant document. Unlike number, this field is not subject to specific format or character restrictions and can hold free-form text.",
        title="Reference",
    )
    payment_communication: Optional[str] = Field(
        None,
        description="Field containing the payment reference or communication associated with the invoice (e.g., bank transfer reference, SEPA remittance message). Often used for reconciliation purposes.",
        title="Payment Communication",
    )
    customer_memo: Optional[str] = Field(
        None,
        description="Internal or external note associated with the invoice, typically intended for the customer. Can include additional context, comments, or special instructions related to the transaction.",
        title="Customer Memo",
    )
    invoice_date: Date = Field(
        ...,
        description="Accounting date of the invoice (format: YYYY-MM-DD).",
        title="Invoice Date",
    )
    due_date: Date = Field(
        ...,
        description="Due date for payment or settlement (format: YYYY-MM-DD).",
        title="Due Date",
    )
    partner_id: constr(min_length=1) = Field(
        ...,
        description="Id of the related third party (supplier or customer) in the accounting software. Used to link the invoice to the corresponding client or supplier record in the accounting system.",
        title="Partner Id",
    )
    journal_id: Optional[str] = Field(
        None,
        description="Identifier of the journal for the invoice. If not provided, the journal will be set automatically if only one exists; otherwise, an error will be thrown.",
        title="Journal Id",
    )
    status: Optional[InvoiceStatusIn] = "posted"
    pdf: Optional[str] = Field(
        None,
        description="Base 64 string representing the PDF attached to the invoice.",
        title="Pdf",
    )
    currency_exchange_rate: Optional[float] = Field(
        1,
        description="Exchange rate applicable at the date of the invoice. Required when the invoice currency is different from the folder's default currency.",
        title="Currency Exchange Rate",
    )
    invoice_correction: Optional[InvoiceCorrection] = Field(
        None,
        description="Information used to add a correction line when roundings have an impact on the total amount of the invoice.",
    )
    nl_payment_terms_split: Optional[NlPaymentTermsSplit] = Field(
        None,
        description="NL only - For Dutch split payment compliance (G/N-rekening): use to specify how invoice amounts are divided between a blocked (G) and normal (N) account in high-risk sectors (e.g., construction, staffing).",
    )
    shipping_country: Optional[str] = Field(
        None, description="Format: ISO 3166-1 codes.", title="Shipping Country"
    )
    partner_info: Optional[AccountToCreate] = Field(
        None,
        description="Information about the client/supplier that must be created. In some tools we cannot create a client/supplier by API. Missing clients/suppliers must be explicitly provided during the invoice creation and will be automatically created by the accounting software. This is for example the case for Tiime.",
    )
    lines: List[InvoiceLineItemInMonoAnalyticPlan] = Field(..., title="Lines")


class InvoiceItemInMultiAnalyticPlans(BaseModel):
    invoice_type: BackboneCommonModelsAccountingCommonInvoiceType = Field(
        ..., description="Specifies the type of invoice"
    )
    invoice_number: Optional[str] = Field(
        None,
        description="Unique 'number' of the invoice instance in the accounting software. This is an internal reference number. if not specified, will be automatically generated according to the system’s numbering rules. It does not necessarily match the number displayed on an invoice.It is recommended to use this number for idempotency to prevent duplicate entries. Refer to the idempotency documentation in the Developer Guides for more details",
        title="Invoice Number",
    )
    currency: str = Field(
        ...,
        description="Code (e.g., USD, EUR) of the currency used for invoice amounts.",
        title="Currency",
    )
    untaxed_amount: float = Field(
        ...,
        description="Total amount of the invoice excluding taxes.",
        title="Untaxed Amount",
    )
    tax_amount: float = Field(
        ...,
        description="Total amount of tax applied to the invoice",
        title="Tax Amount",
    )
    total: float = Field(
        ...,
        description="Total amount of the invoice, including taxes (untaxed_amount + tax_amount).",
        title="Total",
    )
    reference: Optional[str] = Field(
        None,
        description="Optional reference field used to store an external or contextual identifier related to the entry. For purchase invoices, it typically contains the invoice number issued by the supplier. For sales invoices, it may reference a quote number or any other relevant document. Unlike number, this field is not subject to specific format or character restrictions and can hold free-form text.",
        title="Reference",
    )
    payment_communication: Optional[str] = Field(
        None,
        description="Field containing the payment reference or communication associated with the invoice (e.g., bank transfer reference, SEPA remittance message). Often used for reconciliation purposes.",
        title="Payment Communication",
    )
    customer_memo: Optional[str] = Field(
        None,
        description="Internal or external note associated with the invoice, typically intended for the customer. Can include additional context, comments, or special instructions related to the transaction.",
        title="Customer Memo",
    )
    invoice_date: Date = Field(
        ...,
        description="Accounting date of the invoice (format: YYYY-MM-DD).",
        title="Invoice Date",
    )
    due_date: Date = Field(
        ...,
        description="Due date for payment or settlement (format: YYYY-MM-DD).",
        title="Due Date",
    )
    partner_id: constr(min_length=1) = Field(
        ...,
        description="Id of the related third party (supplier or customer) in the accounting software. Used to link the invoice to the corresponding client or supplier record in the accounting system.",
        title="Partner Id",
    )
    journal_id: Optional[str] = Field(
        None,
        description="Identifier of the journal for the invoice. If not provided, the journal will be set automatically if only one exists; otherwise, an error will be thrown.",
        title="Journal Id",
    )
    status: Optional[InvoiceStatusIn] = "posted"
    pdf: Optional[str] = Field(
        None,
        description="Base 64 string representing the PDF attached to the invoice.",
        title="Pdf",
    )
    currency_exchange_rate: Optional[float] = Field(
        1,
        description="Exchange rate applicable at the date of the invoice. Required when the invoice currency is different from the folder's default currency.",
        title="Currency Exchange Rate",
    )
    invoice_correction: Optional[InvoiceCorrection] = Field(
        None,
        description="Information used to add a correction line when roundings have an impact on the total amount of the invoice.",
    )
    nl_payment_terms_split: Optional[NlPaymentTermsSplit] = Field(
        None,
        description="NL only - For Dutch split payment compliance (G/N-rekening): use to specify how invoice amounts are divided between a blocked (G) and normal (N) account in high-risk sectors (e.g., construction, staffing).",
    )
    shipping_country: Optional[str] = Field(
        None, description="Format: ISO 3166-1 codes.", title="Shipping Country"
    )
    partner_info: Optional[AccountToCreate] = Field(
        None,
        description="Information about the client/supplier that must be created. In some tools we cannot create a client/supplier by API. Missing clients/suppliers must be explicitly provided during the invoice creation and will be automatically created by the accounting software. This is for example the case for Tiime.",
    )
    lines: List[InvoiceLineItemInMultiAnalyticPlans] = Field(..., title="Lines")


class InvoiceItemOutMonoAnalyticPlan(BaseModel):
    invoice_type: BackboneCommonModelsAccountingCommonInvoiceType = Field(
        ..., description="Specifies the type of invoice"
    )
    invoice_number: Optional[str] = Field(
        None,
        description="Unique 'number' of the invoice instance in the accounting software. This is an internal reference number. if not specified, will be automatically generated according to the system’s numbering rules. It does not necessarily match the number displayed on an invoice.It is recommended to use this number for idempotency to prevent duplicate entries. Refer to the idempotency documentation in the Developer Guides for more details",
        title="Invoice Number",
    )
    currency: str = Field(
        ...,
        description="Code (e.g., USD, EUR) of the currency used for invoice amounts.",
        title="Currency",
    )
    untaxed_amount: float = Field(
        ...,
        description="Total amount of the invoice excluding taxes.",
        title="Untaxed Amount",
    )
    tax_amount: float = Field(
        ...,
        description="Total amount of tax applied to the invoice",
        title="Tax Amount",
    )
    total: float = Field(
        ...,
        description="Total amount of the invoice, including taxes (untaxed_amount + tax_amount).",
        title="Total",
    )
    reference: Optional[str] = Field(
        None,
        description="Optional reference field used to store an external or contextual identifier related to the entry. For purchase invoices, it typically contains the invoice number issued by the supplier. For sales invoices, it may reference a quote number or any other relevant document. Unlike number, this field is not subject to specific format or character restrictions and can hold free-form text.",
        title="Reference",
    )
    payment_communication: Optional[str] = Field(
        None,
        description="Field containing the payment reference or communication associated with the invoice (e.g., bank transfer reference, SEPA remittance message). Often used for reconciliation purposes.",
        title="Payment Communication",
    )
    customer_memo: Optional[str] = Field(
        None,
        description="Internal or external note associated with the invoice, typically intended for the customer. Can include additional context, comments, or special instructions related to the transaction.",
        title="Customer Memo",
    )
    id: Optional[str] = Field(None, title="Id")
    invoice_date: Date = Field(
        ...,
        description="Accounting invoice date. It is automatically set to '1970-01-01' if the value is empty in the accounting system.",
        title="Invoice Date",
    )
    due_date: Date = Field(
        ...,
        description="Last Due date of the invoice. The invoice date is used when this information is not given by the software.",
        title="Due Date",
    )
    partner_id: str = Field(..., title="Partner Id")
    journal_id: Optional[str] = Field(
        None,
        description="Indicates the journal used in for the invoice. If the journal is not given, the journal will be automatically set if only one journal exists otherwise an error will be thrown.",
        title="Journal Id",
    )
    payments: Optional[List[Payment]] = Field(None, title="Payments")
    status: Optional[InvoiceStatusOut] = "posted"
    last_updated_on: Optional[DateTime] = Field(
        None,
        description="The last time the invoice has been updated.",
        title="Last Updated On",
    )
    partner: Optional[Partner] = Field(
        None,
        description="Extra information about the partner (client/supplier) linked to the invoice. To ensure this information is returned, you need to use the include_partner_info query parameter.",
    )
    due_dates: Optional[List[InvoiceItemDueDatesOut]] = Field(
        [], description="List of all due dates of the invoice.", title="Due Dates"
    )
    lines: List[InvoiceLineItemOutMonoAnalyticPlan] = Field(..., title="Lines")


class InvoiceItemOutMultiAnalyticPlans(BaseModel):
    invoice_type: BackboneCommonModelsAccountingCommonInvoiceType = Field(
        ..., description="Specifies the type of invoice"
    )
    invoice_number: Optional[str] = Field(
        None,
        description="Unique 'number' of the invoice instance in the accounting software. This is an internal reference number. if not specified, will be automatically generated according to the system’s numbering rules. It does not necessarily match the number displayed on an invoice.It is recommended to use this number for idempotency to prevent duplicate entries. Refer to the idempotency documentation in the Developer Guides for more details",
        title="Invoice Number",
    )
    currency: str = Field(
        ...,
        description="Code (e.g., USD, EUR) of the currency used for invoice amounts.",
        title="Currency",
    )
    untaxed_amount: float = Field(
        ...,
        description="Total amount of the invoice excluding taxes.",
        title="Untaxed Amount",
    )
    tax_amount: float = Field(
        ...,
        description="Total amount of tax applied to the invoice",
        title="Tax Amount",
    )
    total: float = Field(
        ...,
        description="Total amount of the invoice, including taxes (untaxed_amount + tax_amount).",
        title="Total",
    )
    reference: Optional[str] = Field(
        None,
        description="Optional reference field used to store an external or contextual identifier related to the entry. For purchase invoices, it typically contains the invoice number issued by the supplier. For sales invoices, it may reference a quote number or any other relevant document. Unlike number, this field is not subject to specific format or character restrictions and can hold free-form text.",
        title="Reference",
    )
    payment_communication: Optional[str] = Field(
        None,
        description="Field containing the payment reference or communication associated with the invoice (e.g., bank transfer reference, SEPA remittance message). Often used for reconciliation purposes.",
        title="Payment Communication",
    )
    customer_memo: Optional[str] = Field(
        None,
        description="Internal or external note associated with the invoice, typically intended for the customer. Can include additional context, comments, or special instructions related to the transaction.",
        title="Customer Memo",
    )
    id: Optional[str] = Field(None, title="Id")
    invoice_date: Date = Field(
        ...,
        description="Accounting invoice date. It is automatically set to '1970-01-01' if the value is empty in the accounting system.",
        title="Invoice Date",
    )
    due_date: Date = Field(
        ...,
        description="Last Due date of the invoice. The invoice date is used when this information is not given by the software.",
        title="Due Date",
    )
    partner_id: str = Field(..., title="Partner Id")
    journal_id: Optional[str] = Field(
        None,
        description="Indicates the journal used in for the invoice. If the journal is not given, the journal will be automatically set if only one journal exists otherwise an error will be thrown.",
        title="Journal Id",
    )
    payments: Optional[List[Payment]] = Field(None, title="Payments")
    status: Optional[InvoiceStatusOut] = "posted"
    last_updated_on: Optional[DateTime] = Field(
        None,
        description="The last time the invoice has been updated.",
        title="Last Updated On",
    )
    partner: Optional[Partner] = Field(
        None,
        description="Extra information about the partner (client/supplier) linked to the invoice. To ensure this information is returned, you need to use the include_partner_info query parameter.",
    )
    due_dates: Optional[List[InvoiceItemDueDatesOut]] = Field(
        [], description="List of all due dates of the invoice.", title="Due Dates"
    )
    lines: List[InvoiceLineItemOutMultiAnalyticPlans] = Field(..., title="Lines")


class ItalianSpecificitiesInput(BaseModel):
    stamp_duty_amount: Optional[float] = Field(
        None,
        description="Documentary stamp tax (specific to Italy)",
        title="Stamp Duty Amount",
    )
    withholding_tax: Optional[WithholdingTax] = Field(
        None, description="Withholding tax (specific to Italy)"
    )
    welfare_fund: Optional[WelfareFund] = Field(
        None, description="Welfare fund (specific to Italy)"
    )
    payment_reporting: Optional[PaymentReporting] = Field(
        None, description="Payment reporting (specific to Italy)"
    )


class ItalianSpecificitiesOutput(BaseModel):
    stamp_duty_amount: Optional[float] = Field(
        None,
        description="Documentary stamp tax (specific to Italy)",
        title="Stamp Duty Amount",
    )
    withholding_tax: Optional[WithholdingTax] = Field(
        None, description="Withholding tax (specific to Italy)"
    )
    welfare_fund: Optional[WelfareFund] = Field(
        None, description="Welfare fund (specific to Italy)"
    )
    payment_reporting: Optional[PaymentReporting] = Field(
        None, description="Payment reporting (specific to Italy)"
    )


class JournalEntryMultiAnalyticPlan(BaseModel):
    reference: Optional[str] = Field(
        None,
        description="Optional reference field used to store an external or contextual identifier related to the entry. For example, it can be used to store a reference number, the invoice number issued by the suppllier or any other relevant information.",
        title="Reference",
    )
    due_date: Optional[Date] = Field(
        None,
        description="If the journal entry relates to an invoice, this is the due date for payment or settlement (format: YYYY-MM-DD).",
        title="Due Date",
    )
    journal_id: str = Field(
        ...,
        description="Id of the journal instance in the accounting system in which the journal entry is recorded.",
        title="Journal Id",
    )
    name: Optional[str] = Field(None, title="Name")
    journal_name: Optional[str] = Field(
        None,
        description="Name of the journal in which the journal entry is recorded.",
        title="Journal Name",
    )
    date: Optional[Date] = Field(
        "1970-01-01",
        description="Accounting date of the journal entry. It is automatically set to '1970-01-01' if the value is not available/empty in the accounting system.",
        title="Date",
    )
    posted: Optional[bool] = Field(
        False,
        description="Indicates if the journal entry has been posted (finalized) in the accounting system.",
        title="Posted",
    )
    id: str = Field(
        ...,
        description="Unique id of the journal entry instance in the accounting system.",
        title="Id",
    )
    due_dates: Optional[List[JournalItemDueDatesOut]] = Field(
        [], description="List of all due dates of a journal entry.", title="Due Dates"
    )
    items: Optional[List[JournalItemMultiAnalyticPlan]] = Field(
        [],
        description="List of journal items that make up the journal entry. Each item represents a line in the journal entry, and the sum of debits must equal the sum of credits to ensure the entry is balanced.",
        title="Items",
    )


class MiscellaneousOperationIn(BaseModel):
    operation_number: Optional[str] = Field(None, title="Operation Number")
    currency: str = Field(
        ...,
        description="Indicates the currency of the operation (e.g., EUR, USD).",
        title="Currency",
    )
    currency_exchange_rate: Optional[float] = Field(
        1,
        description="Indicates the exchange rate at the date of the operation. Must be filled in when creating the operation in another currency from the folder's default currency.",
        title="Currency Exchange Rate",
    )
    lines: List[MiscellaneousOperationLine] = Field(..., title="Lines")
    operation_date: Date = Field(..., title="Operation Date")
    journal_id: Optional[str] = Field(
        None,
        description="Indicates the journal used in for the operation. If the journal is not given, the journal will be automatically set if only one journal exists otherwise an error will be thrown.",
        title="Journal Id",
    )
    status: Optional[MiscellaneousOperationStatusIn] = "posted"


class OrderLineItemOut(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    created_on: Optional[DateTime] = Field(None, title="Created On")
    variant: Optional[OrderLineProductVariantItem] = Field(
        None, description="Product variant"
    )
    quantity: int = Field(..., title="Quantity")
    current_quantity: int = Field(
        ...,
        description="Quantity without refunds and returns.",
        title="Current Quantity",
    )
    unit_price: float = Field(
        ..., description="Unit price of the product without taxes.", title="Unit Price"
    )
    description: str = Field(..., title="Description")
    tax_id: Optional[str] = Field(
        None, description="Technical id of the tax rate in Chift", title="Tax Id"
    )
    tax_rate: float = Field(
        ...,
        description="Indicates the tax rate used for the line (e.g. 21.0).",
        title="Tax Rate",
    )
    untaxed_amount: float = Field(
        ...,
        description="Untaxed amount of the order line with discount.",
        title="Untaxed Amount",
    )
    tax_amount: float = Field(
        ..., description="Total taxes applied to the order line.", title="Tax Amount"
    )
    total: float = Field(
        ..., description="Total of the order line with discount.", title="Total"
    )
    discounts: Optional[List[BackboneCommonModelsCommerceCommonDiscountItem]] = Field(
        [], title="Discounts"
    )
    gift_card: Optional[bool] = Field(False, title="Gift Card")


class OrderRefundItem(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    created_on: Optional[DateTime] = Field(None, title="Created On")
    total: float = Field(..., title="Total")
    reason: Optional[str] = Field(None, title="Reason")
    order_lines: Optional[List[RefundOrderLineItem]] = Field([], title="Order Lines")
    other: Optional[float] = Field(0, title="Other")
    shipping_refunds: Optional[List[ShippingRefund]] = Field(
        [], title="Shipping Refunds"
    )
    other_fees: Optional[List[RefundFeesItem]] = Field([], title="Other Fees")
    transactions: Optional[List[OrderTransactions]] = Field([], title="Transactions")


class OrderReturnItem(BaseModel):
    id: str = Field(..., description="Technical id of the return in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    created_on: Optional[DateTime] = Field(None, title="Created On")
    order_lines: Optional[List[ReturnOrderLineItem]] = Field([], title="Order Lines")
    new_lines: Optional[List[ReturnOrderLineItem]] = Field([], title="New Lines")
    linked_fees: Optional[List[ReturnFeesItem]] = Field([], title="Linked Fees")


class PMSClosureItem(BaseModel):
    date: Date = Field(
        ..., description="Date of the closure", examples=["2025-01-01"], title="Date"
    )
    status: ClosureStates = Field(
        ..., description="Status of the closure", examples=["closed"]
    )
    closures: Optional[List[POSClosureInformationItem]] = Field(
        [], description="Info about closures related to specific day", title="Closures"
    )


class PMSInvoiceFullItem(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    invoice_number: Optional[str] = Field(
        ...,
        description="Number/sequence",
        examples=["INV-12345"],
        title="Invoice Number",
    )
    creation_date: Optional[DateTime] = Field(
        None,
        description="Creation date of the invoice",
        examples=["2023-10-01T12:00:00"],
        title="Creation Date",
    )
    closing_date: Optional[DateTime] = Field(
        None,
        description="Closing date of the invoice",
        examples=["2023-10-10T12:00:00"],
        title="Closing Date",
    )
    partners: Optional[List[InvoicePartnerItem]] = Field(
        None, description="List of partners related to the invoice", title="Partners"
    )
    items: List[PMSOrderLineItem] = Field(
        ..., description="List of items related to the invoice", title="Items"
    )
    payments: List[PMSPaymentItem] = Field(
        ..., description="List of payments related to the invoice", title="Payments"
    )
    service_id: Optional[str] = Field(
        None,
        description="Reference to the service related to this order",
        title="Service Id",
    )
    reservation: Optional[ReservationItem] = Field(
        None, description="Reference to the reservation related to this order"
    )
    tax_amount: float = Field(
        ..., description="Taxes amount", examples=[21.0], title="Tax Amount"
    )
    untaxed_amount: float = Field(
        ..., description="Untaxed amount", examples=[100.0], title="Untaxed Amount"
    )
    total: float = Field(
        ..., description="Total amount incl. taxes", examples=[121.0], title="Total"
    )


class PMSOrderItem(BaseModel):
    id: str = Field(
        ..., description="Unique identifier of the order", examples=["123"], title="Id"
    )
    source_ref: Ref = Field(..., description="Technical id in the target software")
    order_number: Optional[str] = Field(
        None,
        description="Order number (often unique reference during the day)",
        examples=["1"],
        title="Order Number",
    )
    creation_date: DateTime = Field(
        ...,
        description="Creation date of the order",
        examples=["2025-01-01T00:00:00Z"],
        title="Creation Date",
    )
    closing_date: Optional[DateTime] = Field(
        None,
        description="Closing date of the order",
        examples=["2025-01-01T00:00:00Z"],
        title="Closing Date",
    )
    service_date: Optional[DateTime] = Field(
        None,
        description="Indicates the date of the service to which the order belongs (can be used to group orders by closure date)",
        examples=["2025-01-01T00:00:00Z"],
        title="Service Date",
    )
    device_id: Optional[str] = Field(
        None,
        description="ID of device that created the order",
        examples=["device-123"],
        title="Device Id",
    )
    total: float = Field(
        ...,
        description="Total amount including tax of the order",
        examples=[11],
        title="Total",
    )
    tax_amount: float = Field(
        ...,
        description="Total amount of the taxes of the order",
        examples=[1],
        title="Tax Amount",
    )
    total_discount: Optional[float] = Field(
        "0",
        description="Total amount of the discounts of the order",
        examples=[10],
        title="Total Discount",
    )
    total_refund: Optional[float] = Field(
        "0",
        description="Total amount of the refunds of the order",
        examples=[5],
        title="Total Refund",
    )
    total_tip: Optional[float] = Field(
        "0",
        description="Total amount of the tips of the order. Tips are not part of the total of the order",
        examples=[1],
        title="Total Tip",
    )
    delivery_fee: Optional[float] = Field(
        "0",
        description="Total amount of the delivery fees of the order",
        examples=[1],
        title="Delivery Fee",
    )
    currency: Optional[str] = Field(
        None, description="Currency of the order", examples=["EUR"], title="Currency"
    )
    country: Optional[str] = Field(
        None,
        description="Country of the order, format: ISO 3166-1 codes.",
        examples=["FR"],
        title="Country",
    )
    loyalty: Optional[int] = Field(
        None, description="Loyalty points of the order", examples=[100], title="Loyalty"
    )
    customer_id: Optional[str] = Field(
        None,
        description="Unique identifier of the customer",
        examples=["customer-123"],
        title="Customer Id",
    )
    location_id: Optional[str] = Field(
        None,
        description="Unique identifier of the location",
        examples=["location-123"],
        title="Location Id",
    )
    taxes: Optional[List[TotalTaxItem]] = Field(
        [], description="List of taxes of the order", title="Taxes"
    )
    guests: Optional[int] = Field(
        None,
        description="Number of guests linked to the order",
        examples=[1],
        title="Guests",
    )
    items: List[PMSOrderLineItem] = Field(
        ..., description="List of items related to the order", title="Items"
    )
    service_id: Optional[str] = Field(
        None,
        description="Reference to the service related to this order",
        title="Service Id",
    )
    reservation: Optional[ReservationItem] = Field(
        None, description="Reference to the reservation related to this order"
    )
    bills: Optional[List[InvoiceItemOutput]] = Field(
        None, description="Reference to the bills related to this order", title="Bills"
    )


class POSOrderItem(BaseModel):
    id: str = Field(
        ...,
        description="Unique identifier of the order",
        examples=["371ca583-d218-4900-b236-397532cf0e52"],
        title="Id",
    )
    order_number: Optional[str] = Field(
        None,
        description="Order number (often unique reference during the day)",
        examples=["1"],
        title="Order Number",
    )
    creation_date: DateTime = Field(
        ...,
        description="Creation date of the order",
        examples=["2025-01-01T00:00:00Z"],
        title="Creation Date",
    )
    closing_date: Optional[DateTime] = Field(
        None,
        description="Closing date of the order",
        examples=["2025-01-01T00:00:00Z"],
        title="Closing Date",
    )
    service_date: Optional[DateTime] = Field(
        None,
        description="Indicates the date of the service to which the order belongs (can be used to group orders by closure date)",
        examples=["2025-01-01T00:00:00Z"],
        title="Service Date",
    )
    device_id: Optional[str] = Field(
        None,
        description="ID of device that created the order",
        examples=["device-123"],
        title="Device Id",
    )
    total: float = Field(
        ...,
        description="Total amount including tax of the order",
        examples=[11],
        title="Total",
    )
    tax_amount: float = Field(
        ...,
        description="Total amount of the taxes of the order",
        examples=[1],
        title="Tax Amount",
    )
    total_discount: Optional[float] = Field(
        "0",
        description="Total amount of the discounts of the order",
        examples=[10],
        title="Total Discount",
    )
    total_refund: Optional[float] = Field(
        "0",
        description="Total amount of the refunds of the order",
        examples=[5],
        title="Total Refund",
    )
    total_tip: Optional[float] = Field(
        "0",
        description="Total amount of the tips of the order. Tips are not part of the total of the order",
        examples=[1],
        title="Total Tip",
    )
    delivery_fee: Optional[float] = Field(
        "0",
        description="Total amount of the delivery fees of the order",
        examples=[1],
        title="Delivery Fee",
    )
    currency: Optional[str] = Field(
        None, description="Currency of the order", examples=["EUR"], title="Currency"
    )
    country: Optional[str] = Field(
        None,
        description="Country of the order, format: ISO 3166-1 codes.",
        examples=["FR"],
        title="Country",
    )
    loyalty: Optional[int] = Field(
        None, description="Loyalty points of the order", examples=[100], title="Loyalty"
    )
    customer_id: Optional[str] = Field(
        None,
        description="Unique identifier of the customer",
        examples=["customer-123"],
        title="Customer Id",
    )
    location_id: Optional[str] = Field(
        None,
        description="Unique identifier of the location",
        examples=["location-123"],
        title="Location Id",
    )
    taxes: Optional[List[TotalTaxItem]] = Field(
        [], description="List of taxes of the order", title="Taxes"
    )
    guests: Optional[int] = Field(
        None,
        description="Number of guests linked to the order",
        examples=[1],
        title="Guests",
    )
    payments: List[POSPaymentItem] = Field(
        ..., description="List of payments made for the order", title="Payments"
    )
    items: List[POSItem] = Field(
        ..., description="List of item lines in the order", title="Items"
    )


class ProductItemOutput(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    name: str = Field(..., title="Name")
    description: Optional[str] = Field(None, title="Description")
    description_html: Optional[str] = Field(None, title="Description Html")
    categories: Optional[
        List[BackboneCommonModelsCommerceCommonProductCategoryItem]
    ] = Field([], title="Categories")
    created_on: Optional[DateTime] = Field(None, title="Created On")
    last_updated_on: Optional[DateTime] = Field(None, title="Last Updated On")
    variants: Optional[List[ProductVariantItem]] = Field([], title="Variants")
    status: Optional[ProductStatus] = None
    sku: Optional[str] = Field(None, title="Sku")
    common_attributes: Optional[List[CommonAttributeItem]] = Field(
        [],
        description="List of attributes that are shared by all variants of the product.",
        title="Common Attributes",
    )
    variant_attributes_options: Optional[List[VariantAttributeOptionItem]] = Field(
        [], title="Variant Attributes Options"
    )
    common_images: Optional[List[ImageItem]] = Field(
        [],
        description="List of images that are shared by all variants of the product.",
        title="Common Images",
    )


class ReadFlowConsumerItem(BaseModel):
    name: str = Field(..., title="Name")
    description: Optional[str] = Field(None, title="Description")
    id: str = Field(..., title="Id")
    config: Optional[FlowConfigOutput] = None
    values: Dict[str, Any] = Field(..., title="Values")
    enabled_on: Optional[DateTime] = Field(
        None,
        description="Date on which the flow was enabled for this consumer",
        title="Enabled On",
    )
    trigger: ReadFlowTrigger


class ReadFlowItem(BaseModel):
    name: str = Field(..., title="Name")
    description: Optional[str] = Field(None, title="Description")
    id: str = Field(..., title="Id")
    execution: Optional[FlowExecution] = None
    config: Optional[FlowConfigOutput] = {"datastores": []}
    triggers: Optional[List[FlowTrigger]] = Field(None, title="Triggers")


class SyncConsumerItem(BaseModel):
    syncid: UUID = Field(..., title="Syncid")
    sync_name: str = Field(..., description="Name of the sync", title="Sync Name")
    status: Optional[SyncConsumerStatus] = Field(
        "inactive",
        description="Indicates whether the consumer has setup the sync. If the setup is complete, it will return 'active'. Otherwise 'inactive'.",
    )
    status_details: Optional[str] = Field(
        None,
        description="Gives additional information if the status is inactive",
        title="Status Details",
    )
    link_createdon: DateTime = Field(
        ...,
        description="Date on which the consumer first navigated to the link to setup the sync",
        title="Link Createdon",
    )
    link_mappings: Optional[List[ReadSyncMappingItem]] = Field(
        None,
        description="Values of the mappings requested for the sync for the specific consumer",
        title="Link Mappings",
    )
    link_metadata: Optional[Dict[str, Any]] = Field(
        None, description="Metadata passed during creation", title="Link Metadata"
    )
    enabled_flows: Optional[List[ReadFlowConsumerItem]] = Field(
        None,
        description="List of flows that the consumer has enabled",
        title="Enabled Flows",
    )


class ChiftPageInvoiceItemOutMonoAnalyticPlan(BaseModel):
    items: List[InvoiceItemOutMonoAnalyticPlan] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageInvoiceItemOutMultiAnalyticPlans(BaseModel):
    items: List[InvoiceItemOutMultiAnalyticPlans] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageJournalEntryMultiAnalyticPlan(BaseModel):
    items: List[JournalEntryMultiAnalyticPlan] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPagePMSInvoiceFullItem(BaseModel):
    items: List[PMSInvoiceFullItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPagePMSOrderItem(BaseModel):
    items: List[PMSOrderItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPagePOSOrderItem(BaseModel):
    items: List[POSOrderItem] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageProductItem(BaseModel):
    items: List[ProductItemOutput] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class CreateFlowItem(BaseModel):
    name: str = Field(..., title="Name")
    description: Optional[str] = Field(None, title="Description")
    execution: FlowExecution
    config: Optional[FlowConfigInput] = {"datastores": []}
    triggers: List[FlowTrigger] = Field(..., title="Triggers")


class CreateSyncMappingItemInput(BaseModel):
    name: str = Field(..., title="Name")
    description: Optional[str] = Field(None, title="Description")
    display_order: Optional[int] = Field(0, title="Display Order")
    challenge_question: Optional[str] = Field(None, title="Challenge Question")
    sub_mappings: Optional[List[CreateSyncMappingToFieldItemInput]] = Field(
        [], title="Sub Mappings"
    )


class CreateSyncMappingItemOutput(BaseModel):
    name: str = Field(..., title="Name")
    description: Optional[str] = Field(None, title="Description")
    display_order: Optional[int] = Field(0, title="Display Order")
    challenge_question: Optional[str] = Field(None, title="Challenge Question")
    sub_mappings: Optional[List[CreateSyncMappingToFieldItemOutput]] = Field(
        [], title="Sub Mappings"
    )


class InvoiceItemInput(BaseModel):
    currency: str = Field(
        ..., description="Currency matching target sofware name", title="Currency"
    )
    invoice_type: BackboneCommonModelsInvoicingCommonInvoiceType = Field(
        ..., description="Invoice type"
    )
    status: InvoiceStatus = Field(..., description="Status")
    invoice_date: Date = Field(..., description="Invoicing date", title="Invoice Date")
    tax_amount: float = Field(..., description="Taxes amount", title="Tax Amount")
    untaxed_amount: float = Field(
        ..., description="Untaxed amount", title="Untaxed Amount"
    )
    total: float = Field(..., description="Total amount incl. taxes", title="Total")
    lines: Optional[List[InvoiceLineItem]] = Field(
        [], description="Invoice lines", title="Lines"
    )
    partner_id: Optional[str] = Field(
        None,
        description="Technical id of the vendor/customer in Chift",
        title="Partner Id",
    )
    invoice_number: Optional[str] = Field(
        None, description="Number/sequence", title="Invoice Number"
    )
    due_date: Optional[Date] = Field(None, description="Due date", title="Due Date")
    reference: Optional[str] = Field(None, description="Reference", title="Reference")
    payment_communication: Optional[str] = Field(
        None, description="Payment communication", title="Payment Communication"
    )
    customer_memo: Optional[str] = Field(
        None, description="Customer note/memo", title="Customer Memo"
    )
    journal_ref: Optional[FieldRef] = Field(None, description="Journal")
    italian_specificities: Optional[ItalianSpecificitiesInput] = Field(
        None, description="Specificities for Italy"
    )


class InvoiceItemOut(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    currency: str = Field(
        ..., description="Currency matching target sofware name", title="Currency"
    )
    invoice_type: BackboneCommonModelsInvoicingCommonInvoiceType = Field(
        ..., description="Invoice type"
    )
    status: InvoiceStatus = Field(..., description="Status")
    invoice_date: Date = Field(..., description="Invoicing date", title="Invoice Date")
    tax_amount: float = Field(..., description="Taxes amount", title="Tax Amount")
    untaxed_amount: float = Field(
        ..., description="Untaxed amount", title="Untaxed Amount"
    )
    total: float = Field(..., description="Total amount incl. taxes", title="Total")
    lines: Optional[List[InvoiceLineItem]] = Field(
        [], description="Invoice lines", title="Lines"
    )
    partner_id: Optional[str] = Field(
        None,
        description="Technical id of the vendor/customer in Chift",
        title="Partner Id",
    )
    invoice_number: Optional[str] = Field(
        None, description="Number/sequence", title="Invoice Number"
    )
    due_date: Optional[Date] = Field(None, description="Due date", title="Due Date")
    reference: Optional[str] = Field(None, description="Reference", title="Reference")
    payment_communication: Optional[str] = Field(
        None, description="Payment communication", title="Payment Communication"
    )
    customer_memo: Optional[str] = Field(
        None, description="Customer note/memo", title="Customer Memo"
    )
    journal_ref: Optional[FieldRef] = Field(None, description="Journal")
    italian_specificities: Optional[ItalianSpecificitiesOutput] = Field(
        None, description="Specificities for Italy"
    )
    last_updated_on: Optional[DateTime] = Field(None, title="Last Updated On")
    outstanding_amount: Optional[float] = Field(
        None, description="Amount left to be paid", title="Outstanding Amount"
    )
    last_payment_date: Optional[Date] = Field(
        None,
        description="Date of the last payment linked to the invoice",
        title="Last Payment Date",
    )
    accounting_date: Optional[Date] = Field(
        None, description="Accounting date", title="Accounting Date"
    )
    payment_method_id: Optional[str] = Field(
        None,
        description="Technical id of the payment method in Chift",
        title="Payment Method Id",
    )
    currency_exchange_rate: Optional[float] = Field(
        1,
        description="Indicates the exchange rate at the date of the invoice.",
        title="Currency Exchange Rate",
    )


class InvoiceItemOutSingle(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    currency: str = Field(
        ..., description="Currency matching target sofware name", title="Currency"
    )
    invoice_type: BackboneCommonModelsInvoicingCommonInvoiceType = Field(
        ..., description="Invoice type"
    )
    status: InvoiceStatus = Field(..., description="Status")
    invoice_date: Date = Field(..., description="Invoicing date", title="Invoice Date")
    tax_amount: float = Field(..., description="Taxes amount", title="Tax Amount")
    untaxed_amount: float = Field(
        ..., description="Untaxed amount", title="Untaxed Amount"
    )
    total: float = Field(..., description="Total amount incl. taxes", title="Total")
    lines: Optional[List[InvoiceLineItem]] = Field(
        [], description="Invoice lines", title="Lines"
    )
    partner_id: Optional[str] = Field(
        None,
        description="Technical id of the vendor/customer in Chift",
        title="Partner Id",
    )
    invoice_number: Optional[str] = Field(
        None, description="Number/sequence", title="Invoice Number"
    )
    due_date: Optional[Date] = Field(None, description="Due date", title="Due Date")
    reference: Optional[str] = Field(None, description="Reference", title="Reference")
    payment_communication: Optional[str] = Field(
        None, description="Payment communication", title="Payment Communication"
    )
    customer_memo: Optional[str] = Field(
        None, description="Customer note/memo", title="Customer Memo"
    )
    journal_ref: Optional[FieldRef] = Field(None, description="Journal")
    italian_specificities: Optional[ItalianSpecificitiesOutput] = Field(
        None, description="Specificities for Italy"
    )
    last_updated_on: Optional[DateTime] = Field(None, title="Last Updated On")
    outstanding_amount: Optional[float] = Field(
        None, description="Amount left to be paid", title="Outstanding Amount"
    )
    last_payment_date: Optional[Date] = Field(
        None,
        description="Date of the last payment linked to the invoice",
        title="Last Payment Date",
    )
    accounting_date: Optional[Date] = Field(
        None, description="Accounting date", title="Accounting Date"
    )
    payment_method_id: Optional[str] = Field(
        None,
        description="Technical id of the payment method in Chift",
        title="Payment Method Id",
    )
    currency_exchange_rate: Optional[float] = Field(
        1,
        description="Indicates the exchange rate at the date of the invoice.",
        title="Currency Exchange Rate",
    )
    pdf: Optional[str] = Field(None, description="PDF document in base64", title="Pdf")


class OrderItemOut(BaseModel):
    id: str = Field(..., description="Technical id in Chift", title="Id")
    source_ref: Ref = Field(..., description="Technical id in the target software")
    order_number: Optional[str] = Field(None, title="Order Number")
    customer: Optional[OrderCustomerItemOut] = None
    billing_address: Optional[BackboneCommonModelsCommerceCommonAddressItemOut] = None
    shipping_address: Optional[BackboneCommonModelsCommerceCommonAddressItemOut] = None
    created_on: Optional[DateTime] = Field(None, title="Created On")
    last_updated_on: Optional[DateTime] = Field(None, title="Last Updated On")
    confirmed_on: Optional[DateTime] = Field(None, title="Confirmed On")
    delivery_date: Optional[DateTime] = Field(None, title="Delivery Date")
    cancelled_on: Optional[DateTime] = Field(None, title="Cancelled On")
    status: OrderStatus
    discount_amount: float = Field(..., title="Discount Amount")
    untaxed_amount_without_fees: float = Field(
        ...,
        description="Untaxed amount without fees (e.g. shipping) but with discout. Refunds and returns are not included.",
        title="Untaxed Amount Without Fees",
    )
    tax_amount_without_fees: float = Field(
        ...,
        description="Total taxes applied to the order without taxes linked to fees (e.g. shipping).",
        title="Tax Amount Without Fees",
    )
    total_without_fees: float = Field(
        ...,
        description="Total of the order without fees (e.g. shipping) but with discount. Refunds and returns are not included.",
        title="Total Without Fees",
    )
    current_untaxed_amount: float = Field(
        ...,
        description="Untaxed amount with discout and any kind of fee (e.g. shipping). After returns, removes and returns.",
        title="Current Untaxed Amount",
    )
    current_tax_amount: float = Field(
        ...,
        description="Total taxes applied to the order. After returns, removes and returns.",
        title="Current Tax Amount",
    )
    current_total: float = Field(
        ...,
        description="Current total of the order with discount. After returns, removes and returns.",
        title="Current Total",
    )
    untaxed_amount: float = Field(
        ...,
        description="Untaxed amount with discout and any kind of fee (e.g. shipping). Refunds and returns are not included.",
        title="Untaxed Amount",
    )
    tax_amount: float = Field(
        ...,
        description="Total taxes applied to the order. Refunds and returns are not included.",
        title="Tax Amount",
    )
    total: float = Field(
        ...,
        description="Total of the order with discount. Refunds and returns are not included.",
        title="Total",
    )
    refunded_amount: Optional[float] = Field(0, title="Refunded Amount")
    currency: str = Field(
        ...,
        description="Indicates the currency of the order (e.g. EUR).",
        title="Currency",
    )
    note: Optional[str] = Field(None, title="Note")
    tags: Optional[List[str]] = Field([], title="Tags")
    lines: List[OrderLineItemOut] = Field(..., title="Lines")
    other_fees: Optional[List[FeesItem]] = Field([], title="Other Fees")
    payment_method_id: Optional[str] = Field(
        None,
        description="Technical id of the payment method in the eCommerce",
        title="Payment Method Id",
    )
    transactions: Optional[List[OrderTransactions]] = Field([], title="Transactions")
    payment_methods: Optional[List[OrderPaymentMethods]] = Field(
        [], title="Payment Methods"
    )
    detailed_refunds: Optional[List[OrderRefundItem]] = Field(
        None, title="Detailed Refunds"
    )
    returns: Optional[List[OrderReturnItem]] = Field([], title="Returns")


class ReadSyncItem(BaseModel):
    name: constr(min_length=1) = Field(..., title="Name")
    connections: List[BackboneApiAppRoutersSyncsConnectionItem] = Field(
        ..., title="Connections"
    )
    mappings: Optional[List[CreateSyncMappingItemOutput]] = Field([], title="Mappings")
    syncid: UUID = Field(..., title="Syncid")
    consumers: List[str] = Field(..., title="Consumers")
    flows: List[ReadFlowItem] = Field(..., title="Flows")


class ChiftPageInvoiceItemOut(BaseModel):
    items: List[InvoiceItemOut] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class ChiftPageOrderItemOut(BaseModel):
    items: List[OrderItemOut] = Field(..., title="Items")
    total: Optional[conint(ge=0)] = Field(None, title="Total")
    page: conint(ge=1) = Field(..., title="Page")
    size: conint(ge=1) = Field(..., title="Size")


class CreateSyncItem(BaseModel):
    name: constr(min_length=1) = Field(..., title="Name")
    connections: List[ConnectionItemInput] = Field(..., title="Connections")
    mappings: Optional[List[CreateSyncMappingItemInput]] = Field([], title="Mappings")
    flows: Optional[List[CreateFlowItem]] = Field([], title="Flows")
