#!/usr/bin/env python3
"""
Adapated from typeshed, this is a full protocol of the stdlib `str`.

"""
# mypy: disable-error-code="misc"
# ruff: noqa: UP049, A002, ANN401, FBT001, FBT002
# Imports:
from __future__ import annotations

# ##-- stdlib imports
import datetime
import enum
import functools as ftz
import itertools as itz
import logging as logmod
import pathlib as pl
import re
import time
import types
import collections
import contextlib
import hashlib
from copy import deepcopy
from uuid import UUID, uuid1
from weakref import ref
import atexit # for @atexit.register
import faulthandler
# ##-- end stdlib imports

# ##-- types
# isort: off
import abc
import collections.abc
from typing import TYPE_CHECKING, cast, assert_type, assert_never
from typing import Generic, NewType, Never
# Protocols:
from typing import Protocol, runtime_checkable
# Typing Decorators:
from typing import no_type_check, final, override, overload

if TYPE_CHECKING:
    from jgdv import Maybe
    from typing import Final
    from typing import ClassVar, Any, LiteralString
    from typing import Self, Literal
    from typing import TypeGuard
    from collections.abc import Iterable, Iterator, Callable, Generator
    from collections.abc import Mapping, MutableMapping, Hashable

##--|

type ReadableBuffer    = Any
type SupportsIndex     = Any
type _FormatMapMapping = Any
type _TranslateTable   = Any
# isort: on
# ##-- end types

##-- logging
logging = logmod.getLogger(__name__)
##-- end logging

# Vars:

# Body:

class String_p(Protocol):

    ##--| Overloaded methods

    @overload
    @staticmethod
    def maketrans[_T](x:dict[str|int, _T], /) -> dict[int, _T]:...

    @overload
    @staticmethod
    def maketrans(x:str, y:str, /) -> dict[int, int]:...

    @overload
    @staticmethod
    def maketrans(x:str, y:str, z:str, /) -> dict[int, Maybe[int]]:...

    @overload
    def __add__(self:LiteralString, value:LiteralString, /) -> LiteralString:...
    @overload
    def __add__(self, value:str, /) -> str:...

    @overload
    def __getitem__(self:LiteralString, key:SupportsIndex|slice, /) -> LiteralString:...

    @overload
    def __getitem__(self, key:SupportsIndex|slice, /) -> str:...

    ##--| Ctor:

    def __new__(cls, object:ReadableBuffer, encoding:str=..., errors:str=...) -> Self:...

    ##--| Overrides

    @override
    def __eq__(self, value:object, /) -> bool:...

    @override
    def __hash__(self) -> int:...

    @override
    def __ne__(self, value:object, /) -> bool:...


    ##--| Dunders
    def __contains__(self, key:str, /) -> bool:...

    def __ge__(self, value:str, /) -> bool:...

    def __gt__(self, value:str, /) -> bool:...

    def __iter__(self) -> Iterator[str]:...

    def __le__(self, value:str, /) -> bool:...

    def __len__(self) -> int:...

    def __lt__(self, value:str, /) -> bool:...

    def __mod__(self, value:Any, /) -> str:...

    def __mul__(self, value:SupportsIndex, /) -> str:...

    def __rmul__(self, value:SupportsIndex, /) -> str:...

    def __getnewargs__(self) -> tuple[str]:...
    ##--| rest

    def capitalize(self) -> str:...

    def casefold(self) -> str:...

    def center(self, width:SupportsIndex, fillchar:str=" ", /) -> str:...

    def count(self, sub:str, start:Maybe[SupportsIndex]=..., end:Maybe[SupportsIndex]=..., /) -> int:...

    def encode(self, encoding:str="utf-8", errors:str="strict") -> bytes:...

    def endswith(self, suffix:str|tuple[str, ...], start:Maybe[SupportsIndex]=..., end:Maybe[SupportsIndex]=...) -> bool:...

    def expandtabs(self, tabsize:SupportsIndex=8) -> str:...

    def find(self, sub:str, start:Maybe[SupportsIndex]=..., end:Maybe[SupportsIndex]=..., /) -> int:...

    def format(self, *args:object, **kwargs:object) -> str:...

    def format_map(self, mapping:_FormatMapMapping, /) -> str:...

    def index(self, sub:str, start:Maybe[SupportsIndex]=..., end:Maybe[SupportsIndex]=..., /) -> int:...

    def isalnum(self) -> bool:...

    def isalpha(self) -> bool:...

    def isascii(self) -> bool:...

    def isdecimal(self) -> bool:...

    def isdigit(self) -> bool:...

    def isidentifier(self) -> bool:...

    def islower(self) -> bool:...

    def isnumeric(self) -> bool:...

    def isprintable(self) -> bool:...

    def isspace(self) -> bool:...

    def istitle(self) -> bool:...

    def isupper(self) -> bool:...

    def join(self, iterable:Iterable[str], /) -> str:...

    def ljust(self, width:SupportsIndex, fillchar:str=" ", /) -> str:...

    def lower(self) -> str:...

    def lstrip(self, chars:Maybe[str]=None, /) -> str:...

    def partition(self, sep:str, /) -> tuple[str, str, str]:...

    def replace(self, old:LiteralString, new:LiteralString, /, count:SupportsIndex=-1) -> LiteralString:...

    def removeprefix(self, prefix:str, /) -> str:...

    def removesuffix(self, suffix:str, /) -> str:...

    def rfind(self, sub:str, start:Maybe[SupportsIndex]=..., end:Maybe[SupportsIndex]=..., /) -> int:...

    def rindex(self, sub:str, start:Maybe[SupportsIndex]=..., end:Maybe[SupportsIndex]=..., /) -> int:...

    def rjust(self, width:SupportsIndex, fillchar:str=" ", /) -> str:...

    def rpartition(self, sep:str, /) -> tuple[str, str, str]:...

    def rsplit(self, sep:Maybe[str]=None, maxsplit:SupportsIndex=-1) -> list[str]:...

    def rstrip(self, chars:Maybe[str]=None, /) -> str:...

    def split(self, sep:Maybe[str]=None, maxsplit:SupportsIndex=-1) -> list[str]:...

    def splitlines(self, keepends:bool=False) -> list[str]:...

    def startswith(self, prefix:str|tuple[str, ...], start:Maybe[SupportsIndex]=..., end:Maybe[SupportsIndex]=..., /) -> bool:...

    def strip(self, chars:Maybe[str]=None, /) -> str:...

    def swapcase(self) -> str:...

    def title(self) -> str:...

    def translate(self, table:_TranslateTable, /) -> str:...

    def upper(self) -> str:...

    def zfill(self, width:SupportsIndex, /) -> str:...

