#!/usr/bin/env python3
"""
TEST File updated

"""
# ruff: noqa: ANN201, ARG001, ANN001, ARG002, ANN202, B011

# Imports
from __future__ import annotations

# ##-- stdlib imports
import logging as logmod
import pathlib as pl
import warnings
# ##-- end stdlib imports

# ##-- 3rd party imports
import pytest
# ##-- end 3rd party imports

##--|
from .. import _interface as API # noqa: N812

##--|

# ##-- types
# isort: off
import abc
import collections.abc
from typing import TYPE_CHECKING, cast, assert_type, assert_never
from typing import Generic, NewType, Never
# Protocols:
from typing import Protocol, runtime_checkable
# Typing Decorators:
from typing import no_type_check, final, override, overload

if TYPE_CHECKING:
    from jgdv import Maybe
    from typing import Final
    from typing import ClassVar, Any, LiteralString
    from typing import Self, Literal
    from typing import TypeGuard
    from collections.abc import Iterable, Iterator, Callable, Generator
    from collections.abc import Sequence, Mapping, MutableMapping, Hashable

##--|

# isort: on
# ##-- end types

##-- logging
logging = logmod.getLogger(__name__)
##-- end logging

# Vars:

# Body:

class TestSec_d:

    def test_sanity(self):
        assert(True is not False) # noqa: PLR0133

    def test_ctor(self):
        match API.Sec_d("test", ".", "::", str|int, API.DefaultBodyMarks_e, True, idx=0):
            case API.Sec_d():
                assert(True)
            case x:
                assert(False), x

    def test_contains_mark(self):
        obj = API.Sec_d("test", ".", "::", str|int, API.DefaultBodyMarks_e, True, idx=0)
        assert(API.DefaultBodyMarks_e.head in obj)

    def test_contains_mark_fail(self):
        obj = API.Sec_d("test", ".", "::", str|int, API.DefaultBodyMarks_e, True, idx=0)
        assert(API.DefaultHeadMarks_e.basic not in obj)

    def test_contains_type(self):
        obj = API.Sec_d("test", ".", "::", str|int|list, API.DefaultBodyMarks_e, True, idx=0)
        assert(str in obj)

    def test_contains_type_fail(self):
        obj = API.Sec_d("test", ".", "::", str|int|list, API.DefaultBodyMarks_e, True, idx=0)
        assert(float not in obj)

    def test_contains_type_union(self):
        obj = API.Sec_d("test", ".", "::", str|int|list, API.DefaultBodyMarks_e, True, idx=0)
        assert(str|int in obj)

    def test_contains_type_union_fail(self):
        obj = API.Sec_d("test", ".", "::", str|int|list, API.DefaultBodyMarks_e, True, idx=0)
        assert(str|int|float not in obj)
