# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetScriptResult',
    'AwaitableGetScriptResult',
    'get_script',
    'get_script_output',
]

@pulumi.output_type
class GetScriptResult:
    """
    A collection of values returned by getScript.
    """
    def __init__(__self__, apm_domain_id=None, content=None, content_file_name=None, content_size_in_bytes=None, content_type=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, monitor_status_count_maps=None, parameters=None, script_id=None, time_created=None, time_updated=None, time_uploaded=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if content_file_name and not isinstance(content_file_name, str):
            raise TypeError("Expected argument 'content_file_name' to be a str")
        pulumi.set(__self__, "content_file_name", content_file_name)
        if content_size_in_bytes and not isinstance(content_size_in_bytes, int):
            raise TypeError("Expected argument 'content_size_in_bytes' to be a int")
        pulumi.set(__self__, "content_size_in_bytes", content_size_in_bytes)
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if monitor_status_count_maps and not isinstance(monitor_status_count_maps, list):
            raise TypeError("Expected argument 'monitor_status_count_maps' to be a list")
        pulumi.set(__self__, "monitor_status_count_maps", monitor_status_count_maps)
        if parameters and not isinstance(parameters, list):
            raise TypeError("Expected argument 'parameters' to be a list")
        pulumi.set(__self__, "parameters", parameters)
        if script_id and not isinstance(script_id, str):
            raise TypeError("Expected argument 'script_id' to be a str")
        pulumi.set(__self__, "script_id", script_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if time_uploaded and not isinstance(time_uploaded, str):
            raise TypeError("Expected argument 'time_uploaded' to be a str")
        pulumi.set(__self__, "time_uploaded", time_uploaded)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> str:
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The content of the script. It may contain custom-defined tags that can be used for setting dynamic parameters. The format to set dynamic parameters is: `<ORAP><ON>param name</ON><OV>param value</OV><OS>isParamValueSecret(true/false)</OS></ORAP>`. Param value and isParamValueSecret are optional, the default value for isParamValueSecret is false. Examples: With mandatory param name : `<ORAP><ON>param name</ON></ORAP>` With parameter name and value : `<ORAP><ON>param name</ON><OV>param value</OV></ORAP>` Note that the content is valid if it matches the given content type. For example, if the content type is SIDE, then the content should be in Side script format. If the content type is JS, then the content should be in JavaScript format.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentFileName")
    def content_file_name(self) -> str:
        """
        File name of the uploaded script content.
        """
        return pulumi.get(self, "content_file_name")

    @property
    @pulumi.getter(name="contentSizeInBytes")
    def content_size_in_bytes(self) -> int:
        """
        Size of the script content.
        """
        return pulumi.get(self, "content_size_in_bytes")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        Content type of the script.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Unique name that can be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the script. scriptId is mandatory for creation of SCRIPTED_BROWSER and SCRIPTED_REST monitor types. For other monitor types, it should be set to null.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="monitorStatusCountMaps")
    def monitor_status_count_maps(self) -> Sequence['outputs.GetScriptMonitorStatusCountMapResult']:
        """
        Details of the monitor count per state. Example: `{ "total" : 5, "enabled" : 3 , "disabled" : 2, "invalid" : 0 }`
        """
        return pulumi.get(self, "monitor_status_count_maps")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetScriptParameterResult']:
        """
        List of script parameters. Example: `[{"scriptParameter": {"paramName": "userid", "paramValue":"testuser", "isSecret": false}, "isOverwritten": false}]`
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> str:
        return pulumi.get(self, "script_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="timeUploaded")
    def time_uploaded(self) -> str:
        """
        The time the script was uploaded.
        """
        return pulumi.get(self, "time_uploaded")


class AwaitableGetScriptResult(GetScriptResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScriptResult(
            apm_domain_id=self.apm_domain_id,
            content=self.content,
            content_file_name=self.content_file_name,
            content_size_in_bytes=self.content_size_in_bytes,
            content_type=self.content_type,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            monitor_status_count_maps=self.monitor_status_count_maps,
            parameters=self.parameters,
            script_id=self.script_id,
            time_created=self.time_created,
            time_updated=self.time_updated,
            time_uploaded=self.time_uploaded)


def get_script(apm_domain_id: Optional[str] = None,
               script_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScriptResult:
    """
    This data source provides details about a specific Script resource in Oracle Cloud Infrastructure Apm Synthetics service.

    Gets the configuration of the script identified by the OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_script = oci.ApmSynthetics.get_script(apm_domain_id=test_apm_domain["id"],
        script_id=test_script_oci_apm_synthetics_script["id"])
    ```


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str script_id: The OCID of the script.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['scriptId'] = script_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmSynthetics/getScript:getScript', __args__, opts=opts, typ=GetScriptResult).value

    return AwaitableGetScriptResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        content=pulumi.get(__ret__, 'content'),
        content_file_name=pulumi.get(__ret__, 'content_file_name'),
        content_size_in_bytes=pulumi.get(__ret__, 'content_size_in_bytes'),
        content_type=pulumi.get(__ret__, 'content_type'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        monitor_status_count_maps=pulumi.get(__ret__, 'monitor_status_count_maps'),
        parameters=pulumi.get(__ret__, 'parameters'),
        script_id=pulumi.get(__ret__, 'script_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        time_uploaded=pulumi.get(__ret__, 'time_uploaded'))
def get_script_output(apm_domain_id: Optional[pulumi.Input[str]] = None,
                      script_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetScriptResult]:
    """
    This data source provides details about a specific Script resource in Oracle Cloud Infrastructure Apm Synthetics service.

    Gets the configuration of the script identified by the OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_script = oci.ApmSynthetics.get_script(apm_domain_id=test_apm_domain["id"],
        script_id=test_script_oci_apm_synthetics_script["id"])
    ```


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str script_id: The OCID of the script.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['scriptId'] = script_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ApmSynthetics/getScript:getScript', __args__, opts=opts, typ=GetScriptResult)
    return __ret__.apply(lambda __response__: GetScriptResult(
        apm_domain_id=pulumi.get(__response__, 'apm_domain_id'),
        content=pulumi.get(__response__, 'content'),
        content_file_name=pulumi.get(__response__, 'content_file_name'),
        content_size_in_bytes=pulumi.get(__response__, 'content_size_in_bytes'),
        content_type=pulumi.get(__response__, 'content_type'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        monitor_status_count_maps=pulumi.get(__response__, 'monitor_status_count_maps'),
        parameters=pulumi.get(__response__, 'parameters'),
        script_id=pulumi.get(__response__, 'script_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        time_uploaded=pulumi.get(__response__, 'time_uploaded')))
