# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOccCustomerGroupResult',
    'AwaitableGetOccCustomerGroupResult',
    'get_occ_customer_group',
    'get_occ_customer_group_output',
]

@pulumi.output_type
class GetOccCustomerGroupResult:
    """
    A collection of values returned by getOccCustomerGroup.
    """
    def __init__(__self__, compartment_id=None, customers_lists=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, occ_customer_group_id=None, state=None, status=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if customers_lists and not isinstance(customers_lists, list):
            raise TypeError("Expected argument 'customers_lists' to be a list")
        pulumi.set(__self__, "customers_lists", customers_lists)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if occ_customer_group_id and not isinstance(occ_customer_group_id, str):
            raise TypeError("Expected argument 'occ_customer_group_id' to be a str")
        pulumi.set(__self__, "occ_customer_group_id", occ_customer_group_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the tenancy containing the customer group.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="customersLists")
    def customers_lists(self) -> Sequence['outputs.GetOccCustomerGroupCustomersListResult']:
        """
        A list containing all the customers that belong to this customer group
        """
        return pulumi.get(self, "customers_lists")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description about the customer group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the customer group.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the customer group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed State.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="occCustomerGroupId")
    def occ_customer_group_id(self) -> str:
        """
        The OCID of the customer group.
        """
        return pulumi.get(self, "occ_customer_group_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        To determine whether the customer group is enabled/disabled.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time when the customer group was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time when the customer group was last updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetOccCustomerGroupResult(GetOccCustomerGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOccCustomerGroupResult(
            compartment_id=self.compartment_id,
            customers_lists=self.customers_lists,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            occ_customer_group_id=self.occ_customer_group_id,
            state=self.state,
            status=self.status,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_occ_customer_group(occ_customer_group_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOccCustomerGroupResult:
    """
    This data source provides details about a specific Occ Customer Group resource in Oracle Cloud Infrastructure Capacity Management service.

    Gets information about the specified customer group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occ_customer_group = oci.CapacityManagement.get_occ_customer_group(occ_customer_group_id=test_occ_customer_group_oci_capacity_management_occ_customer_group["id"])
    ```


    :param str occ_customer_group_id: The OCID of the customer group.
    """
    __args__ = dict()
    __args__['occCustomerGroupId'] = occ_customer_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CapacityManagement/getOccCustomerGroup:getOccCustomerGroup', __args__, opts=opts, typ=GetOccCustomerGroupResult).value

    return AwaitableGetOccCustomerGroupResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        customers_lists=pulumi.get(__ret__, 'customers_lists'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        occ_customer_group_id=pulumi.get(__ret__, 'occ_customer_group_id'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_occ_customer_group_output(occ_customer_group_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOccCustomerGroupResult]:
    """
    This data source provides details about a specific Occ Customer Group resource in Oracle Cloud Infrastructure Capacity Management service.

    Gets information about the specified customer group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occ_customer_group = oci.CapacityManagement.get_occ_customer_group(occ_customer_group_id=test_occ_customer_group_oci_capacity_management_occ_customer_group["id"])
    ```


    :param str occ_customer_group_id: The OCID of the customer group.
    """
    __args__ = dict()
    __args__['occCustomerGroupId'] = occ_customer_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CapacityManagement/getOccCustomerGroup:getOccCustomerGroup', __args__, opts=opts, typ=GetOccCustomerGroupResult)
    return __ret__.apply(lambda __response__: GetOccCustomerGroupResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        customers_lists=pulumi.get(__response__, 'customers_lists'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        occ_customer_group_id=pulumi.get(__response__, 'occ_customer_group_id'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
