# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIpsecConfigResult',
    'AwaitableGetIpsecConfigResult',
    'get_ipsec_config',
    'get_ipsec_config_output',
]

@pulumi.output_type
class GetIpsecConfigResult:
    """
    A collection of values returned by getIpsecConfig.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, ipsec_id=None, time_created=None, tunnels=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipsec_id and not isinstance(ipsec_id, str):
            raise TypeError("Expected argument 'ipsec_id' to be a str")
        pulumi.set(__self__, "ipsec_id", ipsec_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if tunnels and not isinstance(tunnels, list):
            raise TypeError("Expected argument 'tunnels' to be a list")
        pulumi.set(__self__, "tunnels", tunnels)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the IPSec connection.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIpsecConfigFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipsecId")
    def ipsec_id(self) -> str:
        return pulumi.get(self, "ipsec_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the IPSec connection was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def tunnels(self) -> Sequence['outputs.GetIpsecConfigTunnelResult']:
        """
        Two [TunnelConfig](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/TunnelConfig/) objects.
        """
        return pulumi.get(self, "tunnels")


class AwaitableGetIpsecConfigResult(GetIpsecConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpsecConfigResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            ipsec_id=self.ipsec_id,
            time_created=self.time_created,
            tunnels=self.tunnels)


def get_ipsec_config(filters: Optional[Sequence[Union['GetIpsecConfigFilterArgs', 'GetIpsecConfigFilterArgsDict']]] = None,
                     ipsec_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpsecConfigResult:
    """
    This data source provides details about a specific Ip Sec Connection Device Config resource in Oracle Cloud Infrastructure Core service.

    Deprecated. To get tunnel information, instead use:

    * [GetIPSecConnectionTunnel](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnectionTunnel/GetIPSecConnectionTunnel)
    * [GetIPSecConnectionTunnelSharedSecret](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnectionTunnelSharedSecret/GetIPSecConnectionTunnelSharedSecret)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ip_sec_connection_device_config = oci.Core.get_ipsec_config(ipsec_id=test_ipsec["id"])
    ```


    :param str ipsec_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IPSec connection.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ipsecId'] = ipsec_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getIpsecConfig:getIpsecConfig', __args__, opts=opts, typ=GetIpsecConfigResult).value

    return AwaitableGetIpsecConfigResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ipsec_id=pulumi.get(__ret__, 'ipsec_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        tunnels=pulumi.get(__ret__, 'tunnels'))
def get_ipsec_config_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetIpsecConfigFilterArgs', 'GetIpsecConfigFilterArgsDict']]]]] = None,
                            ipsec_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIpsecConfigResult]:
    """
    This data source provides details about a specific Ip Sec Connection Device Config resource in Oracle Cloud Infrastructure Core service.

    Deprecated. To get tunnel information, instead use:

    * [GetIPSecConnectionTunnel](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnectionTunnel/GetIPSecConnectionTunnel)
    * [GetIPSecConnectionTunnelSharedSecret](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnectionTunnelSharedSecret/GetIPSecConnectionTunnelSharedSecret)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ip_sec_connection_device_config = oci.Core.get_ipsec_config(ipsec_id=test_ipsec["id"])
    ```


    :param str ipsec_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IPSec connection.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ipsecId'] = ipsec_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getIpsecConfig:getIpsecConfig', __args__, opts=opts, typ=GetIpsecConfigResult)
    return __ret__.apply(lambda __response__: GetIpsecConfigResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ipsec_id=pulumi.get(__response__, 'ipsec_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        tunnels=pulumi.get(__response__, 'tunnels')))
