# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousDatabasePeersResult',
    'AwaitableGetAutonomousDatabasePeersResult',
    'get_autonomous_database_peers',
    'get_autonomous_database_peers_output',
]

@pulumi.output_type
class GetAutonomousDatabasePeersResult:
    """
    A collection of values returned by getAutonomousDatabasePeers.
    """
    def __init__(__self__, autonomous_database_id=None, autonomous_database_peer_collections=None, filters=None, id=None):
        if autonomous_database_id and not isinstance(autonomous_database_id, str):
            raise TypeError("Expected argument 'autonomous_database_id' to be a str")
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if autonomous_database_peer_collections and not isinstance(autonomous_database_peer_collections, list):
            raise TypeError("Expected argument 'autonomous_database_peer_collections' to be a list")
        pulumi.set(__self__, "autonomous_database_peer_collections", autonomous_database_peer_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> str:
        return pulumi.get(self, "autonomous_database_id")

    @property
    @pulumi.getter(name="autonomousDatabasePeerCollections")
    def autonomous_database_peer_collections(self) -> Sequence['outputs.GetAutonomousDatabasePeersAutonomousDatabasePeerCollectionResult']:
        """
        The list of autonomous_database_peer_collection.
        """
        return pulumi.get(self, "autonomous_database_peer_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousDatabasePeersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetAutonomousDatabasePeersResult(GetAutonomousDatabasePeersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDatabasePeersResult(
            autonomous_database_id=self.autonomous_database_id,
            autonomous_database_peer_collections=self.autonomous_database_peer_collections,
            filters=self.filters,
            id=self.id)


def get_autonomous_database_peers(autonomous_database_id: Optional[str] = None,
                                  filters: Optional[Sequence[Union['GetAutonomousDatabasePeersFilterArgs', 'GetAutonomousDatabasePeersFilterArgsDict']]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDatabasePeersResult:
    """
    This data source provides the list of Autonomous Database Peers in Oracle Cloud Infrastructure Database service.

    Lists the Autonomous Database peers for the specified Autonomous Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_peers = oci.Database.get_autonomous_database_peers(autonomous_database_id=test_autonomous_database["id"])
    ```


    :param str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousDatabaseId'] = autonomous_database_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousDatabasePeers:getAutonomousDatabasePeers', __args__, opts=opts, typ=GetAutonomousDatabasePeersResult).value

    return AwaitableGetAutonomousDatabasePeersResult(
        autonomous_database_id=pulumi.get(__ret__, 'autonomous_database_id'),
        autonomous_database_peer_collections=pulumi.get(__ret__, 'autonomous_database_peer_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_autonomous_database_peers_output(autonomous_database_id: Optional[pulumi.Input[str]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAutonomousDatabasePeersFilterArgs', 'GetAutonomousDatabasePeersFilterArgsDict']]]]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutonomousDatabasePeersResult]:
    """
    This data source provides the list of Autonomous Database Peers in Oracle Cloud Infrastructure Database service.

    Lists the Autonomous Database peers for the specified Autonomous Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_peers = oci.Database.get_autonomous_database_peers(autonomous_database_id=test_autonomous_database["id"])
    ```


    :param str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousDatabaseId'] = autonomous_database_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousDatabasePeers:getAutonomousDatabasePeers', __args__, opts=opts, typ=GetAutonomousDatabasePeersResult)
    return __ret__.apply(lambda __response__: GetAutonomousDatabasePeersResult(
        autonomous_database_id=pulumi.get(__response__, 'autonomous_database_id'),
        autonomous_database_peer_collections=pulumi.get(__response__, 'autonomous_database_peer_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
