# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBackupDestinationsResult',
    'AwaitableGetBackupDestinationsResult',
    'get_backup_destinations',
    'get_backup_destinations_output',
]

@pulumi.output_type
class GetBackupDestinationsResult:
    """
    A collection of values returned by getBackupDestinations.
    """
    def __init__(__self__, backup_destinations=None, compartment_id=None, filters=None, id=None, type=None):
        if backup_destinations and not isinstance(backup_destinations, list):
            raise TypeError("Expected argument 'backup_destinations' to be a list")
        pulumi.set(__self__, "backup_destinations", backup_destinations)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="backupDestinations")
    def backup_destinations(self) -> Sequence['outputs.GetBackupDestinationsBackupDestinationResult']:
        """
        The list of backup_destinations.
        """
        return pulumi.get(self, "backup_destinations")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBackupDestinationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the backup destination.
        """
        return pulumi.get(self, "type")


class AwaitableGetBackupDestinationsResult(GetBackupDestinationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupDestinationsResult(
            backup_destinations=self.backup_destinations,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            type=self.type)


def get_backup_destinations(compartment_id: Optional[str] = None,
                            filters: Optional[Sequence[Union['GetBackupDestinationsFilterArgs', 'GetBackupDestinationsFilterArgsDict']]] = None,
                            type: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupDestinationsResult:
    """
    This data source provides the list of Backup Destinations in Oracle Cloud Infrastructure Database service.

    Gets a list of backup destinations in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_backup_destinations = oci.Database.get_backup_destinations(compartment_id=compartment_id,
        type=backup_destination_type)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str type: A filter to return only resources that match the given type of the Backup Destination.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getBackupDestinations:getBackupDestinations', __args__, opts=opts, typ=GetBackupDestinationsResult).value

    return AwaitableGetBackupDestinationsResult(
        backup_destinations=pulumi.get(__ret__, 'backup_destinations'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        type=pulumi.get(__ret__, 'type'))
def get_backup_destinations_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBackupDestinationsFilterArgs', 'GetBackupDestinationsFilterArgsDict']]]]] = None,
                                   type: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBackupDestinationsResult]:
    """
    This data source provides the list of Backup Destinations in Oracle Cloud Infrastructure Database service.

    Gets a list of backup destinations in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_backup_destinations = oci.Database.get_backup_destinations(compartment_id=compartment_id,
        type=backup_destination_type)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str type: A filter to return only resources that match the given type of the Backup Destination.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getBackupDestinations:getBackupDestinations', __args__, opts=opts, typ=GetBackupDestinationsResult)
    return __ret__.apply(lambda __response__: GetBackupDestinationsResult(
        backup_destinations=pulumi.get(__response__, 'backup_destinations'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        type=pulumi.get(__response__, 'type')))
