# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbHomeResult',
    'AwaitableGetDbHomeResult',
    'get_db_home',
    'get_db_home_output',
]

@pulumi.output_type
class GetDbHomeResult:
    """
    A collection of values returned by getDbHome.
    """
    def __init__(__self__, compartment_id=None, database_software_image_id=None, databases=None, db_home_id=None, db_home_location=None, db_system_id=None, db_version=None, defined_tags=None, display_name=None, enable_database_delete=None, freeform_tags=None, id=None, is_desupported_version=None, is_unified_auditing_enabled=None, kms_key_id=None, kms_key_version_id=None, last_patch_history_entry_id=None, lifecycle_details=None, source=None, state=None, time_created=None, vm_cluster_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_software_image_id and not isinstance(database_software_image_id, str):
            raise TypeError("Expected argument 'database_software_image_id' to be a str")
        pulumi.set(__self__, "database_software_image_id", database_software_image_id)
        if databases and not isinstance(databases, list):
            raise TypeError("Expected argument 'databases' to be a list")
        pulumi.set(__self__, "databases", databases)
        if db_home_id and not isinstance(db_home_id, str):
            raise TypeError("Expected argument 'db_home_id' to be a str")
        pulumi.set(__self__, "db_home_id", db_home_id)
        if db_home_location and not isinstance(db_home_location, str):
            raise TypeError("Expected argument 'db_home_location' to be a str")
        pulumi.set(__self__, "db_home_location", db_home_location)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if db_version and not isinstance(db_version, str):
            raise TypeError("Expected argument 'db_version' to be a str")
        pulumi.set(__self__, "db_version", db_version)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if enable_database_delete and not isinstance(enable_database_delete, bool):
            raise TypeError("Expected argument 'enable_database_delete' to be a bool")
        pulumi.set(__self__, "enable_database_delete", enable_database_delete)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_desupported_version and not isinstance(is_desupported_version, bool):
            raise TypeError("Expected argument 'is_desupported_version' to be a bool")
        pulumi.set(__self__, "is_desupported_version", is_desupported_version)
        if is_unified_auditing_enabled and not isinstance(is_unified_auditing_enabled, bool):
            raise TypeError("Expected argument 'is_unified_auditing_enabled' to be a bool")
        pulumi.set(__self__, "is_unified_auditing_enabled", is_unified_auditing_enabled)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_version_id and not isinstance(kms_key_version_id, str):
            raise TypeError("Expected argument 'kms_key_version_id' to be a str")
        pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        if last_patch_history_entry_id and not isinstance(last_patch_history_entry_id, str):
            raise TypeError("Expected argument 'last_patch_history_entry_id' to be a str")
        pulumi.set(__self__, "last_patch_history_entry_id", last_patch_history_entry_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if vm_cluster_id and not isinstance(vm_cluster_id, str):
            raise TypeError("Expected argument 'vm_cluster_id' to be a str")
        pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseSoftwareImageId")
    def database_software_image_id(self) -> str:
        """
        The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "database_software_image_id")

    @property
    @pulumi.getter
    def databases(self) -> Sequence['outputs.GetDbHomeDatabaseResult']:
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter(name="dbHomeId")
    def db_home_id(self) -> str:
        return pulumi.get(self, "db_home_id")

    @property
    @pulumi.getter(name="dbHomeLocation")
    def db_home_location(self) -> str:
        """
        The location of the Oracle Database Home.
        """
        return pulumi.get(self, "db_home_location")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> str:
        """
        The Oracle Database version.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-provided name for the Database Home. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enableDatabaseDelete")
    def enable_database_delete(self) -> bool:
        return pulumi.get(self, "enable_database_delete")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDesupportedVersion")
    def is_desupported_version(self) -> bool:
        return pulumi.get(self, "is_desupported_version")

    @property
    @pulumi.getter(name="isUnifiedAuditingEnabled")
    def is_unified_auditing_enabled(self) -> bool:
        """
        Indicates whether unified autiding is enabled or not.
        """
        return pulumi.get(self, "is_unified_auditing_enabled")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> str:
        return pulumi.get(self, "kms_key_version_id")

    @property
    @pulumi.getter(name="lastPatchHistoryEntryId")
    def last_patch_history_entry_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation is started.
        """
        return pulumi.get(self, "last_patch_history_entry_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def source(self) -> str:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Database Home.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the Database Home was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        return pulumi.get(self, "vm_cluster_id")


class AwaitableGetDbHomeResult(GetDbHomeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbHomeResult(
            compartment_id=self.compartment_id,
            database_software_image_id=self.database_software_image_id,
            databases=self.databases,
            db_home_id=self.db_home_id,
            db_home_location=self.db_home_location,
            db_system_id=self.db_system_id,
            db_version=self.db_version,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            enable_database_delete=self.enable_database_delete,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_desupported_version=self.is_desupported_version,
            is_unified_auditing_enabled=self.is_unified_auditing_enabled,
            kms_key_id=self.kms_key_id,
            kms_key_version_id=self.kms_key_version_id,
            last_patch_history_entry_id=self.last_patch_history_entry_id,
            lifecycle_details=self.lifecycle_details,
            source=self.source,
            state=self.state,
            time_created=self.time_created,
            vm_cluster_id=self.vm_cluster_id)


def get_db_home(db_home_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbHomeResult:
    """
    This data source provides details about a specific Db Home resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Database Home.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_home = oci.Database.get_db_home(db_home_id=db_home_id)
    ```


    :param str db_home_id: The Database Home [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['dbHomeId'] = db_home_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDbHome:getDbHome', __args__, opts=opts, typ=GetDbHomeResult).value

    return AwaitableGetDbHomeResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_software_image_id=pulumi.get(__ret__, 'database_software_image_id'),
        databases=pulumi.get(__ret__, 'databases'),
        db_home_id=pulumi.get(__ret__, 'db_home_id'),
        db_home_location=pulumi.get(__ret__, 'db_home_location'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        db_version=pulumi.get(__ret__, 'db_version'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        enable_database_delete=pulumi.get(__ret__, 'enable_database_delete'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_desupported_version=pulumi.get(__ret__, 'is_desupported_version'),
        is_unified_auditing_enabled=pulumi.get(__ret__, 'is_unified_auditing_enabled'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        kms_key_version_id=pulumi.get(__ret__, 'kms_key_version_id'),
        last_patch_history_entry_id=pulumi.get(__ret__, 'last_patch_history_entry_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        source=pulumi.get(__ret__, 'source'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        vm_cluster_id=pulumi.get(__ret__, 'vm_cluster_id'))
def get_db_home_output(db_home_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbHomeResult]:
    """
    This data source provides details about a specific Db Home resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Database Home.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_home = oci.Database.get_db_home(db_home_id=db_home_id)
    ```


    :param str db_home_id: The Database Home [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['dbHomeId'] = db_home_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getDbHome:getDbHome', __args__, opts=opts, typ=GetDbHomeResult)
    return __ret__.apply(lambda __response__: GetDbHomeResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        database_software_image_id=pulumi.get(__response__, 'database_software_image_id'),
        databases=pulumi.get(__response__, 'databases'),
        db_home_id=pulumi.get(__response__, 'db_home_id'),
        db_home_location=pulumi.get(__response__, 'db_home_location'),
        db_system_id=pulumi.get(__response__, 'db_system_id'),
        db_version=pulumi.get(__response__, 'db_version'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        enable_database_delete=pulumi.get(__response__, 'enable_database_delete'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_desupported_version=pulumi.get(__response__, 'is_desupported_version'),
        is_unified_auditing_enabled=pulumi.get(__response__, 'is_unified_auditing_enabled'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        kms_key_version_id=pulumi.get(__response__, 'kms_key_version_id'),
        last_patch_history_entry_id=pulumi.get(__response__, 'last_patch_history_entry_id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        source=pulumi.get(__response__, 'source'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        vm_cluster_id=pulumi.get(__response__, 'vm_cluster_id')))
