# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbSystemsUpgradeHistoryEntriesResult',
    'AwaitableGetDbSystemsUpgradeHistoryEntriesResult',
    'get_db_systems_upgrade_history_entries',
    'get_db_systems_upgrade_history_entries_output',
]

@pulumi.output_type
class GetDbSystemsUpgradeHistoryEntriesResult:
    """
    A collection of values returned by getDbSystemsUpgradeHistoryEntries.
    """
    def __init__(__self__, db_system_id=None, db_system_upgrade_history_entries=None, filters=None, id=None, state=None, upgrade_action=None):
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if db_system_upgrade_history_entries and not isinstance(db_system_upgrade_history_entries, list):
            raise TypeError("Expected argument 'db_system_upgrade_history_entries' to be a list")
        pulumi.set(__self__, "db_system_upgrade_history_entries", db_system_upgrade_history_entries)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if upgrade_action and not isinstance(upgrade_action, str):
            raise TypeError("Expected argument 'upgrade_action' to be a str")
        pulumi.set(__self__, "upgrade_action", upgrade_action)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> str:
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="dbSystemUpgradeHistoryEntries")
    def db_system_upgrade_history_entries(self) -> Sequence['outputs.GetDbSystemsUpgradeHistoryEntriesDbSystemUpgradeHistoryEntryResult']:
        """
        The list of db_system_upgrade_history_entries.
        """
        return pulumi.get(self, "db_system_upgrade_history_entries")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbSystemsUpgradeHistoryEntriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the action.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="upgradeAction")
    def upgrade_action(self) -> Optional[str]:
        return pulumi.get(self, "upgrade_action")


class AwaitableGetDbSystemsUpgradeHistoryEntriesResult(GetDbSystemsUpgradeHistoryEntriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbSystemsUpgradeHistoryEntriesResult(
            db_system_id=self.db_system_id,
            db_system_upgrade_history_entries=self.db_system_upgrade_history_entries,
            filters=self.filters,
            id=self.id,
            state=self.state,
            upgrade_action=self.upgrade_action)


def get_db_systems_upgrade_history_entries(db_system_id: Optional[str] = None,
                                           filters: Optional[Sequence[Union['GetDbSystemsUpgradeHistoryEntriesFilterArgs', 'GetDbSystemsUpgradeHistoryEntriesFilterArgsDict']]] = None,
                                           state: Optional[str] = None,
                                           upgrade_action: Optional[str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbSystemsUpgradeHistoryEntriesResult:
    """
    This data source provides the list of Db Systems Upgrade History Entries in Oracle Cloud Infrastructure Database service.

    Gets the history of the upgrade actions performed on the specified DB system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_systems_upgrade_history_entries = oci.Database.get_db_systems_upgrade_history_entries(db_system_id=test_db_system["id"],
        state=db_systems_upgrade_history_entry_state,
        upgrade_action=db_systems_upgrade_history_entry_upgrade_action)
    ```


    :param str db_system_id: The DB system [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str state: A filter to return only upgrade history entries that match the given lifecycle state exactly.
    :param str upgrade_action: A filter to return only upgradeHistoryEntries that match the specified Upgrade Action.
    """
    __args__ = dict()
    __args__['dbSystemId'] = db_system_id
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['upgradeAction'] = upgrade_action
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDbSystemsUpgradeHistoryEntries:getDbSystemsUpgradeHistoryEntries', __args__, opts=opts, typ=GetDbSystemsUpgradeHistoryEntriesResult).value

    return AwaitableGetDbSystemsUpgradeHistoryEntriesResult(
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        db_system_upgrade_history_entries=pulumi.get(__ret__, 'db_system_upgrade_history_entries'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        upgrade_action=pulumi.get(__ret__, 'upgrade_action'))
def get_db_systems_upgrade_history_entries_output(db_system_id: Optional[pulumi.Input[str]] = None,
                                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDbSystemsUpgradeHistoryEntriesFilterArgs', 'GetDbSystemsUpgradeHistoryEntriesFilterArgsDict']]]]] = None,
                                                  state: Optional[pulumi.Input[Optional[str]]] = None,
                                                  upgrade_action: Optional[pulumi.Input[Optional[str]]] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbSystemsUpgradeHistoryEntriesResult]:
    """
    This data source provides the list of Db Systems Upgrade History Entries in Oracle Cloud Infrastructure Database service.

    Gets the history of the upgrade actions performed on the specified DB system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_systems_upgrade_history_entries = oci.Database.get_db_systems_upgrade_history_entries(db_system_id=test_db_system["id"],
        state=db_systems_upgrade_history_entry_state,
        upgrade_action=db_systems_upgrade_history_entry_upgrade_action)
    ```


    :param str db_system_id: The DB system [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str state: A filter to return only upgrade history entries that match the given lifecycle state exactly.
    :param str upgrade_action: A filter to return only upgradeHistoryEntries that match the specified Upgrade Action.
    """
    __args__ = dict()
    __args__['dbSystemId'] = db_system_id
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['upgradeAction'] = upgrade_action
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getDbSystemsUpgradeHistoryEntries:getDbSystemsUpgradeHistoryEntries', __args__, opts=opts, typ=GetDbSystemsUpgradeHistoryEntriesResult)
    return __ret__.apply(lambda __response__: GetDbSystemsUpgradeHistoryEntriesResult(
        db_system_id=pulumi.get(__response__, 'db_system_id'),
        db_system_upgrade_history_entries=pulumi.get(__response__, 'db_system_upgrade_history_entries'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        upgrade_action=pulumi.get(__response__, 'upgrade_action')))
