# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSystemVersionsResult',
    'AwaitableGetSystemVersionsResult',
    'get_system_versions',
    'get_system_versions_output',
]

@pulumi.output_type
class GetSystemVersionsResult:
    """
    A collection of values returned by getSystemVersions.
    """
    def __init__(__self__, compartment_id=None, filters=None, gi_version=None, id=None, shape=None, system_version_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if gi_version and not isinstance(gi_version, str):
            raise TypeError("Expected argument 'gi_version' to be a str")
        pulumi.set(__self__, "gi_version", gi_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)
        if system_version_collections and not isinstance(system_version_collections, list):
            raise TypeError("Expected argument 'system_version_collections' to be a list")
        pulumi.set(__self__, "system_version_collections", system_version_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSystemVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> str:
        """
        Grid Infrastructure version.
        """
        return pulumi.get(self, "gi_version")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        Exadata shape.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="systemVersionCollections")
    def system_version_collections(self) -> Sequence['outputs.GetSystemVersionsSystemVersionCollectionResult']:
        """
        The list of system_version_collection.
        """
        return pulumi.get(self, "system_version_collections")


class AwaitableGetSystemVersionsResult(GetSystemVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSystemVersionsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            gi_version=self.gi_version,
            id=self.id,
            shape=self.shape,
            system_version_collections=self.system_version_collections)


def get_system_versions(compartment_id: Optional[str] = None,
                        filters: Optional[Sequence[Union['GetSystemVersionsFilterArgs', 'GetSystemVersionsFilterArgsDict']]] = None,
                        gi_version: Optional[str] = None,
                        shape: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSystemVersionsResult:
    """
    This data source provides the list of System Versions in Oracle Cloud Infrastructure Database service.

    Gets a list of supported Exadata system versions for a given shape and GI version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_system_versions = oci.Database.get_system_versions(compartment_id=compartment_id,
        gi_version=system_version_gi_version,
        shape=system_version_shape)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str gi_version: Specifies gi version query parameter.
    :param str shape: Specifies shape query parameter.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['giVersion'] = gi_version
    __args__['shape'] = shape
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getSystemVersions:getSystemVersions', __args__, opts=opts, typ=GetSystemVersionsResult).value

    return AwaitableGetSystemVersionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        gi_version=pulumi.get(__ret__, 'gi_version'),
        id=pulumi.get(__ret__, 'id'),
        shape=pulumi.get(__ret__, 'shape'),
        system_version_collections=pulumi.get(__ret__, 'system_version_collections'))
def get_system_versions_output(compartment_id: Optional[pulumi.Input[str]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSystemVersionsFilterArgs', 'GetSystemVersionsFilterArgsDict']]]]] = None,
                               gi_version: Optional[pulumi.Input[str]] = None,
                               shape: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSystemVersionsResult]:
    """
    This data source provides the list of System Versions in Oracle Cloud Infrastructure Database service.

    Gets a list of supported Exadata system versions for a given shape and GI version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_system_versions = oci.Database.get_system_versions(compartment_id=compartment_id,
        gi_version=system_version_gi_version,
        shape=system_version_shape)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str gi_version: Specifies gi version query parameter.
    :param str shape: Specifies shape query parameter.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['giVersion'] = gi_version
    __args__['shape'] = shape
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getSystemVersions:getSystemVersions', __args__, opts=opts, typ=GetSystemVersionsResult)
    return __ret__.apply(lambda __response__: GetSystemVersionsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        gi_version=pulumi.get(__response__, 'gi_version'),
        id=pulumi.get(__response__, 'id'),
        shape=pulumi.get(__response__, 'shape'),
        system_version_collections=pulumi.get(__response__, 'system_version_collections')))
